/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Glu;
import cds.aladin.MyLabel;
import cds.aladin.Server;
import cds.vizier.VizieRList;
import java.awt.Button;
import java.awt.Component;
import java.awt.Event;
import java.awt.Frame;
import java.awt.Label;
import java.awt.TextField;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;

public class ArchivesServer
extends Server {
    static String NOM = "Missions\nin VizieR";
    static String NOMTEXTFIELD = "Mission";
    static String TITLE = "Mission log archives in VizieR";
    static String INFO = "The archive logs accessible by the Aladin interface";
    static String DEFAULT_METHODE = "Specify a target and a mission to get the point sources.\nSelect them in the view window to get the associated images";
    static String HELP_LIST = "For your help, you can pick up mission names from the list below";
    static String CATDESC = "Get info.";
    static String TAGGLU = "VizieRXML.rm";
    static String WARNING = "";
    Vector vArchives;
    VizieRList missionlist;
    TextField mission;
    MyLabel currentlist;
    Button getReadMe;
    String default_methode;
    String help_list;
    String nomTextfield;
    String title;

    protected ArchivesServer(Aladin aladin, Label label, Vector vector) {
        Component component;
        this.init();
        this.aladin = aladin;
        this.status = label;
        this.type = 1;
        this.setLayout(null);
        this.setFont(Aladin.PLAIN);
        int n = 0;
        Label label2 = new Label("VizieR catalog service");
        label2.setFont(Aladin.LLITALIC);
        label2.setBounds(151, n, 300, 20);
        n += 30;
        this.add(label2);
        StringTokenizer stringTokenizer = new StringTokenizer(this.default_methode, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            component = new Label(stringTokenizer.nextToken());
            component.setBounds(86, n, 400, 20);
            n += 15;
            this.add(component);
        }
        component = this.targetPanel(27, null, true, 5);
        component.setBounds(10, n += 5, 450, 30);
        n += 30;
        this.add(component);
        Label label3 = new Label(this.nomTextfield);
        label3.setFont(Aladin.LBOLD);
        int n2 = 55;
        label3.setBounds(10, n, n2, 30);
        this.add(label3);
        this.mission = new TextField(26);
        this.mission.setBounds(n2 + 15, n, 150, 30);
        this.add(this.mission);
        Label label4 = new Label("Radius");
        label4.setFont(Aladin.LBOLD);
        label4.setBounds(289, n, n2, 30);
        this.add(label4);
        TextField textField = new TextField("10 arcmin");
        textField.setBounds(347, n, 100, 30);
        this.add(textField);
        this.setModeRad(1, textField);
        Label label5 = new Label(this.help_list);
        label5.setBounds(86, n += 40, 400, 20);
        n += 20;
        this.add(label5);
        Button button = new Button(CATDESC);
        this.missionlist = new VizieRList(this.mission, button, vector, 12);
        this.missionlist.setFont(Aladin.PLAIN);
        this.missionlist.setBounds(10, n, 450, 180);
        this.add(this.missionlist);
        button.setFont(Aladin.BOLD);
        button.enable(false);
        button.setBounds(300, n += 200, 100, 25);
        this.add(button);
    }

    public boolean action(Event event, Object object) {
        if (CATDESC.equals(object)) {
            String string = this.mission.getText().trim();
            if (string.equals("")) {
                this.aladin.message.warning("You must specify a catalog name (or number)");
                return true;
            }
            string = Glu.quote(string);
            this.aladin.glu.showDocument("getReadMe", string);
            return true;
        }
        return false;
    }

    protected int creatArchivePlane(String string, String string2, String string3, String string4, String string5) {
        String string6 = String.valueOf(Glu.quote(string3)) + " " + Glu.quote(string) + " " + Glu.quote(string2);
        URL uRL = this.aladin.glu.getURL(TAGGLU, string6);
        if (uRL == null) {
            this.aladin.message.warning("Unknown server error");
            return -1;
        }
        if (!this.verif(2, string, String.valueOf(string4) + " " + string2)) {
            return -1;
        }
        return this.aladin.calque.newPlanCatalog(uRL, string4, string, String.valueOf(string4) + " " + string2);
    }

    protected int creatPlane(String string, String string2, String string3, String string4, String string5) {
        String string6 = string3;
        if (string4 == null) {
            string4 = string6;
        }
        return this.creatArchivePlane(string, string2, string6, string4, null);
    }

    protected void init() {
        this.nom = NOM;
        this.info = INFO;
        this.title = TITLE;
        this.default_methode = DEFAULT_METHODE;
        this.help_list = HELP_LIST;
        this.nomTextfield = NOMTEXTFIELD;
    }

    protected void reaffiche() {
        this.hide();
        this.show();
    }

    protected void reset() {
        super.reset();
        this.rad[0].setText("10 arcmin");
        this.mission.setText("");
    }

    public void submit() {
        Frame frame = this.getFrame(this);
        String string = this.getTarget();
        if (string == null) {
            return;
        }
        String string2 = this.getRadius();
        if (string2.equals("")) {
            this.aladin.message.warning("You must specify the radius of your query");
            return;
        }
        String string3 = this.mission.getText().trim();
        if (string3.equals("")) {
            this.aladin.message.warning("You must specify a catalog name (or number)");
            return;
        }
        String string4 = new String(string);
        this.waitCursor();
        int n = this.missionlist.countItems() - 1;
        while (n >= 0) {
            this.missionlist.deselect(n);
            --n;
        }
        this.creatPlane(string, string2, string3, null, null);
        this.defaultCursor();
    }
}

