/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.Objet;
import cds.aladin.Plan;
import cds.aladin.PlanFilter;
import cds.aladin.Source;
import cds.aladin.UCDFilter;
import cds.aladin.ZoomView;
import cds.astro.Unit;
import cds.tools.parser.Parser;
import cds.tools.parser.ParserException;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Toolkit;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class Action {
    boolean badSyntax = false;
    static final String[] COLORNAME = new String[]{"black", "blue", "cyan", "darkGray", "gray", "green", "lightGray", "magenta", "orange", "pink", "red", "white", "yellow"};
    static final Color[] MYCOLORS = new Color[]{Color.black, Color.blue, Color.cyan, Color.darkGray, Color.gray, Color.green, Color.lightGray, Color.magenta, Color.orange, Color.pink, Color.red, Color.white, Color.yellow};
    protected static final String DRAWOBJECT = "drawobject";
    protected static final String DRAWSTRING = "drawstring";
    protected static final String HIDE = "hide";
    protected static final String SIZE = "circle";
    protected static final String FILLSIZE = "fillcircle";
    protected static final String ELLIPSE = "ellipse";
    protected static final String PM = "pm";
    protected static final String RGB = "rgb";
    protected static final String RAINBOW = "rainbow";
    protected static final String CARRE = "square";
    protected static final String CROIX = "cross";
    protected static final String PLUS = "plus";
    protected static final String LOSANGE = "rhomb";
    protected static final String POINT = "dot";
    protected static final String DOT = "microdot";
    protected static final String[] NOPARAMSHAPE = new String[]{"square", "cross", "plus", "rhomb", "dot", "microdot"};
    protected static final String DRAW = "draw";
    protected static final String COLOR = "color=";
    protected static final String SHAPE = "shape=";
    Parser majAxisParser;
    Parser minAxisParser;
    Parser posAngleParser;
    Parser pmDecParser;
    Parser pmRAParser;
    Color color = null;
    Parser sizeParser;
    private int maxRadius = 30;
    private int minRadius = 3;
    Parser redParser;
    Parser greenParser;
    Parser blueParser;
    Parser rainbowParser;
    boolean colorIsVariable = false;
    boolean rainbowColorIsVariable = false;
    boolean mustComputeMinMax = true;
    boolean mustComputeRGBMinMax = true;
    boolean mustComputeRainbowMinMax = true;
    boolean userDefinedMinMax = false;
    boolean userDefinedRainbowMinMax = false;
    double minValue;
    double maxValue;
    double redMinValue;
    double redMaxValue;
    double blueMinValue;
    double blueMaxValue;
    double greenMinValue;
    double greenMaxValue;
    double rainbowMinValue;
    double rainbowMaxValue;
    private String shape = "draw";
    private String function = "drawobject";
    String textToDisp;
    Parser parserToDisp = null;
    int wTexte;
    int hTexte;
    Font F = Aladin.SBOLD;
    Aladin a;
    PlanFilter pf;

    Action(String string, Aladin aladin, PlanFilter planFilter) {
        this.a = aladin;
        this.pf = planFilter;
        this.decodeAction(string);
    }

    protected void action(Source source, Graphics graphics, Point point, int n, int n2) {
        Color color;
        if (this.colorIsVariable) {
            this.color = this.computeColor(source);
        }
        if (this.rainbowColorIsVariable) {
            this.color = this.computeRainbowColor(source);
        }
        if ((color = this.color) == null) {
            color = source.plan.c;
        }
        if (this.function.equals(HIDE)) {
            return;
        }
        if (this.function.equals(DRAWOBJECT)) {
            if (this.shape.equals(DRAW)) {
                source.doDraw(graphics, point, color);
                return;
            }
            if (this.shape.equals(CARRE)) {
                graphics.setColor(color);
                source.drawCarre(graphics, point);
                return;
            }
            if (this.shape.equals(CROIX)) {
                graphics.setColor(color);
                source.drawCroix(graphics, point);
                return;
            }
            if (this.shape.equals(PLUS)) {
                graphics.setColor(color);
                source.drawPlus(graphics, point);
                return;
            }
            if (this.shape.equals(LOSANGE)) {
                graphics.setColor(color);
                source.drawLosange(graphics, point);
                return;
            }
            if (this.shape.equals(POINT)) {
                graphics.setColor(color);
                source.drawPoint(graphics, point);
                return;
            }
            if (this.shape.equals(DOT)) {
                graphics.setColor(color);
                source.drawDot(graphics, point);
                return;
            }
            if (this.shape.equals(ELLIPSE)) {
                this.drawEllipse(source, graphics, point, color, n, n2);
                return;
            }
            if (this.shape.equals(PM)) {
                this.drawPM(source, graphics, point, color, n, n2);
                return;
            }
            if (this.shape.equals(SIZE) || this.shape.equals(FILLSIZE)) {
                if (source.values[n][n2][0] == -1.0) {
                    return;
                }
                int n3 = (int)(source.values[n][n2][0] * this.a.calque.view.zoomview.zoom);
                graphics.setColor(color);
                if (this.shape.equals(SIZE)) {
                    graphics.drawOval(point.x - n3 / 2, point.y - n3 / 2, n3, n3);
                } else {
                    graphics.fillOval(point.x - n3 / 2, point.y - n3 / 2, n3, n3);
                }
                return;
            }
            source.doDraw(graphics, point, null);
            return;
        }
        if (this.function.equals(DRAWSTRING)) {
            String string;
            int n4;
            if (this.textToDisp != null && (this.textToDisp.startsWith("[") || this.textToDisp.startsWith("{"))) {
                if (this.textToDisp.startsWith("[")) {
                    n4 = source.findUCD(UCDFilter.decodeUCD(this.textToDisp).substring(1, this.textToDisp.length() - 1).toUpperCase());
                    if (n4 < 0) {
                        return;
                    }
                    string = source.getValue(n4);
                } else {
                    n4 = source.findColumn(UCDFilter.decodeUCD(this.textToDisp).substring(1, this.textToDisp.length() - 1));
                    if (n4 < 0) {
                        return;
                    }
                    string = source.getValue(n4);
                }
            } else if (this.parserToDisp != null) {
                if (!Action.setAllVariables(this.parserToDisp, source, false)) {
                    return;
                }
                string = new Double(this.parserToDisp.eval()).toString();
                n4 = string.indexOf(".");
                if (n4 >= 0) {
                    int n5;
                    int n6 = string.indexOf("E");
                    int n7 = n5 = string.length() > n4 + 5 ? n4 + 5 : string.length();
                    if (n6 >= 0) {
                        n5 = n6 > n5 ? n5 : n6;
                    }
                    String string2 = new String(string);
                    string = string.substring(0, n5);
                    if (n6 >= 0) {
                        string = String.valueOf(string) + string2.substring(n6);
                    }
                }
            } else {
                int n8;
                n4 = this.textToDisp.indexOf("\"");
                string = n4 >= 0 && (n8 = this.textToDisp.lastIndexOf("\"")) >= 0 && n4 != n8 ? this.textToDisp.substring(n4 + 1, n8) : this.textToDisp;
            }
            FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.F);
            this.wTexte = fontMetrics.stringWidth(string) / 2;
            this.hTexte = Aladin.SSIZE / 2;
            graphics.setFont(this.F);
            graphics.setColor(color);
            graphics.drawString(string, point.x - this.wTexte, point.y + this.hTexte);
            return;
        }
    }

    private Color computeColor(Source source) {
        if (this.mustComputeRGBMinMax) {
            this.computeRGBMinMax();
            this.mustComputeRGBMinMax = false;
        }
        if (!Action.setAllVariables(this.redParser, source, false)) {
            return null;
        }
        if (!Action.setAllVariables(this.blueParser, source, false)) {
            return null;
        }
        if (!Action.setAllVariables(this.greenParser, source, false)) {
            return null;
        }
        double d = this.redParser.eval();
        double d2 = this.greenParser.eval();
        double d3 = this.blueParser.eval();
        if (d == 99.9 || d2 == 99.9 || d3 == 99.9) {
            return null;
        }
        float f = this.redParser.isConstant() ? Math.max(Math.min((float)d / 255.0f, 1.0f), 0.0f) : (float)((d - this.redMinValue) / (this.redMaxValue - this.redMinValue));
        float f2 = this.greenParser.isConstant() ? Math.max(Math.min((float)d2 / 255.0f, 1.0f), 0.0f) : (float)((d2 - this.greenMinValue) / (this.greenMaxValue - this.greenMinValue));
        float f3 = this.blueParser.isConstant() ? Math.max(Math.min((float)d3 / 255.0f, 1.0f), 0.0f) : (float)((d3 - this.blueMinValue) / (this.blueMaxValue - this.blueMinValue));
        return new Color(f, f2, f3);
    }

    private void computeEllipse(Source source, int n, int n2) {
        try {
            Unit unit = new Unit("arcsec");
        }
        catch (ParseException parseException) {}
        if (!Action.setAllVariables(this.majAxisParser, source, false)) {
            return;
        }
        if (!Action.setAllVariables(this.minAxisParser, source, false)) {
            return;
        }
        source.values[n][n2][0] = this.majAxisParser.eval();
        source.values[n][n2][1] = this.minAxisParser.eval();
        if (!Action.setAllVariables(this.posAngleParser, source, false)) {
            return;
        }
        source.values[n][n2][2] = this.posAngleParser.eval();
    }

    private void computeMinMax() {
        if (this.sizeParser.isConstant()) {
            this.minValue = 0.0;
            this.maxValue = this.sizeParser.eval();
            return;
        }
        this.minValue = Double.POSITIVE_INFINITY;
        this.maxValue = Double.NEGATIVE_INFINITY;
        Plan plan = null;
        Objet[] objetArray = null;
        Plan[] planArray = this.pf.getConcernedPlans();
        int n = planArray.length - 1;
        while (n >= 0) {
            plan = planArray[n];
            objetArray = plan.pcat.o;
            int n2 = objetArray.length - 1;
            while (n2 >= 0) {
                double d;
                Source source;
                if (Aladin.isSlow && n2 % 50 == 0) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(10L);
                    }
                    catch (Exception exception) {}
                }
                if (objetArray[n2] instanceof Source && objetArray[n2] != null && Action.setAllVariables(this.sizeParser, source = (Source)objetArray[n2], false) && Math.abs(d = this.sizeParser.eval()) != 99.9) {
                    if (d > this.maxValue) {
                        this.maxValue = d;
                    }
                    if (d < this.minValue) {
                        this.minValue = d;
                    }
                }
                --n2;
            }
            --n;
        }
    }

    private void computePM(Source source, int n, int n2) {
        double d;
        double d2;
        if (!Action.setAllVariables(this.pmRAParser, source, false, true)) {
            return;
        }
        if (!Action.setAllVariables(this.pmDecParser, source, false, true)) {
            return;
        }
        source.values[n][n2][0] = this.pmRAParser.eval();
        source.values[n][n2][1] = this.pmDecParser.eval();
        Unit unit = null;
        Unit unit2 = null;
        try {
            unit = this.pmRAParser.evalUnit();
            unit2 = this.pmDecParser.evalUnit();
        }
        catch (ParseException parseException) {
            return;
        }
        Unit unit3 = null;
        Unit unit4 = null;
        Unit unit5 = null;
        boolean bl = true;
        try {
            unit3 = new Unit("1ms/yr");
            unit3.convert(unit);
        }
        catch (ParseException parseException) {
            bl = false;
        }
        catch (ArithmeticException arithmeticException) {
            bl = false;
        }
        if (bl) {
            d2 = 15.0 * unit3.value * Math.cos(source.dej * Math.PI / 180.0);
        } else {
            bl = true;
            try {
                unit4 = new Unit("1mas/yr");
                unit4.convert(unit);
            }
            catch (ParseException parseException) {
                bl = false;
            }
            catch (ArithmeticException arithmeticException) {
                bl = false;
            }
            if (bl) {
                d2 = unit4.value;
            } else {
                return;
            }
        }
        bl = true;
        try {
            unit5 = new Unit("1mas/yr");
            unit5.convert(unit2);
        }
        catch (ParseException parseException) {
            bl = false;
        }
        catch (ArithmeticException arithmeticException) {
            bl = false;
        }
        if (bl) {
            d = unit5.value;
            if (Double.isNaN(d2) || Double.isNaN(d)) {
                return;
            }
        } else {
            return;
        }
        source.values[n][n2][0] = d2;
        source.values[n][n2][1] = d;
    }

    private void computeRGBMinMax() {
        this.blueMinValue = Double.POSITIVE_INFINITY;
        this.greenMinValue = Double.POSITIVE_INFINITY;
        this.redMinValue = Double.POSITIVE_INFINITY;
        this.blueMaxValue = Double.NEGATIVE_INFINITY;
        this.greenMaxValue = Double.NEGATIVE_INFINITY;
        this.redMaxValue = Double.NEGATIVE_INFINITY;
        Plan plan = null;
        Objet[] objetArray = null;
        Plan[] planArray = this.pf.getConcernedPlans();
        int n = planArray.length - 1;
        while (n >= 0) {
            plan = planArray[n];
            objetArray = plan.pcat.o;
            int n2 = objetArray.length - 1;
            while (n2 >= 0) {
                Source source;
                if (Aladin.isSlow && n2 % 50 == 0) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(10L);
                    }
                    catch (Exception exception) {}
                }
                if (objetArray[n2] instanceof Source && objetArray[n2] != null && Action.setAllVariables(this.redParser, source = (Source)objetArray[n2], false) && Action.setAllVariables(this.greenParser, source, false) && Action.setAllVariables(this.blueParser, source, false)) {
                    double d = this.redParser.eval();
                    double d2 = this.greenParser.eval();
                    double d3 = this.blueParser.eval();
                    if (Math.abs(d) != 99.9) {
                        if (d > this.redMaxValue) {
                            this.redMaxValue = d;
                        }
                        if (d < this.redMinValue) {
                            this.redMinValue = d;
                        }
                    }
                    if (Math.abs(d2) != 99.9) {
                        if (d2 > this.greenMaxValue) {
                            this.greenMaxValue = d2;
                        }
                        if (d2 < this.greenMinValue) {
                            this.greenMinValue = d2;
                        }
                    }
                    if (Math.abs(d3) != 99.9) {
                        if (d3 > this.blueMaxValue) {
                            this.blueMaxValue = d3;
                        }
                        if (d3 < this.blueMinValue) {
                            this.blueMinValue = d3;
                        }
                    }
                }
                --n2;
            }
            --n;
        }
        if (this.redMinValue == this.redMaxValue) {
            this.redMinValue = 0.0;
        }
        if (this.greenMinValue == this.greenMaxValue) {
            this.greenMinValue = 0.0;
        }
        if (this.blueMinValue == this.blueMaxValue) {
            this.blueMinValue = 0.0;
        }
    }

    private Color computeRainbowColor(Source source) {
        if (this.mustComputeRainbowMinMax) {
            this.computeRainbowMinMax();
            this.mustComputeRainbowMinMax = false;
        }
        if (!Action.setAllVariables(this.rainbowParser, source, false)) {
            return null;
        }
        double d = this.rainbowParser.eval();
        if (d == 99.9) {
            return null;
        }
        float f = (float)((d - this.rainbowMinValue) / (this.rainbowMaxValue - this.rainbowMinValue));
        f = this.getHue(f);
        return Color.getHSBColor(f, 1.0f, 1.0f);
    }

    private void computeRainbowMinMax() {
        this.rainbowMinValue = Double.POSITIVE_INFINITY;
        this.rainbowMaxValue = Double.NEGATIVE_INFINITY;
        Plan plan = null;
        Objet[] objetArray = null;
        Plan[] planArray = this.pf.getConcernedPlans();
        double d = Double.POSITIVE_INFINITY;
        int n = planArray.length - 1;
        while (n >= 0) {
            plan = planArray[n];
            objetArray = plan.pcat.o;
            int n2 = objetArray.length - 1;
            while (n2 >= 0) {
                Source source;
                if (Aladin.isSlow && n2 % 50 == 0) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(10L);
                    }
                    catch (Exception exception) {}
                }
                if (objetArray[n2] instanceof Source && objetArray[n2] != null && Action.setAllVariables(this.rainbowParser, source = (Source)objetArray[n2], false) && Math.abs(d = this.rainbowParser.eval()) != 99.9) {
                    if (d > this.rainbowMaxValue) {
                        this.rainbowMaxValue = d;
                    }
                    if (d < this.rainbowMinValue) {
                        this.rainbowMinValue = d;
                    }
                }
                --n2;
            }
            --n;
        }
        if (d == this.rainbowMaxValue) {
            this.rainbowMinValue = 0.0;
            return;
        }
    }

    private void computeSize(Source source, int n, int n2) {
        if (!Action.setAllVariables(this.sizeParser, source, false)) {
            return;
        }
        double d = this.sizeParser.eval();
        if (this.sizeParser.isConstant()) {
            source.values[n][n2][0] = d;
            return;
        }
        if (d > this.maxValue) {
            d = this.maxValue;
        } else if (d < this.minValue) {
            d = this.minValue;
        }
        source.values[n][n2][0] = (double)this.minRadius + (d - this.minValue) * (double)(this.maxRadius - this.minRadius) / (this.maxValue - this.minValue);
    }

    protected void computeValues(Source source, int n, int n2) {
        source.values[n][n2][2] = -1.0;
        source.values[n][n2][1] = -1.0;
        source.values[n][n2][0] = -1.0;
        if (this.shape.equals(SIZE) || this.shape.equals(FILLSIZE)) {
            if (this.mustComputeMinMax) {
                this.computeMinMax();
                this.mustComputeMinMax = false;
            }
            this.computeSize(source, n, n2);
        } else if (this.shape.equals(ELLIPSE)) {
            this.computeEllipse(source, n, n2);
        } else if (this.shape.equals(PM)) {
            this.computePM(source, n, n2);
        }
    }

    protected static int countNbOcc(char c, String string) {
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            if (string.charAt(n2) == c) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    private void decodeAction(String string) {
        int n;
        String string2 = new String(string);
        string = UCDFilter.skipSpaces(string);
        while (string.charAt(0) == '\n') {
            string = string.substring(1);
        }
        int n2 = string.indexOf("(");
        String string3 = "";
        if (n2 < 0) {
            n2 = string.length();
        } else {
            int n3 = this.getClosingParenthesis(string, n2 + 1);
            if (n3 < 0) {
                this.badSyntax = true;
                this.a.message.warning("Missing ) in action string", 1);
                return;
            }
            string3 = string.substring(n2 + 1, n3);
        }
        String string4 = string.substring(0, n2);
        if (string4.equals(DRAWOBJECT)) {
            this.function = DRAWOBJECT;
            this.decodeDrawObject(string3);
            return;
        }
        if (string4.equals(DRAWSTRING)) {
            this.function = DRAWSTRING;
            this.decodeDrawString(string3);
            return;
        }
        if (string4.equals(HIDE)) {
            this.function = HIDE;
            return;
        }
        int n4 = string2.indexOf(DRAW);
        if (n4 >= 0) {
            string2 = string2.substring(n4 + DRAW.length());
        }
        if ((n = this.processFunction(string2 = string2.trim())) >= 0 && n < string2.length()) {
            this.processFunction(string2.substring(n).trim());
        }
    }

    private Color decodeColorString(String string) {
        Color color;
        try {
            color = Color.decode(string);
        }
        catch (NumberFormatException numberFormatException) {
            color = null;
        }
        return color;
    }

    private void decodeDrawObject(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        String string2 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (string2.startsWith(COLOR)) {
                try {
                    while (Action.countNbOcc('(', string2) != Action.countNbOcc(')', string2)) {
                        string2 = String.valueOf(string2) + "," + stringTokenizer.nextToken();
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    this.a.message.warning("Error in color syntax", 1);
                    this.badSyntax = true;
                    return;
                }
                this.processColor(string2.substring(COLOR.length()));
                continue;
            }
            if (!string2.startsWith(SHAPE)) continue;
            if ((string2.indexOf(SIZE) >= 0 || string2.indexOf(FILLSIZE) >= 0 || string2.indexOf(ELLIPSE) >= 0 || string2.indexOf(PM) >= 0) && string2.indexOf("(") >= 0) {
                try {
                    while (Action.countNbOcc('(', string2) != Action.countNbOcc(')', string2)) {
                        string2 = String.valueOf(string2) + "," + stringTokenizer.nextToken();
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    this.a.message.warning("Error in action syntax", 1);
                    this.badSyntax = true;
                    return;
                }
            }
            this.decodeShape(string2);
        }
    }

    private void decodeDrawString(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        String string2 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (string2.startsWith(COLOR)) {
                try {
                    while (Action.countNbOcc('(', string2) != Action.countNbOcc(')', string2)) {
                        string2 = String.valueOf(string2) + "," + stringTokenizer.nextToken();
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    this.a.message.warning("Error in color syntax", 1);
                    this.badSyntax = true;
                    return;
                }
                this.processColor(string2.substring(COLOR.length()));
                continue;
            }
            this.textToDisp = string2;
        }
    }

    private void decodeEllipseParameters(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        String string2 = "";
        String string3 = "";
        String string4 = "";
        try {
            string4 = stringTokenizer.nextToken();
            string3 = stringTokenizer.nextToken();
            string2 = stringTokenizer.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            this.a.message.warning("Missing parameter for the ellipse", 1);
            this.badSyntax = true;
        }
        this.majAxisParser = UCDFilter.createParser(string4, this.a);
        this.minAxisParser = UCDFilter.createParser(string3, this.a);
        this.posAngleParser = UCDFilter.createParser(string2, this.a);
    }

    private void decodePMParameters(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        String string2 = "";
        String string3 = "";
        try {
            string2 = stringTokenizer.nextToken();
            string3 = stringTokenizer.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            this.a.message.warning("Missing parameter for the proper motion", 1);
            this.badSyntax = true;
        }
        this.pmRAParser = UCDFilter.createParser(string2, this.a);
        this.pmDecParser = UCDFilter.createParser(string3, this.a);
    }

    private void decodeRGB(String string) {
        String string2 = string.substring(string.indexOf("(") + 1, Math.max(string.lastIndexOf(")"), 0));
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        if (stringTokenizer.countTokens() != 3) {
            this.badSyntax = true;
            this.a.message.warning("rgb function should have exactly 3 parameters", 1);
            return;
        }
        try {
            this.redParser = UCDFilter.createParser(stringTokenizer.nextToken(), this.a);
            this.greenParser = UCDFilter.createParser(stringTokenizer.nextToken(), this.a);
            this.blueParser = UCDFilter.createParser(stringTokenizer.nextToken(), this.a);
        }
        catch (ParserException parserException) {
            this.a.message.warning("Malformed expression in rgb parameters, error", 1);
            this.badSyntax = true;
            return;
        }
        if (this.redParser.isConstant() && this.greenParser.isConstant() && this.blueParser.isConstant()) {
            this.color = new Color(Math.max(Math.min((float)this.redParser.eval() / 255.0f, 1.0f), 0.0f), Math.max(Math.min((float)this.greenParser.eval() / 255.0f, 1.0f), 0.0f), Math.max(Math.min((float)this.blueParser.eval() / 255.0f, 1.0f), 0.0f));
        } else {
            this.colorIsVariable = true;
        }
    }

    private void decodeRainbow(String string) {
        String string2 = string.substring(string.indexOf("(") + 1, Math.max(string.lastIndexOf(")"), 0));
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        if (stringTokenizer.countTokens() != 1 && stringTokenizer.countTokens() != 3) {
            this.badSyntax = true;
            this.a.message.warning("Incorrect syntax for rainbow function. Syntax is rainbow rainbow(exp[,minValue,maxValue])", 1);
            return;
        }
        try {
            this.rainbowParser = UCDFilter.createParser(stringTokenizer.nextToken(), this.a);
        }
        catch (ParserException parserException) {
            this.a.message.warning("Malformed expression in rainbow parameters, error", 1);
            this.badSyntax = true;
            return;
        }
        if (this.rainbowParser.isConstant()) {
            this.color = Color.getHSBColor(this.getHue((float)this.rainbowParser.eval()), 1.0f, 1.0f);
        } else {
            this.rainbowColorIsVariable = true;
        }
        if (stringTokenizer.hasMoreTokens()) {
            try {
                this.rainbowMinValue = Double.valueOf(stringTokenizer.nextToken());
                this.rainbowMaxValue = Double.valueOf(stringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                this.a.message.warning("Error in min/max values of rainbow function. Only decimal values are permitted,1");
                this.badSyntax = true;
                return;
            }
            this.mustComputeRainbowMinMax = false;
            this.userDefinedRainbowMinMax = true;
        }
    }

    private void decodeShape(String string) {
        String string2 = string.substring(string.indexOf("(") + 1, Math.max(string.lastIndexOf(")"), 0));
        if (string2.length() != 0) {
            this.shape = string.substring(SHAPE.length(), string.indexOf("(")).trim();
            if (this.shape.equals(SIZE) || this.shape.equals(FILLSIZE)) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                if (stringTokenizer.countTokens() != 1 && stringTokenizer.countTokens() != 3 && stringTokenizer.countTokens() != 5) {
                    this.badSyntax = true;
                    this.a.message.warning("Incorrect syntax for circle function. Syntax is circle (exp[,minRadius,maxRadius])", 1);
                    return;
                }
                try {
                    this.sizeParser = UCDFilter.createParser(stringTokenizer.nextToken(), this.a);
                }
                catch (ParserException parserException) {
                    this.a.message.warning("Malformed expression in action expression, error", 1);
                    this.badSyntax = true;
                }
                if (stringTokenizer.hasMoreTokens()) {
                    try {
                        this.minRadius = Integer.valueOf(stringTokenizer.nextToken());
                        this.maxRadius = Integer.valueOf(stringTokenizer.nextToken());
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.a.message.warning("Error in min/max values of circle radius. Only integer values are permitted", 1);
                        this.badSyntax = true;
                        return;
                    }
                }
                if (stringTokenizer.hasMoreTokens()) {
                    try {
                        this.minValue = Integer.valueOf(stringTokenizer.nextToken()).intValue();
                        this.maxValue = Integer.valueOf(stringTokenizer.nextToken()).intValue();
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.a.message.warning("Error in min/max values of expression. Only integer values are permitted", 1);
                        this.badSyntax = true;
                        return;
                    }
                    this.mustComputeMinMax = false;
                    this.userDefinedMinMax = true;
                }
            } else if (this.shape.equals(ELLIPSE)) {
                this.decodeEllipseParameters(string2);
            } else if (this.shape.equals(PM)) {
                this.decodePMParameters(string2);
            }
        } else {
            this.shape = string.substring(SHAPE.length());
            if (this.shape.equals(ELLIPSE) || this.shape.equals(SIZE) || this.shape.equals(FILLSIZE) || this.shape.equals(PM)) {
                this.a.message.warning("Error, missing parameters for the action " + this.shape, 1);
                this.badSyntax = true;
            }
        }
    }

    private void doDrawEllipse(Graphics graphics, Color color, Point point, double d, double d2, double d3) {
        d3 = d3 * Math.PI / 180.0;
        int n = 30;
        Point[] pointArray = new Point[n];
        int n2 = 0;
        while (n2 < n) {
            double d4 = 2.0 * (double)n2 / (double)n * Math.PI;
            double d5 = d * Math.cos(d4);
            double d6 = d2 * Math.sin(d4);
            double d7 = d5 * Math.cos(d3) - d6 * Math.sin(d3) + (double)point.x;
            double d8 = d5 * Math.sin(d3) + d6 * Math.cos(d3) + (double)point.y;
            pointArray[n2] = new Point((int)d7, (int)d8);
            ++n2;
        }
        graphics.setColor(color);
        int n3 = 0;
        while (n3 < n - 1) {
            graphics.drawLine(pointArray[n3].x, pointArray[n3].y, pointArray[n3 + 1].x, pointArray[n3 + 1].y);
            ++n3;
        }
        graphics.drawLine(pointArray[n - 1].x, pointArray[n - 1].y, pointArray[0].x, pointArray[0].y);
    }

    private void drawEllipse(Source source, Graphics graphics, Point point, Color color, int n, int n2) {
        double d = source.values[n][n2][0];
        double d2 = source.values[n][n2][1];
        double d3 = source.values[n][n2][2];
        if (d3 == -1.0) {
            d3 = 0.0;
        }
        if (d == -1.0) {
            return;
        }
        Plan plan = this.a.calque.getPlanRef();
        if (plan == null) {
            plan = source.plan;
        }
        Coord coord = new Coord();
        coord.al = source.raj;
        coord.del = source.dej;
        Coord coord2 = new Coord();
        coord2.al = source.raj;
        coord2.del = source.dej;
        coord2 = plan.projd.getXY(coord2);
        double d4 = coord2.x;
        double d5 = coord2.y;
        ZoomView zoomView = this.a.calque.view.zoomview;
        coord.al += d / 3600.0 * Math.sin(d3 * 2.0 * Math.PI / 360.0) / Math.cos(coord.del * 2.0 * Math.PI / 360.0);
        coord.del += d / 3600.0 * Math.cos(d3 * 2.0 * Math.PI / 360.0);
        coord2.al += d2 / 3600.0 * Math.cos(d3 * 2.0 * Math.PI / 360.0) / Math.cos(coord2.del * 2.0 * Math.PI / 360.0);
        coord2.del += -(d2 / 3600.0) * Math.sin(d3 * 2.0 * Math.PI / 360.0);
        coord = new Coord(coord.al, coord.del);
        coord = plan.projd.getXY(coord);
        coord2 = new Coord(coord2.al, coord2.del);
        coord2 = plan.projd.getXY(coord2);
        Point point2 = zoomView.getViewCoord(coord.x, coord.y);
        double d6 = coord.x;
        double d7 = coord.y;
        Point point3 = zoomView.getViewCoord(coord.x - 2.0 * (coord.x - d4), coord.y - 2.0 * (coord.y - d5));
        double d8 = Math.sqrt(Math.pow(point3.x - point2.x, 2.0) + Math.pow(point3.y - point2.y, 2.0));
        point2 = zoomView.getViewCoord(coord2.x, coord2.y);
        point3 = zoomView.getViewCoord(coord2.x - 2.0 * (coord2.x - d4), coord2.y - 2.0 * (coord2.y - d5));
        double d9 = Math.sqrt(Math.pow(point3.x - point2.x, 2.0) + Math.pow(point3.y - point2.y, 2.0));
        Point point4 = new Point((point2.x + point3.x) / 2, (point2.y + point3.y) / 2);
        double d10 = Math.atan((d5 - d7) / (d4 - d6)) * 180.0 / Math.PI;
        this.doDrawEllipse(graphics, color, point4, 0.5 * d8, 0.5 * d9, d10);
    }

    private void drawPM(Source source, Graphics graphics, Point point, Color color, int n, int n2) {
        double d = 1000.0;
        int n3 = 8;
        double d2 = source.values[n][n2][0];
        double d3 = source.values[n][n2][1];
        if (d2 == -1.0 && d3 == -1.0) {
            return;
        }
        Plan plan = this.a.calque.getPlanRef();
        if (plan == null) {
            plan = source.plan;
        }
        Coord coord = new Coord();
        coord.al = source.raj;
        coord.del = source.dej;
        coord = plan.projd.getXY(coord);
        double d4 = coord.x;
        double d5 = coord.y;
        ZoomView zoomView = this.a.calque.view.zoomview;
        n3 = (int)((double)n3 * zoomView.zoom);
        coord.al += (d2 *= d) / 3600000.0 / Math.cos(Math.PI * coord.del / 180.0);
        coord.del += (d3 *= d) / 3600000.0;
        coord = new Coord(coord.al, coord.del);
        coord = plan.projd.getXY(coord);
        Point point2 = zoomView.getViewCoord(d4, d5);
        Point point3 = zoomView.getViewCoord(coord.x, coord.y);
        double d6 = Math.atan((d5 - coord.y) / (d4 - coord.x));
        if (d4 - coord.x < 0.0) {
            d6 += Math.PI;
        }
        double d7 = d6 + 0.7853981633974483;
        Point point4 = new Point((int)((double)n3 * Math.cos(d7)) + point3.x, (int)((double)n3 * Math.sin(d7)) + point3.y);
        d7 = d6 - 0.7853981633974483;
        Point point5 = new Point((int)((double)n3 * Math.cos(d7)) + point3.x, (int)((double)n3 * Math.sin(d7)) + point3.y);
        graphics.setColor(color);
        graphics.drawLine(point2.x, point2.y, point3.x, point3.y);
        graphics.drawLine(point3.x, point3.y, point4.x, point4.y);
        graphics.drawLine(point3.x, point3.y, point5.x, point5.y);
    }

    private int findColorName(String string) {
        int n = 0;
        while (n < COLORNAME.length) {
            if (string.equalsIgnoreCase(COLORNAME[n])) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private int getClosingParenthesis(String string, int n) {
        int n2 = n;
        int n3;
        while ((n3 = string.indexOf(")", n)) != -1) {
            String string2 = string.substring(n2, n3 + 1);
            if (Action.countNbOcc('(', string2) + 1 == Action.countNbOcc(')', string2)) {
                return n3;
            }
            n = n3 + 1;
        }
        return -1;
    }

    private float getHue(float f) {
        float f2 = 0.78f;
        float f3 = 1.0f - f;
        if ((f3 *= 0.78f) > 0.78f) {
            f3 = 0.78f;
        }
        if (f3 < 0.0f) {
            f3 = 0.0f;
        }
        return f3;
    }

    private void processColor(String string) {
        int n = this.findColorName(string);
        if (n >= 0) {
            this.color = MYCOLORS[n];
            return;
        }
        if (string.startsWith(RGB)) {
            this.decodeRGB(string);
            return;
        }
        if (string.startsWith(RAINBOW)) {
            this.decodeRainbow(string);
            return;
        }
        this.color = this.decodeColorString(string);
    }

    private int processFunction(String string) {
        String string2;
        int n;
        int n2;
        if (string.length() == 0) {
            return -1;
        }
        if (string.startsWith("\"")) {
            int n3 = string.indexOf("\"", 1);
            if (n3 < 0) {
                this.badSyntax = true;
                this.a.message.warning("Error: A string was never closed", 1);
                return -1;
            }
            this.function = DRAWSTRING;
            this.textToDisp = string.substring(1, n3);
            return n3 + 1;
        }
        if (string.startsWith("[") || string.startsWith("{")) {
            int n4;
            int n5 = n4 = string.startsWith("[") ? string.indexOf("]") : string.indexOf("}");
            if (n4 < 0) {
                this.badSyntax = true;
                this.a.message.warning("Error in a parameter syntax", 1);
                return -1;
            }
            this.function = DRAWSTRING;
            this.textToDisp = string.substring(0, n4 + 1);
            return n4 + 1;
        }
        int n6 = string.indexOf(" ");
        int n7 = string.indexOf("(");
        if (n6 >= 0 && n7 >= 0) {
            n2 = Math.min(string.indexOf(" "), string.indexOf("("));
        }
        if ((n2 = n6 < 0 ? n7 : n6) < 0) {
            n2 = string.length();
        }
        if ((n = this.findColorName(string2 = string.substring(0, n2))) >= 0) {
            this.color = MYCOLORS[n];
            return string2.length();
        }
        if (string.startsWith(RGB)) {
            n2 = string.indexOf("(");
            if (n2 < 0) {
                this.badSyntax = true;
                this.a.message.warning("Error: missing parameters for rgb function !", 1);
                return -1;
            }
            int n8 = this.getClosingParenthesis(string, n2 + 1);
            if (n8 < 0) {
                this.badSyntax = true;
                this.a.message.warning("Error: closing parenthesis of rgb function was not found !", 1);
                return -1;
            }
            this.decodeRGB(string.substring(Math.max(0, n2), n8 + 1));
            return n8 + 1;
        }
        if (string.startsWith(RAINBOW)) {
            n2 = string.indexOf("(");
            if (n2 < 0) {
                this.badSyntax = true;
                this.a.message.warning("Error: missing parameters for rainbow function !", 1);
                return -1;
            }
            int n9 = this.getClosingParenthesis(string, n2 + 1);
            if (n9 < 0) {
                this.badSyntax = true;
                this.a.message.warning("Error: closing parenthesis of rainbow function was not found !", 1);
                return -1;
            }
            this.decodeRainbow(string.substring(Math.max(0, n2), n9 + 1));
            return n9 + 1;
        }
        if (string2.startsWith("#")) {
            this.color = this.decodeColorString(string.substring(0, n2));
            return string2.length();
        }
        if (string2.equals(CARRE) || string2.equals(CROIX) || string2.equals(PLUS) || string2.equals(LOSANGE) || string2.equals(POINT) || string2.equals(DOT)) {
            this.shape = string2;
            this.function = DRAWOBJECT;
            return string2.length();
        }
        if (string.startsWith(SIZE) || string.startsWith(FILLSIZE) || string.startsWith(ELLIPSE) || string.startsWith(PM)) {
            this.function = DRAWOBJECT;
            n2 = string.indexOf("(");
            if (n2 < 0) {
                this.badSyntax = true;
                this.a.message.warning("Error: missing parameters for shape function !", 1);
                return -1;
            }
            int n10 = this.getClosingParenthesis(string, n2 + 1);
            if (n10 < 0) {
                this.badSyntax = true;
                this.a.message.warning("Error: closing parenthesis of shape function was not found !", 1);
                return -1;
            }
            this.decodeShape(SHAPE + string.substring(0, n10 + 1));
            return n10 + 1;
        }
        try {
            this.parserToDisp = UCDFilter.createParser(string, this.a);
            this.function = DRAWSTRING;
            return -1;
        }
        catch (ParserException parserException) {
            this.badSyntax = true;
            this.a.message.warning("Your function " + string + " could not be understood !", 1);
            return -1;
        }
    }

    protected void reset() {
        if (!this.userDefinedMinMax) {
            this.mustComputeMinMax = true;
        }
        this.mustComputeRGBMinMax = true;
        if (!this.userDefinedRainbowMinMax) {
            this.mustComputeRainbowMinMax = true;
        }
    }

    protected static boolean setAllVariables(Parser parser, Source source, boolean bl) {
        return Action.setAllVariables(parser, source, bl, false);
    }

    protected static boolean setAllVariables(Parser parser, Source source, boolean bl, boolean bl2) {
        Enumeration enumeration = parser.getVariables();
        while (enumeration.hasMoreElements()) {
            int n;
            String string = (String)enumeration.nextElement();
            if (string.startsWith("[")) {
                n = source.findUCD(UCDFilter.decodeUCD(string).substring(1, string.length() - 1).toUpperCase());
                if (n < 0) {
                    if (bl) continue;
                    return false;
                }
            } else {
                n = source.findColumn(UCDFilter.decodeUCD(string).substring(1, string.length() - 1));
                if (n < 0) {
                    if (bl) continue;
                    return false;
                }
            }
            try {
                parser.setVar(string, Double.valueOf(source.getValue(n)));
            }
            catch (NumberFormatException numberFormatException) {
                if (bl) continue;
                return false;
            }
            catch (NullPointerException nullPointerException) {
                if (bl) continue;
                return false;
            }
            if (!bl2 || parser.setVarUnit(string, source.getUnit(n))) continue;
            return false;
        }
        return true;
    }
}

