/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot;

import java.awt.Color;
import java.awt.Graphics;
import java.util.LinkedList;
import java.util.ListIterator;
import ptolemy.plot.PlotBox;

public class Render
extends PlotBox {
    private int[][] _colormap = new int[3][256];
    private static final int _HIGHCOLOR = 225;
    private LinkedList _imageData = new LinkedList();
    private static final int _LOWCOLOR = 175;
    private static final int _NOTVISIBLE = -999;
    private boolean _showing = false;
    private double _xIncrement = 0.0;
    private double _xOffset = 0.0;
    private double _yIncrement = 0.0;
    private double _yOffset = 0.0;

    public Render() {
        this.setGrid(false);
        this._setPadding(0.0);
        int[] nArray = new int[256];
        int n = 0;
        while (n <= 255) {
            nArray[n] = n;
            ++n;
        }
        this._colormap[0] = nArray;
        this._colormap[1] = nArray;
        this._colormap[2] = nArray;
    }

    public synchronized void addStripe(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray2.length);
        this._imageData.add(nArray2);
        this._xTop = (double)this._imageData.size() * this.getXIncrement();
        this._xBottom = this.getXOffset();
        this._yTop = (double)((int[])this._imageData.getFirst()).length * this.getYIncrement();
        this._yBottom = this.getYOffset();
        this.setXRange(this.getXOffset(), (double)this._imageData.size() * this.getXIncrement());
        this.setYRange(this.getYOffset(), (double)((int[])this._imageData.getFirst()).length * this.getYIncrement());
    }

    public synchronized void clearData() {
        this._imageData = new LinkedList();
    }

    public synchronized int[][] getColormap() {
        return this._colormap;
    }

    public synchronized double getXIncrement() {
        return this._xIncrement;
    }

    public synchronized double getXOffset() {
        return this._xOffset;
    }

    public synchronized double getYIncrement() {
        return this._yIncrement;
    }

    public synchronized double getYOffset() {
        return this._yOffset;
    }

    public synchronized void samplePlot() {
        Runnable runnable = new Runnable(){

            public void run() {
                Render render = Render.this;
                synchronized (render) {
                    Render.this.clear(true);
                    Render.this.setGrid(false);
                    Render.this.setTitle("Sample image");
                    Render.this.setYLabel("hertz");
                    Render.this.setXLabel("time");
                    Render.this.setXIncrement(0.05);
                    Render.this.setXOffset(0.0);
                    Render.this.setYIncrement(40.0);
                    Render.this.setYOffset(0.0);
                    int[] nArray = new int[100];
                    int n = 225;
                    int n2 = 0;
                    while (n2 < nArray.length) {
                        nArray[n2] = n;
                        n = n == 175 ? 225 : 175;
                        ++n2;
                    }
                    int[] nArray2 = new int[100];
                    System.arraycopy(nArray, 0, nArray2, 1, nArray2.length - 1);
                    nArray2[0] = 175;
                    Render.this.clearData();
                    int n3 = 1;
                    while (n3 <= 50) {
                        Render.this.addStripe(nArray);
                        Render.this.addStripe(nArray2);
                        ++n3;
                    }
                }
            }
        };
        this.deferIfNecessary(runnable);
        this.repaint();
    }

    public synchronized void setColormap(int[][] nArray) {
        this._colormap = nArray;
    }

    public synchronized void setXIncrement(double d) {
        this._xIncrement = d;
    }

    public synchronized void setXOffset(double d) {
        this._xOffset = d;
    }

    public synchronized void setYIncrement(double d) {
        this._yIncrement = d;
    }

    public synchronized void setYOffset(double d) {
        this._yOffset = d;
    }

    protected synchronized void _drawPlot(Graphics graphics, boolean bl) {
        super._drawPlot(graphics, bl);
        double d = (double)this._ulx + (this._originalXlow - this._xMin) * this._xscale + 1.0;
        double d2 = this._xIncrement * this._xscale;
        double d3 = d + d2;
        ListIterator listIterator = this._imageData.listIterator(0);
        while (listIterator.hasNext()) {
            int[] nArray = (int[])listIterator.next();
            this._drawStripe(graphics, nArray, d, (int)d3 - (int)d);
            d = d3;
            d3 = d + d2;
        }
        this._showing = true;
    }

    private int[] _clipXWidth(int n, int n2) {
        int[] nArray = new int[2];
        if (n < this._ulx + 1 && n + n2 > this._lrx - 1) {
            nArray[0] = this._ulx + 1;
            nArray[1] = this._lrx - this._ulx - 1;
        } else if (n < this._ulx + 1 && n + n2 > this._ulx + 1) {
            nArray[0] = this._ulx + 1;
            nArray[1] = n2 - (this._ulx - n);
        } else if (n >= this._ulx + 1 && n + n2 <= this._lrx - 1) {
            nArray[0] = n;
            nArray[1] = n2;
        } else if (n <= this._lrx - 1 && n + n2 > this._lrx - 1) {
            nArray[0] = n;
            nArray[1] = this._lrx - n;
        } else {
            nArray[0] = -999;
        }
        return nArray;
    }

    private int[] _clipYHeight(int n, int n2) {
        int[] nArray = new int[2];
        if (n < this._uly + 1 && n + n2 > this._lry - 1) {
            nArray[0] = this._uly + 1;
            nArray[1] = this._lry - this._uly - 1;
        } else if (n < this._uly + 1 && n + n2 >= this._uly + 1) {
            nArray[0] = this._uly + 1;
            nArray[1] = n2 - (this._uly - n);
        } else if (n >= this._uly + 1 && n + n2 <= this._lry - 1) {
            nArray[0] = n;
            nArray[1] = n2;
        } else if (n <= this._lry - 1 && n + n2 > this._lry - 1) {
            nArray[0] = n;
            nArray[1] = this._lry - n;
        } else {
            nArray[0] = -999;
        }
        return nArray;
    }

    private void _drawStripe(Graphics graphics, int[] nArray, double d, double d2) {
        if (d2 < 1.0) {
            d2 = 1.0;
        }
        double d3 = (double)(this._lry - (int)((this._originalYhigh - this._yMin) * this._yscale)) + 1.0;
        double d4 = this._yIncrement * this._yscale;
        double d5 = d3 + d4;
        int n = 0;
        while (n < nArray.length) {
            this._drawPatch(graphics, (int)d, (int)d3, (int)d2, (int)d5 - (int)d3, nArray[n]);
            d3 = d5;
            d5 = d3 + d4;
            ++n;
        }
    }

    private void _drawPatch(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        if (n4 < 1) {
            n4 = 1;
        }
        int n6 = this._colormap[0][n5];
        int n7 = this._colormap[1][n5];
        int n8 = this._colormap[2][n5];
        graphics.setColor(new Color(n6, n7, n8));
        int[] nArray = this._clipXWidth(n, n3);
        n = nArray[0];
        n3 = nArray[1];
        if (n == -999) {
            return;
        }
        int[] nArray2 = this._clipYHeight(n2, n4);
        n2 = nArray2[0];
        n4 = nArray2[1];
        if (n2 == -999) {
            return;
        }
        graphics.fillRect(n, n2, n3, n4);
    }
}

