/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot;

import com.jvt.applets.PlotButtons;
import com.jvt.applets.PlotVOApplet;
import com.jvt.statistics.StatsCalculator;
import com.jvt.utils.JVTUtil;
import com.jvt.votable.Column;
import com.jvt.votable.PlotColumn;
import com.jvt.votable.PlotData;
import com.jvt.votable.PlotFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import ptolemy.gui.CloseListener;
import ptolemy.gui.Query;
import ptolemy.plot.PlotBox;

public class PlotStatisticsDialog
extends JDialog {
    private Component _contents;
    private PlotVOApplet _pva;
    private PlotButtons _btns;
    private PlotData _pd;
    public static final String FILTER_LABEL = "filter";
    public static final String CALCULATE_LABEL = "Calculate";
    public static final String CLOSE_LABEL = "Close";
    private JPanel _basic;
    private JPanel _advanced;
    private JTabbedPane _tabbedBase;
    private JOptionPane _optionPane;
    private String _buttonPressed = "";
    private static Object[] _buttons = new Object[2];
    private boolean _doneHandleClosing = false;
    private String _selectedX;
    private String _selectedY;
    private String _selectedFilter;
    private Query _resultBasic = new Query();
    private Query _resultAdv = new Query();
    private JComboBox _filterCol = new JComboBox();
    private JComboBox _xCol = new JComboBox();
    private JComboBox _yCol = new JComboBox();
    private JComboBox _zCol = new JComboBox();
    private JComboBox _filterColB = new JComboBox();
    private JComboBox _xColB = new JComboBox();
    private JComboBox _yColB = new JComboBox();
    private JLabel _lblFilter = new JLabel("filter");
    private JLabel _lblX = new JLabel("X");
    private JLabel _lblY = new JLabel("Y");
    private JLabel _lblZ = new JLabel("Z");
    private JLabel _lblFilterB = new JLabel("filter");
    private JLabel _lblXB = new JLabel("X");
    private JLabel _lblYB = new JLabel("Y");
    private JPanel _panFilterlbl = new JPanel();
    private JPanel _panXlbl = new JPanel();
    private JPanel _panYlbl = new JPanel();
    private JPanel _panZlbl = new JPanel();
    private JPanel _panFilterCol = new JPanel();
    private JPanel _panXCol = new JPanel();
    private JPanel _panYCol = new JPanel();
    private JPanel _panZCol = new JPanel();
    private JPanel _panFilterlblB = new JPanel();
    private JPanel _panXlblB = new JPanel();
    private JPanel _panYlblB = new JPanel();
    private JPanel _panFilterColB = new JPanel();
    private JPanel _panXColB = new JPanel();
    private JPanel _panYColB = new JPanel();
    private JTextField _obsrvTxt = new JTextField("", 10);
    private JTextField _rangeTxt = new JTextField("", 10);
    private JTextField _minTxt = new JTextField("", 10);
    private JTextField _maxTxt = new JTextField("", 10);
    private JTextField _meanTxt = new JTextField("", 10);
    private JTextField _varTxt = new JTextField("", 10);
    private JTextField _stdevTxt = new JTextField("", 10);
    private JTextField _skewTxt = new JTextField("", 10);
    private JTextField _kurtTxt = new JTextField("", 10);
    private double[] X_X;
    private double[] X_Y;
    private double[] XY_X;
    private double[] XY_Y;
    private double[] XYZ_X;
    private double[] XYZ_Y;
    private double[] XYZ_Z;
    private ArrayList _dax1 = new ArrayList();
    private ArrayList _day1 = new ArrayList();
    private ArrayList _dax2 = new ArrayList();
    private ArrayList _dax3 = new ArrayList();
    private ArrayList _day2 = new ArrayList();
    private ArrayList _day3 = new ArrayList();
    private ArrayList _daz3 = new ArrayList();
    private String _filter;
    private String _colX;
    private String _colY;
    private String _colZ;
    private boolean _histogram;
    private double[] _xRange;
    private double[] _yRange = new double[2];
    private double _minX;
    private double _maxX;
    private double _minY;
    private double _maxY;
    private JRadioButton _entireData;
    private JRadioButton _plotData;
    private JRadioButton _selectedData;
    private ButtonGroup _radioButtonGroup;
    private JPanel _radioButtonsPanel;
    private static final String ENTIRE_DATA_LABEL = "Entire Data";
    private static final String PLOT_DATA_LABEL = "Only Plot Data";
    private static final String SELECTED_DATA_LABEL = "Only Selected Point Data";
    private Double[] dataX;
    private Double[] dataY;
    private Double[] dataZ;
    private ArrayList selectedIndexs;
    protected final PlotBox _plot;

    public PlotStatisticsDialog(PlotBox plotBox, Frame frame, PlotVOApplet plotVOApplet, PlotButtons plotButtons) {
        super(frame, "Plot Statistics", true);
        this._plot = plotBox;
        this._pva = plotVOApplet;
        this._btns = plotButtons;
        this.init(this._plot, this._pva);
        this.addPanel(frame);
    }

    public void init(PlotBox plotBox, PlotVOApplet plotVOApplet) {
        this._basic = new JPanel();
        this._advanced = new JPanel();
        this._tabbedBase = new JTabbedPane();
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        JPanel jPanel6 = new JPanel();
        JPanel jPanel7 = new JPanel();
        JPanel jPanel8 = new JPanel();
        JPanel jPanel9 = new JPanel();
        JLabel jLabel = new JLabel("X ");
        JLabel jLabel2 = new JLabel("Y ");
        String[] stringArray = plotVOApplet.getColumnNames();
        this._selectedX = this._btns.getSelectedXColumn();
        this._selectedY = this._btns.getSelectedYColumn();
        int n = 0;
        while (n < plotVOApplet.getNumOfColumns()) {
            this._xCol.addItem(stringArray[n]);
            this._yCol.addItem(stringArray[n]);
            this._zCol.addItem(stringArray[n]);
            this._xColB.addItem(stringArray[n]);
            this._yColB.addItem(stringArray[n]);
            if (this._selectedX.equals(stringArray[n])) {
                this._xCol.setSelectedIndex(n);
                this._xColB.setSelectedIndex(n);
            }
            if (this._selectedY.equals(stringArray[n])) {
                this._yCol.setSelectedIndex(n);
                this._yColB.setSelectedIndex(n);
            }
            ++n;
        }
        this._xCol.addActionListener(new ComboListener());
        this._xColB.addActionListener(new ComboListener());
        this._yCol.addActionListener(new ComboListener());
        this._yColB.addActionListener(new ComboListener());
        String[] stringArray2 = plotVOApplet.getFilterNames();
        this._selectedFilter = this._btns.getSelectedFilter();
        int n2 = 0;
        while (n2 < stringArray2.length) {
            this._filterCol.addItem(stringArray2[n2]);
            this._filterColB.addItem(stringArray2[n2]);
            if (this._selectedFilter.equals(stringArray2[n2])) {
                this._filterCol.setSelectedIndex(n2);
                this._filterColB.setSelectedIndex(n2);
            }
            ++n2;
        }
        this._filterCol.addActionListener(new ComboListener());
        this._filterColB.addActionListener(new ComboListener());
        this._xCol.setMaximumRowCount(6);
        this._yCol.setMaximumRowCount(6);
        this._zCol.setMaximumRowCount(6);
        this._filterCol.setMaximumRowCount(6);
        this._filterColB.setMaximumRowCount(6);
        this._xColB.setMaximumRowCount(6);
        this._yColB.setMaximumRowCount(6);
        this._panFilterlblB.add(this._lblFilterB);
        this._panXlblB.add(this._lblXB);
        this._panYlblB.add(this._lblYB);
        this._panFilterColB.add(this._filterColB);
        this._panXColB.add(this._xColB);
        this._panYColB.add(this._yColB);
        jPanel.setLayout(new FlowLayout(1, 2, 2));
        jPanel.add(this._panFilterlblB);
        jPanel.add(this._panFilterColB);
        jPanel.add(this._panXlblB);
        jPanel.add(this._panXColB);
        jPanel.add(this._panYlblB);
        jPanel.add(this._panYColB);
        this._resultBasic.setTextWidth(9);
        this._resultBasic.addLine("obsrv", "No of observations", "");
        this._resultBasic.addLine("rang", "Range ", "");
        this._resultBasic.addLine("min", "Minimum ", "");
        this._resultBasic.addLine("max", "Maximum ", "");
        this._resultBasic.addLine("mean", "Mean ", "");
        this._resultBasic.addLine("var", "Variance ", "");
        this._resultBasic.addLine("stdev", "Standard deviation ", "");
        this._resultBasic.addLine("skew", "Skew ", "");
        this._resultBasic.addLine("kurt", "Kurtosis ", "");
        jPanel5.setLayout(new BoxLayout(jPanel5, 1));
        jPanel5.add(this._obsrvTxt);
        jPanel5.add(this._rangeTxt);
        jPanel5.add(this._minTxt);
        jPanel5.add(this._maxTxt);
        jPanel5.add(this._meanTxt);
        jPanel5.add(this._varTxt);
        jPanel5.add(this._stdevTxt);
        jPanel5.add(this._skewTxt);
        jPanel5.add(this._kurtTxt);
        jPanel2.setLayout(new FlowLayout(1, 1, 3));
        jPanel2.add(this._resultBasic);
        jPanel2.add(jPanel5);
        jPanel7.add(jLabel);
        jPanel7.setPreferredSize(new Dimension(20, 20));
        jPanel8.add(jLabel2);
        jPanel8.setPreferredSize(new Dimension(230, 20));
        jPanel9.setLayout(new FlowLayout(2, 0, 3));
        jPanel9.setPreferredSize(new Dimension(400, 25));
        jPanel9.add(jPanel7);
        jPanel9.add(jPanel8);
        this.setModal(true);
        this._basic.setLayout(new BorderLayout());
        this._basic.add((Component)jPanel, "North");
        this._basic.add((Component)jPanel9, "Center");
        this._basic.add((Component)jPanel2, "South");
        this._panFilterlbl.add(this._lblFilter);
        this._panXlbl.add(this._lblX);
        this._panYlbl.add(this._lblY);
        this._panZlbl.add(this._lblZ);
        this._panFilterCol.add(this._filterCol);
        this._panXCol.add(this._xCol);
        this._panYCol.add(this._yCol);
        this._panZCol.add(this._zCol);
        jPanel3.setLayout(new FlowLayout(1, 2, 2));
        jPanel3.add(this._panFilterlbl);
        jPanel3.add(this._panFilterCol);
        jPanel3.add(this._panXlbl);
        jPanel3.add(this._panXCol);
        jPanel3.add(this._panYlbl);
        jPanel3.add(this._panYCol);
        jPanel3.add(this._panZlbl);
        jPanel3.add(this._panZCol);
        this._resultAdv.addLine("cor", "Linear correlation of X & Y", "");
        this._resultAdv.addLine("signi", "   - Significance(t)", "");
        this._resultAdv.addLine("prob", "   - Probablity", "");
        this._resultAdv.addLine("rnk", "Rank Correlation of X & Y", "");
        this._resultAdv.addLine("signir", "    - Significance(t)", "");
        this._resultAdv.addLine("probr", "    - Probablity", "");
        this._resultAdv.addLine("par", "Partial correlation of X, Y & Z", "");
        jPanel4.add(this._resultAdv);
        this._advanced.setLayout(new BorderLayout());
        this._advanced.add((Component)jPanel3, "North");
        this._advanced.add((Component)jPanel4, "Center");
        this._tabbedBase.addTab("Basic Functions", this._basic);
        this._tabbedBase.addTab("Advanced Functions", this._advanced);
    }

    private JPanel addRadioButtonsPanel() {
        this._radioButtonsPanel = new JPanel();
        this._entireData = new JRadioButton(ENTIRE_DATA_LABEL, false);
        this._radioButtonsPanel.add(this._entireData);
        this._plotData = new JRadioButton(PLOT_DATA_LABEL, true);
        this._radioButtonsPanel.add(this._plotData);
        this._selectedData = new JRadioButton(SELECTED_DATA_LABEL, false);
        this._radioButtonsPanel.add(this._selectedData);
        this._radioButtonGroup = new ButtonGroup();
        this._radioButtonGroup.add(this._entireData);
        this._radioButtonGroup.add(this._plotData);
        this._radioButtonGroup.add(this._selectedData);
        return this._radioButtonsPanel;
    }

    private void addPanel(Frame frame) {
        PlotStatisticsDialog._buttons[0] = CALCULATE_LABEL;
        PlotStatisticsDialog._buttons[1] = CLOSE_LABEL;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(this._tabbedBase);
        jPanel.add(this.addRadioButtonsPanel());
        this._contents = this._tabbedBase;
        this._optionPane = new JOptionPane(jPanel, 1, 0, null, _buttons, _buttons[0]);
        this._optionPane.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (PlotStatisticsDialog.this.isVisible() && propertyChangeEvent.getSource() == PlotStatisticsDialog.this._optionPane && (string.equals("value") || string.equals("inputValue"))) {
                    Object object = PlotStatisticsDialog.this._optionPane.getValue();
                    if (object == JOptionPane.UNINITIALIZED_VALUE) {
                        return;
                    }
                    PlotStatisticsDialog.this._optionPane.setValue(JOptionPane.UNINITIALIZED_VALUE);
                    if (object instanceof String) {
                        PlotStatisticsDialog.this._buttonPressed = (String)object;
                    }
                    if (_buttons[0].equals(PlotStatisticsDialog.this._buttonPressed) && PlotStatisticsDialog.this._plotData.isSelected()) {
                        PlotStatisticsDialog.this.apply();
                        return;
                    }
                    if (_buttons[0].equals(PlotStatisticsDialog.this._buttonPressed) && PlotStatisticsDialog.this._entireData.isSelected()) {
                        PlotStatisticsDialog.this.apply();
                        return;
                    }
                    if (_buttons[0].equals(PlotStatisticsDialog.this._buttonPressed) && PlotStatisticsDialog.this._selectedData.isSelected()) {
                        PlotStatisticsDialog.this.apply();
                        return;
                    }
                    ((Component)PlotStatisticsDialog.this).setVisible(false);
                    PlotStatisticsDialog.this._handleClosing();
                }
            }
        });
        this.getContentPane().add(this._optionPane);
        this.pack();
        this.setResizable(false);
        if (frame != null) {
            this.setLocationRelativeTo(frame);
        } else {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            ((Component)this).setLocation((toolkit.getScreenSize().width - this.getSize().width) / 2, (toolkit.getScreenSize().height - this.getSize().height) / 2);
        }
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                PlotStatisticsDialog.this._handleClosing();
            }
        });
        this.apply();
        ((Component)this).setVisible(true);
    }

    public String getSelXCol() {
        return (String)this._xCol.getSelectedItem();
    }

    public String getSelYCol() {
        return (String)this._yCol.getSelectedItem();
    }

    public String getSelZCol() {
        return (String)this._zCol.getSelectedItem();
    }

    public String getSelFilter() {
        return (String)this._filterCol.getSelectedItem();
    }

    public void apply() {
        JVTUtil.showWaitCursor(this);
        try {
            this._xRange = this._plot.getXRange();
            this._yRange = this._plot.getYRange();
            this._minX = this._xRange[0];
            this._maxX = this._xRange[1];
            this._minY = this._yRange[0];
            this._maxY = this._yRange[1];
            if (this._btns.isLogX()) {
                this._minX = Math.pow(10.0, this._minX);
                this._maxX = Math.pow(10.0, this._maxX);
            }
            if (this._btns.isLogY()) {
                this._minY = Math.pow(10.0, this._minY);
                this._maxY = Math.pow(10.0, this._maxY);
            }
            this._filter = this.getSelFilter();
            this._colX = this.getSelXCol();
            this._colY = this.getSelYCol();
            this._colZ = this.getSelZCol();
            this._histogram = this._pva.isHistogram();
            this._pd = this._pva.getPlotData();
            StatsCalculator statsCalculator = new StatsCalculator();
            this.fillArrays();
            DecimalFormat decimalFormat = new DecimalFormat("0.000E0");
            DecimalFormat decimalFormat2 = new DecimalFormat("0.###");
            this._resultBasic.set("obsrv", JVTUtil.applyProperFormat(statsCalculator.findnoofobservations(this.X_X), decimalFormat2, decimalFormat));
            this._resultBasic.set("rang", JVTUtil.applyProperFormat(statsCalculator.findrange(this.X_X), decimalFormat2, decimalFormat));
            this._resultBasic.set("min", JVTUtil.applyProperFormat(statsCalculator.findmin(this.X_X), decimalFormat2, decimalFormat));
            this._resultBasic.set("max", JVTUtil.applyProperFormat(statsCalculator.findmax(this.X_X), decimalFormat2, decimalFormat));
            this._resultBasic.set("mean", JVTUtil.applyProperFormat(statsCalculator.findmean(this.X_X), decimalFormat2, decimalFormat));
            this._resultBasic.set("var", JVTUtil.applyProperFormat(statsCalculator.findvariance(this.X_X), decimalFormat2, decimalFormat));
            this._resultBasic.set("stdev", JVTUtil.applyProperFormat(statsCalculator.findstddev(this.X_X), decimalFormat2, decimalFormat));
            this._resultBasic.set("skew", JVTUtil.applyProperFormat(statsCalculator.findskew(this.X_X), decimalFormat2, decimalFormat));
            this._resultBasic.set("kurt", JVTUtil.applyProperFormat(statsCalculator.findkurtosis(this.X_X), decimalFormat2, decimalFormat));
            this._obsrvTxt.setText(JVTUtil.applyProperFormat(statsCalculator.findnoofobservations(this.X_Y), decimalFormat2, decimalFormat));
            this._rangeTxt.setText(JVTUtil.applyProperFormat(statsCalculator.findrange(this.X_Y), decimalFormat2, decimalFormat));
            this._minTxt.setText(JVTUtil.applyProperFormat(statsCalculator.findmin(this.X_Y), decimalFormat2, decimalFormat));
            this._maxTxt.setText(JVTUtil.applyProperFormat(statsCalculator.findmax(this.X_Y), decimalFormat2, decimalFormat));
            this._meanTxt.setText(JVTUtil.applyProperFormat(statsCalculator.findmean(this.X_Y), decimalFormat2, decimalFormat));
            this._varTxt.setText(JVTUtil.applyProperFormat(statsCalculator.findvariance(this.X_Y), decimalFormat2, decimalFormat));
            this._stdevTxt.setText(JVTUtil.applyProperFormat(statsCalculator.findstddev(this.X_Y), decimalFormat2, decimalFormat));
            this._skewTxt.setText(JVTUtil.applyProperFormat(statsCalculator.findskew(this.X_Y), decimalFormat2, decimalFormat));
            this._kurtTxt.setText(JVTUtil.applyProperFormat(statsCalculator.findkurtosis(this.X_Y), decimalFormat2, decimalFormat));
            double d = statsCalculator.findlinearcorrelation(this.XY_X, this.XY_Y);
            this._resultAdv.set("cor", JVTUtil.applyProperFormat(d, decimalFormat2, decimalFormat));
            d = statsCalculator.findt_linear(this.XY_X, this.XY_Y);
            this._resultAdv.set("signi", JVTUtil.applyProperFormat(d, decimalFormat2, decimalFormat));
            d = statsCalculator.findlinearcorprob(this.XY_X, this.XY_Y);
            int n = statsCalculator.getErrorNum();
            if (n != 0) {
                this._resultAdv.set("prob", "Error");
            } else {
                this._resultAdv.set("prob", JVTUtil.applyProperFormat(d, decimalFormat2, decimalFormat));
            }
            d = statsCalculator.findrankcorrelation(this.XY_X, this.XY_Y);
            this._resultAdv.set("rnk", JVTUtil.applyProperFormat(d, decimalFormat2, decimalFormat));
            d = statsCalculator.findt_rank(this.XY_X, this.XY_Y);
            this._resultAdv.set("signir", JVTUtil.applyProperFormat(d, decimalFormat2, decimalFormat));
            d = statsCalculator.findrankcorprob(this.XY_X, this.XY_Y);
            n = statsCalculator.getErrorNum();
            if (n != 0) {
                this._resultAdv.set("probr", "Error");
            } else {
                this._resultAdv.set("probr", JVTUtil.applyProperFormat(d, decimalFormat2, decimalFormat));
            }
            d = statsCalculator.findpartialcorrelation(this.XYZ_X, this.XYZ_Y, this.XYZ_Z);
            this._resultAdv.set("par", JVTUtil.applyProperFormat(d, decimalFormat2, decimalFormat));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        JVTUtil.showDefaultCursor(this);
    }

    public void fillArrays() {
        int n;
        Column column;
        int n2;
        boolean[] blArray = new boolean[]{};
        this._dax1.clear();
        this._day1.clear();
        this._dax2.clear();
        this._dax3.clear();
        this._day2.clear();
        this._day3.clear();
        this._daz3.clear();
        if (this._entireData.isSelected() || this._plotData.isSelected()) {
            this.dataX = new Double[0];
            this.dataY = new Double[0];
            this.dataZ = new Double[0];
            n2 = 0;
            while (n2 < this._pd.getNumOfPlotColumns()) {
                column = this._pd.getPlotColumn(n2);
                if (this._colX.equals(column.getName())) {
                    this.dataX = ((PlotColumn)column).getData();
                }
                if (this._colY.equals(column.getName())) {
                    this.dataY = ((PlotColumn)column).getData();
                }
                if (this._colZ.equals(column.getName())) {
                    this.dataZ = ((PlotColumn)column).getData();
                }
                ++n2;
            }
        }
        if (this._selectedData.isSelected() && !this._histogram) {
            this.selectedIndexs = this._pva.getSelectedPointsIndex();
            this.dataX = new Double[this.selectedIndexs.size()];
            this.dataY = new Double[this.selectedIndexs.size()];
            this.dataZ = new Double[this.selectedIndexs.size()];
            n2 = 0;
            while (n2 < this.selectedIndexs.size()) {
                int n3 = 0;
                while (n3 < this._pd.getNumOfPlotColumns()) {
                    Integer n4 = (Integer)this.selectedIndexs.get(n2);
                    n = n4;
                    PlotColumn plotColumn = this._pd.getPlotColumn(n3);
                    if (this._colX.equals(plotColumn.getName())) {
                        this.dataX[n2] = plotColumn.getData(n);
                    }
                    if (this._colY.equals(plotColumn.getName())) {
                        this.dataY[n2] = plotColumn.getData(n);
                    }
                    if (this._colZ.equals(plotColumn.getName())) {
                        this.dataZ[n2] = plotColumn.getData(n);
                    }
                    ++n3;
                }
                ++n2;
            }
        }
        if ("All".equals(this._filter)) {
            if (this._entireData.isSelected()) {
                this.filter1(this.dataX, this.dataY, this.dataZ, blArray, false);
            } else if (this._plotData.isSelected() && !this._histogram) {
                this.filter2(this.dataX, this.dataY, this.dataZ, blArray, false);
            } else if (this._plotData.isSelected() && this._histogram || this._selectedData.isSelected() && this._histogram) {
                this.filter3(this.dataX, this.dataY, this.dataZ, blArray, false);
            } else if (this._selectedData.isSelected() && !this._histogram) {
                this.filter1(this.dataX, this.dataY, this.dataZ, blArray, false);
            }
        } else {
            n2 = 0;
            while (n2 < this._pd.getNumOfFilters()) {
                column = this._pd.getPlotFilter(n2);
                if (this._filter.equals(column.getName())) {
                    blArray = ((PlotFilter)column).getData();
                    break;
                }
                ++n2;
            }
            if (this._entireData.isSelected()) {
                this.filter1(this.dataX, this.dataY, this.dataZ, blArray, true);
            } else if (this._plotData.isSelected() && !this._histogram) {
                this.filter2(this.dataX, this.dataY, this.dataZ, blArray, true);
            } else if (this._plotData.isSelected() && this._histogram || this._selectedData.isSelected() && this._histogram) {
                this.filter3(this.dataX, this.dataY, this.dataZ, blArray, true);
            } else if (this._selectedData.isSelected() && !this._histogram) {
                this.filter1(this.dataX, this.dataY, this.dataZ, blArray, true);
            }
        }
        this.X_X = new double[this._dax1.size()];
        this.X_Y = new double[this._day1.size()];
        n2 = 0;
        while (n2 < this._dax1.size()) {
            this.X_X[n2] = (Double)this._dax1.get(n2);
            ++n2;
        }
        int n5 = 0;
        while (n5 < this._day1.size()) {
            this.X_Y[n5] = (Double)this._day1.get(n5);
            ++n5;
        }
        this.XY_X = new double[this._dax2.size()];
        this.XY_Y = new double[this._day2.size()];
        int n6 = 0;
        while (n6 < this._dax2.size()) {
            this.XY_X[n6] = (Double)this._dax2.get(n6);
            this.XY_Y[n6] = (Double)this._day2.get(n6);
            ++n6;
        }
        this.XYZ_X = new double[this._dax3.size()];
        this.XYZ_Y = new double[this._day3.size()];
        this.XYZ_Z = new double[this._daz3.size()];
        n = 0;
        while (n < this._dax3.size()) {
            this.XYZ_X[n] = (Double)this._dax3.get(n);
            this.XYZ_Y[n] = (Double)this._day3.get(n);
            this.XYZ_Z[n] = (Double)this._daz3.get(n);
            ++n;
        }
    }

    public void filter3(Double[] doubleArray, Double[] doubleArray2, Double[] doubleArray3, boolean[] blArray, boolean bl) {
        int n = 0;
        while (n < doubleArray.length) {
            if (bl && blArray[n] || !bl) {
                if (doubleArray2[n] != null && doubleArray2[n] >= this._minY && doubleArray2[n] <= this._maxY) {
                    this._day1.add(doubleArray2[n]);
                }
                if (doubleArray[n] != null && doubleArray[n] >= this._minX && doubleArray[n] <= this._maxX) {
                    this._dax1.add(doubleArray[n]);
                    if (doubleArray2[n] != null) {
                        this._dax2.add(doubleArray[n]);
                        this._day2.add(doubleArray2[n]);
                        if (doubleArray3[n] != null) {
                            this._dax3.add(doubleArray[n]);
                            this._day3.add(doubleArray2[n]);
                            this._daz3.add(doubleArray3[n]);
                        }
                    }
                }
            }
            ++n;
        }
    }

    public void filter2(Double[] doubleArray, Double[] doubleArray2, Double[] doubleArray3, boolean[] blArray, boolean bl) {
        int n = 0;
        while (n < doubleArray.length) {
            if ((bl && blArray[n] || !bl) && doubleArray[n] != null && doubleArray[n] >= this._minX && doubleArray[n] <= this._maxX && doubleArray2[n] != null && doubleArray2[n] >= this._minY && doubleArray2[n] <= this._maxY) {
                this._dax1.add(doubleArray[n]);
                this._day1.add(doubleArray2[n]);
                this._dax2.add(doubleArray[n]);
                this._day2.add(doubleArray2[n]);
                if (doubleArray3[n] != null) {
                    this._dax3.add(doubleArray[n]);
                    this._day3.add(doubleArray2[n]);
                    this._daz3.add(doubleArray3[n]);
                }
            }
            ++n;
        }
    }

    public void filter1(Double[] doubleArray, Double[] doubleArray2, Double[] doubleArray3, boolean[] blArray, boolean bl) {
        int n = 0;
        while (n < doubleArray.length) {
            if (bl && blArray[n] || !bl) {
                if (doubleArray2[n] != null) {
                    this._day1.add(doubleArray2[n]);
                }
                if (doubleArray[n] != null) {
                    this._dax1.add(doubleArray[n]);
                    if (doubleArray2[n] != null) {
                        this._dax2.add(doubleArray[n]);
                        this._day2.add(doubleArray2[n]);
                        if (doubleArray3[n] != null) {
                            this._dax3.add(doubleArray[n]);
                            this._day3.add(doubleArray2[n]);
                            this._daz3.add(doubleArray3[n]);
                        }
                    }
                }
            }
            ++n;
        }
    }

    protected void _handleClosing() {
        if (this._contents instanceof CloseListener && !this._doneHandleClosing) {
            this._doneHandleClosing = true;
            ((CloseListener)((Object)this._contents)).windowClosed(this, this._buttonPressed);
        }
    }

    public void restore() {
        this._plot.repaint();
    }

    class ComboListener
    implements ActionListener {
        ComboListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == PlotStatisticsDialog.this._xCol) {
                PlotStatisticsDialog.this._xColB.setSelectedItem(PlotStatisticsDialog.this._xCol.getSelectedItem());
            }
            if (actionEvent.getSource() == PlotStatisticsDialog.this._xColB) {
                PlotStatisticsDialog.this._xCol.setSelectedItem(PlotStatisticsDialog.this._xColB.getSelectedItem());
            }
            if (actionEvent.getSource() == PlotStatisticsDialog.this._yCol) {
                PlotStatisticsDialog.this._yColB.setSelectedItem(PlotStatisticsDialog.this._yCol.getSelectedItem());
            }
            if (actionEvent.getSource() == PlotStatisticsDialog.this._yColB) {
                PlotStatisticsDialog.this._yCol.setSelectedItem(PlotStatisticsDialog.this._yColB.getSelectedItem());
            }
            if (actionEvent.getSource() == PlotStatisticsDialog.this._filterCol) {
                PlotStatisticsDialog.this._filterColB.setSelectedItem(PlotStatisticsDialog.this._filterCol.getSelectedItem());
            }
            if (actionEvent.getSource() == PlotStatisticsDialog.this._filterColB) {
                PlotStatisticsDialog.this._filterCol.setSelectedItem(PlotStatisticsDialog.this._filterColB.getSelectedItem());
            }
        }
    }
}

