/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot;

import com.jvt.applets.PlotVOApplet;
import com.jvt.statistics.stats;
import com.jvt.utils.JVTUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import ptolemy.gui.CloseListener;
import ptolemy.gui.Query;
import ptolemy.plot.Plot;
import ptolemy.plot.PlotBox;

public class PlotStatistics
extends JDialog {
    public Component contents;
    private PlotVOApplet pva;
    private JPanel basic;
    private JPanel advanced;
    private JTabbedPane tabbedBase;
    private JOptionPane _optionPane;
    protected String _buttonPressed = "";
    private static Object[] _buttons = new Object[3];
    private boolean _doneHandleClosing = false;
    private double[] xRange;
    private double[] yRange = new double[2];
    String selectedX;
    String selectedY;
    String selectedFilter;
    Query resultBasic = new Query();
    Query resultAdv = new Query();
    JPanel panRadio = new JPanel();
    JCheckBox plotted = new JCheckBox("Use only plot data", false);
    JComboBox filterCol = new JComboBox();
    JComboBox xCol = new JComboBox();
    JComboBox yCol = new JComboBox();
    JComboBox zCol = new JComboBox();
    JComboBox filterColB = new JComboBox();
    JComboBox xColB = new JComboBox();
    JLabel lblFilter = new JLabel("Filter");
    JLabel lblX = new JLabel("X");
    JLabel lblY = new JLabel("Y");
    JLabel lblZ = new JLabel("Z");
    JLabel lblFilterB = new JLabel("Filter");
    JLabel lblXB = new JLabel("X");
    JPanel panFilterlbl = new JPanel();
    JPanel panXlbl = new JPanel();
    JPanel panYlbl = new JPanel();
    JPanel panZlbl = new JPanel();
    JPanel panFilterCol = new JPanel();
    JPanel panXCol = new JPanel();
    JPanel panYCol = new JPanel();
    JPanel panZCol = new JPanel();
    JPanel panFilterlblB = new JPanel();
    JPanel panXlblB = new JPanel();
    JPanel panFilterColB = new JPanel();
    JPanel panXColB = new JPanel();
    public static int MAX_ROWS_FOR_COMBO_BOX = 6;
    protected final PlotBox _plot;

    public PlotStatistics(PlotBox plotBox, Frame frame, PlotVOApplet plotVOApplet) {
        super(frame, "Plot Statistics", true);
        this._plot = plotBox;
        this.pva = plotVOApplet;
        this.init(this._plot, this.pva);
        this.addPanel(frame);
    }

    public void init(PlotBox plotBox, PlotVOApplet plotVOApplet) {
        this.basic = new JPanel();
        this.advanced = new JPanel();
        this.tabbedBase = new JTabbedPane();
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        String[] stringArray = plotVOApplet.getColumnNames();
        this.selectedX = plotVOApplet.getSelectedXColumn();
        this.selectedY = plotVOApplet.getSelectedYColumn();
        int n = 0;
        while (n < plotVOApplet.getNumOfColumns()) {
            this.xCol.addItem(stringArray[n]);
            this.yCol.addItem(stringArray[n]);
            this.zCol.addItem(stringArray[n]);
            this.xColB.addItem(stringArray[n]);
            if (this.selectedX.equals(stringArray[n])) {
                this.xCol.setSelectedIndex(n);
                this.xColB.setSelectedIndex(n);
            }
            if (this.selectedY.equals(stringArray[n])) {
                this.yCol.setSelectedIndex(n);
            }
            ++n;
        }
        this.xCol.addActionListener(new ComboListener());
        this.xColB.addActionListener(new ComboListener());
        String[] stringArray2 = plotVOApplet.getFilterNames();
        this.selectedFilter = plotVOApplet.getSelectedFilter();
        int n2 = 0;
        while (n2 < stringArray2.length) {
            this.filterCol.addItem(stringArray2[n2]);
            this.filterColB.addItem(stringArray2[n2]);
            if (this.selectedX.equals(stringArray2[n2])) {
                this.filterCol.setSelectedIndex(n2);
                this.filterColB.setSelectedIndex(n2);
            }
            ++n2;
        }
        this.filterCol.addActionListener(new ComboListener());
        this.filterColB.addActionListener(new ComboListener());
        this.xCol.setMaximumRowCount(MAX_ROWS_FOR_COMBO_BOX);
        this.yCol.setMaximumRowCount(MAX_ROWS_FOR_COMBO_BOX);
        this.zCol.setMaximumRowCount(MAX_ROWS_FOR_COMBO_BOX);
        this.filterCol.setMaximumRowCount(MAX_ROWS_FOR_COMBO_BOX);
        this.filterColB.setMaximumRowCount(MAX_ROWS_FOR_COMBO_BOX);
        this.xColB.setMaximumRowCount(MAX_ROWS_FOR_COMBO_BOX);
        this.panFilterlblB.add(this.lblFilterB);
        this.panXlblB.add(this.lblXB);
        this.panFilterColB.add(this.filterColB);
        this.panXColB.add(this.xColB);
        jPanel.setLayout(new FlowLayout(1, 2, 2));
        jPanel.add(this.panFilterlblB);
        jPanel.add(this.panFilterColB);
        jPanel.add(this.panXlblB);
        jPanel.add(this.panXColB);
        this.resultBasic.addLine("obsrv", "No of observations in X", "");
        this.resultBasic.addLine("rang", "Range of X", "");
        this.resultBasic.addLine("min", "Minimum of X", "");
        this.resultBasic.addLine("max", "Maximum of X", "");
        this.resultBasic.addLine("mean", "Mean of X", "");
        this.resultBasic.addLine("var", "Variance of X", "");
        this.resultBasic.addLine("stdev", "Standard deviation of X", "");
        this.resultBasic.addLine("skew", "Skew of X", "");
        this.resultBasic.addLine("kurt", "Kurtosis of X", "");
        jPanel2.add(this.resultBasic);
        this.setModal(true);
        this.basic.setLayout(new BorderLayout());
        this.basic.add((Component)jPanel, "North");
        this.basic.add((Component)jPanel2, "South");
        this.panFilterlbl.add(this.lblFilter);
        this.panXlbl.add(this.lblX);
        this.panYlbl.add(this.lblY);
        this.panZlbl.add(this.lblZ);
        this.panFilterCol.add(this.filterCol);
        this.panXCol.add(this.xCol);
        this.panYCol.add(this.yCol);
        this.panZCol.add(this.zCol);
        jPanel3.setLayout(new FlowLayout(1, 2, 2));
        jPanel3.add(this.panFilterlbl);
        jPanel3.add(this.panFilterCol);
        jPanel3.add(this.panXlbl);
        jPanel3.add(this.panXCol);
        jPanel3.add(this.panYlbl);
        jPanel3.add(this.panYCol);
        jPanel3.add(this.panZlbl);
        jPanel3.add(this.panZCol);
        this.resultAdv.addLine("cor", "Linear correlation of X & Y", "");
        this.resultAdv.addLine("signi", "               Significance(t)", "");
        this.resultAdv.addLine("prob", "               Probablity", "");
        this.resultAdv.addLine("rnk", "Rank Correlation of X & Y", "");
        this.resultAdv.addLine("par", "Partial correlation of X, Y & Z", "");
        jPanel4.add(this.resultAdv);
        this.advanced.setLayout(new BorderLayout());
        this.advanced.add((Component)jPanel3, "North");
        this.advanced.add((Component)jPanel4, "Center");
        this.tabbedBase.addTab("Basic Functions", this.basic);
        this.tabbedBase.addTab("Advanced Functions", this.advanced);
        this.xRange = plotBox.getXRange();
        this.yRange = plotBox.getYRange();
    }

    private void addPanel(Frame frame) {
        PlotStatistics._buttons[0] = this.plotted;
        PlotStatistics._buttons[1] = "Calculate";
        PlotStatistics._buttons[2] = "Close";
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(this.tabbedBase);
        this.contents = this.tabbedBase;
        this._optionPane = new JOptionPane(jPanel, 3, 0, null, _buttons, _buttons[1]);
        this._optionPane.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (PlotStatistics.this.isVisible() && propertyChangeEvent.getSource() == PlotStatistics.this._optionPane && (string.equals("value") || string.equals("inputValue"))) {
                    Object object = PlotStatistics.this._optionPane.getValue();
                    if (object == JOptionPane.UNINITIALIZED_VALUE) {
                        return;
                    }
                    PlotStatistics.this._optionPane.setValue(JOptionPane.UNINITIALIZED_VALUE);
                    if (object instanceof String) {
                        PlotStatistics.this._buttonPressed = (String)object;
                    }
                    if (_buttons[1].equals(PlotStatistics.this._buttonPressed) && PlotStatistics.this.plotted.isSelected()) {
                        PlotStatistics.this.xCol.setSelectedItem(PlotStatistics.this.selectedX);
                        PlotStatistics.this.yCol.setSelectedItem(PlotStatistics.this.selectedY);
                        PlotStatistics.this.filterCol.setSelectedItem(PlotStatistics.this.selectedFilter);
                        PlotStatistics.this.apply(false);
                        return;
                    }
                    if (_buttons[1].equals(PlotStatistics.this._buttonPressed) && !PlotStatistics.this.plotted.isSelected()) {
                        PlotStatistics.this.apply(true);
                        return;
                    }
                    ((Component)PlotStatistics.this).setVisible(false);
                    PlotStatistics.this._handleClosing();
                }
            }
        });
        this.getContentPane().add(this._optionPane);
        this.pack();
        this.setResizable(false);
        if (frame != null) {
            this.setLocationRelativeTo(frame);
        } else {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            ((Component)this).setLocation((toolkit.getScreenSize().width - this.getSize().width) / 2, (toolkit.getScreenSize().height - this.getSize().height) / 2);
        }
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                PlotStatistics.this._handleClosing();
            }
        });
        this.plotted.setSelected(true);
        this.apply(false);
        ((Component)this).setVisible(true);
    }

    public String getSelXCol() {
        return (String)this.xCol.getSelectedItem();
    }

    public String getSelYCol() {
        return (String)this.yCol.getSelectedItem();
    }

    public String getSelZCol() {
        return (String)this.zCol.getSelectedItem();
    }

    public String getSelFilter() {
        return (String)this.filterCol.getSelectedItem();
    }

    public void apply(boolean bl) {
        JVTUtil.showWaitCursor(this);
        try {
            String string = this.getSelFilter();
            String string2 = this.getSelXCol();
            String string3 = this.getSelYCol();
            String string4 = this.getSelZCol();
            boolean bl2 = !(this._plot instanceof Plot);
            stats stats2 = new stats(this.pva.getPlotData(), string, string2, string3, string4, this.xRange, this.yRange, bl, bl2);
            DecimalFormat decimalFormat = new DecimalFormat("0.000E0");
            DecimalFormat decimalFormat2 = new DecimalFormat("0.###");
            this.resultBasic.set("obsrv", JVTUtil.applyProperFormat(stats2.findnoofobservations(1), decimalFormat2, decimalFormat));
            this.resultBasic.set("rang", JVTUtil.applyProperFormat(stats2.findrange(1), decimalFormat2, decimalFormat));
            this.resultBasic.set("min", JVTUtil.applyProperFormat(stats2.findmin(1), decimalFormat2, decimalFormat));
            this.resultBasic.set("max", JVTUtil.applyProperFormat(stats2.findmax(1), decimalFormat2, decimalFormat));
            this.resultBasic.set("mean", JVTUtil.applyProperFormat(stats2.findmean(1), decimalFormat2, decimalFormat));
            this.resultBasic.set("var", JVTUtil.applyProperFormat(stats2.findvariance(1), decimalFormat2, decimalFormat));
            this.resultBasic.set("stdev", JVTUtil.applyProperFormat(stats2.findstddev(1), decimalFormat2, decimalFormat));
            this.resultBasic.set("skew", JVTUtil.applyProperFormat(stats2.findskew(1), decimalFormat2, decimalFormat));
            this.resultBasic.set("kurt", JVTUtil.applyProperFormat(stats2.findkurtosis(1), decimalFormat2, decimalFormat));
            double d = stats2.findlinearcorrelation();
            this.resultAdv.set("cor", JVTUtil.applyProperFormat(d, decimalFormat2, decimalFormat));
            d = stats2.findt_linear();
            this.resultAdv.set("signi", JVTUtil.applyProperFormat(d, decimalFormat2, decimalFormat));
            d = stats2.findlinearcorprob();
            int n = stats2.getErrorNum();
            if (n != 0) {
                this.resultAdv.set("prob", "Error");
            } else {
                this.resultAdv.set("prob", JVTUtil.applyProperFormat(d, decimalFormat2, decimalFormat));
            }
            d = stats2.findrankcorrelation();
            this.resultAdv.set("rnk", JVTUtil.applyProperFormat(d, decimalFormat2, decimalFormat));
            d = stats2.findpartialcorrelation();
            this.resultAdv.set("par", JVTUtil.applyProperFormat(d, decimalFormat2, decimalFormat));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        JVTUtil.showDefaultCursor(this);
    }

    protected void _handleClosing() {
        if (this.contents instanceof CloseListener && !this._doneHandleClosing) {
            this._doneHandleClosing = true;
            ((CloseListener)((Object)this.contents)).windowClosed(this, this._buttonPressed);
        }
    }

    public void restore() {
        this._plot.repaint();
    }

    class ComboListener
    implements ActionListener {
        ComboListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == PlotStatistics.this.xCol) {
                PlotStatistics.this.xColB.setSelectedItem(PlotStatistics.this.xCol.getSelectedItem());
            }
            if (actionEvent.getSource() == PlotStatistics.this.xColB) {
                PlotStatistics.this.xCol.setSelectedItem(PlotStatistics.this.xColB.getSelectedItem());
            }
            if (actionEvent.getSource() == PlotStatistics.this.filterCol) {
                PlotStatistics.this.filterColB.setSelectedItem(PlotStatistics.this.filterCol.getSelectedItem());
            }
            if (actionEvent.getSource() == PlotStatistics.this.filterColB) {
                PlotStatistics.this.filterCol.setSelectedItem(PlotStatistics.this.filterColB.getSelectedItem());
            }
        }
    }
}

