/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot;

import com.jvt.applets.PlotButtons;
import com.jvt.applets.PlotVOApplet;
import com.jvt.utils.JVTUtil;
import com.jvt.votable.Column;
import com.jvt.votable.DataDisplayColumn;
import com.jvt.votable.PlotColumn;
import com.jvt.votable.PlotData;
import com.jvt.votable.PlotFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import ptolemy.gui.CloseListener;

public class PlotDataDisplayDialog
extends JFrame {
    public Component contents;
    protected String _buttonPressed = "";
    private static final String _TRUE = "T";
    private static final String _FALSE = "F";
    private static String[] _buttons = new String[]{"Close"};
    private boolean _doneHandleClosing = false;
    private JOptionPane _optionPane;
    private PlotVOApplet _pva = null;
    private PlotData _pd = null;
    private PlotButtons _pb = null;
    private JTable _dataTable;
    private JTable _metadataTable;
    private JScrollPane _dataScrollPane;
    private JScrollPane _metadataScrollPane;
    private JPanel _dataPanel;
    private JPanel _metadataPanel;
    private JPanel _panel;
    private JPanel _dataDisplayPanel;
    private JPanel _votableDisplayPanel;
    private JLabel _tableData = new JLabel("Table Data : ");
    private JLabel _lblDlgDesc = new JLabel("Display VOPlot meta-data and data in table format.");
    private JLabel _tableMetaData = new JLabel("Table MetaData : ");
    private int _verticalscrollbar = 22;
    private int _horizontalscrollbar = 32;
    private JRadioButton _entireData;
    private JRadioButton _selectedData;
    private JRadioButton _highlightedData;
    private ButtonGroup _radioButtonGroup;
    private JPanel _radioButtonsPanel;
    private boolean _isDataSelected = false;
    private static final String ENTIRE_DATA_LABEL = "Show all";
    private static final String SELECTED_DATA_LABEL = "Show selected";
    private static final String HIGHLIGHTED_DATA_LABEL = "Show highlighted (from external application)";
    DecimalFormat _fmt1;
    DecimalFormat _fmt2;
    public static final int AUTO_RESIZE_OFF = 0;
    public static final int dialogboxHeight = 550;
    public static final int dialogboxWidth = 800;

    public PlotDataDisplayDialog(Frame frame, PlotVOApplet plotVOApplet, PlotButtons plotButtons) {
        this.setTitle("Display VOTable Data in Tabular format");
        this._pb = plotButtons;
        this.init(plotVOApplet);
        this.addPanel();
    }

    private void addPanel() {
        this._panel = new JPanel();
        this._panel.setLayout(new BoxLayout(this._panel, 1));
        this._panel.add(this._dataDisplayPanel);
        this._optionPane = new JOptionPane(this._panel, 1, 1, null, _buttons, _buttons[0]);
        this._optionPane.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (PlotDataDisplayDialog.this.isVisible() && propertyChangeEvent.getSource() == PlotDataDisplayDialog.this._optionPane && (string.equals("value") || string.equals("inputValue"))) {
                    Object object = PlotDataDisplayDialog.this._optionPane.getValue();
                    if (object == JOptionPane.UNINITIALIZED_VALUE) {
                        return;
                    }
                    PlotDataDisplayDialog.this._optionPane.setValue(JOptionPane.UNINITIALIZED_VALUE);
                    if (object instanceof String) {
                        PlotDataDisplayDialog.this._buttonPressed = (String)object;
                    }
                    ((Component)PlotDataDisplayDialog.this).setVisible(false);
                    JVTUtil.SHOW_DATA = true;
                    PlotDataDisplayDialog.this._pb.unselectDataDisplayButton();
                    PlotDataDisplayDialog.this._handleClosing();
                }
            }
        });
        this.getContentPane().add(this._optionPane);
        this.pack();
        this.setResizable(false);
        ((Component)this).setSize(800, 550);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        ((Component)this).setLocation((toolkit.getScreenSize().width - this.getSize().width) / 2, (toolkit.getScreenSize().height - this.getSize().height) / 2);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                JVTUtil.SHOW_DATA = true;
                PlotDataDisplayDialog.this._pb.unselectDataDisplayButton();
                PlotDataDisplayDialog.this._handleClosing();
            }
        });
        ((Component)this).setVisible(true);
    }

    private JPanel addRadioButtonsPanel() {
        this._radioButtonsPanel = new JPanel();
        this._entireData = new JRadioButton(ENTIRE_DATA_LABEL, false);
        this._radioButtonsPanel.add(this._entireData);
        this._selectedData = new JRadioButton(SELECTED_DATA_LABEL, false);
        this._radioButtonsPanel.add(this._selectedData);
        this._highlightedData = new JRadioButton(HIGHLIGHTED_DATA_LABEL, false);
        this._radioButtonsPanel.add(this._highlightedData);
        if (this._isDataSelected) {
            this._selectedData.setSelected(true);
        } else {
            this._entireData.setSelected(true);
        }
        this._entireData.addActionListener(new RadioListener());
        this._selectedData.addActionListener(new RadioListener());
        this._highlightedData.addActionListener(new RadioListener());
        this._radioButtonGroup = new ButtonGroup();
        this._radioButtonGroup.add(this._entireData);
        this._radioButtonGroup.add(this._selectedData);
        this._radioButtonGroup.add(this._highlightedData);
        return this._radioButtonsPanel;
    }

    protected void _handleClosing() {
        if (this.contents instanceof CloseListener && !this._doneHandleClosing) {
            this._doneHandleClosing = true;
            ((CloseListener)((Object)this.contents)).windowClosed(this, this._buttonPressed);
        }
    }

    private void init(PlotVOApplet plotVOApplet) {
        this._pva = plotVOApplet;
        this._pd = plotVOApplet.getPlotData();
        JVTUtil.SHOW_DATA = false;
        ArrayList arrayList = this._pva.getSelectedPointsIndex();
        this._isDataSelected = arrayList != null && arrayList.size() > 0;
        this._dataPanel = new JPanel();
        this._metadataPanel = new JPanel();
        this._dataDisplayPanel = new JPanel();
        this._fmt1 = new DecimalFormat("0.0000");
        this._fmt2 = new DecimalFormat("0.0000E0");
        try {
            Serializable serializable;
            Serializable serializable2;
            Vector<String> vector = new Vector<String>();
            vector.add("Name");
            vector.add("Data Type");
            vector.add("Unit");
            vector.add("UCD");
            Vector<Serializable> vector2 = new Vector<Serializable>();
            int n = 0;
            while (n < this._pd.getNumOfPlotColumns()) {
                Vector<String> vector3 = new Vector<String>();
                serializable2 = this._pd.getPlotColumn(n);
                vector3.add(((Column)serializable2).getName());
                vector3.add(((Column)serializable2).getDatatype());
                vector3.add(((Column)serializable2).getUnit());
                vector3.add(((Column)serializable2).getUCD());
                vector2.add(vector3);
                ++n;
            }
            int n2 = 0;
            while (n2 < this._pd.getNumOfDataDisplayColumns()) {
                if (n2 != this._pd.getObjectIDColumnIndex()) {
                    serializable2 = new Vector();
                    serializable = this._pd.getDataDisplayColumn(n2);
                    ((Vector)serializable2).add(((Column)serializable).getName());
                    ((Vector)serializable2).add(((Column)serializable).getDatatype());
                    ((Vector)serializable2).add(((Column)serializable).getUnit());
                    ((Vector)serializable2).add(((Column)serializable).getUCD());
                    vector2.add(serializable2);
                }
                ++n2;
            }
            int n3 = 0;
            while (n3 < this._pd.getNumOfFilters()) {
                serializable = new Vector();
                PlotFilter plotFilter = this._pd.getPlotFilter(n3);
                ((Vector)serializable).add(plotFilter.getName());
                ((Vector)serializable).add(plotFilter.getDatatype());
                ((Vector)serializable).add(plotFilter.getUnit());
                ((Vector)serializable).add(plotFilter.getUCD());
                vector2.add(serializable);
                ++n3;
            }
            this._metadataTable = new JTable(vector2, vector);
            this._metadataTable.setPreferredScrollableViewportSize(new Dimension(600, 93));
            this._metadataScrollPane = new JScrollPane(this._metadataTable, this._verticalscrollbar, this._horizontalscrollbar);
            this._metadataScrollPane.setRequestFocusEnabled(false);
            this._metadataPanel.setLayout(new BorderLayout());
            serializable = new JPanel(new BorderLayout());
            ((Container)serializable).add(this._lblDlgDesc, "Center");
            ((Container)serializable).add(this._tableMetaData, "South");
            this._metadataPanel.add((Component)serializable, "North");
            this._metadataPanel.add((Component)this._metadataScrollPane, "Center");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this._dataDisplayPanel.add(this._metadataPanel);
        this._dataScrollPane = new JScrollPane(null, this._verticalscrollbar, this._horizontalscrollbar);
        if (this._isDataSelected) {
            this.viewSelectiveData(this._pva.getSelectedPointsIndex());
        } else {
            this.showEntireData();
        }
        this._dataDisplayPanel.add(this._dataPanel);
        this._dataDisplayPanel.add(this.addRadioButtonsPanel());
    }

    private void showEntireData() {
        try {
            Vector vector = new Vector();
            vector = this.generateColumnNames();
            Vector vector2 = new Vector();
            int n = 0;
            while (n < this._pd.getNumOfRows()) {
                Serializable serializable;
                int n2;
                Vector<String> vector3 = new Vector<String>();
                vector3.add(this.generateSerialNumber(n + 1));
                int n3 = 0;
                while (n3 < this._pd.getNumOfPlotColumns()) {
                    PlotColumn plotColumn = this._pd.getPlotColumn(n3);
                    n2 = plotColumn.getDatatypeIntegerFormat();
                    serializable = plotColumn.getData(n);
                    this.appendData((Double)serializable, n2, vector3);
                    ++n3;
                }
                int n4 = 0;
                while (n4 < this._pd.getNumOfDataDisplayColumns()) {
                    if (n4 != this._pd.getObjectIDColumnIndex()) {
                        DataDisplayColumn dataDisplayColumn = this._pd.getDataDisplayColumn(n4);
                        vector3.add(dataDisplayColumn.getData(n));
                    }
                    ++n4;
                }
                n2 = 0;
                while (n2 < this._pd.getNumOfFilters()) {
                    serializable = this._pd.getPlotFilter(n2);
                    if (((PlotFilter)serializable).getData(n)) {
                        vector3.add(_TRUE);
                    } else {
                        vector3.add(_FALSE);
                    }
                    ++n2;
                }
                vector2.add(vector3);
                ++n;
            }
            this._dataTable = new JTable(vector2, vector);
            this._dataTable.setPreferredScrollableViewportSize(new Dimension(600, 196));
            this._dataTable.setAutoResizeMode(0);
            this._dataScrollPane.setViewportView(this._dataTable);
            this._dataPanel.setLayout(new BorderLayout());
            this._dataPanel.add((Component)this._tableData, "North");
            this._dataPanel.add((Component)this._dataScrollPane, "Center");
            this._dataDisplayPanel.add(this._dataPanel);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String generateSerialNumber(int n) {
        String string = n + "";
        return string;
    }

    private Vector generateColumnNames() {
        Vector<String> vector = new Vector<String>();
        try {
            vector.add("Sr No.");
            int n = 0;
            while (n < this._pd.getNumOfPlotColumns()) {
                PlotColumn plotColumn = this._pd.getPlotColumn(n);
                vector.add(plotColumn.getName());
                ++n;
            }
            int n2 = 0;
            while (n2 < this._pd.getNumOfDataDisplayColumns()) {
                if (n2 != this._pd.getObjectIDColumnIndex()) {
                    DataDisplayColumn dataDisplayColumn = this._pd.getDataDisplayColumn(n2);
                    vector.add(dataDisplayColumn.getName());
                }
                ++n2;
            }
            int n3 = 0;
            while (n3 < this._pd.getNumOfFilters()) {
                PlotFilter plotFilter = this._pd.getPlotFilter(n3);
                vector.add(plotFilter.getName());
                ++n3;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return vector;
    }

    private void viewSelectiveData(ArrayList arrayList) {
        try {
            int n = 0;
            Vector vector = new Vector();
            vector = this.generateColumnNames();
            Vector vector2 = new Vector();
            int n2 = 0;
            while (n2 < arrayList.size()) {
                int n3;
                Vector<String> vector3 = new Vector<String>();
                Integer n4 = (Integer)arrayList.get(n2);
                if (null == n4) break;
                n = n4;
                vector3.add(this.generateSerialNumber(n + 1));
                int n5 = 0;
                while (n5 < this._pd.getNumOfPlotColumns()) {
                    PlotColumn plotColumn = this._pd.getPlotColumn(n5);
                    n3 = plotColumn.getDatatypeIntegerFormat();
                    this.appendData(plotColumn.getData(n2), n3, vector3);
                    ++n5;
                }
                int n6 = 0;
                while (n6 < this._pd.getNumOfDataDisplayColumns()) {
                    if (n6 != this._pd.getObjectIDColumnIndex()) {
                        DataDisplayColumn dataDisplayColumn = this._pd.getDataDisplayColumn(n6);
                        vector3.add(dataDisplayColumn.getData(n));
                    }
                    ++n6;
                }
                n3 = 0;
                while (n3 < this._pd.getNumOfFilters()) {
                    PlotFilter plotFilter = this._pd.getPlotFilter(n3);
                    if (plotFilter.getData(n)) {
                        vector3.add(_TRUE);
                    } else {
                        vector3.add(_FALSE);
                    }
                    ++n3;
                }
                vector2.add(vector3);
                ++n2;
            }
            this._dataTable = new JTable(vector2, vector);
            this._dataTable.setPreferredScrollableViewportSize(new Dimension(600, 196));
            this._dataTable.setAutoResizeMode(0);
            this._dataScrollPane.setViewportView(this._dataTable);
            this._dataPanel.setLayout(new BorderLayout());
            this._dataPanel.add((Component)this._tableData, "North");
            this._dataPanel.add((Component)this._dataScrollPane, "Center");
            this._dataDisplayPanel.add(this._dataPanel);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void appendData(Double d, int n, Vector vector) {
        if (d == null) {
            vector.add("");
        } else if (7 == n) {
            double d2 = d;
            String string = JVTUtil.applyProperFormat(d2, this._fmt1, this._fmt2);
            vector.add(string);
        } else {
            vector.add(JVTUtil.getInOriginalFormat(d, n));
        }
    }

    class RadioListener
    implements ActionListener {
        RadioListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (PlotDataDisplayDialog.this._pva.getPlotData() != null) {
                if (PlotDataDisplayDialog.this._entireData.isSelected()) {
                    PlotDataDisplayDialog.this.showEntireData();
                } else if (PlotDataDisplayDialog.this._selectedData.isSelected()) {
                    PlotDataDisplayDialog.this.viewSelectiveData(PlotDataDisplayDialog.this._pva.getSelectedPointsIndex());
                } else if (PlotDataDisplayDialog.this._highlightedData.isSelected()) {
                    PlotDataDisplayDialog.this.viewSelectiveData(PlotDataDisplayDialog.this._pva.getHighlightedPointsIndex());
                }
            }
        }
    }
}

