/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot;

import com.jvt.applets.PlotButtons;
import com.jvt.applets.PlotVOApplet;
import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Vector;
import ptolemy.plot.Histogram;
import ptolemy.plot.Plot;
import ptolemy.plot.PlotBox;
import ptolemy.plot.PlotFilterData;
import ptolemy.plot.PlotInfo;
import ptolemy.plot.PlotPoints;

public class PlotBoxProperties
implements Serializable {
    private PlotBox pb;
    private PlotVOApplet pva;
    private PlotButtons buttons;
    private String Title;
    private String XLabel;
    private String YLabel = new String();
    private int NoPlots;
    private int NoCols;
    private int noPlotsAsYet;
    private int NoFils = 0;
    private String Marks = new String("dots");
    private boolean Grid;
    private boolean Colors = true;
    private boolean Overlay;
    private boolean Histogram = false;
    private boolean Impulses;
    private boolean Connected = false;
    private int Height;
    private int Width = 0;
    private double[] XRange;
    private double[] YRange = new double[]{-1.0, 1.0};
    private Vector[] XTicks;
    private Vector[] YTicks;
    private Color Background;
    private Color Foreground;
    private double BinWidth = -1.0;
    boolean dataGiven;
    private ArrayList _plotInfo = new ArrayList();
    private ArrayList _plotPoints = new ArrayList();
    private ArrayList _plotFilterData = new ArrayList();

    public int getPlotInfoSize() {
        return this._plotInfo.size();
    }

    public void setPlotBoxProperties(PlotVOApplet plotVOApplet, PlotBox plotBox, PlotButtons plotButtons) {
        PlotBox plotBox2;
        this.pb = plotBox;
        this.pva = plotVOApplet;
        this.buttons = plotButtons;
        this.Title = this.pb.getTitle();
        this.XLabel = this.pb.getXLabel();
        this.YLabel = this.pb.getYLabel();
        this.NoPlots = this.pva.getNumPlots();
        this.Grid = this.pb.getGrid();
        this.Colors = this.pb.getColor();
        this.Overlay = this.pva.toOverlay();
        this.Histogram = this.pva.isHistogram();
        this.Height = this.pva.getAppletHeight();
        this.Width = this.pva.getAppletWidth();
        this.XRange = this.pb.getXRange();
        this.YRange = this.pb.getYRange();
        this.XTicks = this.pb.getXTicks();
        this.YTicks = this.pb.getYTicks();
        this.Background = this.pva.getBackColor();
        this.Foreground = this.pva.getForeColor();
        if (this.pb instanceof Histogram) {
            plotBox2 = (Histogram)this.pb;
            this.BinWidth = ((Histogram)plotBox2).getBinWidth();
        }
        if (this.pb instanceof Plot) {
            plotBox2 = (Plot)this.pb;
            this.Marks = ((Plot)plotBox2).getMarksStyle();
            this.Impulses = ((Plot)plotBox2).getImpulses();
            this.Connected = ((Plot)plotBox2).getConnected();
        }
        this.dataGiven = false;
        this.NoCols = 0;
    }

    public void addPlotInfo(int n) {
        PlotInfo plotInfo = new PlotInfo();
        plotInfo.addSelectedXColName(this.buttons.getSelectedXColumn());
        plotInfo.addSelectedYColName(this.buttons.getSelectedYColumn());
        plotInfo.addSelectedFilterName(this.buttons.getSelectedFilter());
        if (n == 1) {
            PlotInfo plotInfo2 = (PlotInfo)this._plotInfo.get(0);
            plotInfo2.addLegend(this.pb.getLegend(0));
        }
        if (n >= 1) {
            plotInfo.addLegend(this.pb.getLegend(n));
        }
        plotInfo.addXLog(this.buttons.isLogX());
        plotInfo.addYLog(this.buttons.isLogY());
        plotInfo.addSelectedXColIndex(this.pva.getColumnIndex(this.buttons.getSelectedXColumn()));
        plotInfo.addSelectedYColIndex(this.pva.getColumnIndex(this.buttons.getSelectedYColumn()));
        plotInfo.setCooSysIndex(this.buttons.getSelectedCooSysIndex());
        int n2 = 0;
        while (n2 < this.noPlotsAsYet) {
            PlotInfo plotInfo3 = (PlotInfo)this._plotInfo.get(n2);
            if (plotInfo3.getDataset() == n) {
                this._plotInfo.set(n2, plotInfo);
                return;
            }
            ++n2;
        }
        this.noPlotsAsYet = n + 1;
        this._plotInfo.add(plotInfo);
    }

    public PlotInfo getPlotInfo(int n) {
        return (PlotInfo)this._plotInfo.get(n);
    }

    public void addPlotData(int n, Double[] doubleArray) {
        PlotPoints plotPoints;
        int n2 = 0;
        while (n2 < this.NoCols) {
            plotPoints = (PlotPoints)this._plotPoints.get(n2);
            if (plotPoints.getIndex() == n) {
                return;
            }
            ++n2;
        }
        plotPoints = new PlotPoints();
        plotPoints.addData(n, doubleArray);
        this._plotPoints.add(plotPoints);
        ++this.NoCols;
        this.dataGiven = true;
    }

    public PlotPoints getPlotData(int n) {
        int n2 = 0;
        while (n2 < this.NoCols) {
            PlotPoints plotPoints = (PlotPoints)this._plotPoints.get(n2);
            if (plotPoints.getIndex() == n) {
                return (PlotPoints)this._plotPoints.get(n2);
            }
            ++n2;
        }
        return null;
    }

    public void addFilterData(String string, boolean[] blArray) {
        PlotFilterData plotFilterData;
        int n = 0;
        while (n < this.NoFils) {
            plotFilterData = (PlotFilterData)this._plotFilterData.get(n);
            if (plotFilterData.getFilterName().equals(string)) {
                return;
            }
            ++n;
        }
        plotFilterData = new PlotFilterData();
        plotFilterData.addFilterData(string, blArray);
        this._plotFilterData.add(plotFilterData);
        ++this.NoFils;
    }

    public PlotFilterData getFilterData(String string) {
        int n = 0;
        while (n < this.NoFils) {
            PlotFilterData plotFilterData = (PlotFilterData)this._plotFilterData.get(n);
            if (plotFilterData.getFilterName().equals(string)) {
                return (PlotFilterData)this._plotFilterData.get(n);
            }
            ++n;
        }
        return null;
    }

    public void clearAll() {
        this._plotInfo.clear();
        this._plotPoints.clear();
        this.noPlotsAsYet = 0;
        this.NoCols = 0;
    }

    public void clearData() {
        this._plotPoints.clear();
        this.NoCols = 0;
    }

    public String getTitle() {
        return this.Title;
    }

    public String getXLabel() {
        return this.XLabel;
    }

    public String getYLabel() {
        return this.YLabel;
    }

    public boolean isGrid() {
        return this.Grid;
    }

    public boolean getColor() {
        return this.Colors;
    }

    public boolean toOverlay() {
        return this.Overlay;
    }

    public boolean isHistogram() {
        return this.Histogram;
    }

    public int getHeight() {
        return this.Height;
    }

    public int getWidth() {
        return this.Width;
    }

    public double[] getXRange() {
        return this.XRange;
    }

    public double[] getYRange() {
        return this.YRange;
    }

    public double getBinWidth() {
        return this.BinWidth;
    }

    public String getXTicks() {
        String string = new String();
        if (this.XTicks != null) {
            int n = 0;
            while (n < this.XTicks[1].size()) {
                string = string + this.XTicks[1].get(n) + " " + this.XTicks[0].get(n) + ", ";
                ++n;
            }
        }
        return string;
    }

    public String getYTicks() {
        String string = new String();
        if (this.YTicks != null) {
            int n = 0;
            while (n < this.YTicks[1].size()) {
                string = string + this.YTicks[1].get(n) + " " + this.YTicks[0].get(n) + ", ";
                ++n;
            }
        }
        return string;
    }

    public Color getBackColor() {
        return this.Background;
    }

    public Color getForeColor() {
        return this.Foreground;
    }

    public String getMarks() {
        return this.Marks;
    }

    public boolean isConnected() {
        return this.Connected;
    }

    public boolean isImpulses() {
        return this.Impulses;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.Title);
        objectOutputStream.writeObject(this.XLabel);
        objectOutputStream.writeObject(this.YLabel);
        objectOutputStream.writeInt(this.NoPlots);
        objectOutputStream.writeInt(this.NoCols);
        objectOutputStream.writeInt(this.NoFils);
        objectOutputStream.writeBoolean(this.Grid);
        objectOutputStream.writeBoolean(this.Colors);
        objectOutputStream.writeBoolean(this.Overlay);
        objectOutputStream.writeBoolean(this.Histogram);
        objectOutputStream.writeInt(this.Height);
        objectOutputStream.writeInt(this.Width);
        objectOutputStream.writeObject(this.XRange);
        objectOutputStream.writeObject(this.YRange);
        objectOutputStream.writeObject(this.XTicks);
        objectOutputStream.writeObject(this.YTicks);
        objectOutputStream.writeObject(this.Background);
        objectOutputStream.writeObject(this.Foreground);
        objectOutputStream.writeBoolean(this.dataGiven);
        objectOutputStream.writeObject(this._plotInfo);
        objectOutputStream.writeObject(this._plotFilterData);
        if (!this.Histogram) {
            objectOutputStream.writeObject(this.Marks);
            objectOutputStream.writeBoolean(this.Impulses);
            objectOutputStream.writeBoolean(this.Connected);
        } else {
            objectOutputStream.writeDouble(this.BinWidth);
        }
        if (this.dataGiven) {
            objectOutputStream.writeObject(this._plotPoints);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.Title = (String)objectInputStream.readObject();
        this.XLabel = (String)objectInputStream.readObject();
        this.YLabel = (String)objectInputStream.readObject();
        this.NoPlots = objectInputStream.readInt();
        this.NoCols = objectInputStream.readInt();
        this.NoFils = objectInputStream.readInt();
        this.Grid = objectInputStream.readBoolean();
        this.Colors = objectInputStream.readBoolean();
        this.Overlay = objectInputStream.readBoolean();
        this.Histogram = objectInputStream.readBoolean();
        this.Height = objectInputStream.readInt();
        this.Width = objectInputStream.readInt();
        this.XRange = (double[])objectInputStream.readObject();
        this.YRange = (double[])objectInputStream.readObject();
        this.XTicks = (Vector[])objectInputStream.readObject();
        this.YTicks = (Vector[])objectInputStream.readObject();
        this.Background = (Color)objectInputStream.readObject();
        this.Foreground = (Color)objectInputStream.readObject();
        this.dataGiven = objectInputStream.readBoolean();
        this._plotInfo = (ArrayList)objectInputStream.readObject();
        this._plotFilterData = (ArrayList)objectInputStream.readObject();
        if (!this.Histogram) {
            this.Marks = (String)objectInputStream.readObject();
            this.Impulses = objectInputStream.readBoolean();
            this.Connected = objectInputStream.readBoolean();
        } else {
            this.BinWidth = objectInputStream.readDouble();
        }
        if (this.dataGiven) {
            this._plotPoints = (ArrayList)objectInputStream.readObject();
        }
    }
}

