/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot;

import com.jvt.exprparser.Expression_Parser;
import com.jvt.exprparser.SimpleNode;
import com.jvt.votable.PlotColumn;
import com.jvt.votable.PlotData;
import com.jvt.votable.PlotFilter;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;

public class ColumnExprParser {
    private PlotData _plotdata = null;
    private StringBuffer _suffix = new StringBuffer();
    private ArrayList _colNumExpr = new ArrayList();
    private int _errorCode = 0;
    private String _colNumStr = "";
    private static final int MAX_COL_DIGITS = 3;
    private static final char COL_PREFIX_CHAR = '$';

    public ColumnExprParser(PlotData plotData) {
        this._plotdata = plotData;
    }

    private boolean parseExpression(String string) {
        int n = 0;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        while (n3 < string.length()) {
            if (string.charAt(n3) == '$') {
                int n4 = 0;
                if (n3 + 1 >= string.length() || !Character.isDigit(string.charAt(n3 + 1))) {
                    this._errorCode = 4;
                    this._colNumStr = "" + string.charAt(n3 + 1);
                    return false;
                }
                n2 = n3;
                char[] cArray = new char[3];
                while (n3 + 1 < string.length() && Character.isDigit(string.charAt(n3 + 1)) && n4 < 3) {
                    cArray[n4] = string.charAt(n3 + 1);
                    ++n4;
                    ++n3;
                }
                int n5 = 0;
                String string2 = new String(cArray, 0, n4);
                try {
                    n5 = Integer.parseInt(string2);
                    if (--n5 < 0 || n5 >= this._plotdata.getNumOfPlotColumns()) {
                        this._errorCode = 4;
                        this._colNumStr = "" + n5;
                        return false;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                    this._errorCode = 4;
                    this._colNumStr = string2;
                    return false;
                }
                String string3 = string.substring(n, n2);
                ColNumExpr colNumExpr = new ColNumExpr(n5, string3);
                this._colNumExpr.add(colNumExpr);
                if (n3 + 1 < string.length()) {
                    n2 = n = n3 + 1;
                } else {
                    n = n3;
                }
            }
            ++n3;
        }
        String string4 = string.substring(n);
        this._suffix.append(string4);
        return true;
    }

    private String substituteData(int n) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        Double d = null;
        int n2 = 0;
        while (n2 < this._colNumExpr.size()) {
            object = (ColNumExpr)this._colNumExpr.get(n2);
            stringBuffer.append(((ColNumExpr)object).getExpr());
            PlotColumn plotColumn = this._plotdata.getPlotColumn(((ColNumExpr)object).getColNum());
            d = plotColumn.getData(n);
            if (null == d) {
                return null;
            }
            stringBuffer.append(d);
            ++n2;
        }
        stringBuffer.append((Object)this._suffix);
        object = stringBuffer.toString();
        return object;
    }

    private boolean evaluateExpression(PlotColumn plotColumn) {
        int n = this._plotdata.getNumOfRows();
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            String string = this.substituteData(n2);
            if (null == string) {
                plotColumn.addData(null);
            } else {
                try {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
                    Expression_Parser expression_Parser = new Expression_Parser(byteArrayInputStream);
                    SimpleNode simpleNode = expression_Parser.parseExpression();
                    Object object = simpleNode.eval();
                    String string2 = object.toString();
                    Double d = new Double(string2);
                    plotColumn.addData(d);
                    bl = true;
                }
                catch (Exception exception) {
                    System.out.println("Exception while evaluation of " + string);
                    exception.printStackTrace();
                    if (!bl) {
                        this._errorCode = 5;
                        return false;
                    }
                    plotColumn.addData(null);
                }
                catch (Error error) {
                    error.printStackTrace();
                    if (!bl) {
                        this._errorCode = 5;
                        return false;
                    }
                    plotColumn.addData(null);
                }
            }
            ++n2;
        }
        return true;
    }

    private boolean evaluateExpression(PlotFilter plotFilter) {
        Object var2_2 = null;
        int n = this._plotdata.getNumOfRows();
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            String string = this.substituteData(n2);
            if (null == string) {
                plotFilter.addData(new Boolean(false));
            } else {
                try {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
                    Expression_Parser expression_Parser = new Expression_Parser(byteArrayInputStream);
                    SimpleNode simpleNode = expression_Parser.parseExpression();
                    Boolean bl2 = (Boolean)simpleNode.eval();
                    plotFilter.addData(bl2);
                    bl = true;
                }
                catch (Exception exception) {
                    System.out.println("Exception while evaluation of " + string);
                    exception.printStackTrace();
                    if (!bl) {
                        this._errorCode = 5;
                        return false;
                    }
                    plotFilter.addData(new Boolean(false));
                }
                catch (Error error) {
                    error.printStackTrace();
                    if (!bl) {
                        this._errorCode = 5;
                        return false;
                    }
                    plotFilter.addData(new Boolean(false));
                }
            }
            ++n2;
        }
        return true;
    }

    public boolean parseAndEvaluate(String string, PlotColumn plotColumn) {
        if (!this.parseExpression(string)) {
            return false;
        }
        return this.evaluateExpression(plotColumn);
    }

    public boolean parseAndEvaluate(String string, PlotFilter plotFilter) {
        if (!this.parseExpression(string)) {
            return false;
        }
        return this.evaluateExpression(plotFilter);
    }

    public int getErrorCode() {
        return this._errorCode;
    }

    public String getColumnNumber() {
        return this._colNumStr;
    }

    class ColNumExpr {
        private String _expr;
        private int _colNum;

        public ColNumExpr() {
            this._expr = null;
            this._colNum = 0;
        }

        public ColNumExpr(int n, String string) {
            this._expr = string;
            this._colNum = n;
        }

        public void setExpr(String string) {
            this._expr = string;
        }

        public void setColNum(int n) {
            this._colNum = n;
        }

        public String getExpr() {
            return this._expr;
        }

        public int getColNum() {
            return this._colNum;
        }
    }
}

