/*
 * Decompiled with CFR 0.152.
 */
package com.jvt.votable;

import com.jvt.applets.PlotVOApplet;
import com.jvt.utils.JVTUtil;
import com.jvt.votable.Column;
import com.jvt.votable.DataDisplayColumn;
import com.jvt.votable.PlotColumn;
import com.jvt.votable.PlotData;
import com.jvt.votable.PlotFilter;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import vowrite.VOTable;
import vowrite.VOTableField;
import vowrite.VOTableResource;
import vowrite.VOTableStreamWriter;
import vowrite.VOTableTable;

public class VOTableWriter {
    private VOTable _votable = null;
    private VOTableResource _votableResource = null;
    private VOTableTable _votableTable = null;
    private PlotData _plotData = null;
    VOTableStreamWriter _vos = null;
    private PlotVOApplet _pva = null;
    private int _noOfRows = -1;
    int _truncateFlag = 0;

    public VOTableWriter(PlotVOApplet plotVOApplet) {
        this._votable = plotVOApplet.getVOTable();
        this._votableResource = plotVOApplet.getResource();
        this._votableTable = plotVOApplet.getTable().returnClone();
        this._plotData = plotVOApplet.getPlotData();
        this._pva = plotVOApplet;
        this._noOfRows = -1;
    }

    public VOTableWriter(PlotVOApplet plotVOApplet, int n) {
        this._votable = plotVOApplet.getVOTable();
        this._votableResource = plotVOApplet.getResource();
        if (plotVOApplet.getTable() != null) {
            this._votableTable = plotVOApplet.getTable().returnClone();
        }
        this._plotData = plotVOApplet.getPlotData();
        this._pva = plotVOApplet;
        this._noOfRows = n;
    }

    public void getDataInVOTableFormat(OutputStream outputStream) {
        PrintStream printStream = new PrintStream(outputStream);
        this._vos = new VOTableStreamWriter(printStream);
        this.writeMetaData(null);
        if (this._truncateFlag == 1) {
            String string = new String("<!--Result truncated to " + this._noOfRows + " rows -->");
            printStream.print(string);
        }
    }

    public void getSelectedDataInVOTableFormat(OutputStream outputStream, ArrayList arrayList) {
        PrintStream printStream = new PrintStream(outputStream);
        this._vos = new VOTableStreamWriter(printStream);
        this.writeMetaData(arrayList);
        if (this._truncateFlag == 1) {
            String string = new String("<!--Result truncated to " + this._noOfRows + " rows -->");
            printStream.print(string);
        }
    }

    public void writeMetaData(ArrayList arrayList) {
        try {
            if (this._votable != null) {
                this._vos.writeVOTable(this._votable);
            }
            if (this._votableResource != null) {
                this._vos.writeResource(this._votableResource);
            }
            if (this._votableTable != null && this._plotData != null) {
                this.constructFields();
                this._vos.writeTable(this._votableTable);
            }
            if (this._plotData != null) {
                this.writeData(arrayList);
            }
            if (this._votableTable != null) {
                this._vos.endTable();
            }
            if (this._votableResource != null) {
                this._vos.endResource();
            }
            if (this._votable != null) {
                this._vos.endVOTable();
            }
        }
        catch (Error error) {
            System.out.println("out of memory error");
            error.printStackTrace();
        }
    }

    public void constructFields() {
        Object object;
        int n = this._plotData.getNumOfPlotColumns();
        int n2 = 0;
        while (n2 < n) {
            PlotColumn plotColumn = this._plotData.getPlotColumn(n2);
            if (plotColumn != null) {
                if (plotColumn.isUserCreated()) {
                    object = new VOTableField();
                    ((VOTableField)object).setDataType(plotColumn.getDatatype());
                    ((VOTableField)object).setName(plotColumn.getName());
                    ((VOTableField)object).setUnit(plotColumn.getUnit());
                    ((VOTableField)object).setUcd(plotColumn.getUCD());
                    this._votableTable.addField((VOTableField)object);
                } else {
                    this._votableTable.addField(plotColumn.getVOField());
                }
            }
            ++n2;
        }
        n = this._plotData.getNumOfDataDisplayColumns();
        int n3 = 0;
        while (n3 < n) {
            object = this._plotData.getDataDisplayColumn(n3);
            if (object != null) {
                this._votableTable.addField(((Column)object).getVOField());
            }
            ++n3;
        }
        n = this._plotData.getNumOfFilters();
        int n4 = 0;
        while (n4 < n) {
            VOTableField vOTableField = new VOTableField();
            PlotFilter plotFilter = this._plotData.getPlotFilter(n4);
            if (plotFilter != null) {
                vOTableField.setDataType(plotFilter.getDatatype());
                vOTableField.setName(plotFilter.getName());
                vOTableField.setUnit(plotFilter.getUnit());
                vOTableField.setUcd(plotFilter.getUCD());
                this._votableTable.addField(vOTableField);
            }
            ++n4;
        }
    }

    public void writeData(ArrayList arrayList) {
        int n = this._plotData.getNumOfRows();
        int n2 = this._plotData.getNumOfPlotColumns();
        int n3 = this._plotData.getNumOfDataDisplayColumns();
        int n4 = this._plotData.getNumOfFilters();
        int n5 = n2 + n3 + n4;
        if (arrayList == null) {
            if (this._noOfRows != -1 && this._noOfRows < n) {
                n = this._noOfRows;
                this._truncateFlag = 1;
            }
            int n6 = 0;
            while (n6 < n) {
                Serializable serializable;
                int n7;
                String[] stringArray = new String[n5];
                int n8 = 0;
                int n9 = 0;
                while (n9 < n2) {
                    PlotColumn plotColumn = this._plotData.getPlotColumn(n9);
                    if (plotColumn != null) {
                        if (plotColumn.getData(n6) == null) {
                            stringArray[n8++] = "";
                        } else {
                            n7 = plotColumn.getDatatypeIntegerFormat();
                            serializable = plotColumn.getData(n6);
                            stringArray[n8++] = JVTUtil.getInOriginalFormat((Double)serializable, n7);
                        }
                    }
                    ++n9;
                }
                int n10 = 0;
                while (n10 < n3) {
                    DataDisplayColumn dataDisplayColumn = this._plotData.getDataDisplayColumn(n10);
                    if (dataDisplayColumn != null) {
                        stringArray[n8++] = dataDisplayColumn.getData(n6) == null ? "" : dataDisplayColumn.getData(n6);
                    }
                    ++n10;
                }
                n7 = 0;
                while (n7 < n4) {
                    serializable = this._plotData.getPlotFilter(n7);
                    if (serializable != null) {
                        stringArray[n8++] = ((PlotFilter)serializable).getData(n6) ? "1" : "0";
                    }
                    ++n7;
                }
                this._vos.addRow(stringArray, n5);
                ++n6;
            }
        } else {
            int n11 = arrayList.size();
            if (this._noOfRows != -1 && this._noOfRows < n11) {
                n11 = this._noOfRows;
                this._truncateFlag = 1;
            }
            int n12 = 0;
            while (n12 < n11) {
                Serializable serializable;
                int n13;
                int n14 = (Integer)arrayList.get(n12);
                String[] stringArray = new String[n5];
                int n15 = 0;
                int n16 = 0;
                while (n16 < n2) {
                    PlotColumn plotColumn = this._plotData.getPlotColumn(n16);
                    if (plotColumn != null) {
                        if (plotColumn.getData(n12) == null) {
                            stringArray[n15++] = "";
                        } else {
                            n13 = plotColumn.getDatatypeIntegerFormat();
                            serializable = plotColumn.getData(n12);
                            stringArray[n15++] = JVTUtil.getInOriginalFormat((Double)serializable, n13);
                        }
                    }
                    ++n16;
                }
                int n17 = 0;
                while (n17 < n3) {
                    DataDisplayColumn dataDisplayColumn = this._plotData.getDataDisplayColumn(n17);
                    if (dataDisplayColumn != null) {
                        stringArray[n15++] = dataDisplayColumn.getData(n14) == null ? "" : dataDisplayColumn.getData(n12);
                    }
                    ++n17;
                }
                n13 = 0;
                while (n13 < n4) {
                    serializable = this._plotData.getPlotFilter(n13);
                    if (serializable != null) {
                        stringArray[n15++] = ((PlotFilter)serializable).getData(n14) ? "1" : "0";
                    }
                    ++n13;
                }
                this._vos.addRow(stringArray, n5);
                ++n12;
            }
        }
    }

    public static void main(String[] stringArray) {
    }
}

