/*
 * Decompiled with CFR 0.152.
 */
package com.jvt.votable;

import VOTableUtil.Data;
import VOTableUtil.Field;
import VOTableUtil.Resource;
import VOTableUtil.Table;
import VOTableUtil.Tabledata;
import VOTableUtil.Td;
import VOTableUtil.Tr;
import VOTableUtil.Votable;
import com.jvt.votable.PlotColumn;
import com.jvt.votable.PlotData;
import com.jvt.votable.VOSingleTable;
import com.jvt.votable.VOTableWrapper;
import java.io.PrintWriter;
import java.util.ArrayList;

public class VOTableParser {
    private String name;
    final int RA = 1;
    final int DEC = 2;

    public VOTableParser(String string) {
        this.name = string;
    }

    public PlotData getData() {
        PrintWriter printWriter = new PrintWriter(System.out, true);
        VOTableWrapper vOTableWrapper = new VOTableWrapper(this.name, printWriter);
        if (vOTableWrapper.getLastError() != null) {
            System.err.println("No VOTable found " + this.name);
            System.err.println("Last error is " + vOTableWrapper.getLastError());
            return null;
        }
        Votable votable = vOTableWrapper.getVotable();
        PlotData plotData = this.getVOTableData(votable, printWriter);
        return plotData;
    }

    private PlotData getVOTableData(Votable votable, PrintWriter printWriter) {
        Resource resource = null;
        if (votable.getResourceCount() > 0) {
            resource = votable.getResourceAt(0);
        }
        if (resource == null) {
            System.err.println("Cannot find first Resource");
            return null;
        }
        Table table = null;
        if (resource.getTableCount() > 0) {
            table = resource.getTableAt(0);
        }
        if (table == null) {
            System.err.println("Cannot find first table of first Resource");
            return null;
        }
        VOSingleTable vOSingleTable = new VOSingleTable(table, printWriter);
        if (vOSingleTable.getLastError() != null) {
            System.err.println("Error in VOSingleTable constructor\n" + vOSingleTable.getLastError());
            return null;
        }
        PlotData plotData = new PlotData();
        ArrayList<FieldIndexType> arrayList = new ArrayList<FieldIndexType>();
        boolean bl = false;
        int n = 0;
        while (n < table.getFieldCount()) {
            PlotColumn plotColumn;
            String string;
            Field field = table.getFieldAt(n);
            String string2 = field.getDatatype();
            String string3 = field.getUcd();
            if (null != string3 && ("POS_EQ_RA_MAIN".equals(string3) || "POS_EQ_DEC_MAIN".equals(string3))) {
                if (string3.equals("POS_EQ_RA_MAIN") && string2.equals("char")) {
                    arrayList.add(new FieldIndexType(n, 1));
                } else if (string3.equals("POS_EQ_RA_MAIN") && string2.equals("double")) {
                    arrayList.add(new FieldIndexType(n, 0));
                }
                if (string3.equals("POS_EQ_DEC_MAIN") && string2.equals("char")) {
                    arrayList.add(new FieldIndexType(n, 2));
                } else if (string3.equals("POS_EQ_DEC_MAIN") && string2.equals("double")) {
                    arrayList.add(new FieldIndexType(n, 0));
                }
                string = field.getName();
                if (null == string && null == (string = field.getId())) {
                    string = "Field " + (n + 1);
                }
                plotColumn = new PlotColumn();
                plotColumn.setName(string);
                plotData.addPlotColumn(plotColumn);
            } else if (null == string2) {
                System.err.println(this.name + " : Field " + (n + 1) + " does not contain datatype.");
            } else if (string2.equals("unsignedByte") || string2.equals("short") || string2.equals("int") || string2.equals("long") || string2.equals("float") || string2.equals("double")) {
                arrayList.add(new FieldIndexType(n, 0));
                string = field.getName();
                if (null == string && null == (string = field.getId())) {
                    string = "Field " + (n + 1);
                }
                plotColumn = new PlotColumn();
                plotColumn.setName(string);
                plotData.addPlotColumn(plotColumn);
            }
            ++n;
        }
        this.getTableData(plotData, table, arrayList);
        return plotData;
    }

    private void getTableData(PlotData plotData, Table table, ArrayList arrayList) {
        Tabledata tabledata;
        Data data;
        if (arrayList.size() > 0 && table.hasData() && (data = table.getData()) != null && data.isTabledata() && (tabledata = data.getTabledata()) != null) {
            int n = tabledata.getTrCount();
            int n2 = 0;
            while (n2 < n) {
                Tr tr = tabledata.getTrAt(n2);
                int n3 = 0;
                while (n3 < arrayList.size()) {
                    FieldIndexType fieldIndexType = (FieldIndexType)arrayList.get(n3);
                    Td td = tr.getTdAt(fieldIndexType.getIndex());
                    String string = td.getPCDATA();
                    Double d = null;
                    if (null == string || string.trim().length() <= 0) {
                        d = null;
                    } else {
                        try {
                            if (fieldIndexType.getType() == 1) {
                                if (string.indexOf(32) == string.lastIndexOf(32)) {
                                    float f = Float.parseFloat(string.substring(0, string.indexOf(32)));
                                    float f2 = Float.parseFloat(string.substring(string.indexOf(32) + 1));
                                    double d2 = (f + f2 / 60.0f) * 15.0f;
                                    d = new Double(d2);
                                } else {
                                    float f = Float.parseFloat(string.substring(0, string.indexOf(32)));
                                    float f3 = Float.parseFloat(string.substring(string.indexOf(32) + 1, string.lastIndexOf(32)));
                                    float f4 = Float.parseFloat(string.substring(string.lastIndexOf(32) + 1));
                                    double d3 = (f + f3 / 60.0f + f4 / 3600.0f) * 15.0f;
                                    d = new Double(d3);
                                }
                            } else if (fieldIndexType.getType() == 2) {
                                int n4 = 1;
                                int n5 = 0;
                                if (string.charAt(0) == '-') {
                                    n4 = -1;
                                    n5 = 1;
                                }
                                if (string.charAt(0) == '+') {
                                    n4 = 1;
                                    n5 = 1;
                                }
                                if (string.indexOf(32) == string.lastIndexOf(32)) {
                                    float f = Float.parseFloat(string.substring(n5, string.indexOf(32)));
                                    float f5 = Float.parseFloat(string.substring(string.indexOf(32) + 1));
                                    double d4 = (float)n4 * (f + f5 / 60.0f);
                                    d = new Double(d4);
                                } else {
                                    float f = Float.parseFloat(string.substring(n5, string.indexOf(32)));
                                    float f6 = Float.parseFloat(string.substring(string.indexOf(32) + 1, string.lastIndexOf(32)));
                                    float f7 = Float.parseFloat(string.substring(string.lastIndexOf(32) + 1));
                                    double d5 = (float)n4 * (f + f6 / 60.0f + f7 / 3600.0f);
                                    d = new Double(d5);
                                }
                            } else {
                                d = new Double(string);
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            d = null;
                        }
                    }
                    PlotColumn plotColumn = plotData.getPlotColumn(n3);
                    if (null != plotColumn) {
                        plotColumn.addData(d);
                    }
                    ++n3;
                }
                ++n2;
            }
        }
    }

    class FieldIndexType {
        int index;
        int type;

        public FieldIndexType(int n, int n2) {
            this.index = n;
            this.type = n2;
        }

        public int getIndex() {
            return this.index;
        }

        public int getType() {
            return this.type;
        }
    }
}

