/*
 * Decompiled with CFR 0.152.
 */
package com.jvt.votable;

import cds.savot.model.CoosysSet;
import cds.savot.model.InfoSet;
import cds.savot.model.LinkSet;
import cds.savot.model.ParamSet;
import cds.savot.model.ResourceSet;
import cds.savot.model.SavotCoosys;
import cds.savot.model.SavotDefinitions;
import cds.savot.model.SavotInfo;
import cds.savot.model.SavotLink;
import cds.savot.model.SavotParam;
import cds.savot.model.SavotResource;
import cds.savot.model.SavotTable;
import cds.savot.model.SavotVOTable;
import cds.savot.model.TableSet;
import cds.savot.pull.SavotPullEngine;
import cds.savot.pull.SavotPullParser;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Vector;
import vowrite.VOTable;
import vowrite.VOTableCoosys;
import vowrite.VOTableDefinitions;
import vowrite.VOTableInfo;
import vowrite.VOTableLink;
import vowrite.VOTableParam;
import vowrite.VOTableResource;
import vowrite.VOTableTable;

public class VOTableMetaDataExtractor {
    private static final String[] _errorMsg = new String[]{"", "Error: No resource in VOTable.", "Error: No table in VOTable."};
    private int _errorNum = 0;
    private VOTable _votable = null;
    private VOTableResource _votableResource = null;
    private VOTableTable _votableTable = null;

    public VOTableMetaDataExtractor(SavotVOTable savotVOTable) {
        try {
            if (null == savotVOTable) {
                System.out.println("Error: VOTable element not found.");
            } else {
                this.extractVOTable(savotVOTable);
                ResourceSet resourceSet = savotVOTable.getResources();
                if (resourceSet.getItemCount() <= 0) {
                    this._errorNum = 1;
                } else {
                    SavotResource savotResource = (SavotResource)resourceSet.getItemAt(0);
                    this.extractResource(savotResource);
                    TableSet tableSet = savotResource.getTables();
                    if (tableSet.getItemCount() <= 0) {
                        this._errorNum = 2;
                    } else {
                        SavotTable savotTable = (SavotTable)tableSet.getItemAt(0);
                        this.extractTable(savotTable);
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void extractVOTable(SavotVOTable savotVOTable) {
        Object object;
        if (savotVOTable == null) {
            return;
        }
        this._votable = new VOTable();
        this._votable.setDescription(savotVOTable.getDescription());
        SavotDefinitions savotDefinitions = savotVOTable.getDefinitions();
        if (null != savotDefinitions) {
            ParamSet paramSet;
            object = new VOTableDefinitions();
            CoosysSet coosysSet = savotDefinitions.getCoosys();
            if (coosysSet != null) {
                ((VOTableDefinitions)object).addAllCOOSYS(this.extractCOOSYS(coosysSet));
            }
            if ((paramSet = savotDefinitions.getParams()) != null) {
                ((VOTableDefinitions)object).addAllParam(this.extractParam(paramSet));
            }
            this._votable.setDefinitions((VOTableDefinitions)object);
        }
        if ((object = savotVOTable.getInfos()) != null) {
            this._votable.addAllInfo(this.extractInfo((InfoSet)object));
        }
    }

    private void extractResource(SavotResource savotResource) {
        LinkSet linkSet;
        ParamSet paramSet;
        CoosysSet coosysSet;
        if (savotResource == null) {
            return;
        }
        this._votableResource = new VOTableResource();
        this._votableResource.setId(savotResource.getId());
        this._votableResource.setName(savotResource.getName());
        this._votableResource.setType(savotResource.getType());
        this._votableResource.setDescription(savotResource.getDescription());
        InfoSet infoSet = savotResource.getInfos();
        if (infoSet != null) {
            this._votableResource.addAllInfo(this.extractInfo(infoSet));
        }
        if ((coosysSet = savotResource.getCoosys()) != null) {
            this._votableResource.addAllCOOSYS(this.extractCOOSYS(coosysSet));
        }
        if ((paramSet = savotResource.getParams()) != null) {
            this._votableResource.addAllParam(this.extractParam(paramSet));
        }
        if ((linkSet = savotResource.getLinks()) != null) {
            this._votableResource.addAllLink(VOTableMetaDataExtractor.extractLink(linkSet));
        }
    }

    private void extractTable(SavotTable savotTable) {
        if (savotTable == null) {
            return;
        }
        this._votableTable = new VOTableTable();
        this._votableTable.setId(savotTable.getId());
        this._votableTable.setName(savotTable.getName());
        this._votableTable.setRef(savotTable.getRef());
        this._votableTable.setDescription(savotTable.getDescription());
        LinkSet linkSet = savotTable.getLinks();
        if (linkSet != null) {
            this._votableTable.addAllLink(VOTableMetaDataExtractor.extractLink(linkSet));
        }
    }

    private Vector extractCOOSYS(CoosysSet coosysSet) {
        int n = 0;
        n = coosysSet.getItemCount();
        Vector<VOTableCoosys> vector = new Vector<VOTableCoosys>(n);
        int n2 = 0;
        while (n2 < n) {
            SavotCoosys savotCoosys = (SavotCoosys)coosysSet.getItemAt(n2);
            if (savotCoosys != null) {
                vector.addElement(this.getSingleCoosys(savotCoosys));
            }
            ++n2;
        }
        return vector;
    }

    private VOTableCoosys getSingleCoosys(SavotCoosys savotCoosys) {
        VOTableCoosys vOTableCoosys = new VOTableCoosys();
        vOTableCoosys.setID(savotCoosys.getId());
        vOTableCoosys.setEquinox(savotCoosys.getEquinox());
        vOTableCoosys.setEpoch(savotCoosys.getEpoch());
        vOTableCoosys.setSystem(savotCoosys.getSystem());
        return vOTableCoosys;
    }

    public static Vector extractLink(LinkSet linkSet) {
        int n = 0;
        n = linkSet.getItemCount();
        Vector<VOTableLink> vector = new Vector<VOTableLink>(n);
        int n2 = 0;
        while (n2 < n) {
            SavotLink savotLink = (SavotLink)linkSet.getItemAt(n2);
            if (savotLink != null) {
                vector.addElement(VOTableMetaDataExtractor.getSingleLink(savotLink));
            }
            ++n2;
        }
        return vector;
    }

    private static VOTableLink getSingleLink(SavotLink savotLink) {
        VOTableLink vOTableLink = new VOTableLink();
        vOTableLink.setAction(savotLink.getAction());
        vOTableLink.setContentRole(savotLink.getContentRole());
        vOTableLink.setContentType(savotLink.getContentType());
        vOTableLink.setGref(URLEncoder.encode(savotLink.getGref()));
        vOTableLink.setHref(URLEncoder.encode(savotLink.getHref()));
        vOTableLink.setId(savotLink.getID());
        vOTableLink.setTitle(savotLink.getTitle());
        vOTableLink.setValue(savotLink.getValue());
        return vOTableLink;
    }

    private Vector extractParam(ParamSet paramSet) {
        int n = 0;
        n = paramSet.getItemCount();
        Vector<VOTableParam> vector = new Vector<VOTableParam>(n);
        int n2 = 0;
        while (n2 < n) {
            SavotParam savotParam = (SavotParam)paramSet.getItemAt(n2);
            if (savotParam != null) {
                vector.addElement(this.getSingleParam(savotParam));
            }
            ++n2;
        }
        return vector;
    }

    private VOTableParam getSingleParam(SavotParam savotParam) {
        VOTableParam vOTableParam = new VOTableParam();
        vOTableParam.setArraySize(savotParam.getArraySize());
        vOTableParam.setDataType(savotParam.getDataType());
        vOTableParam.setDescription(savotParam.getDescription());
        vOTableParam.setId(savotParam.getId());
        vOTableParam.setName(savotParam.getName());
        vOTableParam.setPrecision(savotParam.getPrecision());
        vOTableParam.setRef(savotParam.getRef());
        vOTableParam.setUcd(savotParam.getUcd());
        vOTableParam.setUnit(savotParam.getUnit());
        vOTableParam.setValue(savotParam.getValue());
        vOTableParam.setWidth(savotParam.getWidth());
        LinkSet linkSet = savotParam.getLinks();
        if (linkSet != null) {
            vOTableParam.addAllLink(VOTableMetaDataExtractor.extractLink(linkSet));
        }
        return vOTableParam;
    }

    private Vector extractInfo(InfoSet infoSet) {
        int n = 0;
        n = infoSet.getItemCount();
        Vector<VOTableInfo> vector = new Vector<VOTableInfo>(n);
        int n2 = 0;
        while (n2 < n) {
            SavotInfo savotInfo = (SavotInfo)infoSet.getItemAt(n2);
            if (savotInfo != null) {
                vector.addElement(this.getSingleInfo(savotInfo));
            }
            ++n2;
        }
        return vector;
    }

    private VOTableInfo getSingleInfo(SavotInfo savotInfo) {
        VOTableInfo vOTableInfo = new VOTableInfo();
        vOTableInfo.setID(savotInfo.getId());
        vOTableInfo.setName(savotInfo.getName());
        vOTableInfo.setValue(savotInfo.getValue());
        return vOTableInfo;
    }

    public VOTable getVOTable() {
        return this._votable;
    }

    public VOTableResource getVOTableResource() {
        return this._votableResource;
    }

    public VOTableTable getVOTableTable() {
        return this._votableTable;
    }

    public static void main(String[] stringArray) throws IOException {
        try {
            SavotPullParser savotPullParser = new SavotPullParser("c:\\vowrite\\Votable1.xml", SavotPullEngine.FULL);
            SavotVOTable savotVOTable = savotPullParser.getVOTable();
            VOTableMetaDataExtractor vOTableMetaDataExtractor = new VOTableMetaDataExtractor(savotVOTable);
            System.out.println("Getting data... \n");
            VOTable vOTable = vOTableMetaDataExtractor.getVOTable();
            VOTableMetaDataExtractor.printVOTable(vOTable);
            VOTableResource vOTableResource = vOTableMetaDataExtractor.getVOTableResource();
            VOTableMetaDataExtractor.printVOTableResource(vOTableResource);
            VOTableTable vOTableTable = vOTableMetaDataExtractor.getVOTableTable();
            VOTableMetaDataExtractor.printVOTableTable(vOTableTable);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void printVOTable(VOTable vOTable) {
        System.out.println("VOTable description:" + vOTable.getDescription());
        VOTableDefinitions vOTableDefinitions = vOTable.getDefinitions();
        VOTableCoosys vOTableCoosys = vOTableDefinitions.getCOOSYS(0);
        System.out.println("votable Equinox:" + vOTableCoosys.getEquinox());
        VOTableInfo vOTableInfo = vOTable.getInfo(0);
        System.out.println("votable Info name:" + vOTableInfo.getName());
    }

    private static void printVOTableResource(VOTableResource vOTableResource) {
        VOTableInfo vOTableInfo = vOTableResource.getInfo(0);
        System.out.println("Resource Info name:" + vOTableInfo.getName());
        VOTableCoosys vOTableCoosys = vOTableResource.getCOOSYS(0);
        System.out.println("resource Equinox:" + vOTableCoosys.getEquinox());
    }

    private static void printVOTableTable(VOTableTable vOTableTable) {
        System.out.println("ID:" + vOTableTable.getId());
        System.out.println("Name:" + vOTableTable.getName());
        System.out.println("Description:" + vOTableTable.getDescription());
    }
}

