/*
 * Decompiled with CFR 0.152.
 */
package com.jvt.exprparser;

import com.jvt.exprparser.ExpressionEvalException;
import com.jvt.exprparser.Expression_Parser;
import com.jvt.exprparser.Expression_ParserTreeConstants;
import com.jvt.exprparser.Node;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;

public class SimpleNode
implements Node {
    protected Node parent;
    protected Node[] children;
    protected int id;
    protected Expression_Parser parser;
    private Boolean trueObject = new Boolean(true);
    private Boolean falseObject = new Boolean(false);
    private static final double _LOG10SCALE = 1.0 / Math.log(10.0);
    public String nodeVal;
    public byte m_nodeType;

    public SimpleNode(int n) {
        this.id = n;
    }

    public SimpleNode(Expression_Parser expression_Parser, int n) {
        this(n);
        this.parser = expression_Parser;
    }

    public void jjtOpen() {
    }

    public void jjtClose() {
    }

    public void jjtSetParent(Node node) {
        this.parent = node;
    }

    public Node jjtGetParent() {
        return this.parent;
    }

    public void jjtAddChild(Node node, int n) {
        if (this.children == null) {
            this.children = new Node[n + 1];
        } else if (n >= this.children.length) {
            Node[] nodeArray = new Node[n + 1];
            System.arraycopy(this.children, 0, nodeArray, 0, this.children.length);
            this.children = nodeArray;
        }
        this.children[n] = node;
    }

    public Node jjtGetChild(int n) {
        return this.children[n];
    }

    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public String toString() {
        return Expression_ParserTreeConstants.jjtNodeName[this.id];
    }

    public String toString(String string) {
        return string + this.toString() + this.m_nodeType;
    }

    public void dump(String string) {
        if (this.children != null) {
            int n = 0;
            while (n < this.children.length) {
                SimpleNode simpleNode = (SimpleNode)this.children[n];
                if (simpleNode != null) {
                    simpleNode.dump(string + " ");
                }
                ++n;
            }
        }
    }

    public void value(String string) {
        this.nodeVal = string;
    }

    public void setType(byte by) {
        this.m_nodeType = by;
    }

    public Object eval() throws ExpressionEvalException {
        switch (this.id) {
            case 0: {
                SimpleNode simpleNode = (SimpleNode)this.children[0];
                Object object = simpleNode.eval();
                return object;
            }
            case 2: {
                SimpleNode simpleNode = (SimpleNode)this.children[0];
                Boolean bl = (Boolean)simpleNode.eval();
                if (bl.booleanValue()) {
                    return this.trueObject;
                }
                SimpleNode simpleNode2 = (SimpleNode)this.children[1];
                return (Boolean)simpleNode2.eval();
            }
            case 3: {
                SimpleNode simpleNode = (SimpleNode)this.children[0];
                Boolean bl = (Boolean)simpleNode.eval();
                if (!bl.booleanValue()) {
                    return this.falseObject;
                }
                SimpleNode simpleNode3 = (SimpleNode)this.children[1];
                Boolean bl2 = (Boolean)simpleNode3.eval();
                if (!bl2.booleanValue()) {
                    return this.falseObject;
                }
                return this.trueObject;
            }
            case 16: {
                SimpleNode simpleNode = (SimpleNode)this.children[0];
                Boolean bl = (Boolean)simpleNode.eval();
                if (!bl.booleanValue()) {
                    return this.trueObject;
                }
                return this.falseObject;
            }
            case 4: {
                Object object;
                Object object2;
                SimpleNode simpleNode = (SimpleNode)this.children[0];
                Object object3 = (SimpleNode)this.children[1];
                if (simpleNode.m_nodeType < 8) {
                    if (simpleNode.m_nodeType < ((SimpleNode)object3).m_nodeType) {
                        object2 = simpleNode;
                        simpleNode = object3;
                        object3 = object2;
                    }
                    object2 = (Number)simpleNode.eval();
                    object = (Number)((SimpleNode)object3).eval();
                    switch (simpleNode.m_nodeType) {
                        case 1: {
                            if (((Number)object2).byteValue() == ((Number)object).byteValue()) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                        case 2: {
                            if (((Number)object2).shortValue() == ((Number)object).shortValue()) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                        case 3: {
                            if (((Number)object2).intValue() == ((Number)object).intValue()) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                        case 4: {
                            if (((Number)object2).longValue() == ((Number)object).longValue()) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                        case 5: {
                            if (((Number)object2).floatValue() == ((Number)object).floatValue()) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                        case 6: {
                            if (((Number)object2).doubleValue() == ((Number)object).doubleValue()) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                        case 7: {
                            BigDecimal bigDecimal = new BigDecimal(object2.toString());
                            BigDecimal bigDecimal2 = new BigDecimal(object.toString());
                            if (bigDecimal.compareTo(bigDecimal2) == 0) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                    }
                }
                if (simpleNode.m_nodeType == 9) {
                    object2 = (String)simpleNode.eval();
                    if (((String)object2).compareTo((String)(object = (String)((SimpleNode)object3).eval())) == 0) {
                        return this.trueObject;
                    }
                    return this.falseObject;
                }
                if (simpleNode.m_nodeType == 11) {
                    object2 = (Date)simpleNode.eval();
                    if (((Date)object2).compareTo((Date)(object = (Date)simpleNode.eval())) == 0) {
                        return this.trueObject;
                    }
                    return this.falseObject;
                }
                if (simpleNode.m_nodeType == 12) {
                    object2 = (Timestamp)simpleNode.eval();
                    if (((Date)object2).compareTo((Date)(object = (Timestamp)simpleNode.eval())) == 0) {
                        return this.trueObject;
                    }
                    return this.falseObject;
                }
            }
            case 5: {
                Object object;
                Object object2;
                SimpleNode simpleNode = (SimpleNode)this.children[0];
                Object object3 = (SimpleNode)this.children[1];
                if (simpleNode.m_nodeType < 8) {
                    if (simpleNode.m_nodeType < ((SimpleNode)object3).m_nodeType) {
                        object2 = simpleNode;
                        simpleNode = object3;
                        object3 = object2;
                    }
                    object2 = (Number)simpleNode.eval();
                    object = (Number)((SimpleNode)object3).eval();
                    switch (simpleNode.m_nodeType) {
                        case 1: {
                            if (((Number)object2).byteValue() != ((Number)object).byteValue()) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                        case 2: {
                            if (((Number)object2).shortValue() != ((Number)object).shortValue()) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                        case 3: {
                            if (((Number)object2).intValue() != ((Number)object).intValue()) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                        case 4: {
                            if (((Number)object2).longValue() != ((Number)object).longValue()) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                        case 5: {
                            if (((Number)object2).floatValue() != ((Number)object).floatValue()) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                        case 6: {
                            if (((Number)object2).doubleValue() != ((Number)object).doubleValue()) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                        case 7: {
                            BigDecimal bigDecimal = new BigDecimal(object2.toString());
                            BigDecimal bigDecimal3 = new BigDecimal(object.toString());
                            if (bigDecimal.compareTo(bigDecimal3) != 0) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                    }
                }
                if (simpleNode.m_nodeType == 9) {
                    object2 = (String)simpleNode.eval();
                    if (((String)object2).compareTo((String)(object = (String)((SimpleNode)object3).eval())) != 0) {
                        return this.trueObject;
                    }
                    return this.falseObject;
                }
                if (simpleNode.m_nodeType == 11) {
                    object2 = (Date)simpleNode.eval();
                    if (((Date)object2).compareTo((Date)(object = (Date)simpleNode.eval())) != 0) {
                        return this.trueObject;
                    }
                    return this.falseObject;
                }
                if (simpleNode.m_nodeType == 12) {
                    object2 = (Timestamp)simpleNode.eval();
                    if (((Date)object2).compareTo((Date)(object = (Timestamp)simpleNode.eval())) != 0) {
                        return this.trueObject;
                    }
                    return this.falseObject;
                }
            }
            case 6: {
                Object object;
                Object object2;
                SimpleNode simpleNode = (SimpleNode)this.children[0];
                Object object3 = (SimpleNode)this.children[1];
                if (simpleNode.m_nodeType < 8) {
                    if (simpleNode.m_nodeType < ((SimpleNode)object3).m_nodeType) {
                        object2 = simpleNode;
                        simpleNode = object3;
                        object3 = object2;
                    }
                    object2 = (Number)simpleNode.eval();
                    object = (Number)((SimpleNode)object3).eval();
                    switch (simpleNode.m_nodeType) {
                        case 1: {
                            if (((Number)object2).byteValue() < ((Number)object).byteValue()) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                        case 2: {
                            if (((Number)object2).shortValue() < ((Number)object).shortValue()) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                        case 3: {
                            if (((Number)object2).intValue() < ((Number)object).intValue()) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                        case 4: {
                            if (((Number)object2).longValue() < ((Number)object).longValue()) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                        case 5: {
                            if (((Number)object2).floatValue() < ((Number)object).floatValue()) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                        case 6: {
                            if (((Number)object2).doubleValue() < ((Number)object).doubleValue()) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                        case 7: {
                            BigDecimal bigDecimal = new BigDecimal(object2.toString());
                            BigDecimal bigDecimal4 = new BigDecimal(object.toString());
                            if (bigDecimal.compareTo(bigDecimal4) < 0) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                    }
                }
                if (simpleNode.m_nodeType == 9) {
                    object2 = (String)simpleNode.eval();
                    if (((String)object2).compareTo((String)(object = (String)((SimpleNode)object3).eval())) < 0) {
                        return this.trueObject;
                    }
                    return this.falseObject;
                }
                if (simpleNode.m_nodeType == 11) {
                    object2 = (Date)simpleNode.eval();
                    if (((Date)object2).compareTo((Date)(object = (Date)simpleNode.eval())) < 0) {
                        return this.trueObject;
                    }
                    return this.falseObject;
                }
                if (simpleNode.m_nodeType == 12) {
                    object2 = (Timestamp)simpleNode.eval();
                    if (((Date)object2).compareTo((Date)(object = (Timestamp)simpleNode.eval())) < 0) {
                        return this.trueObject;
                    }
                    return this.falseObject;
                }
            }
            case 7: {
                Object object;
                Object object2;
                SimpleNode simpleNode = (SimpleNode)this.children[0];
                Object object3 = (SimpleNode)this.children[1];
                if (simpleNode.m_nodeType < 8) {
                    if (simpleNode.m_nodeType < ((SimpleNode)object3).m_nodeType) {
                        object2 = simpleNode;
                        simpleNode = object3;
                        object3 = object2;
                    }
                    object2 = (Number)simpleNode.eval();
                    object = (Number)((SimpleNode)object3).eval();
                    switch (simpleNode.m_nodeType) {
                        case 1: {
                            if (((Number)object2).byteValue() > ((Number)object).byteValue()) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                        case 2: {
                            if (((Number)object2).shortValue() > ((Number)object).shortValue()) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                        case 3: {
                            if (((Number)object2).intValue() > ((Number)object).intValue()) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                        case 4: {
                            if (((Number)object2).longValue() > ((Number)object).longValue()) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                        case 5: {
                            if (((Number)object2).floatValue() > ((Number)object).floatValue()) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                        case 6: {
                            if (((Number)object2).doubleValue() > ((Number)object).doubleValue()) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                        case 7: {
                            BigDecimal bigDecimal = new BigDecimal(object2.toString());
                            BigDecimal bigDecimal5 = new BigDecimal(object.toString());
                            if (bigDecimal.compareTo(bigDecimal5) > 0) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                    }
                }
                if (simpleNode.m_nodeType == 9) {
                    object2 = (String)simpleNode.eval();
                    if (((String)object2).compareTo((String)(object = (String)((SimpleNode)object3).eval())) > 0) {
                        return this.trueObject;
                    }
                    return this.falseObject;
                }
                if (simpleNode.m_nodeType == 11) {
                    object2 = (Date)simpleNode.eval();
                    if (((Date)object2).compareTo((Date)(object = (Date)simpleNode.eval())) > 0) {
                        return this.trueObject;
                    }
                    return this.falseObject;
                }
                if (simpleNode.m_nodeType == 12) {
                    object2 = (Timestamp)simpleNode.eval();
                    if (((Date)object2).compareTo((Date)(object = (Timestamp)simpleNode.eval())) > 0) {
                        return this.trueObject;
                    }
                    return this.falseObject;
                }
            }
            case 8: {
                Object object;
                Object object2;
                SimpleNode simpleNode = (SimpleNode)this.children[0];
                Object object3 = (SimpleNode)this.children[1];
                if (simpleNode.m_nodeType < 8) {
                    if (simpleNode.m_nodeType < ((SimpleNode)object3).m_nodeType) {
                        object2 = simpleNode;
                        simpleNode = object3;
                        object3 = object2;
                    }
                    object2 = (Number)simpleNode.eval();
                    object = (Number)((SimpleNode)object3).eval();
                    switch (simpleNode.m_nodeType) {
                        case 1: {
                            if (((Number)object2).byteValue() <= ((Number)object).byteValue()) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                        case 2: {
                            if (((Number)object2).shortValue() <= ((Number)object).shortValue()) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                        case 3: {
                            if (((Number)object2).intValue() <= ((Number)object).intValue()) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                        case 4: {
                            if (((Number)object2).longValue() <= ((Number)object).longValue()) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                        case 5: {
                            if (((Number)object2).floatValue() <= ((Number)object).floatValue()) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                        case 6: {
                            if (((Number)object2).doubleValue() <= ((Number)object).doubleValue()) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                        case 7: {
                            BigDecimal bigDecimal = new BigDecimal(object2.toString());
                            BigDecimal bigDecimal6 = new BigDecimal(object.toString());
                            if (bigDecimal.compareTo(bigDecimal6) <= 0) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                    }
                }
                if (simpleNode.m_nodeType == 9) {
                    object2 = (String)simpleNode.eval();
                    if (((String)object2).compareTo((String)(object = (String)((SimpleNode)object3).eval())) <= 0) {
                        return this.trueObject;
                    }
                    return this.falseObject;
                }
                if (simpleNode.m_nodeType == 11) {
                    object2 = (Date)simpleNode.eval();
                    if (((Date)object2).compareTo((Date)(object = (Date)simpleNode.eval())) <= 0) {
                        return this.trueObject;
                    }
                    return this.falseObject;
                }
                if (simpleNode.m_nodeType == 12) {
                    object2 = (Timestamp)simpleNode.eval();
                    if (((Date)object2).compareTo((Date)(object = (Timestamp)simpleNode.eval())) <= 0) {
                        return this.trueObject;
                    }
                    return this.falseObject;
                }
            }
            case 9: {
                Object object;
                Object object2;
                SimpleNode simpleNode = (SimpleNode)this.children[0];
                Object object3 = (SimpleNode)this.children[1];
                if (simpleNode.m_nodeType < 8) {
                    if (simpleNode.m_nodeType < ((SimpleNode)object3).m_nodeType) {
                        object2 = simpleNode;
                        simpleNode = object3;
                        object3 = object2;
                    }
                    object2 = (Number)simpleNode.eval();
                    object = (Number)((SimpleNode)object3).eval();
                    switch (simpleNode.m_nodeType) {
                        case 1: {
                            if (((Number)object2).byteValue() >= ((Number)object).byteValue()) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                        case 2: {
                            if (((Number)object2).shortValue() >= ((Number)object).shortValue()) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                        case 3: {
                            if (((Number)object2).intValue() >= ((Number)object).intValue()) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                        case 4: {
                            if (((Number)object2).longValue() >= ((Number)object).longValue()) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                        case 5: {
                            if (((Number)object2).floatValue() >= ((Number)object).floatValue()) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                        case 6: {
                            if (((Number)object2).doubleValue() >= ((Number)object).doubleValue()) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                        case 7: {
                            BigDecimal bigDecimal = new BigDecimal(object2.toString());
                            BigDecimal bigDecimal7 = new BigDecimal(object.toString());
                            if (bigDecimal.compareTo(bigDecimal7) >= 0) {
                                return this.trueObject;
                            }
                            return this.falseObject;
                        }
                    }
                }
                if (simpleNode.m_nodeType == 9) {
                    object2 = (String)simpleNode.eval();
                    if (((String)object2).compareTo((String)(object = (String)((SimpleNode)object3).eval())) >= 0) {
                        return this.trueObject;
                    }
                    return this.falseObject;
                }
                if (simpleNode.m_nodeType == 11) {
                    object2 = (Date)simpleNode.eval();
                    if (((Date)object2).compareTo((Date)(object = (Date)simpleNode.eval())) >= 0) {
                        return this.trueObject;
                    }
                    return this.falseObject;
                }
                if (simpleNode.m_nodeType == 12) {
                    object2 = (Timestamp)simpleNode.eval();
                    if (((Date)object2).compareTo((Date)(object = (Timestamp)simpleNode.eval())) >= 0) {
                        return this.trueObject;
                    }
                    return this.falseObject;
                }
            }
            case 14: {
                SimpleNode simpleNode = (SimpleNode)this.children[0];
                Object object3 = (SimpleNode)this.children[1];
                Object object2 = (Number)simpleNode.eval();
                Object object = (Number)((SimpleNode)object3).eval();
                int n = ((Number)object2).intValue();
                int n2 = ((Number)object).intValue();
                return new Integer(n % n2);
            }
            case 10: {
                Object object;
                Object object4;
                Object object5 = (SimpleNode)this.children[0];
                Object object6 = (SimpleNode)this.children[1];
                if (((SimpleNode)object5).m_nodeType < 8) {
                    if (((SimpleNode)object5).m_nodeType < ((SimpleNode)object6).m_nodeType) {
                        object4 = object5;
                        object5 = object6;
                        object6 = object4;
                    }
                    object4 = (Number)((SimpleNode)object5).eval();
                    object = (Number)((SimpleNode)object6).eval();
                    switch (((SimpleNode)object5).m_nodeType) {
                        case 1: {
                            return new Byte((byte)(((Number)object4).byteValue() + ((Number)object).byteValue()));
                        }
                        case 2: {
                            return new Short((short)(((Number)object4).shortValue() + ((Number)object).shortValue()));
                        }
                        case 3: {
                            return new Integer(((Number)object4).intValue() + ((Number)object).intValue());
                        }
                        case 4: {
                            return new Long(((Number)object4).longValue() + ((Number)object).longValue());
                        }
                        case 5: {
                            return new Float(((Number)object4).floatValue() + ((Number)object).floatValue());
                        }
                        case 6: {
                            return new Double(((Number)object4).doubleValue() + ((Number)object).doubleValue());
                        }
                        case 7: {
                            BigDecimal bigDecimal = new BigDecimal(object4.toString());
                            BigDecimal bigDecimal8 = new BigDecimal(object.toString());
                            return bigDecimal.add(bigDecimal8);
                        }
                    }
                }
                if (((SimpleNode)object5).m_nodeType == 9) {
                    object4 = (String)((SimpleNode)object5).eval();
                    object = (String)((SimpleNode)object6).eval();
                    return (String)object4 + (String)object;
                }
            }
            case 11: {
                Object object4;
                Object object5 = (SimpleNode)this.children[0];
                Object object6 = (SimpleNode)this.children[1];
                if (((SimpleNode)object5).m_nodeType < ((SimpleNode)object6).m_nodeType) {
                    object4 = object5;
                    object5 = object6;
                    object6 = object4;
                }
                object4 = (Number)((SimpleNode)object5).eval();
                Object object = (Number)((SimpleNode)object6).eval();
                switch (((SimpleNode)object5).m_nodeType) {
                    case 1: {
                        return new Byte((byte)(((Number)object4).byteValue() - ((Number)object).byteValue()));
                    }
                    case 2: {
                        return new Short((short)(((Number)object4).shortValue() - ((Number)object).shortValue()));
                    }
                    case 3: {
                        return new Integer(((Number)object4).intValue() - ((Number)object).intValue());
                    }
                    case 4: {
                        return new Long(((Number)object4).longValue() - ((Number)object).longValue());
                    }
                    case 5: {
                        return new Float(((Number)object4).floatValue() - ((Number)object).floatValue());
                    }
                    case 6: {
                        return new Double(((Number)object4).doubleValue() - ((Number)object).doubleValue());
                    }
                    case 7: {
                        BigDecimal bigDecimal = new BigDecimal(object4.toString());
                        BigDecimal bigDecimal9 = new BigDecimal(object.toString());
                        return bigDecimal.subtract(bigDecimal9);
                    }
                }
            }
            case 12: {
                Object object4;
                Object object5 = (SimpleNode)this.children[0];
                Object object6 = (SimpleNode)this.children[1];
                if (((SimpleNode)object5).m_nodeType < ((SimpleNode)object6).m_nodeType) {
                    object4 = object5;
                    object5 = object6;
                    object6 = object4;
                }
                object4 = (Number)((SimpleNode)object5).eval();
                Object object = (Number)((SimpleNode)object6).eval();
                switch (((SimpleNode)object5).m_nodeType) {
                    case 1: {
                        return new Byte((byte)(((Number)object4).byteValue() * ((Number)object).byteValue()));
                    }
                    case 2: {
                        return new Short((short)(((Number)object4).shortValue() * ((Number)object).shortValue()));
                    }
                    case 3: {
                        return new Integer(((Number)object4).intValue() * ((Number)object).intValue());
                    }
                    case 4: {
                        return new Long(((Number)object4).longValue() * ((Number)object).longValue());
                    }
                    case 5: {
                        return new Float(((Number)object4).floatValue() * ((Number)object).floatValue());
                    }
                    case 6: {
                        return new Double(((Number)object4).doubleValue() * ((Number)object).doubleValue());
                    }
                    case 7: {
                        BigDecimal bigDecimal = new BigDecimal(object4.toString());
                        BigDecimal bigDecimal10 = new BigDecimal(object.toString());
                        return bigDecimal.multiply(bigDecimal10);
                    }
                }
            }
            case 13: {
                Object object4;
                Object object5 = (SimpleNode)this.children[0];
                Object object6 = (SimpleNode)this.children[1];
                if (((SimpleNode)object5).m_nodeType < ((SimpleNode)object6).m_nodeType) {
                    object4 = object5;
                    object5 = object6;
                    object6 = object4;
                }
                object4 = (Number)((SimpleNode)object5).eval();
                Object object = (Number)((SimpleNode)object6).eval();
                switch (((SimpleNode)object5).m_nodeType) {
                    case 1: {
                        return new Byte((byte)(((Number)object4).byteValue() / ((Number)object).byteValue()));
                    }
                    case 2: {
                        return new Short((short)(((Number)object4).shortValue() / ((Number)object).shortValue()));
                    }
                    case 3: {
                        return new Integer(((Number)object4).intValue() / ((Number)object).intValue());
                    }
                    case 4: {
                        return new Long(((Number)object4).longValue() / ((Number)object).longValue());
                    }
                    case 5: {
                        return new Float(((Number)object4).floatValue() / ((Number)object).floatValue());
                    }
                    case 6: {
                        return new Double(((Number)object4).doubleValue() / ((Number)object).doubleValue());
                    }
                    case 7: {
                        BigDecimal bigDecimal = new BigDecimal(object4.toString());
                        BigDecimal bigDecimal11 = new BigDecimal(object.toString());
                        return bigDecimal.divide(bigDecimal11, 5, 4);
                    }
                }
            }
            case 15: {
                Object object4;
                Object object5 = (SimpleNode)this.children[0];
                Object object6 = (Number)((SimpleNode)object5).eval();
                switch (((SimpleNode)object5).m_nodeType) {
                    case 1: {
                        return new Byte((byte)(((Number)object6).byteValue() * -1));
                    }
                    case 2: {
                        return new Short((short)(((Number)object6).shortValue() * -1));
                    }
                    case 3: {
                        return new Integer(((Number)object6).intValue() * -1);
                    }
                    case 4: {
                        return new Long(((Number)object6).longValue() * -1L);
                    }
                    case 5: {
                        return new Float(((Number)object6).floatValue() * -1.0f);
                    }
                    case 6: {
                        return new Double(((Number)object6).doubleValue() * -1.0);
                    }
                    case 7: {
                        object4 = new BigDecimal(object6.toString());
                        return ((BigDecimal)object4).negate();
                    }
                }
            }
            case 37: {
                try {
                    return new Integer(this.nodeVal);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ExpressionEvalException(numberFormatException.toString());
                }
            }
            case 38: {
                try {
                    return new Double(this.nodeVal);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ExpressionEvalException(numberFormatException.toString());
                }
            }
            case 17: {
                SimpleNode simpleNode = (SimpleNode)this.children[0];
                Object object = simpleNode.eval();
                double d = ((Number)object).doubleValue();
                return new Double(Math.abs(d));
            }
            case 18: {
                SimpleNode simpleNode = (SimpleNode)this.children[0];
                Object object = simpleNode.eval();
                double d = ((Number)object).doubleValue();
                return new Double(Math.exp(d));
            }
            case 19: {
                SimpleNode simpleNode = (SimpleNode)this.children[0];
                Object object = simpleNode.eval();
                double d = ((Number)object).doubleValue();
                return new Double(Math.pow(10.0, d));
            }
            case 20: {
                if (this.jjtGetNumChildren() == 1) {
                    SimpleNode simpleNode = (SimpleNode)this.children[0];
                    Object object = simpleNode.eval();
                    double d = ((Number)object).doubleValue();
                    return new Double(Math.ceil(d));
                }
                SimpleNode simpleNode = (SimpleNode)this.children[0];
                SimpleNode simpleNode4 = (SimpleNode)this.children[1];
                Object object = simpleNode.eval();
                Object object7 = simpleNode4.eval();
                double d = ((Number)object).doubleValue();
                double d2 = ((Number)object7).doubleValue();
                return new Double(Math.min(d, d2));
            }
            case 21: {
                if (this.jjtGetNumChildren() == 1) {
                    SimpleNode simpleNode = (SimpleNode)this.children[0];
                    Object object = simpleNode.eval();
                    double d = ((Number)object).doubleValue();
                    return new Double(Math.floor(d));
                }
                SimpleNode simpleNode = (SimpleNode)this.children[0];
                SimpleNode simpleNode5 = (SimpleNode)this.children[1];
                Object object = simpleNode.eval();
                Object object8 = simpleNode5.eval();
                double d = ((Number)object).doubleValue();
                double d3 = ((Number)object8).doubleValue();
                return new Double(Math.max(d, d3));
            }
            case 22: {
                SimpleNode simpleNode = (SimpleNode)this.children[0];
                Object object = simpleNode.eval();
                double d = ((Number)object).doubleValue();
                return new Double(Math.log(d) * _LOG10SCALE);
            }
            case 23: {
                SimpleNode simpleNode = (SimpleNode)this.children[0];
                Object object = simpleNode.eval();
                double d = ((Number)object).doubleValue();
                return new Double(Math.log(d));
            }
            case 24: {
                SimpleNode simpleNode = (SimpleNode)this.children[0];
                SimpleNode simpleNode6 = (SimpleNode)this.children[1];
                Object object = simpleNode.eval();
                Object object9 = simpleNode6.eval();
                double d = ((Number)object).doubleValue();
                double d4 = ((Number)object9).doubleValue();
                return new Double(Math.pow(d, d4));
            }
            case 25: {
                return new Double(Math.random());
            }
            case 26: {
                SimpleNode simpleNode = (SimpleNode)this.children[0];
                Object object = simpleNode.eval();
                double d = ((Number)object).doubleValue();
                return new Double(Math.round(d));
            }
            case 27: {
                SimpleNode simpleNode = (SimpleNode)this.children[0];
                Object object = simpleNode.eval();
                double d = ((Number)object).doubleValue();
                return new Double(Math.sqrt(d));
            }
            case 28: {
                SimpleNode simpleNode = (SimpleNode)this.children[0];
                Object object = simpleNode.eval();
                double d = ((Number)object).doubleValue();
                return new Double(Math.acos(d));
            }
            case 29: {
                SimpleNode simpleNode = (SimpleNode)this.children[0];
                Object object = simpleNode.eval();
                double d = ((Number)object).doubleValue();
                return new Double(Math.asin(d));
            }
            case 30: {
                SimpleNode simpleNode = (SimpleNode)this.children[0];
                Object object = simpleNode.eval();
                double d = ((Number)object).doubleValue();
                return new Double(Math.atan(d));
            }
            case 31: {
                SimpleNode simpleNode = (SimpleNode)this.children[0];
                SimpleNode simpleNode7 = (SimpleNode)this.children[1];
                Object object = simpleNode.eval();
                Object object10 = simpleNode7.eval();
                double d = ((Number)object).doubleValue();
                double d5 = ((Number)object10).doubleValue();
                return new Double(Math.atan2(d, d5));
            }
            case 32: {
                SimpleNode simpleNode = (SimpleNode)this.children[0];
                Object object = simpleNode.eval();
                double d = ((Number)object).doubleValue();
                return new Double(Math.cos(d));
            }
            case 33: {
                SimpleNode simpleNode = (SimpleNode)this.children[0];
                Object object = simpleNode.eval();
                double d = ((Number)object).doubleValue();
                return new Double(Math.sin(d));
            }
            case 34: {
                SimpleNode simpleNode = (SimpleNode)this.children[0];
                Object object = simpleNode.eval();
                double d = ((Number)object).doubleValue();
                return new Double(Math.tan(d));
            }
            case 35: {
                SimpleNode simpleNode = (SimpleNode)this.children[0];
                Object object = simpleNode.eval();
                double d = ((Number)object).doubleValue();
                return new Double(Math.toRadians(d));
            }
            case 36: {
                SimpleNode simpleNode = (SimpleNode)this.children[0];
                Object object = simpleNode.eval();
                double d = ((Number)object).doubleValue();
                return new Double(Math.toDegrees(d));
            }
        }
        throw new ExpressionEvalException("Invalid operator");
    }

    private boolean isNumber(int n) {
        switch (n) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    private boolean isString(int n) {
        switch (n) {
            case -1: 
            case 1: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    private boolean isBoolean(int n) {
        switch (n) {
            case -7: {
                return true;
            }
        }
        return false;
    }

    private String operatorToString(int n) {
        switch (n) {
            case 10: {
                return new String("+");
            }
            case 11: {
                return new String("-");
            }
            case 12: {
                return new String("*");
            }
            case 13: {
                return new String("/");
            }
            case 14: {
                return new String("%");
            }
            case 15: {
                return new String("(-)");
            }
            case 7: {
                return new String(">");
            }
            case 6: {
                return new String("<");
            }
            case 8: {
                return new String(">=");
            }
            case 9: {
                return new String("<=");
            }
            case 4: {
                return new String("==");
            }
            case 5: {
                return new String("!=");
            }
            case 3: {
                return new String("&&");
            }
            case 2: {
                return new String("||");
            }
            case 16: {
                return new String("!");
            }
            case 17: {
                return new String("Abs");
            }
            case 18: {
                return new String("Exp");
            }
            case 20: {
                return new String("Ceil");
            }
            case 21: {
                return new String("Floor");
            }
            case 22: {
                return new String("Log");
            }
            case 24: {
                return new String("Pow");
            }
            case 25: {
                return new String("Random");
            }
            case 26: {
                return new String("Round");
            }
            case 27: {
                return new String("Sqrt");
            }
            case 23: {
                return new String("Ln");
            }
            case 19: {
                return new String("Dexp");
            }
            case 28: {
                return new String("Acos");
            }
            case 29: {
                return new String("Asin");
            }
            case 30: {
                return new String("Atan");
            }
            case 31: {
                return new String("Atan2");
            }
            case 32: {
                return new String("Cos");
            }
            case 33: {
                return new String("Sin");
            }
            case 34: {
                return new String("Tan");
            }
            case 35: {
                return new String("toRadian");
            }
            case 36: {
                return new String("toDegree");
            }
        }
        return null;
    }
}

