/*
 * Decompiled with CFR 0.152.
 */
package com.jvt.applets;

class Projections {
    private double pi = 2.0 * Math.asin(1.0);
    private int itern = 30;
    private double tol = 1.0E-7;
    private double alfa0b50 = 282.25 * this.pi / 180.0;
    private double dl0b50 = 33.0 * this.pi / 180.0;
    private double delngp = 27.4 * this.pi / 180.0;
    private Double[] xproj;
    private Double[] yproj;

    Projections() {
    }

    public static void main(String[] stringArray) {
        double[] dArray = new double[]{0.01, 0.02, 0.08, 0.1, 0.11, 0.13, 0.2, 0.21};
        double[] dArray2 = new double[]{-2.63, 1.99, 1.16, 2.53, 2.76, -39.81, -17.73, -26.33};
        Double[] doubleArray = new Double[dArray.length + 1];
        Double[] doubleArray2 = new Double[dArray2.length + 1];
        int n = 0;
        while (n < dArray.length) {
            doubleArray[n] = new Double(dArray[n]);
            doubleArray2[n] = new Double(dArray2[n]);
            ++n;
        }
        doubleArray[dArray.length] = null;
        doubleArray2[dArray.length] = null;
        Projections projections = new Projections();
        projections.sinu(doubleArray, doubleArray2);
        Double[] doubleArray3 = projections.getxproj();
        Double[] doubleArray4 = projections.getyproj();
        System.out.println("Galactic Longitude \t Galactic Latitude");
        int n2 = 0;
        while (n2 < doubleArray.length) {
            if (doubleArray3[n2] != null && doubleArray4[n2] != null) {
                System.out.println(doubleArray3[n2] + "\t" + doubleArray4[n2]);
            }
            ++n2;
        }
    }

    public void simpleprojection(Double[] doubleArray, Double[] doubleArray2) {
        int n = doubleArray.length;
        this.xproj = new Double[n];
        this.yproj = new Double[n];
        int n2 = 0;
        while (n2 < n) {
            if (doubleArray[n2] == null || doubleArray2[n2] == null) {
                this.xproj[n2] = null;
                this.yproj[n2] = null;
            } else {
                double d = Math.sin(doubleArray2[n2] * this.pi / 180.0) * Math.sin(this.delngp);
                double d2 = Math.cos(doubleArray2[n2] * this.pi / 180.0) * Math.cos(this.delngp) * Math.sin(doubleArray[n2] * this.pi / 180.0 - this.alfa0b50);
                this.yproj[n2] = new Double(Math.asin(d - d2) * 180.0 / this.pi);
                double d3 = Math.cos(this.delngp) * Math.tan(doubleArray2[n2] * this.pi / 180.0) / Math.cos(doubleArray[n2] * this.pi / 180.0 - this.alfa0b50);
                double d4 = Math.tan(doubleArray[n2] * this.pi / 180.0 - this.alfa0b50) * Math.sin(this.delngp);
                this.xproj[n2] = new Double((Math.atan(d3 + d4) + this.dl0b50) * 180.0 / this.pi);
            }
            ++n2;
        }
    }

    public void projmoll(Double[] doubleArray, Double[] doubleArray2) {
        int n = doubleArray.length;
        Double[] doubleArray3 = new Double[n];
        Double[] doubleArray4 = new Double[n];
        int n2 = 0;
        while (n2 < n) {
            if (doubleArray[n2] == null || doubleArray2[n2] == null) {
                doubleArray4[n2] = null;
                doubleArray3[n2] = null;
            } else {
                double d = Math.sin(doubleArray2[n2] * this.pi / 180.0) * Math.sin(this.delngp);
                double d2 = Math.cos(doubleArray2[n2] * this.pi / 180.0) * Math.cos(this.delngp) * Math.sin(doubleArray[n2] * this.pi / 180.0 - this.alfa0b50);
                doubleArray4[n2] = new Double(Math.asin(d - d2));
                double d3 = Math.cos(this.delngp) * Math.tan(doubleArray2[n2] * this.pi / 180.0) / Math.cos(doubleArray[n2] * this.pi / 180.0 - this.alfa0b50);
                double d4 = Math.tan(doubleArray[n2] * this.pi / 180.0 - this.alfa0b50) * Math.sin(this.delngp);
                doubleArray3[n2] = new Double(Math.atan(d3 + d4) + this.dl0b50);
            }
            ++n2;
        }
        this.xproj = new Double[n];
        this.yproj = new Double[n];
        int n3 = 0;
        while (n3 < n) {
            if (doubleArray4[n3] == null || doubleArray3[n3] == null) {
                this.xproj[n3] = null;
                this.yproj[n3] = null;
            } else {
                double d = doubleArray4[n3];
                double d5 = this.newtonraphson(d);
                this.xproj[n3] = new Double(2.0 * Math.sqrt(2.0) * (doubleArray3[n3] - this.dl0b50) * Math.cos(d5) / this.pi * 180.0 / this.pi);
                this.yproj[n3] = new Double(Math.sqrt(2.0) * Math.sin(d5) * 180.0 / this.pi);
            }
            ++n3;
        }
    }

    public void aitoff(Double[] doubleArray, Double[] doubleArray2) {
        int n = doubleArray.length;
        Double[] doubleArray3 = new Double[n];
        Double[] doubleArray4 = new Double[n];
        int n2 = 0;
        while (n2 < n) {
            if (doubleArray[n2] == null || doubleArray2[n2] == null) {
                doubleArray4[n2] = null;
                doubleArray3[n2] = null;
            } else {
                double d = Math.sin(doubleArray2[n2] * this.pi / 180.0) * Math.sin(this.delngp);
                double d2 = Math.cos(doubleArray2[n2] * this.pi / 180.0) * Math.cos(this.delngp) * Math.sin(doubleArray[n2] * this.pi / 180.0 - this.alfa0b50);
                doubleArray4[n2] = new Double(Math.asin(d - d2));
                double d3 = Math.cos(this.delngp) * Math.tan(doubleArray2[n2] * this.pi / 180.0) / Math.cos(doubleArray[n2] * this.pi / 180.0 - this.alfa0b50);
                double d4 = Math.tan(doubleArray[n2] * this.pi / 180.0 - this.alfa0b50) * Math.sin(this.delngp);
                doubleArray3[n2] = new Double(Math.atan(d3 + d4) + this.dl0b50);
            }
            ++n2;
        }
        this.xproj = new Double[n];
        this.yproj = new Double[n];
        int n3 = 0;
        while (n3 < n) {
            if (doubleArray4[n3] == null || doubleArray3[n3] == null) {
                this.xproj[n3] = null;
                this.yproj[n3] = null;
            } else {
                double d = Math.sqrt(2.0 / (1.0 + Math.cos(doubleArray4[n3]) * Math.cos(doubleArray3[n3] * 0.5)));
                this.xproj[n3] = new Double(2.0 * d * Math.cos(doubleArray4[n3]) * Math.sin(0.5 * doubleArray3[n3]) * 180.0 / this.pi);
                this.yproj[n3] = new Double(d * Math.sin(doubleArray4[n3]) * 180.0 / this.pi);
            }
            ++n3;
        }
    }

    public void merc(Double[] doubleArray, Double[] doubleArray2) {
        int n = doubleArray.length;
        Double[] doubleArray3 = new Double[n];
        Double[] doubleArray4 = new Double[n];
        int n2 = 0;
        while (n2 < n) {
            if (doubleArray[n2] == null || doubleArray2[n2] == null) {
                doubleArray4[n2] = null;
                doubleArray3[n2] = null;
            } else {
                double d = Math.sin(doubleArray2[n2] * this.pi / 180.0) * Math.sin(this.delngp);
                double d2 = Math.cos(doubleArray2[n2] * this.pi / 180.0) * Math.cos(this.delngp) * Math.sin(doubleArray[n2] * this.pi / 180.0 - this.alfa0b50);
                doubleArray4[n2] = new Double(Math.asin(d - d2));
                double d3 = Math.cos(this.delngp) * Math.tan(doubleArray2[n2] * this.pi / 180.0) / Math.cos(doubleArray[n2] * this.pi / 180.0 - this.alfa0b50);
                double d4 = Math.tan(doubleArray[n2] * this.pi / 180.0 - this.alfa0b50) * Math.sin(this.delngp);
                doubleArray3[n2] = new Double(Math.atan(d3 + d4) + this.dl0b50);
            }
            ++n2;
        }
        this.xproj = new Double[n];
        this.yproj = new Double[n];
        int n3 = 0;
        while (n3 < n) {
            if (doubleArray4[n3] == null || doubleArray3[n3] == null) {
                this.xproj[n3] = null;
                this.yproj[n3] = null;
            } else {
                this.xproj[n3] = new Double((doubleArray3[n3] - this.dl0b50) * 180.0 / this.pi);
                this.yproj[n3] = new Double(0.5 * Math.log((1.0 + Math.sin(doubleArray4[n3])) / (1.0 - Math.sin(doubleArray4[n3]))) * 180.0 / this.pi);
            }
            ++n3;
        }
    }

    public void sinu(Double[] doubleArray, Double[] doubleArray2) {
        int n = doubleArray.length;
        Double[] doubleArray3 = new Double[n];
        Double[] doubleArray4 = new Double[n];
        int n2 = 0;
        while (n2 < n) {
            if (doubleArray[n2] == null || doubleArray2[n2] == null) {
                doubleArray4[n2] = null;
                doubleArray3[n2] = null;
            } else {
                double d = Math.sin(doubleArray2[n2] * this.pi / 180.0) * Math.sin(this.delngp);
                double d2 = Math.cos(doubleArray2[n2] * this.pi / 180.0) * Math.cos(this.delngp) * Math.sin(doubleArray[n2] * this.pi / 180.0 - this.alfa0b50);
                doubleArray4[n2] = new Double(Math.asin(d - d2));
                double d3 = Math.cos(this.delngp) * Math.tan(doubleArray2[n2] * this.pi / 180.0) / Math.cos(doubleArray[n2] * this.pi / 180.0 - this.alfa0b50);
                double d4 = Math.tan(doubleArray[n2] * this.pi / 180.0 - this.alfa0b50) * Math.sin(this.delngp);
                doubleArray3[n2] = new Double(Math.atan(d3 + d4) + this.dl0b50);
            }
            ++n2;
        }
        this.xproj = new Double[n];
        this.yproj = new Double[n];
        int n3 = 0;
        while (n3 < n) {
            if (doubleArray4[n3] == null || doubleArray3[n3] == null) {
                this.xproj[n3] = null;
                this.yproj[n3] = null;
            } else {
                this.xproj[n3] = new Double((doubleArray3[n3] - this.dl0b50) * Math.cos(doubleArray4[n3]) * 180.0 / this.pi);
                this.yproj[n3] = new Double(doubleArray4[n3] * 180.0 / this.pi);
            }
            ++n3;
        }
    }

    public double newtonraphson(double d) {
        double d2 = 2.0 * Math.asin(2.0 * d / this.pi);
        double d3 = 0.0;
        int n = 1;
        boolean bl = false;
        while (!bl) {
            double d4;
            bl = true;
            d3 = d2 - this.func(d2, d) / this.grad(d2);
            double d5 = Math.abs(d3 - d2);
            if (!(d5 / (d4 = Math.abs(d3)) > this.tol) || n >= this.itern) continue;
            bl = false;
            d2 = d3;
            ++n;
        }
        return d3;
    }

    public double func(double d, double d2) {
        double d3 = 2.0 * d;
        return d3 + Math.sin(d3) - this.pi * Math.sin(d2);
    }

    public double grad(double d) {
        double d2 = 2.0 * d;
        return 2.0 * (1.0 + Math.cos(d2));
    }

    public Double[] getxproj() {
        int n = this.xproj.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.xproj[n2] != null) {
                this.xproj[n2] = new Double(Math.cos(this.yproj[n2] * this.pi / 180.0) * this.xproj[n2]);
            }
            ++n2;
        }
        return this.xproj;
    }

    public Double[] getyproj() {
        return this.yproj;
    }
}

