/*
 * Decompiled with CFR 0.152.
 */
package com.jvt.applets;

import cds.aladin.Aladin;
import cds.tools.ExtApp;
import com.jvt.applets.CoordinateSystems;
import com.jvt.applets.PlotButtons;
import com.jvt.utils.JVTUtil;
import com.jvt.votable.DataDisplayColumn;
import com.jvt.votable.PlotColumn;
import com.jvt.votable.PlotData;
import com.jvt.votable.PlotFilter;
import com.jvt.votable.SAVOTParser;
import com.jvt.votable.VOTableWriter;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import netscape.javascript.JSObject;
import ptolemy.plot.Histogram;
import ptolemy.plot.Plot;
import ptolemy.plot.PlotBox;
import ptolemy.plot.PlotBoxProperties;
import ptolemy.plot.PlotInfo;
import ptolemy.plot.PlotPoint;
import vowrite.VOTable;
import vowrite.VOTableResource;
import vowrite.VOTableTable;

public class PlotVOApplet
extends JApplet
implements ExtApp {
    Container _container = null;
    public static final String FILENAME = "filename";
    public static final String SERVLETPATH = "servletpath";
    public static final String VOTABLEPATH = "votablepath";
    public static final String PARAMETERS = "parameters";
    public static final String WIDTH = "width";
    public static final String HEIGHT = "height";
    public static final String BACKGROUND = "background";
    public static final String FOREGROUND = "foreground";
    public static final String DATAURL = "dataurl";
    public static final String SAVE_EPS_URL = "saveEPS";
    public static final String SESSION_ID = "sessionid";
    public static final String HELP_URL = "userguideURL";
    private int _numColumns = 0;
    private PlotData _pd;
    private VOTable _votableMetaData = null;
    private VOTableResource _votableResource = null;
    private VOTableTable _votableTable = null;
    public boolean _fieldsAdded = false;
    private double _binwidth;
    private String _xunit = new String();
    private String _yunit = new String();
    private String _xucd = new String();
    private String _yucd = new String();
    private boolean _usedAsWebApp = false;
    private Color _background = Color.white;
    private Color _foreground = Color.black;
    private int _width;
    private int _height;
    private boolean _histogram = false;
    private ArrayList _colsPlotted;
    private JSObject _mainWindow;
    private int _dataSet = -1;
    public static final int PLOT = 0;
    public static final int HISTOGRAM = 1;
    public static final String HIST_Y_LABEL = "Data Points";
    public static final int VOTABLE_TEXT_INPUT_WIDTH = 25;
    public static final int APPLET_WIDTH = 840;
    public static final int APPLET_HEIGHT = 550;
    public static final int APPLET_SUB_APP_WIDTH = 670;
    public static final int APPLET_SUB_APP_HEIGHT = 500;
    public static final String BACKGROUND_COLOR = "#faf0e6";
    private boolean _redrawing = false;
    private boolean _firstplot = false;
    private int _currentPlotType = 0;
    private HashSet _selectedPointOIds = new HashSet();
    private HashSet _highlightedPoints = new HashSet();
    private ExtApp _extApp = null;
    private String _filterApplied = "All";
    private PlotBoxProperties _prop;
    private CoordinateSystems coosys;
    private PlotButtons _buttons = new PlotButtons();
    public static String[] _errorMsg = new String[]{"No valid columns in this VOTable", "Cannot plot non-positive data on logarithmic X axis.", "Cannot plot non-positive data on logarithmic Y axis.", "No numeric data found in VOTable.", ""};
    private PlotBox _plot;
    private boolean _connected;
    private boolean _impulses;
    private boolean _color;
    private boolean _grid;
    private boolean _yincrement;
    private String _marker;
    private boolean _isSubApp = false;

    public String getAppletInfo() {
        return "PlotVOApplet : A votable data plotter.\nDeveloped by Persistent Systems and IUCAA in association with CDS \n as part of Virtual Observatory India initiative.\n($Id: PlotVOApplet.java,v 1.110 2003/06/20 10:51:38 ranjan Exp $)";
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{FILENAME, "string", "100"}, {SERVLETPATH, "string", "100"}, {VOTABLEPATH, "string", "100"}, {PARAMETERS, "string", "100"}, {WIDTH, "integer", "100"}, {HEIGHT, "integer", "100"}, {BACKGROUND, "hexcolor value", "background color"}, {HELP_URL, "url", "100"}};
        return stringArray;
    }

    public void init() {
        super.init();
        PlotVOApplet.printVOPlotInfo();
        this.setAsWebApp(true);
    }

    public void start() {
        Object object;
        if (this._plot == null) {
            this._plot = new Plot();
            this._currentPlotType = 0;
            this._plot.setVOApplet(this, this._buttons);
            this.setDefaultPlotProperties();
            object = (Plot)this.plot();
            this.applyPlotProperties((Plot)object);
            this._selectedPointOIds.clear();
        }
        this._colsPlotted = new ArrayList();
        this.coosys = new CoordinateSystems();
        if (this.isSubApp()) {
            this._width = 670;
            this._height = 500;
        } else {
            this._width = 840;
            this._height = 550;
        }
        object = BACKGROUND_COLOR;
        if (object != null) {
            this._background = PlotBox.getColorByName((String)object);
        }
        if (this.isWebApp() && !this.isSubApp()) {
            this.readParameters();
            this.readData();
            this._mainWindow = JSObject.getWindow((Applet)this);
        }
        this._container = this.getContentPane();
        this._buttons.init(this._container, this._background, this);
        this.setUpPlotBox();
        this._dataSet = -1;
        this._prop = new PlotBoxProperties();
    }

    public static void printVOPlotInfo() {
        System.out.println("----------------------------------------------");
        System.out.println("VOPlot (VOTable Plotting tool) Version 1.1.1 beta\n");
        System.out.println("VOPlot is developed by Persistent Systems, Pune and");
        System.out.println("IUCAA in association with CDS as a part of the");
        System.out.println("Virtual Observatory India initiative. ");
        System.out.println("---------------------------------------------- \n");
    }

    public int setAsSubApplication(boolean bl) {
        this._isSubApp = bl;
        return 1;
    }

    public int getNumOfColumns() {
        return this._numColumns;
    }

    public int getAppletHeight() {
        return this._height;
    }

    public int getAppletWidth() {
        return this._width;
    }

    public Color getBackColor() {
        return this._background;
    }

    public Color getForeColor() {
        return this._foreground;
    }

    public ArrayList getSelectedPointsIndex() {
        ArrayList arrayList = this.getIndexesForOIds(this._selectedPointOIds);
        int n = 0;
        while (n < arrayList.size()) {
            System.out.println(arrayList.get(n));
            ++n;
        }
        return arrayList;
    }

    public ArrayList getHighlightedPointsIndex() {
        ArrayList arrayList = this.getIndexesForOIds(this._highlightedPoints);
        return arrayList;
    }

    public ArrayList getIndexesForOIds(HashSet hashSet) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        DataDisplayColumn dataDisplayColumn = this._pd.getObjectIDColumn();
        if (null == hashSet || null == dataDisplayColumn || hashSet.size() <= 0) {
            return arrayList;
        }
        Iterator iterator = hashSet.iterator();
        block0: while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (null == string) continue;
            int n = 0;
            while (n < dataDisplayColumn.getNumOfRows()) {
                if (string.equals(dataDisplayColumn.getData(n))) {
                    arrayList.add(new Integer(n));
                    continue block0;
                }
                ++n;
            }
        }
        return arrayList;
    }

    public String[] getColumnNames() {
        if (null == this._pd) {
            return new String[0];
        }
        int n = this._pd.getNumOfPlotColumns();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = this._pd.getPlotColumn(n2).getName();
            ++n2;
        }
        return stringArray;
    }

    public int getColumnIndex(String string) {
        if (null == this._pd) {
            return -1;
        }
        int n = this._pd.getNumOfPlotColumns();
        int n2 = 0;
        while (n2 < n) {
            if (string.equals(this._pd.getPlotColumn(n2).getName())) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public String[] getFilterNames() {
        if (null == this._pd) {
            return new String[0];
        }
        int n = this._pd.getNumOfFilters();
        String[] stringArray = new String[n + 1];
        stringArray[0] = "All";
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2 + 1] = this._pd.getPlotFilter(n2).getName();
            ++n2;
        }
        return stringArray;
    }

    public Double[] getColumnData(int n) {
        Double[] doubleArray = new Double[]{};
        PlotColumn plotColumn = this._pd.getPlotColumn(n);
        if (null == plotColumn) {
            System.out.println("PlotColumn pc = null");
            return doubleArray;
        }
        return plotColumn.getData();
    }

    public String getColumnUcd(int n) {
        String string = new String();
        PlotColumn plotColumn = this._pd.getPlotColumn(n);
        if (null == plotColumn) {
            System.out.println("PlotColumn pc = null");
            return string;
        }
        return plotColumn.getUCD();
    }

    public String getColumnUnit(int n) {
        String string = "";
        PlotColumn plotColumn = this._pd.getPlotColumn(n);
        if (null == plotColumn) {
            return string;
        }
        string = plotColumn.getUnit();
        if (null == string || string.trim().length() <= 0) {
            string = "";
            return string;
        }
        return "[" + string + "]";
    }

    private boolean[] getFilterData(String string) {
        boolean[] blArray = new boolean[]{};
        int n = 0;
        while (n < this._pd.getNumOfFilters()) {
            PlotFilter plotFilter = this._pd.getPlotFilter(n);
            if (string.equals(plotFilter.getName())) {
                blArray = plotFilter.getData();
            }
            ++n;
        }
        return blArray;
    }

    public boolean toOverlay() {
        if (this._redrawing && this._firstplot) {
            return false;
        }
        if (this._redrawing && !this._firstplot) {
            return true;
        }
        if (!this._redrawing) {
            return this._buttons.isOverlaySelected();
        }
        return true;
    }

    private void readParameters() {
        String string = this.getParameter(WIDTH);
        this._width = string != null ? Integer.parseInt(string) - 140 : 840;
        String string2 = this.getParameter(HEIGHT);
        this._height = string2 != null ? Integer.parseInt(string2) - 20 : 550;
        String string3 = this.getParameter(BACKGROUND);
        this._background = string3 != null ? PlotBox.getColorByName(string3) : PlotBox.getColorByName(BACKGROUND_COLOR);
        string3 = this.getParameter(FOREGROUND);
        if (string3 != null) {
            this._foreground = PlotBox.getColorByName(string3);
        }
    }

    private void readData() {
        String string = this.getParameter(PARAMETERS);
        this.getVOTableData(string);
    }

    public void setAsWebApp(boolean bl) {
        this._usedAsWebApp = bl;
    }

    public boolean isWebApp() {
        return this._usedAsWebApp;
    }

    public boolean isSubApp() {
        return this._isSubApp;
    }

    public boolean isHistogram() {
        return this._histogram;
    }

    public int getNumPlots() {
        return this._dataSet + 1;
    }

    private void addToHighlightedPoints(String[] stringArray) {
        this._highlightedPoints.clear();
        if (null == stringArray) {
            return;
        }
        System.out.println("Highlighted points :");
        int n = 0;
        while (n < stringArray.length) {
            System.out.print(stringArray[n] + ", ");
            this._highlightedPoints.add(stringArray[n]);
            ++n;
        }
        System.out.println(" ");
    }

    private void addToSelectedPoints(String[] stringArray) {
        this._selectedPointOIds.clear();
        this.clearSelectedPoints(false);
        if (null == stringArray) {
            return;
        }
        System.out.println("Selected points :");
        int n = 0;
        while (n < stringArray.length) {
            System.out.print(stringArray[n] + ", ");
            this._selectedPointOIds.add(stringArray[n]);
            ++n;
        }
        System.out.println(" ");
    }

    public void drawPlot() {
        int n;
        if (null == this._pd) {
            System.out.println("Error : Cannot draw plot, plot data not found.");
            return;
        }
        JVTUtil.showWaitCursor(this);
        if (1 == this._currentPlotType) {
            this.storeHistogramProperties((Histogram)this._plot);
            this._plot = new Plot();
            this._currentPlotType = 0;
            this.reInitialize();
            this._prop.clearAll();
        }
        Plot plot = (Plot)this.plot();
        this._selectedPointOIds.clear();
        if (this._dataSet == -1) {
            this.applyPlotProperties(plot);
        }
        String string = this._pd.getCatalogueName();
        this._histogram = false;
        Double[] doubleArray = new Double[]{};
        Double[] doubleArray2 = new Double[]{};
        boolean[] blArray = new boolean[]{};
        this._filterApplied = this._buttons.getSelectedFilter();
        DataDisplayColumn dataDisplayColumn = this._pd.getObjectIDColumn();
        if (this._filterApplied != "All") {
            blArray = this.getFilterData(this._filterApplied);
        }
        String[] stringArray = this.getColumnNames();
        String string2 = this._buttons.getSelectedXColumn();
        String string3 = this._buttons.getSelectedYColumn();
        int n2 = 0;
        while (n2 < this._numColumns) {
            if (string2.equals(stringArray[n2])) {
                doubleArray = this.getColumnData(n2);
                this._xunit = this.getColumnUnit(n2);
                this._xucd = this.getColumnUcd(n2);
            }
            if (string3.equals(stringArray[n2])) {
                doubleArray2 = this.getColumnData(n2);
                this._yunit = this.getColumnUnit(n2);
                this._yucd = this.getColumnUcd(n2);
            }
            ++n2;
        }
        if (this._buttons.isLogY() && this.showErrorIfNonPositive(this._filterApplied, doubleArray2, 2)) {
            return;
        }
        if (this._buttons.isLogX() && this.showErrorIfNonPositive(this._filterApplied, doubleArray, 1)) {
            return;
        }
        String string4 = this.generateLabel('x');
        String string5 = this.generateLabel('y');
        this.storePlotProperties(plot);
        if (this.isAlreadyPlotted(this._filterApplied, string4, string5, 0.0, this._buttons.getSelectedCooSysIndex())) {
            plot.fillPlot();
            JVTUtil.showDefaultCursor(this);
            return;
        }
        this._colsPlotted.add(this._filterApplied + " " + string4 + " " + string5 + 0.0 + this._buttons.getSelectedCooSysIndex());
        if (this.toOverlay()) {
            Object object;
            ++this._dataSet;
            if (this._dataSet == 1) {
                object = this.getLegendLabel(false, false);
                plot.addLegend(0, (String)object);
            }
            if (this._dataSet >= 1) {
                object = this.getLegendLabel(true, false);
                plot.addLegend(this._dataSet, (String)object);
            }
            plot.setTitle(string);
            if (plot.getXLabel() != null) {
                plot.setXLabel(plot.getXLabel() + ", " + string4);
            } else {
                plot.setXLabel(string4);
            }
            if (plot.getYLabel() != null) {
                plot.setYLabel(plot.getYLabel() + ", " + string5);
            } else {
                plot.setYLabel(string5);
            }
            if (this._dataSet > 0) {
                object = plot.getXRange();
                plot.setXRange((double)object[0], (double)object[1]);
                object = plot.getYRange();
                plot.setYRange((double)object[0], (double)object[1]);
            }
        } else {
            this._dataSet = 0;
            this._prop.clearAll();
            this._colsPlotted.clear();
            this._colsPlotted.add(this._filterApplied + " " + string4 + " " + string5 + 0.0 + this._buttons.getSelectedCooSysIndex());
            plot.clear(true);
            plot.repaint();
            plot.setXLabel(string4);
            plot.setYLabel(string5);
            plot.setTitle(string);
        }
        this.applyPlotProperties(plot);
        if (this._buttons.isLogY()) {
            plot.setYLog(true);
        } else {
            plot.setYLog(false);
        }
        if (this._buttons.isLogX()) {
            plot.setXLog(true);
        } else {
            plot.setXLog(false);
        }
        if (this._filterApplied != "All") {
            n = 0;
            while (n < doubleArray.length) {
                if (blArray[n] && doubleArray[n] != null && doubleArray2[n] != null) {
                    plot.addPoint(this._dataSet, doubleArray[n], doubleArray2[n], dataDisplayColumn.getData(n), true);
                }
                ++n;
            }
        } else {
            n = 0;
            while (n < doubleArray.length) {
                if (doubleArray[n] != null && doubleArray2[n] != null) {
                    plot.addPoint(this._dataSet, doubleArray[n], doubleArray2[n], dataDisplayColumn.getData(n), true);
                }
                ++n;
            }
        }
        if (this._dataSet == 0) {
            plot.fillPlot();
        }
        String[] stringArray2 = new String[this._highlightedPoints.size()];
        Iterator iterator = this._highlightedPoints.iterator();
        int n3 = 0;
        while (iterator.hasNext()) {
            stringArray2[n3++] = (String)iterator.next();
        }
        this.highlightPoints(stringArray2);
        plot.repaint();
        this._prop.setPlotBoxProperties(this, this._plot, this._buttons);
        this._prop.addPlotInfo(this._dataSet);
        JVTUtil.showDefaultCursor(this);
    }

    double[] getMinMax(Double[] doubleArray) {
        double d = Double.NEGATIVE_INFINITY;
        double d2 = Double.POSITIVE_INFINITY;
        int n = 0;
        while (n < doubleArray.length) {
            if (doubleArray[n] != null) {
                if (doubleArray[n] > d) {
                    d = doubleArray[n];
                }
                if (doubleArray[n] < d2) {
                    d2 = doubleArray[n];
                }
            }
            ++n;
        }
        double[] dArray = new double[]{d2, d};
        return dArray;
    }

    double[] getMinMax(Double[] doubleArray, boolean[] blArray) {
        double d = Double.NEGATIVE_INFINITY;
        double d2 = Double.POSITIVE_INFINITY;
        int n = 0;
        while (n < doubleArray.length) {
            if (blArray[n] && doubleArray[n] != null) {
                if (doubleArray[n] > d) {
                    d = doubleArray[n];
                }
                if (doubleArray[n] < d2) {
                    d2 = doubleArray[n];
                }
            }
            ++n;
        }
        double[] dArray = new double[]{d2, d};
        return dArray;
    }

    public String generateLabel(char c) {
        String string = new String();
        if (c == 'x') {
            string = this._buttons.getSelectedXColumn();
            if (this._buttons.isLogX()) {
                string = "log(" + string + ")";
            }
            if (this._xunit != null) {
                string = string + " " + this._xunit;
            }
        } else {
            string = this._buttons.getSelectedYColumn();
            if (this._buttons.isLogY()) {
                string = "log(" + string + ")";
            }
            if (this._yunit != null) {
                string = string + " " + this._yunit;
            }
        }
        return string;
    }

    public void sendImage() {
        this._prop.setPlotBoxProperties(this, this._plot, this._buttons);
        this.sendToServlet();
        String string = "";
        this._mainWindow.eval("window.open(\"" + string + "/plot.gif?action=showImg.gif\", \"_blank\", \"width=800,height=500,top=100,left=100\")");
        this.plot().validate();
    }

    boolean isAlreadyPlotted(String string, String string2, String string3, double d, int n) {
        if (!this._buttons.isOverlaySelected()) {
            return false;
        }
        String string4 = string + " " + string2 + " " + string3 + d + n;
        int n2 = 0;
        while (n2 < this._colsPlotted.size()) {
            String string5 = (String)this._colsPlotted.get(n2);
            if (string4.equals(string5)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    boolean showErrorIfNonPositive(String string, Double[] doubleArray, int n) {
        if (!this.isColPositive(string, doubleArray)) {
            JVTUtil.showDefaultCursor(this);
            this.showError(_errorMsg[n]);
            this.repaint();
            return true;
        }
        return false;
    }

    void showError(String string) {
        JOptionPane.showMessageDialog(null, string, "Error", 0);
    }

    public void showHelp() {
        try {
            String string = this.getParameter(HELP_URL);
            this._mainWindow.eval("window.open(\"" + string + "\")");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static PlotVOApplet launch() {
        PlotVOApplet plotVOApplet = new PlotVOApplet();
        try {
            try {
                System.getProperty("java.class.path");
                plotVOApplet.setAsWebApp(false);
            }
            catch (AccessControlException accessControlException) {
                plotVOApplet.setAsWebApp(true);
            }
            JFrame jFrame = new JFrame();
            jFrame.setTitle("VOPlot");
            JPanel jPanel = new JPanel();
            jPanel.add(plotVOApplet);
            jFrame.getContentPane().add((Component)plotVOApplet, "Center");
            plotVOApplet.setAsSubApplication(true);
            plotVOApplet.start();
            ((Component)jFrame).setSize(new Dimension(860, 600));
            ((Component)jFrame).setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return plotVOApplet;
    }

    public void showVOPlotFrame() {
        try {
            PlotVOApplet plotVOApplet = PlotVOApplet.launch();
            VOTableWriter vOTableWriter = new VOTableWriter(this);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            vOTableWriter.getDataInVOTableFormat(byteArrayOutputStream);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            plotVOApplet.loadVOTable(this, byteArrayInputStream);
            this.showPointsInExtApp(this._selectedPointOIds);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private byte[] writeTestVOTable() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        stringBuffer.append("\t<VOTABLE>\n");
        stringBuffer.append("\t<DEFINITIONS>\n");
        stringBuffer.append("\t  <COOSYS ID=\"J2000\" system=\"eq_FK5\" equinox=\"J2000\"/>\n");
        stringBuffer.append("\t</DEFINITIONS>\n");
        stringBuffer.append("\t<RESOURCE ID=\"yCat_1200\" name=\"I/200\">\n");
        stringBuffer.append("\t  <DESCRIPTION>Lick Northern Proper Motion: NPM1 Ref. Galaxies</DESCRIPTION>\n");
        stringBuffer.append("\t  <COOSYS ID=\"B1950\" system=\"eq_FK4\" equinox=\"J1950\"/>\n");
        stringBuffer.append("\t  <TABLE ID=\"I_200_npm1rgal\" name=\"I/200/npm1rgal\">\n");
        stringBuffer.append("\t  <FIELD name=\"_OID\" ucd=\"ID_NUMBER\" datatype=\"char\" type=\"hidden\">");
        stringBuffer.append("\t      </FIELD>\n");
        stringBuffer.append("\t  <FIELD name=\"RAB1950\" ucd=\"POS_EQ_RA_MAIN\" datatype=\"char\" arraysize=\"12\" unit=\"&quot;h:m:s&quot;\">");
        stringBuffer.append("\t      </FIELD>\n");
        stringBuffer.append("\t  <FIELD name=\"DEB1950\" ucd=\"POS_EQ_DEC_MAIN\" datatype=\"char\" arraysize=\"12\" unit=\"&quot;h:m:s&quot;\">");
        stringBuffer.append("\t\t</FIELD>\n");
        stringBuffer.append("\t\t<DATA><TABLEDATA>\n");
        stringBuffer.append("<TR><TD>1</TD><TD>12 20 02.855</TD><TD>+79 01 57.74</TD></TR>\n");
        stringBuffer.append("<TR><TD>2</TD><TD>12 20 03.827</TD><TD>+13 59 38.74</TD></TR>\n");
        stringBuffer.append("<TR><TD>3</TD><TD>12 20 04.358</TD><TD>-14 00 56.23</TD></TR>\n");
        stringBuffer.append("<TR><TD>4</TD><TD>12 20 04.698</TD><TD>+24 21 44.27</TD></TR>\n");
        stringBuffer.append("<TR><TD>5</TD><TD>12 20 04.742</TD><TD>+13 43 28.96</TD></TR>\n");
        stringBuffer.append("<TR><TD>6</TD><TD>12 20 05.898</TD><TD>-13 34 53.95</TD></TR>\n");
        stringBuffer.append("<TR><TD>7</TD><TD>12 20 06.606</TD><TD>+75 06 55.73</TD></TR>\n");
        stringBuffer.append("<TR><TD>8</TD><TD>12 20 08.937</TD><TD>+03 25 08.17</TD></TR>\n");
        stringBuffer.append("<TR><TD>9</TD><TD>12 20 09.029</TD><TD>+51 25 55.00</TD></TR>\n");
        stringBuffer.append("<TR><TD>10</TD><TD>12 20 09.223</TD><TD>+56 51 08.34</TD></TR>\n");
        stringBuffer.append("<TR><TD>11</TD><TD>12 20 09.762</TD><TD>+64 10 48.80</TD></TR>\n");
        stringBuffer.append("<TR><TD>12</TD><TD>12 20 10.241</TD><TD>-12 14 29.68</TD></TR>\n");
        stringBuffer.append("<TR><TD>13</TD><TD>12 20 13.367</TD><TD>-19 33 00.19</TD></TR>\n");
        stringBuffer.append("<TR><TD>14</TD><TD>12 20 13.657</TD><TD>+28 00 51.04</TD></TR>\n");
        stringBuffer.append("<TR><TD>15</TD><TD>12 20 13.877</TD><TD>+35 38 13.93</TD></TR>\n");
        stringBuffer.append("<TR><TD>16</TD><TD>12 20 14.501</TD><TD>+05 53 01.86</TD></TR>\n");
        stringBuffer.append("<TR><TD>17</TD><TD>12 20 14.553</TD><TD>+20 02 50.49</TD></TR>\n");
        stringBuffer.append("<TR><TD>18</TD><TD>12 20 16.148</TD><TD>+03 22 51.67</TD></TR>\n");
        stringBuffer.append("<TR><TD>19</TD><TD>12 20 17.183</TD><TD>+12 51 27.43</TD></TR>\n");
        stringBuffer.append("<TR><TD>20</TD><TD>12 20 19.164</TD><TD>+39 17 48.46</TD></TR>\n");
        stringBuffer.append("<TR><TD>21</TD><TD>12 20 20.340</TD><TD>-02 23 30.87</TD></TR>\n");
        stringBuffer.append("<TR><TD>22</TD><TD>12 20 20.609</TD><TD>+06 06 06.58</TD></TR>\n");
        stringBuffer.append("<TR><TD>23</TD><TD>12 20 22.215</TD><TD>+22 43 27.96</TD></TR>\n");
        stringBuffer.append("<TR><TD>24</TD><TD>12 20 22.553</TD><TD>+18 56 30.28</TD></TR>\n");
        stringBuffer.append("<TR><TD>25</TD><TD>12 20 23.188</TD><TD>+03 01 26.77</TD></TR>\n");
        stringBuffer.append("<TR><TD>26</TD><TD>12 20 23.806</TD><TD>+31 27 24.61</TD></TR>\n");
        stringBuffer.append("<TR><TD>27</TD><TD>12 20 25.281</TD><TD>+10 49 32.96</TD></TR>\n");
        stringBuffer.append("<TR><TD>28</TD><TD>12 20 26.843</TD><TD>-12 56 47.29</TD></TR>\n");
        stringBuffer.append("<TR><TD>29</TD><TD>12 20 27.420</TD><TD>-14 03 42.01</TD></TR>\n");
        stringBuffer.append("<TR><TD>30</TD><TD>12 20 27.424</TD><TD>+22 54 42.13</TD></TR>\n");
        stringBuffer.append("<TR><TD>31</TD><TD>12 20 30.246</TD><TD>+67 08 22.56</TD></TR>\n");
        stringBuffer.append("<TR><TD>32</TD><TD>12 20 32.386</TD><TD>+53 52 46.99</TD></TR>\n");
        stringBuffer.append("<TR><TD>33</TD><TD>12 20 34.132</TD><TD>+10 53 53.92</TD></TR>\n");
        stringBuffer.append("<TR><TD>34</TD><TD>12 20 35.013</TD><TD>+15 47 11.93</TD></TR>\n");
        stringBuffer.append("<TR><TD>35</TD><TD>12 20 35.392</TD><TD>-10 45 44.70</TD></TR>\n");
        stringBuffer.append("<TR><TD>36</TD><TD>12 20 35.706</TD><TD>-12 55 39.11</TD></TR>\n");
        stringBuffer.append("<TR><TD>37</TD><TD>12 20 35.970</TD><TD>-12 36 12.57</TD></TR>\n");
        stringBuffer.append("<TR><TD>38</TD><TD>12 20 36.816</TD><TD>-04 46 39.26</TD></TR>\n");
        stringBuffer.append("<TR><TD>39</TD><TD>12 20 37.945</TD><TD>+27 10 56.21</TD></TR>\n");
        stringBuffer.append("<TR><TD>40</TD><TD>12 20 38.288</TD><TD>+14 37 24.51</TD></TR>\n");
        stringBuffer.append("<TR><TD>41</TD><TD>12 20 38.407</TD><TD>-16 24 55.85</TD></TR>\n");
        stringBuffer.append("<TR><TD>42</TD><TD>12 20 38.567</TD><TD>+06 20 56.85</TD></TR>\n");
        stringBuffer.append("<TR><TD>43</TD><TD>12 20 40.033</TD><TD>+76 14 33.19</TD></TR>\n");
        stringBuffer.append("<TR><TD>44</TD><TD>12 20 40.363</TD><TD>+32 25 38.20</TD></TR>\n");
        stringBuffer.append("<TR><TD>45</TD><TD>12 20 42.249</TD><TD>-15 50 54.64</TD></TR>\n");
        stringBuffer.append("<TR><TD>46</TD><TD>12 20 44.282</TD><TD>+63 29 58.33</TD></TR>\n");
        stringBuffer.append("<TR><TD>47</TD><TD>12 20 47.223</TD><TD>-05 24 23.21</TD></TR>\n");
        stringBuffer.append("<TR><TD>48</TD><TD>12 20 48.174</TD><TD>+28 25 48.79</TD></TR>\n");
        stringBuffer.append("<TR><TD>49</TD><TD>12 20 48.450</TD><TD>-14 05 46.47</TD></TR>\n");
        stringBuffer.append("<TR><TD>50</TD><TD>12 20 49.203</TD><TD>+06 19 03.73</TD></TR>\n");
        stringBuffer.append("\t\t</TABLEDATA>\n");
        stringBuffer.append("\t\t</DATA>\n");
        stringBuffer.append("\t\t</TABLE>\n");
        stringBuffer.append("\t\t</RESOURCE>\n");
        stringBuffer.append("\t\t</VOTABLE>\n");
        String string = stringBuffer.toString();
        return string.getBytes();
    }

    public void showAladinDialog() {
        try {
            this._extApp = this.isWebApp() ? Aladin.launch(this) : Aladin.launch();
            VOTableWriter vOTableWriter = new VOTableWriter(this);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            vOTableWriter.getDataInVOTableFormat(byteArrayOutputStream);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            this._extApp.loadVOTable(this, byteArrayInputStream);
            this.showPointsInExtApp(this._selectedPointOIds);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    boolean isColPositive(String string, Double[] doubleArray) {
        boolean[] blArray = new boolean[]{true};
        if (string != "All") {
            blArray = this.getFilterData(string);
            int n = 0;
            while (n < doubleArray.length) {
                if (blArray[n] && doubleArray[n] != null && doubleArray[n] <= 0.0) {
                    return false;
                }
                ++n;
            }
        } else {
            int n = 0;
            while (n < doubleArray.length) {
                if (doubleArray[n] != null && doubleArray[n] <= 0.0) {
                    return false;
                }
                ++n;
            }
        }
        return true;
    }

    private void setDefaultPlotProperties() {
        this._connected = false;
        this._impulses = false;
        this._marker = "various";
        this._grid = true;
        this._color = true;
        this._yincrement = false;
        this._binwidth = 1.0;
    }

    public void applyPlotProperties(Plot plot) {
        plot.setConnected(this._connected);
        plot.setImpulses(this._impulses);
        plot.setMarksStyle(this._marker);
        plot.setGrid(this._grid);
        plot.setColor(this._color);
    }

    public void storePlotProperties(Plot plot) {
        this._connected = plot.getConnected();
        this._impulses = plot.getImpulses();
        this._marker = plot.getMarksStyle();
        this._grid = plot.getGrid();
        this._color = plot.getColor();
    }

    public void applyHistogramProperties(Histogram histogram) {
        histogram.setGrid(this._grid);
        histogram.setColor(this._color);
        histogram.setYIncremented(this._yincrement);
    }

    public void storeHistogramProperties(Histogram histogram) {
        this._yincrement = histogram.isYIncremented();
        this._grid = histogram.getGrid();
        this._color = histogram.getColor();
    }

    public void drawHistogram(double d) {
        Object object;
        if (null == this._pd) {
            System.out.println("Error : Cannot draw histogram, plot data not found.");
            return;
        }
        JVTUtil.showWaitCursor(this);
        if (0 == this._currentPlotType) {
            object = (Plot)this.plot();
            this.applyPlotProperties((Plot)object);
            this.storePlotProperties((Plot)object);
            this._plot = new Histogram();
            this._currentPlotType = 1;
            this.reInitialize();
            this._prop.clearAll();
        }
        this._redrawing = false;
        object = this._buttons.getSelectedXColumn();
        String string = this._buttons.getSelectedYColumn();
        this.drawColHist(this._buttons.getSelectedFilter(), (String)object, string);
        JVTUtil.showDefaultCursor(this);
    }

    public void redrawHistograms(double d) {
        JVTUtil.showWaitCursor(this);
        if (0 == this._currentPlotType) {
            this._plot = new Histogram();
            this._currentPlotType = 1;
            this.reInitialize();
        }
        this._redrawing = true;
        this._binwidth = d;
        int n = this._dataSet;
        int n2 = 0;
        while (n2 <= n) {
            this._firstplot = n2 == 0;
            PlotInfo plotInfo = this._prop.getPlotInfo(n2);
            String string = plotInfo.getSelectedXColName();
            String string2 = plotInfo.getSelectedYColName();
            String string3 = plotInfo.getSelectedFilterName();
            this.drawColHist(string3, string, string2);
            this._prop.setPlotBoxProperties(this, this._plot, this._buttons);
            ++n2;
        }
        JVTUtil.showDefaultCursor(this);
    }

    public void drawColHist(String string, String string2, String string3) {
        this.plot().zoomSelect("Zoom");
        Histogram histogram = (Histogram)this.plot();
        if (this._dataSet == -1) {
            this.applyHistogramProperties(histogram);
        }
        boolean[] blArray = new boolean[]{};
        if (string != "All") {
            blArray = this.getFilterData(string);
        }
        this._histogram = true;
        Double[] doubleArray = new Double[]{};
        Double[] doubleArray2 = new Double[]{};
        String string4 = this._pd.getCatalogueName();
        String[] stringArray = this.getColumnNames();
        int n = 0;
        while (n < this._numColumns) {
            if (string2.equals(stringArray[n])) {
                doubleArray = this.getColumnData(n);
                this._xunit = this.getColumnUnit(n);
                this._xucd = this.getColumnUcd(n);
            }
            if (string3.equals(stringArray[n])) {
                doubleArray2 = this.getColumnData(n);
                this._yunit = this.getColumnUnit(n);
                this._yucd = this.getColumnUcd(n);
            }
            ++n;
        }
        if (this._buttons.isLogX() && this.showErrorIfNonPositive(string, doubleArray, 1)) {
            return;
        }
        this.storeHistogramProperties(histogram);
        String string5 = this._redrawing ? string2 : this.generateLabel('x');
        String string6 = HIST_Y_LABEL;
        if (this._buttons.isLogY()) {
            if (histogram.isYIncremented()) {
                string6 = string6 + "+1";
            }
            string6 = "log(" + string6 + ")";
        }
        if (this.isAlreadyPlotted(string, "", string5, this._binwidth, this._buttons.getSelectedCooSysIndex())) {
            histogram.fillPlot();
            return;
        }
        this._colsPlotted.add(string + " " + "" + " " + string5 + this._binwidth + this._buttons.getSelectedCooSysIndex());
        if (this.toOverlay()) {
            String string7;
            ++this._dataSet;
            if (this._dataSet == 1) {
                string7 = this.getLegendLabel(false, true);
                histogram.addLegend(0, string7);
            }
            if (this._dataSet >= 1) {
                string7 = this.getLegendLabel(true, true);
                histogram.addLegend(this._dataSet, string7);
            }
            histogram.setTitle(string4);
            if (histogram.getXLabel() != null) {
                histogram.setXLabel(histogram.getXLabel() + ", " + string5);
            } else {
                histogram.setXLabel(string5);
            }
        } else {
            this._colsPlotted.clear();
            this._colsPlotted.add(string + " " + "" + " " + string5 + this._binwidth + this._buttons.getSelectedCooSysIndex());
            this._dataSet = 0;
            if (!this._redrawing) {
                this._prop.clearAll();
            }
            histogram.clear(true);
            histogram.repaint();
            histogram.setXLabel(string5);
            histogram.setTitle(string4);
        }
        histogram.setYLabel(string6);
        histogram.setBinWidth(this._binwidth);
        histogram.setBinOffset(this._binwidth / 2.0);
        this.applyHistogramProperties(histogram);
        if (this._buttons.isLogY()) {
            histogram.setYLog(true);
        } else {
            histogram.setYLog(false);
        }
        if (string != "All") {
            int n2 = 0;
            while (n2 < doubleArray.length) {
                if (blArray[n2] && doubleArray[n2] != null) {
                    if (this._buttons.isLogX()) {
                        histogram.addPoint(this._dataSet, Math.log(doubleArray[n2]) * JVTUtil._LOG10SCALE);
                    } else {
                        histogram.addPoint(this._dataSet, doubleArray[n2]);
                    }
                }
                ++n2;
            }
        } else {
            int n3 = 0;
            while (n3 < doubleArray.length) {
                if (doubleArray[n3] != null) {
                    if (this._buttons.isLogX()) {
                        histogram.addPoint(this._dataSet, Math.log(doubleArray[n3]) * JVTUtil._LOG10SCALE);
                    } else {
                        histogram.addPoint(this._dataSet, doubleArray[n3]);
                    }
                }
                ++n3;
            }
        }
        if (this._dataSet == 0) {
            histogram.fillPlot();
        }
        if (!this._redrawing) {
            this._prop.setPlotBoxProperties(this, this._plot, this._buttons);
            this._prop.addPlotInfo(this._dataSet);
        }
        histogram.repaint();
    }

    public void setUpPlotBox() {
        this._setPlotSize(this._width, this._height);
        this._buttons.setButtons(true, this._background);
        this.setBackground(this._background);
        this.plot().setBackground(this._background);
        this.plot().setForeground(this._foreground);
        this.plot().setVisible(true);
    }

    void setUpPlotBoxSwap() {
        this._setPlotSize(this._width, this._height);
        this.setBackground(this._background);
        this.plot().setBackground(this._background);
        this.plot().setForeground(this._foreground);
        this.plot().setVisible(true);
    }

    public void reInitialize() {
        this._plot.setVOApplet(this, this._buttons);
        this._buttons.swapPanels();
        this._dataSet = -1;
        this._colsPlotted.clear();
        this._selectedPointOIds.clear();
    }

    public void selectPointsWithin(boolean bl, double d, double d2, double d3, double d4) {
        if (0 == this._currentPlotType) {
            Plot plot = (Plot)this.plot();
            Vector vector = plot._points;
            int n = 0;
            while (n < vector.size()) {
                Vector vector2 = (Vector)vector.elementAt(n);
                int n2 = 0;
                while (n2 < vector2.size()) {
                    PlotPoint plotPoint = (PlotPoint)vector2.elementAt(n2);
                    if (plotPoint.x > d && plotPoint.x < d3 && plotPoint.y > d2 && plotPoint.y < d4) {
                        if (bl) {
                            plotPoint.selected = true;
                            this._selectedPointOIds.add(plotPoint.objectID);
                        } else {
                            plotPoint.selected = false;
                            this._selectedPointOIds.remove(plotPoint.objectID);
                        }
                    }
                    ++n2;
                }
                ++n;
            }
            this.repaint();
        }
        this.showPointsInExtApp(this._selectedPointOIds);
    }

    private void showPointsInExtApp(HashSet hashSet) {
        if (null == hashSet) {
            return;
        }
        Iterator iterator = hashSet.iterator();
        String[] stringArray = new String[hashSet.size()];
        int n = 0;
        System.out.println("Aladin to select points: ");
        while (iterator.hasNext()) {
            stringArray[n] = (String)iterator.next();
            System.out.print(stringArray[n] + ", ");
            ++n;
        }
        System.out.println("\n------");
        if (null != this._extApp) {
            this._extApp.selectVOTableObject(stringArray);
        }
    }

    private void clearPointsInExtApp() {
        System.out.println("Clearing points in Aladin.");
        if (null != this._extApp) {
            String[] stringArray = new String[]{};
            this._extApp.selectVOTableObject(stringArray);
        }
    }

    public void selectPoints(String[] stringArray) {
        if (0 == this._currentPlotType && null != stringArray) {
            Plot plot = (Plot)this.plot();
            Vector vector = plot._points;
            int n = 0;
            while (n < vector.size()) {
                Vector vector2 = (Vector)vector.elementAt(n);
                int n2 = 0;
                while (n2 < vector2.size()) {
                    PlotPoint plotPoint = (PlotPoint)vector2.elementAt(n2);
                    int n3 = 0;
                    while (n3 < stringArray.length) {
                        if (plotPoint.objectID.equals(stringArray[n3])) {
                            plotPoint.selected = true;
                            break;
                        }
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            this.repaint();
        }
    }

    public void clearSelectedPoints(boolean bl) {
        if (0 == this._currentPlotType) {
            this._selectedPointOIds.clear();
            Plot plot = (Plot)this.plot();
            Vector vector = plot._points;
            int n = 0;
            while (n < vector.size()) {
                Vector vector2 = (Vector)vector.elementAt(n);
                int n2 = 0;
                while (n2 < vector2.size()) {
                    PlotPoint plotPoint = (PlotPoint)vector2.elementAt(n2);
                    plotPoint.selected = false;
                    ++n2;
                }
                ++n;
            }
            this.repaint();
        }
        if (bl) {
            this.clearPointsInExtApp();
        }
    }

    public void highlightPoints(String[] stringArray) {
        if (null == stringArray) {
            return;
        }
        int n = 0;
        if (0 == this._currentPlotType) {
            Plot plot = (Plot)this.plot();
            Vector vector = plot._points;
            int n2 = 0;
            while (n2 < vector.size()) {
                Vector vector2 = (Vector)vector.elementAt(n2);
                int n3 = 0;
                while (n3 < vector2.size()) {
                    PlotPoint plotPoint = (PlotPoint)vector2.elementAt(n3);
                    plotPoint.highlighted = false;
                    n = 0;
                    while (n < stringArray.length) {
                        if (plotPoint.objectID.equals(stringArray[n])) {
                            plotPoint.highlighted = true;
                            break;
                        }
                        ++n;
                    }
                    ++n3;
                }
                ++n2;
            }
            this.repaint();
        }
    }

    private void showNoStatus() {
        this.showStatus("");
    }

    public void getDataFromServlet(String string) {
        try {
            String string2 = this.getParameter(VOTABLEPATH);
            String string3 = string2 + string;
            System.out.println("Parsing votable - " + string3);
            this.showStatus("Parsing VOTable. Please wait...");
            try {
                SAVOTParser sAVOTParser = new SAVOTParser(string3);
                this.setVOTable(sAVOTParser.getVOTableMetaData());
                this.setResource(sAVOTParser.getVOTableResourceMetaData());
                this.setTable(sAVOTParser.getVOTableTableMetaData());
                this._pd = sAVOTParser.getPlotData();
                if (null != this._pd) {
                    DataDisplayColumn dataDisplayColumn = this._pd.getObjectIDColumn();
                    if (null != dataDisplayColumn) {
                        System.out.println("Printing object IDs.");
                        int n = 0;
                        while (n < dataDisplayColumn.getNumOfRows()) {
                            System.out.println(dataDisplayColumn.getData(n));
                            ++n;
                        }
                    } else {
                        this._pd.generateObjectIDColumn();
                    }
                }
                this.showNoStatus();
            }
            catch (Exception exception) {
                this.showStatus("Error while parsing VOTable.");
                exception.printStackTrace();
            }
            if (null == this._pd) {
                this._numColumns = 0;
                System.err.println("No Plot Data found.");
            } else {
                this._numColumns = this._pd.getNumOfPlotColumns();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void sendToServlet() {
        try {
            Object object;
            String string = "";
            string = this.getParameter(SERVLETPATH);
            URL uRL = new URL(string + "?action=getData");
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setUseCaches(false);
            httpURLConnection.setDefaultUseCaches(false);
            httpURLConnection.setRequestProperty("Content-Type", "application/octet-stream");
            this._prop.clearData();
            int n = 0;
            while (n < this._prop.getPlotInfoSize()) {
                object = this._prop.getPlotInfo(n);
                int n2 = ((PlotInfo)object).getSelectedXColIndex();
                this._prop.addPlotData(n2, this.getColumnData(n2));
                n2 = ((PlotInfo)object).getSelectedYColIndex();
                this._prop.addPlotData(n2, this.getColumnData(n2));
                String string2 = ((PlotInfo)object).getSelectedFilterName();
                if (!string2.equals("All")) {
                    this._prop.addFilterData(string2, this.getFilterData(string2));
                }
                ++n;
            }
            object = new ObjectOutputStream(httpURLConnection.getOutputStream());
            ((ObjectOutputStream)object).writeObject(this._prop);
            ((ObjectOutputStream)object).flush();
            ((ObjectOutputStream)object).close();
            ObjectInputStream objectInputStream = new ObjectInputStream(httpURLConnection.getInputStream());
            String string3 = (String)objectInputStream.readObject();
            objectInputStream.close();
            httpURLConnection.disconnect();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setPlotData(PlotData plotData) {
        this._pd = plotData;
        this._buttons.emptyCmbData();
        this._buttons.emptyCmbFilter();
        this._buttons.addFilterItem("All");
        if (this._pd != null) {
            this._numColumns = this._pd.getNumOfPlotColumns();
            String[] stringArray = this.getColumnNames();
            int n = 0;
            while (n < this._numColumns) {
                this._buttons.addDataItem(stringArray[n]);
                ++n;
            }
        } else {
            this._numColumns = 0;
        }
        this._dataSet = -1;
        this.plot().clear(true);
        this.plot().repaint();
    }

    public void setPlotData(PlotData plotData, boolean bl) {
        this._pd = plotData;
        this._numColumns = this._pd.getNumOfPlotColumns();
        int n = 0;
        while (n < this._numColumns) {
            PlotColumn plotColumn = this._pd.getPlotColumn(n);
            ++n;
        }
        if (!bl) {
            int n2 = this._buttons.getSelectedXIndex();
            int n3 = this._buttons.getSelectedYIndex();
            this._buttons.emptyCmbData();
            int n4 = 0;
            while (n4 < this._pd.getNumOfPlotColumns()) {
                PlotColumn plotColumn = this._pd.getPlotColumn(n4);
                this._buttons.addDataItem(plotColumn.getName());
                ++n4;
            }
            this._buttons.setSelectedXIndex(n2);
            this._buttons.setSelectedYIndex(n3);
        } else {
            int n5 = this._buttons.getSelectedFilterIndex();
            this._buttons.emptyCmbFilter();
            this._buttons.addFilterItem("All");
            int n6 = 0;
            while (n6 < this._pd.getNumOfFilters()) {
                PlotFilter plotFilter = this._pd.getPlotFilter(n6);
                this._buttons.addFilterItem(plotFilter.getName());
                ++n6;
            }
            this._buttons.setSelectedFilterIndex(n5);
        }
        this.coosys = new CoordinateSystems();
    }

    public void setPlotFilter(String string) {
        if (null == string || string.trim().length() <= 0 || this._filterApplied.equals(string)) {
            return;
        }
        this._filterApplied = string;
        if (0 == this._currentPlotType) {
            this.drawPlot();
        } else {
            this.drawHistogram(1.0);
        }
    }

    private String getLegendLabel(boolean bl, boolean bl2) {
        Object object;
        String string;
        String string2;
        String string3;
        if (bl) {
            string3 = this._buttons.getSelectedFilter();
            string2 = this._buttons.getSelectedXColumn();
            string = this._buttons.getSelectedYColumn();
            int n = this._buttons.getSelectedCooSysIndex();
        } else {
            object = this._prop.getPlotInfo(0);
            string3 = ((PlotInfo)object).getSelectedFilterName();
            string2 = ((PlotInfo)object).getSelectedXColName();
            string = ((PlotInfo)object).getSelectedYColName();
            int n = ((PlotInfo)object).getCooSysIndex();
        }
        String string4 = bl2 ? string2 : string + " : " + string2;
        object = string3 != "All" ? string3 + "[" + string4 + "]" : string4;
        return object;
    }

    public void sendEPSUsingPerlScript(PlotBox plotBox) {
        try {
            String string = "";
            string = this.getParameter(SAVE_EPS_URL);
            String string2 = this.getParameter(SESSION_ID);
            URL uRL = new URL(string + "?action=getEPSData" + "&sessionid=" + string2);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setUseCaches(false);
            httpURLConnection.setDefaultUseCaches(false);
            httpURLConnection.setRequestProperty("Content-Type", "application/postscript");
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(httpURLConnection.getOutputStream());
            plotBox.export(bufferedOutputStream);
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
            try {
                byte[] byArray = new byte[100];
                BufferedInputStream bufferedInputStream = new BufferedInputStream(httpURLConnection.getInputStream());
                bufferedInputStream.read(byArray, 0, 10);
                bufferedInputStream.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            httpURLConnection.disconnect();
            this._mainWindow.eval("window.location.href = \"" + string + "/plot.ps?action=showEPS" + "&sessionid=" + string2 + "\"");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        catch (Error error) {
            error.printStackTrace();
        }
    }

    public void sendEPS(PlotBox plotBox) {
        try {
            String string = "";
            string = this.getParameter(SAVE_EPS_URL);
            String string2 = this.getParameter(SESSION_ID);
            if (null == string2) {
                string2 = "";
            }
            URL uRL = new URL(string + "?action=getEPSData" + "&sessionid=" + string2);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setUseCaches(false);
            httpURLConnection.setDefaultUseCaches(false);
            httpURLConnection.setRequestProperty("Content-Type", "application/postscript");
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(httpURLConnection.getOutputStream());
            plotBox.export(objectOutputStream);
            objectOutputStream.flush();
            objectOutputStream.close();
            try {
                byte[] byArray = new byte[100];
                BufferedInputStream bufferedInputStream = new BufferedInputStream(httpURLConnection.getInputStream());
                bufferedInputStream.read(byArray, 0, 10);
                bufferedInputStream.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            httpURLConnection.disconnect();
            this._mainWindow.eval("window.location.href = \"" + string + "/plot.ps?action=showEPS" + "&sessionid=" + string2 + "\"");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        catch (Error error) {
            error.printStackTrace();
        }
    }

    private void getVOTableData(String string) {
        try {
            String string2 = this.getParameter(VOTABLEPATH);
            String string3 = string2 + string;
            URL uRL = new URL(string3);
            this.showStatus("Parsing VOTable. Please wait...");
            try {
                SAVOTParser sAVOTParser = new SAVOTParser(string3);
                this.setVOTable(sAVOTParser.getVOTableMetaData());
                this.setResource(sAVOTParser.getVOTableResourceMetaData());
                this.setTable(sAVOTParser.getVOTableTableMetaData());
                this._pd = sAVOTParser.getPlotData();
                this.showNoStatus();
            }
            catch (Exception exception) {
                this.showStatus("Error while parsing VOTable.");
                exception.printStackTrace();
            }
            if (null == this._pd) {
                this._numColumns = 0;
                this.showError(_errorMsg[0]);
                System.err.println("Error: No Plot Data found in this VOTable.");
            } else {
                this._numColumns = this._pd.getNumOfPlotColumns();
                if (null == this._pd.getObjectIDColumn()) {
                    this._pd.generateObjectIDColumn();
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Error while reading votable data : " + exception.toString());
        }
    }

    public PlotData getPlotData() {
        return this._pd;
    }

    public VOTable getVOTable() {
        return this._votableMetaData;
    }

    public VOTableResource getResource() {
        return this._votableResource;
    }

    public VOTableTable getTable() {
        return this._votableTable;
    }

    public void setVOTable(VOTable vOTable) {
        this._votableMetaData = vOTable;
    }

    public void setResource(VOTableResource vOTableResource) {
        this._votableResource = vOTableResource;
    }

    public void setTable(VOTableTable vOTableTable) {
        this._votableTable = vOTableTable;
    }

    public PlotBox plot() {
        return this._plot;
    }

    protected void _setPlotSize(int n, int n2) {
        this.plot().setSize(n, n2);
    }

    public void loadVOTable(ExtApp extApp, InputStream inputStream) {
        try {
            this._extApp = extApp;
            SAVOTParser sAVOTParser = new SAVOTParser(inputStream);
            PlotData plotData = sAVOTParser.getPlotData();
            if (null == plotData) {
                this.showError(_errorMsg[0]);
                System.err.println("Error: No plot data found in this VOTable.");
            } else if (null == plotData.getObjectIDColumn()) {
                System.err.println("Error: No object ID column found in VOTable.");
                plotData.generateObjectIDColumn();
            }
            this._plot.clear(true);
            this._highlightedPoints.clear();
            this._selectedPointOIds.clear();
            this.setPlotData(plotData);
            this.setVOTable(sAVOTParser.getVOTableMetaData());
            this.setResource(sAVOTParser.getVOTableResourceMetaData());
            this.setTable(sAVOTParser.getVOTableTableMetaData());
            this.drawPlot();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void showVOTableObject(String[] stringArray) {
        this.addToHighlightedPoints(stringArray);
        this.highlightPoints(stringArray);
    }

    public void selectVOTableObject(String[] stringArray) {
        this.addToSelectedPoints(stringArray);
        this.selectPoints(stringArray);
    }

    public String execCommand(String string) {
        return null;
    }
}

