/*
 * Decompiled with CFR 0.152.
 */
package com.jvt.applets;

import java.text.DecimalFormat;

class CoordinateConverter {
    private double pi = 2.0 * Math.asin(1.0);
    private int itern = 30;
    private double tol = 1.0E-7;
    private double alfa0b50 = 282.25 * this.pi / 180.0;
    private double dl0b50 = 33.0 * this.pi / 180.0;
    private double delngp = 27.4 * this.pi / 180.0;
    private double[] alpha;
    private double[] delta;
    private double[] dlrad;
    private double[] brad;
    private double[] x_mw;
    private double[] y_mw;
    private double[] x_ha;
    private double[] y_ha;
    private double[] x_me;
    private double[] y_me;
    private double[] x_si;
    private double[] y_si;
    private double[] dldeg;
    private double[] bdeg;
    private int nrows;

    CoordinateConverter() {
    }

    public void simpleprojection(double[] dArray, double[] dArray2) {
        this.degtorad(dArray, dArray2);
        this.eqtogal();
        this.dldeg = new double[this.nrows];
        this.bdeg = new double[this.nrows];
        int n = 0;
        while (n < this.nrows) {
            this.bdeg[n] = this.brad[n] * 180.0 / this.pi;
            this.dldeg[n] = this.dlrad[n] * 180.0 / this.pi;
            ++n;
        }
        System.out.println("bdeg");
        this.printArray(this.bdeg);
        System.out.println("dldeg");
        this.printArray(this.dldeg);
    }

    public void printArray(double[] dArray) {
        DecimalFormat decimalFormat = new DecimalFormat("0.00");
        int n = 0;
        while (n < dArray.length) {
            System.out.println(decimalFormat.format(dArray[n]));
            ++n;
        }
    }

    public double[] getgallat() {
        return this.bdeg;
    }

    public double[] getgallong() {
        return this.dldeg;
    }

    public void degtorad(double[] dArray, double[] dArray2) {
        this.nrows = dArray.length;
        this.alpha = new double[this.nrows];
        this.delta = new double[this.nrows];
        int n = 0;
        while (n < this.nrows) {
            this.alpha[n] = dArray[n] * this.pi / 180.0;
            this.delta[n] = dArray2[n] * this.pi / 180.0;
            ++n;
        }
    }

    public void eqtogal() {
        this.dlrad = new double[this.nrows];
        this.brad = new double[this.nrows];
        int n = 0;
        while (n < this.nrows) {
            double d = Math.sin(this.delta[n]) * Math.sin(this.delngp);
            double d2 = Math.cos(this.delta[n]) * Math.cos(this.delngp) * Math.sin(this.alpha[n] - this.alfa0b50);
            this.brad[n] = Math.asin(d - d2);
            double d3 = Math.cos(this.delngp) * Math.tan(this.delta[n]) / Math.cos(this.alpha[n] - this.alfa0b50);
            double d4 = Math.tan(this.alpha[n] - this.alfa0b50) * Math.sin(this.delngp);
            this.dlrad[n] = Math.atan(d3 + d4) + this.dl0b50;
            ++n;
        }
    }

    public void projmoll(double[] dArray, double[] dArray2) {
        this.degtorad(dArray, dArray2);
        this.eqtogal();
        this.x_mw = new double[this.nrows];
        this.y_mw = new double[this.nrows];
        int n = 0;
        while (n < this.nrows) {
            double d = this.brad[n];
            double d2 = this.newtonraphson(d);
            this.x_mw[n] = 2.0 * Math.sqrt(2.0) * (this.dlrad[n] - this.dl0b50) * Math.cos(d2) / this.pi;
            this.y_mw[n] = Math.sqrt(2.0) * Math.sin(d2);
            ++n;
        }
    }

    public void aitoff(double[] dArray, double[] dArray2) {
        this.degtorad(dArray, dArray2);
        this.eqtogal();
        this.x_ha = new double[this.nrows];
        this.y_ha = new double[this.nrows];
        int n = 0;
        while (n < this.nrows) {
            double d = Math.sqrt(2.0 / (1.0 + Math.cos(this.brad[n]) * Math.cos(this.dlrad[n] * 0.5)));
            this.x_ha[n] = 2.0 * d * Math.cos(this.brad[n]) * Math.sin(0.5 * this.dlrad[n]);
            this.y_ha[n] = d * Math.sin(this.brad[n]);
            ++n;
        }
    }

    public void merc(double[] dArray, double[] dArray2) {
        this.degtorad(dArray, dArray2);
        this.eqtogal();
        this.x_me = new double[this.nrows];
        this.y_me = new double[this.nrows];
        int n = 0;
        while (n < this.nrows) {
            this.x_me[n] = this.dlrad[n] - this.dl0b50;
            this.y_me[n] = 0.5 * Math.log((1.0 + Math.sin(this.brad[n])) / (1.0 - Math.sin(this.brad[n])));
            ++n;
        }
    }

    public void sinu(double[] dArray, double[] dArray2) {
        this.degtorad(dArray, dArray2);
        this.eqtogal();
        this.x_si = new double[this.nrows];
        this.y_si = new double[this.nrows];
        int n = 0;
        while (n < this.nrows) {
            this.x_si[n] = (this.dlrad[n] - this.dl0b50) * Math.cos(this.brad[n]);
            this.y_si[n] = this.brad[n];
            ++n;
        }
    }

    public double newtonraphson(double d) {
        double d2 = 2.0 * Math.asin(2.0 * d / this.pi);
        double d3 = 0.0;
        int n = 1;
        boolean bl = false;
        while (!bl) {
            double d4;
            bl = true;
            d3 = d2 - this.func(d2, d) / this.grad(d2);
            double d5 = Math.abs(d3 - d2);
            if (!(d5 / (d4 = Math.abs(d3)) > this.tol) || n >= this.itern) continue;
            bl = false;
            d2 = d3;
            ++n;
        }
        return d3;
    }

    public double func(double d, double d2) {
        double d3 = 2.0 * d;
        return d3 + Math.sin(d3) - this.pi * Math.sin(d2);
    }

    public double grad(double d) {
        double d2 = 2.0 * d;
        return 2.0 * (1.0 + Math.cos(d2));
    }

    public double[] getxmw() {
        return this.x_mw;
    }

    public double[] getymw() {
        return this.y_mw;
    }

    public double[] getxha() {
        return this.x_ha;
    }

    public double[] getyha() {
        return this.y_ha;
    }

    public double[] getxme() {
        return this.x_me;
    }

    public double[] getyme() {
        return this.y_me;
    }

    public double[] getxsi() {
        return this.x_si;
    }

    public double[] getysi() {
        return this.y_si;
    }
}

