/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random.engine;

import cern.jet.random.engine.RandomEngine;
import edu.cornell.lassp.houle.RngPack.RandomSeedable;
import java.util.Date;

public class MersenneTwister
extends RandomEngine {
    private int mti;
    private int[] mt = new int[624];
    private static final int N = 624;
    private static final int M = 397;
    private static final int MATRIX_A = -1727483681;
    private static final int UPPER_MASK = Integer.MIN_VALUE;
    private static final int LOWER_MASK = Integer.MAX_VALUE;
    private static final int TEMPERING_MASK_B = -1658038656;
    private static final int TEMPERING_MASK_C = -272236544;
    private static final int mag0 = 0;
    private static final int mag1 = -1727483681;
    public static final int DEFAULT_SEED = 4357;

    public MersenneTwister() {
        this(4357);
    }

    public MersenneTwister(int n) {
        this.setSeed(n);
    }

    public MersenneTwister(Date date) {
        this((int)RandomSeedable.ClockSeed(date));
    }

    public Object clone() {
        MersenneTwister mersenneTwister = (MersenneTwister)super.clone();
        mersenneTwister.mt = (int[])this.mt.clone();
        return mersenneTwister;
    }

    protected void nextBlock() {
        int n;
        int n2 = 0;
        while (n2 < 227) {
            n = this.mt[n2] & Integer.MIN_VALUE | this.mt[n2 + 1] & Integer.MAX_VALUE;
            this.mt[n2] = this.mt[n2 + 397] ^ n >>> 1 ^ ((n & 1) == 0 ? 0 : -1727483681);
            ++n2;
        }
        while (n2 < 623) {
            n = this.mt[n2] & Integer.MIN_VALUE | this.mt[n2 + 1] & Integer.MAX_VALUE;
            this.mt[n2] = this.mt[n2 + -227] ^ n >>> 1 ^ ((n & 1) == 0 ? 0 : -1727483681);
            ++n2;
        }
        n = this.mt[623] & Integer.MIN_VALUE | this.mt[0] & Integer.MAX_VALUE;
        this.mt[623] = this.mt[396] ^ n >>> 1 ^ ((n & 1) == 0 ? 0 : -1727483681);
        this.mti = 0;
    }

    public int nextInt() {
        if (this.mti == 624) {
            this.nextBlock();
        }
        int n = this.mt[this.mti++];
        n ^= n >>> 11;
        n ^= n << 7 & 0x9D2C5680;
        n ^= n << 15 & 0xEFC60000;
        n ^= n >>> 18;
        return n;
    }

    protected void setSeed(int n) {
        int n2 = 0;
        while (n2 < 624) {
            this.mt[n2] = n & 0xFFFF0000;
            n = 69069 * n + 1;
            int n3 = n2++;
            this.mt[n3] = this.mt[n3] | (n & 0xFFFF0000) >>> 16;
            n = 69069 * n + 1;
        }
        this.mti = 624;
    }
}

