/*
 * Decompiled with CFR 0.152.
 */
package cds.xml;

import cds.xml.XMLConsumer;
import java.io.DataInputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;

public class XMLParser {
    private XMLConsumer ac;
    private DataInputStream dis;
    private Stack stack;
    private String name;
    private Hashtable param;
    private char[] ch;
    private int start;
    private int length;
    private int end;
    private byte[] tmp;
    private int offset;
    private int max;
    private String error;
    private int line;
    private boolean beforeXML;
    static final int BUFSIZE = 8192;
    static final int MAXBUF = 100000;
    private boolean formatQuest = false;
    static String[] mKey = new String[]{"&amp;", "&gt;", "&lt;", "&apos;", "&quot;"};
    static String[] mValue = new String[]{"&", ">", "<", "'", "\""};

    public XMLParser(XMLConsumer xMLConsumer) {
        this.ac = xMLConsumer;
        this.stack = new Stack();
        this.param = new Hashtable();
        this.tmp = new byte[8192];
        this.max = 0;
        this.offset = 0;
        this.line = 1;
        this.beforeXML = true;
        this.error = null;
    }

    public static String XMLDecode(String string) {
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = null;
        int n = 0;
        int n2 = 0;
        while (n2 < cArray.length) {
            char c = cArray[n2];
            switch (n) {
                case 0: {
                    if (c == '&') {
                        stringBuffer2 = new StringBuffer();
                        stringBuffer2.append(c);
                        n = 1;
                        break;
                    }
                    stringBuffer.append(c);
                    break;
                }
                case 1: {
                    stringBuffer2.append(c);
                    if (c != ';') break;
                    String string2 = stringBuffer2.toString();
                    int n3 = 0;
                    while (n3 < mKey.length && !string2.equals(mKey[n3])) {
                        ++n3;
                    }
                    if (n3 >= mKey.length) {
                        return null;
                    }
                    stringBuffer.append(mValue[n3]);
                    n = 0;
                    break;
                }
            }
            ++n2;
        }
        if (n == 1) {
            return null;
        }
        return stringBuffer.toString();
    }

    public static String XMLEncode(String string) {
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < cArray.length) {
            int n2 = 0;
            while (n2 < mValue.length && mValue[n2].charAt(0) != cArray[n]) {
                ++n2;
            }
            if (n2 < mValue.length) {
                stringBuffer.append(mKey[n2]);
            } else {
                stringBuffer.append(cArray[n]);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public String getError() {
        return this.error;
    }

    private String getNameParam() {
        while (this.start < this.end && XMLParser.isSpace(this.ch[this.start])) {
            ++this.start;
        }
        int n = this.start;
        while (this.start < this.end && !XMLParser.isSpace(this.ch[this.start]) && this.ch[this.start] != '=') {
            ++this.start;
        }
        return new String(this.ch, n, this.start - n);
    }

    public Stack getStack() {
        return this.stack;
    }

    private String getValueParam() {
        while (this.start < this.end && (XMLParser.isSpace(this.ch[this.start]) || this.ch[this.start] == '=')) {
            ++this.start;
        }
        char c = ' ';
        if (this.start < this.end && (this.ch[this.start] == '\"' || this.ch[this.start] == '\'')) {
            c = this.ch[this.start];
            ++this.start;
        }
        int n = this.start;
        while (this.start < this.end && (c == ' ' && !XMLParser.isSpace(this.ch[this.start]) || c != ' ' && this.ch[this.start] != c)) {
            ++this.start;
        }
        String string = XMLParser.XMLDecode(new String(this.ch, n, this.start - n));
        if (string == null) {
            this.setError("Macro error");
            return null;
        }
        if (c != ' ') {
            ++this.start;
        }
        while (this.start < this.end && XMLParser.isSpace(this.ch[this.start])) {
            ++this.start;
        }
        return string;
    }

    public boolean in(String string) {
        Enumeration enumeration = this.stack.elements();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", /.\t\n\r\f");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            boolean bl = false;
            while (enumeration.hasMoreElements() && !(bl = string2.equals((String)enumeration.nextElement()))) {
            }
            if (bl) continue;
            return false;
        }
        return enumeration.hasMoreElements() ^ true;
    }

    private static final boolean isSpace(char c) {
        return c == ' ' || c == '\t' || c == '\n' || c == '\r';
    }

    public boolean parse(DataInputStream dataInputStream) throws Exception {
        this.formatQuest = false;
        this.dis = dataInputStream;
        boolean bl = this.xmlBeforeTag();
        try {
            if (dataInputStream != null) {
                dataInputStream.close();
            }
        }
        catch (Exception exception) {}
        return bl;
    }

    public boolean parseFormat(DataInputStream dataInputStream) throws Exception {
        this.formatQuest = true;
        this.dis = dataInputStream;
        boolean bl = this.xmlBeforeTag();
        try {
            if (dataInputStream != null) {
                dataInputStream.close();
            }
        }
        catch (Exception exception) {}
        return bl;
    }

    private void setError(String string) {
        this.error = String.valueOf(string) + " (line " + this.line + ")\n";
    }

    private boolean xmlBeforeTag() throws Exception {
        while (true) {
            char c = this.xmlGetString(this.beforeXML ? 5 : 2);
            if (this.length > 0 && (this.length != 1 || this.ch[this.start] != ' ')) {
                this.ac.characters(this.ch, this.start, this.length);
            }
            if (this.beforeXML) {
                this.beforeXML = false;
                continue;
            }
            if (c == '\u0000') {
                return this.error == null;
            }
            if (!this.xmlInTag()) break;
        }
        return false;
    }

    private int xmlGetNameTag() throws Exception {
        int n = 1;
        char c = this.xmlGetString(0);
        if (c == '\u0000') {
            this.setError("stream truncated");
            return -1;
        }
        if (this.length > 0 && this.ch[this.start] == '/') {
            n = 2;
            ++this.start;
            --this.length;
        } else if (this.length > 1 && this.ch[this.start + this.length - 1] == '/') {
            n = 3;
            --this.length;
        }
        if (n == 1 && c != '>') {
            n = 0;
        }
        this.name = new String(this.ch, this.start, this.length);
        return n;
    }

    private int xmlGetParamTag(int n) throws Exception {
        int n2 = 0;
        char c = this.xmlGetString(n == -1 ? 4 : 1);
        if (this.length > 0 && this.ch[this.start + this.length - 1] == '/') {
            n2 = 3;
            --this.length;
        }
        if (c != '>') {
            this.setError("No end tag");
            return -1;
        }
        if (n == 1) {
            this.param.clear();
            this.end = this.start + this.length;
            while (this.start < this.end) {
                String string = this.getNameParam();
                String string2 = this.getValueParam();
                if (string2 == null) {
                    return -1;
                }
                this.param.put(string, string2);
            }
        }
        return n2;
    }

    private char xmlGetString(int n) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        int n3 = -1;
        int n4 = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        boolean bl10 = false;
        boolean bl11 = false;
        boolean bl12 = false;
        boolean bl13 = false;
        boolean bl14 = false;
        boolean bl15 = false;
        while (bl3 && (n4 = this.xmlGetc()) != 0) {
            bl = XMLParser.isSpace((char)n4);
            switch (n) {
                case 0: {
                    bl3 = !bl && n4 != 62;
                    break;
                }
                case 1: {
                    bl3 = n4 != 62;
                    break;
                }
                case 2: {
                    bl3 = n4 != 60;
                    break;
                }
                case 3: {
                    bl3 = (bl8 && n4 == 62) ^ true;
                    bl10 = n4 == 93;
                    bl8 = bl9 && bl10;
                    bl9 = bl10;
                    if (n2 < 100000 || !bl4) break;
                    this.ch = stringBuffer.toString().toCharArray();
                    this.ac.characters(this.ch, 0, this.ch.length);
                    stringBuffer = new StringBuffer();
                    n2 = 0;
                    n3 = 0;
                    break;
                }
                case 4: {
                    bl3 = (bl5 && n4 == 62) ^ true;
                    bl7 = n4 == 45;
                    bl5 = bl6 && bl7;
                    bl6 = bl7;
                    break;
                }
                case 5: {
                    bl3 = (bl11 && n4 == 62) ^ true;
                    bl11 = bl12 && (n4 == 108 || n4 == 76) || bl11;
                    bl12 = bl13 && (n4 == 109 || n4 == 77);
                    bl13 = bl14 && (n4 == 120 || n4 == 88);
                    bl14 = bl15 && n4 == 63;
                    boolean bl16 = bl15 = n4 == 60;
                    if (!bl15) break;
                    n3 = n2;
                    break;
                }
            }
            if (n == 3 || n == 5 || (!bl || bl && !bl2) && n < 3) {
                if (n != 3 && n != 5 && bl) {
                    n4 = 32;
                }
                stringBuffer.append((char)n4);
                ++n2;
            }
            bl2 = bl;
            boolean bl17 = bl4 = n4 == 10;
        }
        if (n != 4) {
            this.ch = stringBuffer.toString().toCharArray();
        }
        this.start = 0;
        int n5 = n == 3 ? this.ch.length - 3 : (this.length = n == 5 && bl11 && n3 >= 0 ? n3 : this.ch.length - 1);
        if (this.length < 0) {
            this.length = 0;
        }
        return (char)n4;
    }

    private char xmlGetc() {
        char c;
        if (this.offset >= this.max) {
            try {
                this.max = this.dis.read(this.tmp);
                if (this.max == -1) {
                    return '\u0000';
                }
            }
            catch (Exception exception) {
                this.setError("Stream error: " + exception);
                return '\u0000';
            }
            this.offset = 0;
        }
        if ((c = (char)this.tmp[this.offset++]) == '\n') {
            ++this.line;
        }
        return c;
    }

    private boolean xmlInTag() throws Exception {
        int n = this.xmlGetNameTag();
        if (n < 0) {
            return false;
        }
        if (this.length >= 7 && new String(this.ch, this.start, 8).equals("![CDATA[")) {
            char c = this.xmlGetString(3);
            if (this.length > 0) {
                this.ac.characters(this.ch, this.start, this.length);
            }
            return c != '\u0000';
        }
        char c = this.ch[this.start];
        if (this.length >= 3 && c == '!' && this.ch[this.start + 1] == '-' && this.ch[this.start + 2] == '-') {
            return this.xmlGetParamTag(-1) >= 0;
        }
        if (c == '?' || c == '!') {
            return this.xmlGetParamTag(0) >= 0;
        }
        if (n == 0) {
            n = this.xmlGetParamTag(1);
        } else if (n == 1) {
            this.param.clear();
        }
        if (n < 0) {
            return false;
        }
        if (n == 3) {
            this.stack.push(this.name);
            this.ac.startElement(this.name, this.param);
            this.stack.pop();
            this.ac.endElement(this.name);
            return true;
        }
        if (n == 2) {
            if (this.stack.empty()) {
                this.setError("Unexpected end tag (</" + this.name + ">)");
                return false;
            }
            String string = (String)this.stack.pop();
            if (!string.equals(this.name)) {
                this.setError("Tags unbalanced (<" + string + ">...</" + this.name + ">)");
                return false;
            }
            this.ac.endElement(this.name);
            return true;
        }
        this.stack.push(this.name);
        this.ac.startElement(this.name, this.param);
        return !this.formatQuest || this.name.compareTo("VOTABLE") != 0 && this.name.compareTo("ASTRO") != 0;
    }
}

