/*
 * Decompiled with CFR 0.152.
 */
package cds.vizier;

import cds.aladin.Glu;
import cds.tools.CDSConstants;
import cds.tools.CDSMethods;
import cds.xml.XMLConsumer;
import cds.xml.XMLParser;
import java.awt.List;
import java.io.DataInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class VizieRQuery
implements XMLConsumer,
CDSConstants {
    static final int KEYWORDS = 0;
    static final int SURVEYS = 1;
    static final int ARCHIVES = 2;
    static final int CATALOGS = 3;
    static final int TD = 4;
    static final int SURVEYMAXCOL = 3;
    static final int ARCHIVEMAXCOL = 3;
    private int section;
    private String currentCat = null;
    private String currentWaveLength = null;
    private String currentDensity = null;
    private String metaError;
    private Vector vKey;
    private boolean inCSV;
    private boolean inTD;
    private boolean inDesc;
    private String headlines;
    private String recsep;
    private String colsep;
    private int column = 0;
    private Vector vSurveys = new Vector(30);
    private StringBuffer currentSurvey = new StringBuffer();
    private Vector vArchives = new Vector(30);
    private StringBuffer currentArchive = new StringBuffer();
    private Hashtable hKey = new Hashtable();
    private Vector nameKey = new Vector();
    private DataInputStream vizierStream = null;
    private int currentFormat = 0;
    private List resultat = null;
    protected Glu glu = null;

    protected void addItem(String string) {
        if (this.resultat != null) {
            this.resultat.addItem(string);
        }
    }

    protected boolean callVizieR(String string, int n, List list) {
        if (string == null) {
            System.out.println("param null");
        }
        if (list == null) {
            System.out.println("resultat null");
        }
        boolean bl = this.catalogsDataQuery(string, n, list);
        if (n == 1) {
            return bl && list != null && list.countItems() > 0;
        }
        return bl;
    }

    public boolean catalogsDataQuery(String string, int n, List list) {
        XMLParser xMLParser = new XMLParser(this);
        this.metaError = null;
        this.section = 3;
        this.inDesc = false;
        this.currentCat = null;
        this.currentWaveLength = null;
        this.currentDensity = null;
        this.resultat = list;
        URL uRL = null;
        try {
            uRL = this.glu != null ? this.glu.getURL("VizieR.MetaCat", string, true) : new URL("http://vizier.u-strasbg.fr/cgi-bin/votable?-meta&" + string);
            if (n == 1) {
                this.resultat.removeAll();
                DataInputStream dataInputStream = new DataInputStream(uRL.openStream());
                boolean bl = xMLParser.parse(dataInputStream);
                return bl;
            }
            this.vizierStream = new DataInputStream(uRL.openStream());
            return this.vizierStream != null;
        }
        catch (Exception exception) {
            this.metaError = String.valueOf(String.valueOf(exception));
            System.err.println("catalogsData : " + exception);
            return false;
        }
    }

    public void characters(char[] cArray, int n, int n2) {
        char c = '\n';
        char c2 = '\t';
        int n3 = n;
        int n4 = n + n2;
        int n5 = 0;
        String string = new String();
        if (this.section == 3) {
            if (this.inDesc) {
                int n6;
                int n7 = 0;
                if (this.currentCat != null) {
                    n7 = this.currentCat.length();
                    string = String.valueOf(string) + this.currentCat;
                    n6 = n7;
                    while (n6 < 20) {
                        string = String.valueOf(string) + " ";
                        ++n6;
                    }
                }
                if (this.currentWaveLength != null) {
                    n7 = this.currentWaveLength.length();
                    string = n7 > 5 ? String.valueOf(string) + this.currentWaveLength.substring(0, 5) : String.valueOf(string) + this.currentWaveLength;
                    n6 = n7;
                    while (n6 < 5) {
                        string = String.valueOf(string) + " ";
                        ++n6;
                    }
                    this.currentWaveLength = null;
                } else {
                    string = String.valueOf(string) + "     ";
                }
                if (this.currentDensity != null) {
                    n7 = this.currentDensity.length();
                    n6 = 3;
                    while (n6 >= n7) {
                        this.currentDensity = " " + this.currentDensity;
                        --n6;
                    }
                    string = String.valueOf(string) + this.currentDensity;
                    this.currentDensity = null;
                } else {
                    string = String.valueOf(string) + "   ";
                }
                if (this.currentCat != null) {
                    this.addItem(String.valueOf(string) + " " + new String(cArray, n, n2));
                    this.inDesc = false;
                }
            }
            return;
        }
        if (this.inCSV) {
            StringBuffer stringBuffer;
            if (this.recsep != null) {
                c = this.recsep.charAt(0);
            }
            if (this.colsep != null) {
                c2 = this.colsep.charAt(0);
            }
            int n8 = this.headlines == null ? 0 : Integer.parseInt(this.headlines);
            n5 = 0;
            n5 = 0;
            while (n3 < n4 && n5 < n8) {
                stringBuffer = new StringBuffer();
                n3 = this.getRec(stringBuffer, cArray, n3, n4, c, c2);
                ++n3;
                ++n5;
            }
            while (n3 < n4) {
                stringBuffer = new StringBuffer();
                n3 = this.getRec(stringBuffer, cArray, n3, n4, c, c2);
                switch (this.section) {
                    case 1: {
                        this.vSurveys.addElement(stringBuffer.toString());
                        break;
                    }
                    case 2: {
                        this.vArchives.addElement(stringBuffer.toString());
                        break;
                    }
                }
                ++n3;
            }
            return;
        }
        if (this.inTD) {
            String string2 = new String(cArray, n, n2);
            switch (this.section) {
                case 1: {
                    if (this.column < 3) {
                        if (this.column != 1) {
                            this.currentSurvey.append(" - ");
                        }
                        this.currentSurvey.append(string2);
                    } else {
                        this.currentSurvey.append(" - ");
                        this.currentSurvey.append(string2);
                        this.currentSurvey.append("Krow");
                        this.vSurveys.addElement(this.currentSurvey.toString());
                    }
                    this.inTD = false;
                    break;
                }
                case 2: {
                    if (this.column < 3) {
                        if (this.column != 1) {
                            this.currentArchive.append(" - ");
                        }
                        this.currentArchive.append(string2);
                    } else {
                        this.currentArchive.append(" - ");
                        this.currentArchive.append(string2);
                        this.currentArchive.append("Krow");
                        this.vArchives.addElement(this.currentArchive.toString());
                    }
                    this.inTD = false;
                    break;
                }
            }
            return;
        }
    }

    public void endElement(String string) {
        if (this.vKey != null && string.equals("FIELD")) {
            this.vKey = null;
        } else if (string.equals("CSV")) {
            this.inCSV = false;
        }
    }

    private int getField(StringBuffer stringBuffer, char[] cArray, int n, int n2, char c, char c2) {
        int n3 = n;
        while (n < n2 && cArray[n] != c2 && cArray[n] != c) {
            ++n;
        }
        String string = new String(cArray, n3, n - n3).trim();
        if (string.length() != 0) {
            if (stringBuffer.length() != 0) {
                stringBuffer.append(" - ");
            }
            stringBuffer.append(string);
        }
        return cArray[n] == c2 ? n + 1 : n;
    }

    public String getMetaError() {
        return this.metaError;
    }

    public Vector getNameKey() {
        return this.nameKey;
    }

    private int getRec(StringBuffer stringBuffer, char[] cArray, int n, int n2, char c, char c2) {
        while (n < n2 && cArray[n] != c) {
            n = this.getField(stringBuffer, cArray, n, n2, c, c2);
        }
        stringBuffer.append("Krow");
        return n;
    }

    public DataInputStream getResultStream() {
        return this.vizierStream;
    }

    public Hashtable gethKey() {
        return this.hKey;
    }

    public Vector getvArchives() {
        return this.vArchives;
    }

    public Vector getvSurveys() {
        return this.vSurveys;
    }

    public boolean metaDataQuery() {
        XMLParser xMLParser = new XMLParser(this);
        this.metaError = null;
        this.section = -1;
        this.vSurveys = new Vector(30);
        this.vArchives = new Vector(30);
        this.hKey = new Hashtable();
        this.nameKey = new Vector();
        this.vKey = null;
        this.inCSV = false;
        URL uRL = null;
        try {
            uRL = this.glu != null ? this.glu.getURL("VizieR.Meta", "", false, false) : new URL("http://vizier.u-strasbg.fr/cgi-bin/votable?-meta.aladin=all");
            InputStream inputStream = uRL.openStream();
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            boolean bl = xMLParser.parse(dataInputStream);
            return bl && this.metaError == null;
        }
        catch (Exception exception) {
            this.metaError = String.valueOf(String.valueOf(exception));
            System.err.println("metaDataQuery : " + exception);
            exception.printStackTrace();
            return false;
        }
    }

    public void query() {
    }

    public void setGLU(Glu glu) {
        this.glu = glu;
    }

    public void startElement(String string, Hashtable hashtable) {
        if (string.equals("VOTABLE")) {
            this.currentFormat = 1;
        }
        if (string.equals("ASTRO")) {
            this.currentFormat = 0;
        }
        if (this.section == 3) {
            if (string.equals("DESCRIPTION")) {
                this.inDesc = true;
            } else if (string.equals("RESOURCE")) {
                if (this.currentFormat == 1) {
                    this.currentCat = (String)hashtable.get("name");
                } else if (this.currentFormat == 0) {
                    this.currentCat = (String)hashtable.get("ID");
                }
            } else if (string.equals("INFO")) {
                String string2 = (String)hashtable.get("name");
                if (string2.equals("-kw.Wavelength")) {
                    this.currentWaveLength = (String)hashtable.get("value");
                }
                if (string2.equals("-density")) {
                    this.currentDensity = (String)hashtable.get("value");
                }
            }
            return;
        }
        if (string.equals("RESOURCE")) {
            String string3 = (String)hashtable.get("ID");
            if (string3.equals("VizieR")) {
                this.section = 0;
            }
        } else if (string.equals("TABLE")) {
            String string4 = (String)hashtable.get("ID");
            if (string4.equals("AladinSurveys")) {
                this.section = 1;
            } else if (string4.equals("AladinArchives")) {
                this.section = 2;
            }
        } else if (this.section == 0 && string.equals("PARAM") && this.currentFormat == 1) {
            String string5 = (String)hashtable.get("name");
            if (string5.startsWith("-kw.")) {
                this.vKey = new Vector(30);
                this.nameKey.addElement(string5);
                this.hKey.put(string5, this.vKey);
            }
        } else if (this.section == 0 && string.equals("FIELD") && this.currentFormat == 0) {
            String string6 = (String)hashtable.get("name");
            if (string6.startsWith("-kw.")) {
                this.vKey = new Vector(30);
                this.nameKey.addElement(string6);
                this.hKey.put(string6, this.vKey);
            }
        } else if (this.vKey != null && string.equals("OPTION")) {
            String string7 = (String)hashtable.get("value");
            if (string7 != null) {
                this.vKey.addElement(string7);
            }
        } else if ((this.section == 1 || this.section == 2) && string.equals("CSV")) {
            this.inCSV = true;
            this.headlines = (String)hashtable.get("headlines");
            this.recsep = (String)hashtable.get("recsep");
            this.colsep = (String)hashtable.get("colsep");
        } else if ((this.section == 1 || this.section == 2) && string.equals("TD")) {
            this.inTD = true;
            ++this.column;
        } else if (string.equals("TR")) {
            this.currentSurvey = new StringBuffer();
            this.currentArchive = new StringBuffer();
            this.column = 0;
        }
    }

    public boolean submit(String string, String string2, String string3, String string4, String string5, int n, List list) {
        return this.submit(string, string2, string3, null, string4, string5, n, list);
    }

    public boolean submit(String string, String string2, String string3, String string4, String string5, String string6, int n, List list) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string == null) {
            stringBuffer.append("-pos");
        } else {
            CDSMethods.append(stringBuffer, "-c", string);
            if (string2 != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
                CDSMethods.append(stringBuffer, "-c.r", stringTokenizer.nextToken());
                if (stringTokenizer.hasMoreTokens()) {
                    String string7 = stringTokenizer.nextToken();
                    if (string7.compareTo("deg") == 0 || string7.compareTo("degree") == 0) {
                        CDSMethods.append(stringBuffer, "-c.u", "degree");
                    } else {
                        CDSMethods.append(stringBuffer, "-c.u", string7);
                    }
                } else {
                    CDSMethods.append(stringBuffer, "-c.u", "arcmin");
                }
            }
        }
        if (string4 != null && string4.compareTo("") != 0) {
            CDSMethods.append(stringBuffer, "-c.eq", string4);
        }
        if (string5 != null && string5.compareTo("") != 0) {
            CDSMethods.append(stringBuffer, "-words", string5);
        }
        if (string6 != null) {
            stringBuffer.append(String.valueOf('&') + string6);
        }
        return this.callVizieR(stringBuffer.toString(), n, list);
    }
}

