/*
 * Decompiled with CFR 0.152.
 */
package cds.vizier;

import java.awt.Button;
import java.awt.Event;
import java.awt.Font;
import java.awt.List;
import java.awt.TextField;
import java.awt.Toolkit;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public final class VizieRList
extends List {
    protected TextField catalog;
    protected Button getReadMe;
    protected int hCaracterCount = 0;
    static final boolean LSCREEN = Toolkit.getDefaultToolkit().getScreenSize().width > 1000;
    protected static final int SIZE = LSCREEN ? 12 : 10;
    protected static Font COURIER = new Font("Monospaced", 0, SIZE);

    public VizieRList(TextField textField, Button button, Vector vector) {
        this(textField, button, vector, 20);
    }

    public VizieRList(TextField textField, Button button, Vector vector, int n) {
        super(n, true);
        this.catalog = textField;
        this.getReadMe = button;
        this.setFont(COURIER);
        this.preSelection(vector);
    }

    public VizieRList(Vector vector) {
        this(null, null, vector, 20);
    }

    public TextField getCatalogField() {
        return this.catalog;
    }

    public TextField getCatalogTextField() {
        return this.catalog;
    }

    public int getHCaracterCount() {
        return this.hCaracterCount;
    }

    public Button getReadMeButton() {
        return this.getReadMe;
    }

    public boolean handleEvent(Event event) {
        Object object;
        Object object2;
        Object object3 = "";
        String[] stringArray = this.getSelectedItems();
        int n = 0;
        while (n < stringArray.length) {
            object2 = new StringTokenizer(stringArray[n], " :");
            object = ((StringTokenizer)object2).nextToken();
            object3 = !((String)object3).equals("") ? String.valueOf(object3) + "," + (String)object : object;
            ++n;
        }
        if (this.catalog != null) {
            this.catalog.setText((String)object3);
        }
        if (this.getReadMe != null) {
            this.getReadMe.enable(n == 1);
            object2 = this.getSelectedItem();
            if (object2 != null) {
                object = new StringTokenizer((String)object2, " :");
                String string = ((StringTokenizer)object).nextToken();
            }
        }
        return super.handleEvent(event);
    }

    public void preSelection(Vector vector) {
        this.hCaracterCount = 0;
        if (this.countItems() > 0) {
            this.clear();
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.addItem(string);
            int n = string.length();
            if (this.hCaracterCount >= n) continue;
            this.hCaracterCount = n;
        }
    }

    public void resetList() {
        int n = 0;
        while (n < this.countItems()) {
            if (this.isSelected(n)) {
                this.deselect(n);
            }
            ++n;
        }
        this.makeVisible(0);
    }

    public void setCatalogTextField(TextField textField) {
        this.catalog = textField;
    }

    public void setReadMeButton(Button button) {
        this.getReadMe = button;
    }
}

