/*
 * Decompiled with CFR 0.152.
 */
package cds.tools.parser;

import cds.astro.Unit;
import cds.tools.parser.Abs;
import cds.tools.parser.BasicOperator;
import cds.tools.parser.Cos;
import cds.tools.parser.Deg2Rad;
import cds.tools.parser.Function;
import cds.tools.parser.Ln;
import cds.tools.parser.Log;
import cds.tools.parser.Node;
import cds.tools.parser.ParserException;
import cds.tools.parser.Rad2Deg;
import cds.tools.parser.Sin;
import cds.tools.parser.Tan;
import cds.tools.parser.Variable;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.text.ParseException;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;

public class Parser {
    private Hashtable vars = new Hashtable(5);
    private Hashtable functions = new Hashtable(5);
    private int state = 0;
    private static final int ADD = 43;
    private static final int SUBTRACT = 45;
    private static final int DIVIDE = 47;
    private static final int MULTIPLY = 42;
    private static final int POWER = 94;
    private static final int GRP = 40;
    private static final int ENDGRP = 41;
    private static final int UNDERSCORE = 95;
    private static final int OPSQBR = 91;
    private static final int CLSQBR = 93;
    private static final BasicOperator OP_ADD = new BasicOperator(Parser.precedence(43), 43);
    private static final BasicOperator OP_MUL = new BasicOperator(Parser.precedence(42), 42);
    private static final BasicOperator OP_DIV = new BasicOperator(Parser.precedence(47), 47);
    private static final BasicOperator OP_SUB = new BasicOperator(Parser.precedence(45), 45);
    private static final BasicOperator OP_GRP = new BasicOperator(0, 40);
    private static final BasicOperator OP_ENDGRP = new BasicOperator(0, 41);
    private static final BasicOperator OP_POW = new BasicOperator(Parser.precedence(94), 94);
    private Node root = null;
    private String str;

    public Parser() {
        this.initFunc();
        this.str = "0";
    }

    public Parser(String string) {
        this.initFunc();
        this.str = !string.equals("") ? new String(string) : "0";
    }

    public void addFunc(Function function) {
        this.functions.put(function.keyword(), function);
    }

    public void addVar(String string) {
        this.vars.put(string, new Variable());
    }

    public double eval() {
        return this.eval(this.root);
    }

    private double eval(Node node) {
        double d = 0.0;
        if (node == null) {
            throw new ParserException("methode eval : noeud null !!!");
        }
        switch (node.type) {
            case 0: {
                d = this.evalOp(node);
                break;
            }
            case 1: {
                d = node.value;
                break;
            }
            case 2: {
                d = this.evalVar(node);
                break;
            }
            case 3: {
                d = this.evalFunc(node);
                break;
            }
            default: {
                throw new ParserException("methode eval : Ce noeud est de type inconnu !!!");
            }
        }
        return d;
    }

    private double evalFunc(Node node) {
        Function function = (Function)this.functions.get(node.svalue);
        if (function == null) {
            throw new ParserException("method evalFunc : la fonction " + node.svalue + " est inconnue !!!");
        }
        return function.eval(this.eval(node.left));
    }

    private Unit evalFuncUnit(Node node) throws ParseException {
        Function function = (Function)this.functions.get(node.svalue);
        if (function == null) {
            throw new ParserException("method evalFunc : la fonction " + node.svalue + " est inconnue !!!");
        }
        return function.evalUnit(this.evalUnit(node.left));
    }

    private double evalOp(Node node) {
        double d = 0.0;
        switch (node.op) {
            case 43: {
                if (node.left != null) {
                    d = this.eval(node.left);
                }
                d += this.eval(node.right);
                break;
            }
            case 45: {
                if (node.right != null) {
                    d = this.eval(node.right);
                }
                d = this.eval(node.left) - d;
                break;
            }
            case 47: {
                d = this.eval(node.left);
                d /= this.eval(node.right);
                break;
            }
            case 42: {
                d = this.eval(node.left);
                d *= this.eval(node.right);
                break;
            }
            case 94: {
                d = Math.pow(this.eval(node.left), this.eval(node.right));
                break;
            }
            default: {
                throw new ParserException("methode evalOp : Operateur inconnu !!!");
            }
        }
        return d;
    }

    private Unit evalOpUnit(Node node) throws ParseException {
        Unit unit = null;
        switch (node.op) {
            case 43: {
                if (node.left != null) {
                    unit = new Unit(this.evalUnit(node.left));
                }
                unit.plus(this.evalUnit(node.right));
                break;
            }
            case 45: {
                if (node.right != null) {
                    unit = new Unit(this.evalUnit(node.right));
                }
                Unit unit2 = this.evalUnit(node.left);
                unit2.minus(unit);
                unit = unit2;
                break;
            }
            case 47: {
                unit = new Unit(this.evalUnit(node.left));
                unit.div(this.evalUnit(node.right));
                break;
            }
            case 42: {
                unit = new Unit(this.evalUnit(node.left));
                unit.mult(this.evalUnit(node.right));
                break;
            }
            case 94: {
                if (node.right.type == 1) {
                    unit = new Unit("(" + this.evalUnit((Node)node.left).symbol + ")" + this.eval(node.right));
                    unit.setValue(Math.pow(this.eval(node.left), this.eval(node.right)));
                    break;
                }
                if (node.left.type == 1) {
                    unit = new Unit(this.evalUnit(node.left));
                    break;
                }
                unit = new Unit(this.evalUnit(node.left));
                break;
            }
            default: {
                throw new ParserException("methode evalOp : Operateur inconnu !!!");
            }
        }
        return unit;
    }

    public Unit evalUnit() throws ParseException {
        return this.evalUnit(this.root);
    }

    private Unit evalUnit(Node node) throws ParseException {
        Unit unit = null;
        if (node == null) {
            throw new ParserException("methode eval : noeud null !!!");
        }
        switch (node.type) {
            case 0: {
                unit = this.evalOpUnit(node);
                break;
            }
            case 1: {
                try {
                    unit = new Unit(new Double(node.value).toString());
                    break;
                }
                catch (ParseException parseException) {
                    System.out.println("Error for a VALUE node");
                    throw parseException;
                }
            }
            case 2: {
                unit = this.evalVarUnit(node);
                break;
            }
            case 3: {
                unit = this.evalFuncUnit(node);
                break;
            }
            default: {
                throw new ParserException("methode eval : Ce noeud est de type inconnu !!!");
            }
        }
        return unit;
    }

    private double evalVar(Node node) {
        Variable variable = (Variable)this.vars.get(node.svalue);
        if (variable == null) {
            throw new ParserException("methode evalVar : la variable " + node.svalue + " est inconnue !!!");
        }
        return variable.getValue();
    }

    private Unit evalVarUnit(Node node) throws ParseException {
        Variable variable = (Variable)this.vars.get(node.svalue);
        if (variable == null) {
            throw new ParserException("methode evalVar : la variable " + node.svalue + " est inconnue !!!");
        }
        Unit unit = new Unit(variable.getUnit());
        return unit;
    }

    private static BasicOperator getOp(int n) {
        switch (n) {
            case 43: {
                return OP_ADD;
            }
            case 45: {
                return OP_SUB;
            }
            case 42: {
                return OP_MUL;
            }
            case 47: {
                return OP_DIV;
            }
            case 94: {
                return OP_POW;
            }
            case 40: {
                return OP_GRP;
            }
            case 41: {
                return OP_ENDGRP;
            }
        }
        return null;
    }

    public double getVar(String string) {
        Variable variable = (Variable)this.vars.get(string);
        if (variable == null) {
            throw new ParserException("methode getVar : La variable " + string + " est inconnue!!!");
        }
        return variable.getValue();
    }

    public Enumeration getVariables() {
        return this.vars.keys();
    }

    private void initFunc() {
        this.addFunc(new Sin());
        this.addFunc(new Cos());
        this.addFunc(new Tan());
        this.addFunc(new Log());
        this.addFunc(new Ln());
        this.addFunc(new Abs());
        this.addFunc(new Deg2Rad());
        this.addFunc(new Rad2Deg());
    }

    public boolean isConstant() {
        return this.getVariables().hasMoreElements() ^ true;
    }

    public void parseString() {
        Stack stack = new Stack();
        Stack stack2 = new Stack();
        StringReader stringReader = new StringReader(this.str);
        StreamTokenizer streamTokenizer = new StreamTokenizer(stringReader);
        streamTokenizer.parseNumbers();
        streamTokenizer.lowerCaseMode(false);
        streamTokenizer.ordinaryChar(43);
        streamTokenizer.ordinaryChar(45);
        streamTokenizer.ordinaryChar(42);
        streamTokenizer.ordinaryChar(47);
        streamTokenizer.ordinaryChar(94);
        streamTokenizer.wordChars(95, 95);
        streamTokenizer.wordChars(91, 93);
        streamTokenizer.wordChars(123, 123);
        streamTokenizer.wordChars(125, 125);
        streamTokenizer.wordChars(64, 64);
        streamTokenizer.wordChars(33, 33);
        streamTokenizer.wordChars(126, 126);
        streamTokenizer.wordChars(38, 38);
        try {
            int n;
            this.state = 0;
            while ((n = streamTokenizer.nextToken()) != -1) {
                switch (this.state) {
                    case 0: {
                        this.parserState0(streamTokenizer, stack, stack2);
                        break;
                    }
                    case 1: {
                        this.parserState1(streamTokenizer, stack, stack2);
                        break;
                    }
                    case 2: {
                        this.parserState2(streamTokenizer, stack, stack2);
                        break;
                    }
                }
            }
            this.parserState2(streamTokenizer, stack, stack2);
            this.root = (Node)stack.elementAt(0);
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
        catch (EmptyStackException emptyStackException) {
            throw new ParserException();
        }
    }

    public void parseString(String string) {
        this.str = string;
        this.parseString();
    }

    private void parserState0(StreamTokenizer streamTokenizer, Stack stack, Stack stack2) throws IOException {
        switch (streamTokenizer.ttype) {
            case -3: {
                Variable variable = (Variable)this.vars.get(streamTokenizer.sval);
                if (variable != null) {
                    Node node = new Node();
                    node.type = 2;
                    node.svalue = streamTokenizer.sval;
                    stack.push(node);
                    this.state = 2;
                    break;
                }
                Function function = (Function)this.functions.get(streamTokenizer.sval);
                if (function != null) {
                    stack2.push(function);
                    this.state = 0;
                    break;
                }
                throw new ParserException("Le mot " + streamTokenizer.sval + " est inconnu !");
            }
            case -2: {
                Node node = new Node();
                node.type = 1;
                node.value = streamTokenizer.nval;
                stack.push(node);
                this.state = 2;
                break;
            }
            case 43: {
                stack2.push(Parser.getOp(43));
                Node node = new Node();
                node.type = 1;
                node.value = 0.0;
                stack.push(node);
                this.state = 1;
                break;
            }
            case 45: {
                stack2.push(Parser.getOp(45));
                Node node = new Node();
                node.type = 1;
                node.value = 0.0;
                stack.push(node);
                this.state = 1;
                break;
            }
            case 40: {
                stack2.push(Parser.getOp(40));
                this.state = 0;
                break;
            }
            default: {
                throw new ParserException("Le parsing a echoue !!");
            }
        }
    }

    private void parserState1(StreamTokenizer streamTokenizer, Stack stack, Stack stack2) throws IOException {
        switch (streamTokenizer.ttype) {
            case -3: {
                Variable variable = (Variable)this.vars.get(streamTokenizer.sval);
                if (variable != null) {
                    Node node = new Node();
                    node.type = 2;
                    node.svalue = streamTokenizer.sval;
                    stack.push(node);
                    this.state = 2;
                    break;
                }
                Function function = (Function)this.functions.get(streamTokenizer.sval);
                if (function != null) {
                    stack2.push(function);
                    this.state = 0;
                    break;
                }
                throw new ParserException("Le mot " + streamTokenizer.sval + " est inconnu !");
            }
            case -2: {
                Node node = new Node();
                node.type = 1;
                node.value = streamTokenizer.nval;
                stack.push(node);
                this.state = 2;
                break;
            }
            case 40: {
                stack2.push(Parser.getOp(40));
                this.state = 0;
                break;
            }
            default: {
                throw new ParserException("Le parsing a echoue !!");
            }
        }
    }

    /*
     * Exception decompiling
     */
    private void parserState2(StreamTokenizer var1_1, Stack var2_2, Stack var3_3) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[DOLOOP]], but top level block is 3[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static int precedence(int n) {
        switch (n) {
            case 43: {
                return 1;
            }
            case 45: {
                return 2;
            }
            case 42: {
                return 3;
            }
            case 47: {
                return 3;
            }
            case 94: {
                return 5;
            }
        }
        return -1;
    }

    public void setVar(String string, double d) {
        Variable variable = (Variable)this.vars.get(string);
        if (variable == null) {
            throw new ParserException("method setVar : Unknown variable " + string + " !!!");
        }
        variable.setValue(d);
    }

    public boolean setVarUnit(String string, String string2) {
        Variable variable = (Variable)this.vars.get(string);
        if (variable == null) {
            throw new ParserException("method setVar : Unknown variable " + string + " !!!");
        }
        try {
            Unit unit = new Unit(string2);
            unit.setValue(variable.getValue());
            variable.setUnit(unit);
        }
        catch (ParseException parseException) {
            return false;
        }
        return true;
    }
}

