/*
 * Decompiled with CFR 0.152.
 */
package cds.image;

import java.awt.Image;
import java.awt.image.PixelGrabber;
import java.io.DataOutputStream;
import java.io.FileOutputStream;

public final class BMPWriter {
    public static void write(Image image, String string) throws Exception {
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        int[] nArray = new int[n2 * n];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n, n2, nArray, 0, n);
        pixelGrabber.grabPixels();
        BMPWriter.write24BitBMP(nArray, n, n2, string);
    }

    public static void write24BitBMP(int[] nArray, int n, int n2, String string) throws Exception {
        int n3 = (4 - n * 3 % 4) % 4;
        int n4 = (n * 3 + n3) * n2;
        byte[] byArray = new byte[n4];
        int n5 = 0;
        int n6 = 0;
        while (n6 < n2) {
            int n7;
            int n8 = 0;
            while (n8 < n) {
                n7 = nArray[(n2 - 1 - n6) * n + n8];
                byArray[n5++] = (byte)(n7 & 0xFF);
                byArray[n5++] = (byte)(n7 >> 8 & 0xFF);
                byArray[n5++] = (byte)(n7 >> 16 & 0xFF);
                ++n8;
            }
            n7 = 0;
            while (n7 < n3) {
                byArray[n5++] = 0;
                ++n7;
            }
            ++n6;
        }
        BMPWriter.writeBMPFile(string, n4, n, n2, 24, byArray);
    }

    protected static void writeBMPFile(String string, int n, int n2, int n3, int n4, byte[] byArray) throws Exception {
        DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(string));
        BMPWriter.writeShort(dataOutputStream, 19778);
        BMPWriter.writeInt(dataOutputStream, n + 54);
        BMPWriter.writeShort(dataOutputStream, 0);
        BMPWriter.writeShort(dataOutputStream, 0);
        BMPWriter.writeInt(dataOutputStream, 54);
        BMPWriter.writeInt(dataOutputStream, 40);
        BMPWriter.writeInt(dataOutputStream, n2);
        BMPWriter.writeInt(dataOutputStream, n3);
        BMPWriter.writeShort(dataOutputStream, 1);
        BMPWriter.writeShort(dataOutputStream, n4);
        BMPWriter.writeInt(dataOutputStream, 0);
        BMPWriter.writeInt(dataOutputStream, n);
        BMPWriter.writeInt(dataOutputStream, 2835);
        BMPWriter.writeInt(dataOutputStream, 2835);
        BMPWriter.writeInt(dataOutputStream, 0);
        BMPWriter.writeInt(dataOutputStream, 0);
        dataOutputStream.write(byArray, 0, n);
        dataOutputStream.close();
    }

    private static void writeInt(DataOutputStream dataOutputStream, int n) throws Exception {
        dataOutputStream.writeByte(n & 0xFF);
        dataOutputStream.writeByte(n >> 8 & 0xFF);
        dataOutputStream.writeByte(n >> 16 & 0xFF);
        dataOutputStream.writeByte(n >> 24 & 0xFF);
    }

    private static void writeShort(DataOutputStream dataOutputStream, int n) throws Exception {
        dataOutputStream.writeByte(n & 0xFF);
        dataOutputStream.writeByte(n >> 8 & 0xFF);
    }
}

