/*
 * Decompiled with CFR 0.152.
 */
package cds.astro;

import cds.astro.ParsingText;
import cds.astro.Udef;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Unit {
    public double value;
    public String symbol;
    private long mksa;
    private double factor;
    static final char[] x = "0123456789abcdef".toCharArray();
    static boolean initialized = false;
    private static byte accuracy = (byte)8;
    static final boolean debug = false;
    private static final byte _e0 = 48;
    private static final byte _m0 = 2;
    private static final long _ = 0x230303030303030L;
    private static final long _LOG = -216172782113783808L;
    private static final long _log = Long.MIN_VALUE;
    private static final long _mag = 0x100000000000000L;
    private static double scaling = 1.0E-7;
    static final double ln10 = Math.log(10.0);
    static final double[] powers = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9};
    private static Hashtable Hsymbols = new Hashtable(149);
    private static Vector aDef = null;
    private static final String[] MKSA = new String[]{"mag", "kg", "m", "s", "A", "K", "cd", "mol"};
    private static final String[] mul_symb = new String[]{"mu", "da", "k", "m", "c", "u", "M", "n", "G", "d", "h", "p", "T", "f", "P", "a", "E", "z", "Z", "y", "Y", "\u00b5"};
    private static final String[] mul_text = new String[]{"micro", "deca", "kilo", "milli", "centi", "micro", "mega", "nano", "giga", "deci", "hecto", "pico", "tera", "femto(10-15)", "peta(10+15)", "atto(10-18)", "exa(10+18)", "zepto(10-21)", "zetta(10+21)", "yocto(10-24)", "yotta(10+24)", "micro"};
    private static final int[] mul_fact = new int[]{-6, 1, 3, -3, -2, -6, 6, -9, 9, -1, 2, -12, 12, -15, 15, -18, 18, -21, 21, -24, 24, -6};
    private static final String[] op_symb = new String[]{"2", "3", "+", "-", "/", ".", "*", " "};
    private static final String[] op_text = new String[]{"square ", "cubic ", "power+", "power-", "per ", "times ", "times ", "times "};
    private static final String[] log_symb = new String[]{"log(", "log[", "[", "dex", "mag(", "mag["};
    private static final char[] log_end;
    private static final Udef[] uDef;

    static {
        char[] cArray = new char[6];
        cArray[0] = 41;
        cArray[1] = 93;
        cArray[2] = 93;
        cArray[4] = 41;
        cArray[5] = 93;
        log_end = cArray;
        uDef = new Udef[]{new Udef("---", "", 0x230303030303030L, 1.0), new Udef("%", "percent", 0x230303030303030L, 0.01), new Udef("h", "hour ", 157678974777962544L, 3600.0), new Udef("min", "minute ", 157678974777962544L, 60.0), new Udef("s", "second ", 157678974777962544L, 1.0), new Udef("mag", "magnitude ", 0x330303030303030L, 1.0), new Udef("Jy", "Jansky(10-26W/m2/Hz) ", 157960436869771312L, 1.0E-26), new Udef("deg", "degree ", 0x230303030303030L, 0.002777777777777778), new Udef("rad", "radian ", 0x230303030303030L, 0.15915494309189535), new Udef("sr", "steradian ", 0x230303030303030L, 0.07957747154594767), new Udef("arcmin", "minute of arc ", 0x230303030303030L, 4.6296296296296294E-5), new Udef("arcsec", "second of arc ", 0x230303030303030L, 7.71604938271605E-7), new Udef("mas", "milli-second of arc ", 0x230303030303030L, 7.716049382716049E-10), new Udef("uas", "micro-second of arc ", 0x230303030303030L, 7.71604938271605E-13), new Udef("Sun", "Solar unit ", 0x230303030303030L, 1.0), new Udef("solMass", "solar mass ", 157960445459705904L, 1.989E30), new Udef("solRad", "solar radius ", 157680069994623024L, 6.9599E8), new Udef("solLum", "solar luminosity ", 157962631598059568L, 3.826E26), new Udef("m", "metre ", 157680069994623024L, 1.0), new Udef("Hz", "Herz ", 157678966188027952L, 1.0), new Udef("kg", "kilogram ", 157960445459705904L, 1.0), new Udef("g", "gram ", 157960445459705904L, 0.001), new Udef("degC", "Celsius ", 157678970483060784L, 1.0), new Udef("K", "Kelvin ", 157678970483060784L, 1.0), new Udef("Pa", "Pascal ", 157959337358143536L, 1.0), new Udef("T", "Tesla ", 157960436852994096L, 1.0), new Udef("V", "Volt ", 157962631581282352L, 1.0), new Udef("W", "Watt ", 157962631598059568L, 1.0), new Udef("J", "Joule ", 157962635893026864L, 1.0), new Udef("eV", "electron-Volt ", 157962635893026864L, 1.602177E-19), new Udef("Ry", "Rydberg(13.6eV) ", 157962635893026864L, 2.1798948E-18), new Udef("a", "year ", 157678974777962544L, 3.15576E7), new Udef("yr", "year ", 157678974777962544L, 3.15576E7), new Udef("d", "day ", 157678974777962544L, 86400.0), new Udef("AU", "astronomical unit ", 157680069994623024L, 1.49598E11), new Udef("au", "astronomical unit ", 157680069994623024L, 1.49598E11), new Udef("pc", "parsec ", 157680069994623024L, 3.0857E16), new Udef("al", "light-year ", 157680069994623024L, 9.46053E15), new Udef("JD", "Julian Day ", 157678974777962544L, 86400.0), new Udef("MJD", "Mod. Julian Date (JD-2400000.5) ", 157678974777962544L, 86400.0), new Udef("pix", "pixel ", 0x230303030303030L, 1.0), new Udef("ct", "count ", 0x230303030303030L, 1.0), new Udef("ph", "photon ", 0x230303030303030L, 1.0), new Udef("A", "Ampere ", 157678970499772464L, 1.0), new Udef("barn", "barn(10-28m2) ", 0x230323030303030L, 1.0E-28), new Udef("bit", "binary information unit ", 0x230303030303030L, 1.0), new Udef("byte", "byte(8bits) ", 0x230303030303030L, 1.0), new Udef("C", "Coulomb ", 157678974794739760L, 1.0), new Udef("D", "Debye (dipole)", 157680074306367536L, 3.333333333333333E-30), new Udef("cd", "candela(lumen/sr) ", 157678970482995504L, 1.0), new Udef("F", "Farad ", 157395313696452656L, 1.0), new Udef("H", "Henry ", 157962635859472432L, 1.0), new Udef("lm", "lumen ", 157678970482995504L, 0.07957747154594767), new Udef("lx", "lux(lm/m2) ", 157676771459739952L, 0.07957747154594767), new Udef("mol", "mole ", 157678970482995249L, 1.0), new Udef("N", "Newton ", 157961536381399088L, 1.0), new Udef("Ohm", "Ohm(V/A) ", 157962631564505136L, 1.0), new Udef("S", "Siemens(A/V) ", 157395309401485360L, 1.0), new Udef("Wb", "Weber(V.s) ", 157962635876249648L, 1.0), new Udef("\u00b5as", "micro-second of arc ", 0x230303030303030L, 7.71604938271605E-13), new Udef("\"d:m:s\"", "degree arcminute arcsecond (sexagesimal angle from degree)", 0x230303030303030L, 0.002777777777777778), new Udef("\"h:m:s\"", "hour minutes seconds (sexagesimal time from hours)", 157678974777962544L, 3600.0), new Udef("\"m:s\"", "minutes seconds (sexagesimal time from minutes)", 157678974777962544L, 60.0), new Udef("\"HH:MM:SS\"", "hour minutes seconds (sexagesimal time)", 157678974777962544L, 1.0), new Udef("\"day\"", "Day of month number", 0x230303030303030L, 86400.0), new Udef("pi", "pi(=3.14...)", 0x230303030303030L, Math.PI), new Udef("c", "c(speed_of_light)", 157680065699655728L, 2.997925E8), new Udef("G", "G(gravitation)", 157400785451233328L, 6.67E-11), new Udef("\\h", "h(Planck)", 157962640187994160L, 6.6262E-34), new Udef("e", "e(electron_charge) ", 157678974794739760L, 1.602177E-19), new Udef("k", "k(Boltzmann) ", 157962635892961328L, 1.38062E-23), new Udef("R", "R(gas_constant) ", 157962635892961327L, 8.3143), new Udef("mp", "proton_mass ", 157960445459705904L, 1.672661E-27), new Udef("me", "electron_mass ", 157960445459705904L, 9.10956E-31), new Udef("atm", "atmosphere ", 157959337358143536L, 101325.0), new Udef("mmHg", "mercury_mm ", 157959337358143536L, 133.3224), new Udef("l", "litre ", 0x230333030303030L, 0.001), new Udef("hr", "hour(use 'h') ", 157678974777962544L, 3600.0), new Udef("sec", "second (use 's')", 157678974777962544L, 1.0), new Udef("inch", "inch ", 157680069994623024L, 0.0254), new Udef("t", "ton ", 157960445459705904L, 1000.0), new Udef("month", "month ", 0x230303030303030L, 1.0), new Udef("erg", "erg(10-7J) ", 157962635893026864L, 1.0E-7), new Udef("dyn", "dyne(10-5N) ", 157961536381399088L, 1.0E-5), new Udef("bar", "bar(10+5Pa) ", 157959337358143536L, 100000.0), new Udef("gauss", "Gauss(10-4T) ", 157960436852994096L, 1.0E-4), new Udef("cal", "calorie ", 157962635893026864L, 4.1854), new Udef("Angstroem", "Angstroem (0.1nm) ", 157680069994623024L, 1.0E-10), new Udef("\u00c5", "Angstroem (0.1nm) ", 157680069994623024L, 1.0E-10), new Udef("u", "Unit of atomic mass ", 157960445459705904L, 1.66053873E-27), new Udef("lyr", "light-year (c*yr) ", 157680069994623024L, 9.46053E15), new Udef("geoMass", "Earth mass ", 157960445459705904L, 5.976E24), new Udef("jovMass", "Jovian mass ", 157960445459705904L, 1.902E27)};
    }

    public Unit() {
        this.symbol = null;
        this.mksa = 0x230303030303030L;
        this.factor = 1.0;
        this.value = Double.NaN;
    }

    public Unit(Unit unit) {
        this.set(unit);
    }

    public Unit(String string) throws ParseException {
        this.set(string);
    }

    public static final String addSymbol(String string, String string2) throws ParseException {
        return Unit.addSymbol(string, string2, String.valueOf(string2) + " ");
    }

    public static final String addSymbol(String string, String string2, String string3) throws ParseException {
        Udef udef = Unit.uLookup(string);
        Unit unit = new Unit(string2);
        if (aDef == null) {
            aDef = new Vector(16);
        }
        if (!Double.isNaN(unit.value)) {
            if ((unit.mksa & 0xFD00000000000000L) != 0L) {
                Unit unit2 = new Unit(unit);
                unit2.dexp();
                unit.factor = unit2.factor * unit2.value;
            } else {
                unit.factor *= unit.value;
            }
        }
        Udef udef2 = new Udef(string, string3, unit.mksa, unit.factor);
        int n = aDef.size() + uDef.length;
        aDef.addElement(udef2);
        Hsymbols.put(string, new Integer(n));
        if (udef == null) {
            return "";
        }
        return udef.expl;
    }

    public final void convert(Unit unit) throws ArithmeticException {
        double d = unit.factor / this.factor;
        if (this.mksa == unit.mksa) {
            if ((this.mksa & Long.MIN_VALUE) == 0L) {
                this.value = d * unit.value;
            } else {
                d = Math.log(d) / ln10;
                if ((this.mksa & 0x100000000000000L) != 0L) {
                    d = -2.5 * d;
                }
                this.value = unit.value + d;
            }
            return;
        }
        if ((this.mksa & 0x2FFFFFFFFFFFFFFL) != (unit.mksa & 0x2FFFFFFFFFFFFFFL)) {
            throw new ArithmeticException("****Unit: can't convert " + this.symbol + " into " + unit.symbol);
        }
        if ((this.mksa & Long.MIN_VALUE) == 0L) {
            double d2 = (unit.mksa & 0x100000000000000L) != 0L ? -2.5 : 1.0;
            this.value = d * Math.exp(unit.value * ln10 / d2);
            return;
        }
        if ((unit.mksa & Long.MIN_VALUE) != 0L) {
            this.value = (unit.mksa & 0x100000000000000L) != 0L ? -0.4 * unit.value : unit.value;
            this.value += Math.log(d) / ln10;
            if ((this.mksa & 0x100000000000000L) != 0L) {
                this.value *= -2.5;
            }
            return;
        }
        double d3 = (this.mksa & 0x100000000000000L) != 0L ? -2.5 : 1.0;
        this.value = d3 * Math.log(d * unit.value) / ln10;
    }

    public final void dexp() throws ArithmeticException {
        if ((this.mksa & Long.MIN_VALUE) == 0L) {
            throw new ArithmeticException("****Unit: dexp(" + this.symbol + ")");
        }
        double d = (this.mksa & 0x100000000000000L) != 0L ? -2.5 : 1.0;
        this.value = Math.exp(this.value * ln10 / d);
        this.mksa &= 0x2FFFFFFFFFFFFFFL;
        if (this.symbol == null) {
            return;
        }
        int n = -1;
        int n2 = this.symbol.length() - 1;
        char c = this.symbol.charAt(n2);
        if (c == ']') {
            n = this.symbol.indexOf(91);
        } else if (c == ')') {
            n = this.symbol.indexOf(40);
        }
        if (n >= 0) {
            this.symbol = this.symbol.substring(n + 1, n2);
        } else {
            StringBuffer stringBuffer = new StringBuffer(64);
            this.toSI(stringBuffer, 0);
            this.symbol = String.valueOf(String.valueOf(stringBuffer));
        }
    }

    public final void div(Unit unit) throws ArithmeticException {
        long l = this.mksa;
        double d = this.factor;
        double d2 = this.value;
        if (!(((this.mksa | unit.mksa) & Long.MIN_VALUE) == 0L || this.mksa == 0x230303030303030L && this.factor == 1.0 || unit.mksa == 0x230303030303030L && unit.factor == 1.0)) {
            throw new ArithmeticException("****Unit: can't divide logs: " + this.symbol + " / " + unit.symbol);
        }
        d2 /= unit.value;
        d /= unit.factor;
        l += 0x230303030303030L;
        if (((l -= unit.mksa) & 0xFC80808080808080L) != 0L) {
            throw new ArithmeticException("****too large powers in: " + this.symbol + " / " + unit.symbol);
        }
        this.mksa = l;
        this.factor = d;
        this.value = d2;
        if (this.symbol != null && unit.symbol != null) {
            if (unit.mksa == 0x230303030303030L && unit.factor == 1.0) {
                return;
            }
            this.symbol = this.mksa == 0x230303030303030L && this.factor == 1.0 ? String.valueOf(Unit.toExpr(unit.symbol)) + "-1" : (this.symbol.equals(unit.symbol) ? Unit.edf(this.factor) : String.valueOf(Unit.toExpr(this.symbol)) + "/" + Unit.toExpr(unit.symbol));
        }
    }

    public void dump(String string) {
        char[] cArray = new char[24];
        long l = this.mksa;
        l = this.mksa;
        int n = 24;
        while (n > 0) {
            cArray[--n] = x[(int)(l & 0xFL)];
            cArray[--n] = x[(int)((l >>>= 4) & 0xFL)];
            l >>>= 4;
            cArray[--n] = 46;
        }
        cArray[n] = 120;
        System.out.println(String.valueOf(string) + ": symbol='" + this.symbol + "', value=" + this.value);
        System.out.println("        factor=" + this.factor + ", Dim0" + cArray);
    }

    private static final String edf(double d) {
        if (d == 1.0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(32);
        Unit.edf(stringBuffer, d);
        return String.valueOf(String.valueOf(stringBuffer));
    }

    private static final int edf(StringBuffer stringBuffer, double d) {
        int n = stringBuffer.length();
        double d2 = d;
        double d3 = 1.0;
        boolean bl = true;
        boolean bl2 = true;
        if (Double.isNaN(d)) {
            return 0;
        }
        if (d < 0.0) {
            stringBuffer.append('-');
            d2 = -d2;
        }
        if (d2 == 0.0) {
            stringBuffer.append('0');
            return stringBuffer.length() - n;
        }
        if (Double.isInfinite(d2)) {
            stringBuffer.append(d2);
            return stringBuffer.length() - n;
        }
        if (Math.abs(d2 - 1.0) < 1.0E-15) {
            return stringBuffer.length() - n;
        }
        int n2 = (int)(Double.doubleToLongBits(d2) >> 52) - 1023;
        n2 = n2 * 3 / 10;
        d3 = Unit.power10(n2);
        while (d2 < d3) {
            d3 = Unit.power10(--n2);
        }
        while (d2 >= 10.0 * d3) {
            d3 = Unit.power10(++n2);
        }
        d2 /= d3;
        if ((d2 += 0.5 * scaling) >= 10.0) {
            d3 = Unit.power10(++n2);
            d2 /= 10.0;
        }
        Double d4 = new Double(d2 / scaling);
        long l = d4.longValue();
        int n3 = accuracy;
        char[] cArray = new char[n3];
        while (--n3 >= 0) {
            cArray[n3] = x[(int)(l % 10L)];
            l /= 10L;
        }
        n3 = 0;
        int n4 = n2;
        if (n2 == -1) {
            stringBuffer.append("0.");
            n4 = 0;
            bl2 = false;
        }
        stringBuffer.append(cArray[n3++]);
        if (n2 != 1 && bl2) {
            stringBuffer.append('.');
            bl2 = false;
        }
        stringBuffer.append(cArray[n3++]);
        if (n2 == 1 && bl2) {
            stringBuffer.append('.');
            n4 = 0;
        }
        while (n3 < cArray.length) {
            stringBuffer.append(cArray[n3++]);
        }
        n3 = stringBuffer.length() - 1;
        while (stringBuffer.charAt(n3) == '0') {
            --n3;
        }
        if (stringBuffer.charAt(n3) != '.') {
            ++n3;
        } else if (n4 != 0) {
            if (stringBuffer.charAt(--n3) == '1') {
                bl = false;
            } else {
                ++n3;
            }
        }
        stringBuffer.setLength(n3);
        if (n4 != 0) {
            if (bl) {
                stringBuffer.append('x');
            }
            stringBuffer.append("10");
            if (n4 > 0) {
                stringBuffer.append('+');
            }
            stringBuffer.append(n4);
        }
        return stringBuffer.length() - n;
    }

    private static final int edu(StringBuffer stringBuffer, long l, int n) {
        int n2;
        int n3 = stringBuffer.length();
        int n4 = 0;
        boolean bl = false;
        if ((l & Long.MIN_VALUE) != 0L && ((l &= Long.MAX_VALUE) & 0x100000000000000L) != 0L) {
            l &= 0xFEFFFFFFFFFFFFFFL;
        }
        if (l == 0x230303030303030L) {
            return 0;
        }
        if (n > 0) {
            n4 = (l & 0x100000000000000L) == 0L ? 0 : 1;
            long l2 = l << 8 >> 8;
            while (l2 != 0L) {
                if ((l2 & 0xFFL) != 48L) {
                    ++n4;
                }
                l2 >>>= 8;
            }
            n2 = 0;
            while (n2 < uDef.length) {
                if (Unit.uDef[n2].mksa == l && Unit.uDef[n2].fact == 1.0) {
                    stringBuffer.append(Unit.uDef[n2].symb);
                    break;
                }
                ++n2;
            }
            if (n4 == 1) {
                return stringBuffer.length() - n3;
            }
            if (stringBuffer.length() != n3) {
                stringBuffer.append(" [");
            } else {
                n4 = 0;
            }
        }
        int n5 = 2;
        n2 = 0;
        while (n2 < 8) {
            int n6 = (int)(l >>> 56 - (n2 << 3) & 0xFFL) - n5;
            n5 = 48;
            if (n6 != 0) {
                if (bl) {
                    stringBuffer.append(".");
                }
                bl = true;
                stringBuffer.append(MKSA[n2]);
                if (n6 != 1) {
                    if (n6 > 0) {
                        stringBuffer.append("+");
                    }
                    stringBuffer.append(n6);
                }
            }
            ++n2;
        }
        if (n4 > 0) {
            stringBuffer.append("]");
        }
        return stringBuffer.length() - n3;
    }

    public final String explain() {
        StringBuffer stringBuffer = new StringBuffer(120);
        ParsingText parsingText = new ParsingText(this.symbol);
        Unit unit = new Unit();
        try {
            unit.unitec(parsingText, stringBuffer);
        }
        catch (Exception exception) {}
        stringBuffer.append(" (");
        this.toSI(stringBuffer, 1);
        stringBuffer.append(")");
        return String.valueOf(String.valueOf(stringBuffer));
    }

    public static final String explain(String string) {
        ParsingText parsingText = new ParsingText(string);
        StringBuffer stringBuffer = new StringBuffer(120);
        Unit unit = new Unit();
        if (!initialized) {
            Unit.init();
        }
        try {
            unit.unitec(parsingText, stringBuffer);
        }
        catch (Exception exception) {
            String string2 = "?***bad Unit <";
            stringBuffer.insert(0, string2);
            stringBuffer.insert(string2.length(), string);
            stringBuffer.insert(string2.length() + string.length(), "> ");
        }
        return String.valueOf(String.valueOf(stringBuffer));
    }

    public final String inSI() {
        StringBuffer stringBuffer = new StringBuffer(64);
        Unit unit = new Unit(this);
        if ((unit.mksa & Long.MIN_VALUE) != 0L) {
            unit.mksa &= 0x7EFFFFFFFFFFFFFFL;
        }
        unit.factor = 1.0;
        unit.convert(this);
        if (!Double.isNaN(this.value)) {
            Unit.edf(stringBuffer, unit.value);
            if (stringBuffer.length() == 0) {
                stringBuffer.append('1');
            }
        }
        unit.toSI(stringBuffer, 0);
        return String.valueOf(String.valueOf(stringBuffer));
    }

    private static void init() {
        int n = 0;
        while (n < uDef.length) {
            Hsymbols.put(Unit.uDef[n].symb, new Integer(n));
            ++n;
        }
        initialized = true;
    }

    public final boolean isCompatibleWith(Unit unit) {
        return (this.mksa & 0x7EFFFFFFFFFFFFFFL) == (unit.mksa & 0x7EFFFFFFFFFFFFFFL);
    }

    public final void log() throws ArithmeticException {
        if ((this.mksa & 0xFD00000000000000L) != 0L) {
            throw new ArithmeticException("****Unit: log(" + this.symbol + ")");
        }
        this.value = Math.log(this.value) / ln10;
        this.mksa |= Long.MIN_VALUE;
        if (this.symbol != null) {
            this.symbol = "[" + this.symbol + "]";
        }
    }

    public final void mag() throws ArithmeticException {
        if ((this.mksa & 0xFD00000000000000L) != 0L) {
            throw new ArithmeticException("****Unit: mag(" + this.symbol + ")");
        }
        this.value = -2.5 * Math.log(this.value) / ln10;
        if (this.mksa == 0x230303030303030L && this.factor == 1.0) {
            this.mksa |= 0x100000000000000L;
            if (this.symbol != null) {
                this.symbol = "mag";
            }
        } else {
            this.mksa |= 0x8100000000000000L;
            if (this.symbol != null) {
                this.symbol = "mag[" + this.symbol + "]";
            }
        }
    }

    public final void minus(Unit unit) throws ArithmeticException {
        if (this.mksa != unit.mksa) {
            throw new ArithmeticException("****Unit: can't combine: " + this.symbol + " - " + unit.symbol);
        }
        this.value -= unit.value * unit.factor / this.factor;
    }

    public final void mult(double d) throws ArithmeticException {
        this.value *= d;
    }

    public final void mult(Unit unit) throws ArithmeticException {
        long l = this.mksa;
        double d = this.factor;
        double d2 = this.value;
        if (!(((this.mksa | unit.mksa) & Long.MIN_VALUE) == 0L || this.mksa == 0x230303030303030L && this.factor == 1.0 || unit.mksa == 0x230303030303030L && unit.factor == 1.0)) {
            throw new ArithmeticException("****Unit: can't multiply logs: " + this.symbol + " x " + unit.symbol);
        }
        d2 *= unit.value;
        d *= unit.factor;
        l += unit.mksa;
        if (((l -= 0x230303030303030L) & 0x7C80808080808080L) != 0L) {
            throw new ArithmeticException("****too large powers in: " + this.symbol + " x " + unit.symbol);
        }
        this.mksa = l;
        this.factor = d;
        this.value = d2;
        if (this.symbol != null && unit.symbol != null) {
            if (unit.mksa == 0x230303030303030L && unit.factor == 1.0) {
                return;
            }
            this.symbol = this.mksa == 0x230303030303030L && this.factor == 1.0 ? unit.symbol : (this.symbol.equals(unit.symbol) && this.factor == unit.factor ? String.valueOf(Unit.toExpr(this.symbol)) + "2" : String.valueOf(Unit.toExpr(this.symbol)) + "." + Unit.toExpr(unit.symbol));
        }
    }

    public final void plus(Unit unit) throws ArithmeticException {
        if (this.mksa != unit.mksa) {
            throw new ArithmeticException("****Unit: can't combine: " + this.symbol + " + " + unit.symbol);
        }
        this.value += unit.value * unit.factor / this.factor;
    }

    /*
     * Unable to fully structure code
     */
    public final void power(int var1_1) throws ArithmeticException {
        var2_2 = 0.0;
        var4_3 = var1_1;
        var5_4 = 1.0;
        var7_5 = 1.0;
        var9_6 = 0x230303030303030L;
        if ((this.mksa & -9151314442816847872L) == 0L) ** GOTO lbl14
        throw new ArithmeticException("****Unit: can't power log[unit]: " + this.symbol);
lbl-1000:
        // 1 sources

        {
            var5_4 *= this.factor;
            var7_5 *= this.value;
            var9_6 += this.mksa;
            if (((var9_6 -= 0x230303030303030L) & -180002695694745472L) != 0L) {
                var2_2 += 1.0;
            }
            --var4_3;
lbl14:
            // 2 sources

            ** while (var4_3 > 0)
        }
lbl15:
        // 2 sources

        while (var4_3 < 0) {
            var5_4 /= this.factor;
            var7_5 /= this.value;
            var9_6 += 0x230303030303030L;
            if (((var9_6 -= this.mksa) & -180002695694745472L) != 0L) {
                var2_2 += 1.0;
            }
            ++var4_3;
        }
        if (var2_2 > 0.0) {
            throw new ArithmeticException("****Unit: power too large: ()^" + var1_1);
        }
        this.factor = var5_4;
        this.value = var7_5;
        this.mksa = var9_6;
        if (var9_6 != 0x230303030303030L && var1_1 != 1 && this.symbol != null) {
            this.symbol = var1_1 == 0 ? "" : String.valueOf(Unit.toExpr(this.symbol)) + var1_1;
        }
    }

    public static final double power10(int n) {
        int n2 = n;
        int n3 = powers.length - 1;
        double d = 1.0;
        boolean bl = false;
        if (n < 0) {
            bl = true;
            n2 = -n;
        }
        while (n2 > n3) {
            d *= powers[n3];
            n2 -= n3;
        }
        d *= powers[n2];
        if (bl) {
            d = 1.0 / d;
        }
        return d;
    }

    public final void prod(Unit unit) throws ArithmeticException {
        if ((this.mksa & Long.MIN_VALUE) == 0L && (unit.mksa & Long.MIN_VALUE) == 0L) {
            this.mult(unit);
            return;
        }
        Unit unit2 = new Unit(this);
        Unit unit3 = new Unit(unit);
        if ((unit2.mksa & Long.MIN_VALUE) != 0L) {
            unit2.mksa &= 0x7EFFFFFFFFFFFFFFL;
            unit2.convert(this);
        }
        if ((unit3.mksa & Long.MIN_VALUE) != 0L) {
            unit3.mksa &= 0x7EFFFFFFFFFFFFFFL;
            unit3.convert(this);
        }
        unit2.mult(unit3);
        if ((this.mksa & Long.MIN_VALUE) != 0L) {
            if ((this.mksa & 0x100000000000000L) != 0L) {
                unit2.mag();
            } else {
                unit2.log();
            }
        }
        this.set(unit2);
    }

    public final void set(Unit unit) {
        this.mksa = unit.mksa;
        this.symbol = unit.symbol;
        this.value = unit.value;
        this.factor = unit.factor;
    }

    public void set(String string) throws ParseException {
        ParsingText parsingText = new ParsingText(string);
        if (!initialized) {
            Unit.init();
        }
        while (parsingText.pos < parsingText.len && Character.isWhitespace(parsingText.a[parsingText.pos])) {
            ++parsingText.pos;
        }
        int n = parsingText.pos;
        double d = parsingText.parseFactor();
        boolean bl = n == parsingText.pos;
        if (bl) {
            d = Double.NaN;
        }
        while (parsingText.pos < parsingText.len && Character.isWhitespace(parsingText.a[parsingText.pos])) {
            ++parsingText.pos;
        }
        if (parsingText.lookup(op_symb) >= 0) {
            d = Double.NaN;
            parsingText.pos = n;
        }
        n = parsingText.pos;
        this.symbol = null;
        this.unitec(parsingText, null);
        this.symbol = string.substring(n, parsingText.pos);
        this.value = d;
        if (bl && (this.mksa & Long.MIN_VALUE) != 0L) {
            this.value = 0.0;
        }
        while (parsingText.pos < parsingText.len && Character.isWhitespace(parsingText.a[parsingText.pos])) {
            ++parsingText.pos;
        }
        if (parsingText.pos < parsingText.len) {
            throw new ParseException("****Unit: set '" + string + "'+" + parsingText.pos, parsingText.pos);
        }
    }

    public static final int setAccuracy(int n) {
        byte by = accuracy;
        if (!initialized) {
            Unit.init();
        }
        accuracy = n < 2 ? (byte)2 : (n > 16 ? (byte)16 : (byte)n);
        scaling = Unit.power10(1 - accuracy);
        return by;
    }

    public void setValue(double d) {
        this.value = d;
    }

    public void setValue(String string) throws ParseException {
        ParsingText parsingText = new ParsingText(string);
        while (parsingText.pos < parsingText.len && Character.isWhitespace(parsingText.a[parsingText.pos])) {
            ++parsingText.pos;
        }
        int n = parsingText.pos;
        this.value = this.symbol.charAt(0) == '\"' && this.symbol.indexOf(58) > 0 ? parsingText.parseSexa() : parsingText.parseFactor();
        if (parsingText.pos == n) {
            this.value = Double.NaN;
            while (parsingText.pos < parsingText.len && parsingText.a[parsingText.pos] == '-') {
                ++parsingText.pos;
            }
        }
        while (parsingText.pos < parsingText.len && Character.isWhitespace(parsingText.a[parsingText.pos])) {
            ++parsingText.pos;
        }
        if (parsingText.pos < parsingText.len) {
            throw new ParseException("****Unit: setValue '" + string + "'+" + parsingText.pos, parsingText.pos);
        }
    }

    public final void sum(Unit unit) throws ArithmeticException {
        boolean bl = false;
        this.dump("...term1");
        unit.dump("...term2");
        if ((this.mksa & 0x2FFFFFFFFFFFFFFL) != (unit.mksa & 0x2FFFFFFFFFFFFFFL)) {
            throw new ArithmeticException("****Unit: can't sum: " + this.symbol + " + " + unit.symbol);
        }
        long l = this.mksa & 0x8100000000000000L;
        long l2 = unit.mksa & 0x8100000000000000L;
        if (l != l2) {
            Unit unit2 = new Unit(this);
            unit2.convert(unit);
            this.sum(unit2);
            return;
        }
        if (l == 0L) {
            this.plus(unit);
            return;
        }
        double d = (l & 0x100000000000000L) != 0L ? -2.5 : 1.0;
        double d2 = unit.value - this.value;
        this.value += (d /= ln10) * Math.log(1.0 + unit.factor / this.factor * Math.exp(d2 / d));
    }

    public static final Enumeration symbols() {
        if (!initialized) {
            Unit.init();
        }
        return Hsymbols.keys();
    }

    private static final String toExpr(String string) {
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length && Character.isLetter(cArray[n])) {
            ++n;
        }
        if (n < cArray.length) {
            return "(" + string + ")";
        }
        return string;
    }

    private void toSI(StringBuffer stringBuffer, int n) {
        if ((this.mksa & Long.MIN_VALUE) != 0L) {
            stringBuffer.append((this.mksa & Long.MIN_VALUE) != 0L ? "mag[" : "log[");
        }
        if (this.factor != 1.0) {
            Unit.edf(stringBuffer, this.factor);
        }
        Unit.edu(stringBuffer, this.mksa, n);
        if ((this.mksa & Long.MIN_VALUE) != 0L) {
            stringBuffer.append("]");
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(120);
        if (!Double.isNaN(this.value)) {
            Unit.edf(stringBuffer, this.value);
            if (stringBuffer.length() == 0) {
                stringBuffer.append((this.mksa & Long.MIN_VALUE) != 0L ? (char)'0' : '1');
            }
        }
        if (this.mksa != 0x230303030303030L || this.factor != 1.0) {
            if (this.symbol != null) {
                stringBuffer.append(this.symbol);
            } else {
                stringBuffer.append('(');
                this.toSI(stringBuffer, 0);
                stringBuffer.append(')');
            }
        }
        return String.valueOf(String.valueOf(stringBuffer));
    }

    private static final Udef uLookup(ParsingText parsingText, int n) {
        String string = new String(parsingText.a, parsingText.pos, n);
        Udef udef = Unit.uLookup(string);
        if (udef != null) {
            parsingText.pos += n;
        }
        return udef;
    }

    private static final Udef uLookup(String string) {
        Object v;
        if (!initialized) {
            Unit.init();
        }
        if (!((v = Hsymbols.get(string)) instanceof Integer)) {
            return null;
        }
        int n = (Integer)v;
        if (n < uDef.length) {
            return uDef[n];
        }
        Udef udef = (Udef)aDef.elementAt(n -= uDef.length);
        return udef;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final int unit1(ParsingText parsingText, StringBuffer stringBuffer) throws ParseException {
        int n;
        int n2;
        int n3;
        int n4;
        Udef udef;
        int n5;
        block31: {
            block32: {
                int n6;
                block33: {
                    n5 = parsingText.pos;
                    udef = uDef[0];
                    n4 = -1;
                    n3 = 1;
                    n2 = 0;
                    n = 0;
                    boolean bl = false;
                    this.mksa = 0x230303030303030L;
                    this.factor = 1.0;
                    if (parsingText.pos >= parsingText.len) {
                        return 0;
                    }
                    block0 : switch (parsingText.a[parsingText.pos]) {
                        case '(': {
                            ++parsingText.pos;
                            bl = stringBuffer != null && stringBuffer.length() > 0;
                            if (bl) {
                                stringBuffer.append('(');
                            }
                            this.unitec(parsingText, stringBuffer);
                            if (parsingText.pos >= parsingText.len) throw new ParseException("****Unit: Missing ) in '" + parsingText + "'", parsingText.pos);
                            if (parsingText.a[parsingText.pos] != ')') throw new ParseException("****Unit: Missing ) in '" + parsingText + "'", parsingText.pos);
                            ++parsingText.pos;
                            if (!bl) break;
                            n6 = stringBuffer.length();
                            while (--n6 >= 0 && stringBuffer.charAt(n6) == ' ') {
                            }
                            stringBuffer.setLength(++n6);
                            stringBuffer.append(')');
                            bl = false;
                            break;
                        }
                        case '\"': {
                            n6 = parsingText.pos + 1;
                            while (true) {
                                if (n6 >= parsingText.len || parsingText.a[n6] == '\"') {
                                    if (n6 < parsingText.len) {
                                        ++n6;
                                    }
                                    if ((udef = Unit.uLookup(parsingText, n6 - parsingText.pos)) != null) break block0;
                                    throw new ParseException("****Unit: quoted unit does not match", parsingText.pos);
                                }
                                ++n6;
                            }
                        }
                        case '-': {
                            int n7 = parsingText.pos++;
                            if (parsingText.pos >= parsingText.len) break;
                            if (Character.isDigit(parsingText.a[parsingText.pos])) {
                                parsingText.pos = n7;
                                break;
                            }
                            while (parsingText.pos < parsingText.len && parsingText.a[parsingText.pos] == '-') {
                                ++parsingText.pos;
                            }
                            break;
                        }
                        case '%': {
                            udef = Unit.uLookup(parsingText, 1);
                            break;
                        }
                        case '\\': {
                            n6 = parsingText.pos + 1;
                            while (true) {
                                if (n6 >= parsingText.len || !Character.isLetter(parsingText.a[n6])) {
                                    udef = Unit.uLookup(parsingText, n6 - parsingText.pos);
                                    if (udef != null) break block0;
                                    ++n;
                                    break block0;
                                }
                                ++n6;
                            }
                        }
                        default: {
                            n6 = parsingText.pos;
                            while (n6 < parsingText.len && Character.isLetter(parsingText.a[n6])) {
                                ++n6;
                            }
                            udef = Unit.uLookup(parsingText, n6 - parsingText.pos);
                            if (udef != null) break;
                            int n7 = parsingText.pos;
                            if (parsingText.len - parsingText.pos > 1) {
                                n4 = parsingText.lookup(mul_symb);
                            }
                            if (n4 < 0 || (udef = Unit.uLookup(parsingText, n6 - parsingText.pos)) != null) break;
                            parsingText.pos = n7;
                        }
                    }
                    if (n == 0 && parsingText.pos < parsingText.len) {
                        n2 = parsingText.a[parsingText.pos];
                    }
                    if (n2 != 43 && n2 != 45 && n2 != 94 && !Character.isDigit((char)n2)) break block31;
                    if (n2 == 94) {
                        ++parsingText.pos;
                    }
                    if (parsingText.pos >= parsingText.len) break block32;
                    n2 = parsingText.a[parsingText.pos];
                    if (n2 == 43) {
                        ++parsingText.pos;
                    }
                    if (n2 != 45) {
                        n2 = 43;
                    }
                    if ((n3 = parsingText.parseInt()) != 0) break block33;
                    ++n;
                    break block31;
                }
                if (n3 > 0 && n3 < 10 && stringBuffer != null) {
                    --parsingText.pos;
                    n6 = parsingText.lookup(op_symb);
                    if (n6 >= 0) {
                        stringBuffer.append(op_text[n6]);
                        n2 = 32;
                        break block31;
                    } else {
                        ++parsingText.pos;
                    }
                }
                break block31;
            }
            ++n;
        }
        if (n > 0) {
            throw new ParseException("****Unit: '" + parsingText + "'+" + parsingText.pos, parsingText.pos);
        }
        if (n4 >= 0) {
            this.factor *= Unit.power10(mul_fact[n4]);
            if (stringBuffer != null) {
                stringBuffer.append(mul_text[n4]);
            }
        }
        if (udef != null) {
            this.factor *= udef.fact;
            this.mksa = udef.mksa;
            if (stringBuffer != null) {
                stringBuffer.append(udef.expl);
            }
        }
        if (n3 == true) return parsingText.pos - n5;
        this.power(n3);
        if (n2 == 32) return parsingText.pos - n5;
        if (stringBuffer == null) return parsingText.pos - n5;
        stringBuffer.append("power");
        stringBuffer.append((char)n2);
        stringBuffer.append(n3);
        return parsingText.pos - n5;
    }

    public final String unitSI() {
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer(16);
        boolean bl2 = bl = (this.mksa & Long.MIN_VALUE) != 0L;
        if (bl) {
            stringBuffer.append('[');
        }
        Unit.edu(stringBuffer, this.mksa, 0);
        if (bl) {
            stringBuffer.append(']');
        }
        return String.valueOf(String.valueOf(stringBuffer));
    }

    /*
     * Unable to fully structure code
     */
    private final int unitec(ParsingText var1_1, StringBuffer var2_2) throws ParseException {
        var3_3 = var1_1.pos;
        var4_4 = null;
        var5_5 = -1;
        var6_6 = 120;
        var7_7 = '\u0000';
        var8_8 = false;
        this.mksa = 0x230303030303030L;
        while (var1_1.pos < var1_1.len && Character.isWhitespace(var1_1.a[var1_1.pos])) {
            ++var1_1.pos;
        }
        var5_5 = var1_1.lookup(Unit.log_symb);
        if (var5_5 >= 0) {
            var7_7 = Unit.log_end[var5_5];
            if (var2_2 != null) {
                var2_2.append(Unit.log_symb[var5_5 & -4]);
            }
        }
        var10_9 = var1_1.pos;
        this.factor = var1_1.parseFactor();
        if (var2_2 != null && var10_9 != var1_1.pos) {
            var2_2.append(var1_1.a, var10_9, var1_1.pos - var10_9);
        }
        var10_9 = -1;
        while (var1_1.pos < var1_1.len) {
            if (var1_1.a[var1_1.pos] == var7_7) break;
            if (var4_4 == null) {
                var4_4 = new Unit();
            }
            var9_10 = var4_4.unit1(var1_1, var2_2);
            if (var6_6 == 47) {
                this.div(var4_4);
            } else {
                this.mult(var4_4);
            }
            var10_9 = var1_1.lookup(Unit.op_symb);
            if (var10_9 < 0) break;
            var6_6 = Unit.op_symb[var10_9].charAt(0);
            if (var2_2 == null) continue;
            var9_10 = var2_2.length();
            while (--var9_10 >= 0 && var2_2.charAt(var9_10) == ' ') {
            }
            var2_2.setLength(++var9_10);
            var2_2.append(' ');
            var2_2.append(Unit.op_text[var10_9]);
        }
        if (var5_5 >= 0) {
            if (var2_2 != null) {
                var9_10 = var2_2.length();
                while (--var9_10 >= 0 && var2_2.charAt(var9_10) == ' ') {
                }
                var2_2.setLength(++var9_10);
                var2_2.append(Unit.log_end[var5_5 & -4]);
            }
            if (var1_1.pos < var1_1.len && var7_7 != '\u0000' && var1_1.a[var1_1.pos] == var7_7) {
                var7_7 = '\u0000';
                ++var1_1.pos;
            }
            this.mksa |= -9223372036854775808L;
            if ((var5_5 & 4) != 0) {
                this.mksa |= 0x100000000000000L;
            }
        }
        if (var10_9 >= 0) {
            throw new ParseException("****Unit.text+" + var1_1.pos + " (missing operand): " + var1_1, var1_1.pos);
        }
        if (var7_7 == '\u0000') ** GOTO lbl64
        throw new ParseException("****Unit.text+" + var1_1.pos + " (missing '" + var7_7 + "'): " + var1_1, var1_1.pos);
lbl-1000:
        // 1 sources

        {
            ++var1_1.pos;
lbl64:
            // 2 sources

            ** while (var1_1.pos < var1_1.len && Character.isWhitespace((char)var1_1.a[var1_1.pos]))
        }
lbl65:
        // 1 sources

        return var1_1.pos - var3_3;
    }
}

