/*
 * Decompiled with CFR 0.152.
 */
package cds.astro;

import cds.astro.Coo;

public class Proj3 {
    protected byte type;
    private double[][] R;
    private double clon;
    private double clat;
    protected double X;
    protected double Y;
    protected Coo point;
    public static final int NONE = 0;
    public static final int TAN = 1;
    public static final int TAN2 = 2;
    public static final int SIN = 3;
    public static final int SIN2 = 4;
    public static final int ARC = 5;
    public static final int AITOFF = 6;
    public static final int SANSON = 7;
    public static final int MERCATOR = 8;
    public static final int LAMBERT = 9;
    public static final String[] name = new String[]{"-", "Gnomonic (TAN)", "Stereographic (TAN2)", "Orthographic (SIN)", "Zenithal Equal-area (SIN2)", "Schmidt (ARC)", "Aitoff", "Sanson", "Mercator", "Lambert"};

    public Proj3(double d, double d2) {
        this(1, d, d2);
    }

    public Proj3(int n) {
        this(n, 0.0, 0.0);
    }

    public Proj3(int n, double d, double d2) {
        this.type = (byte)n;
        this.clon = d;
        this.clat = d2;
        this.point = new Coo(d, d2);
        if (d != 0.0 || d2 != 0.0) {
            this.R = Coo.localMatrix(this.clon, this.clat);
        }
    }

    public Proj3(int n, String string, boolean bl) throws Exception {
        this.point = new Coo(string, bl);
        this.type = (byte)n;
        this.clon = this.point.lon;
        this.clat = this.point.lat;
        if (this.clon != 0.0 || this.clat != 0.0) {
            this.R = Coo.localMatrix(this.clon, this.clat);
        }
    }

    public boolean computeAngles(double d, double d2) {
        double d3;
        double d4;
        double d5;
        boolean bl = false;
        if (d == this.X && d2 == this.Y) {
            return Double.isNaN(this.point.lon) ^ true;
        }
        this.X = d;
        this.Y = d2;
        this.point.lon = Double.NaN;
        this.point.lat = Double.NaN;
        switch (this.type) {
            case 1: {
                d5 = 1.0 / Math.sqrt(1.0 + this.X * this.X + this.Y * this.Y);
                d4 = this.X * d5;
                d3 = this.Y * d5;
                break;
            }
            case 2: {
                double d6 = (this.X * this.X + this.Y * this.Y) / 4.0;
                double d7 = 1.0 + d6;
                d5 = (1.0 - d6) / d7;
                d4 = this.X / d7;
                d3 = this.Y / d7;
                break;
            }
            case 3: {
                double d8 = 1.0 - this.X * this.X - this.Y * this.Y;
                if (d8 < 0.0) {
                    if (d8 > -2.0E-16) {
                        d8 = 0.0;
                    } else {
                        return false;
                    }
                }
                d5 = Math.sqrt(d8);
                d4 = this.X;
                d3 = this.Y;
                break;
            }
            case 4: {
                double d9 = (this.X * this.X + this.Y * this.Y) / 4.0;
                if (d9 > 1.0) {
                    return false;
                }
                double d10 = Math.sqrt(1.0 - d9);
                d5 = 1.0 - 2.0 * d9;
                d4 = d10 * this.X;
                d3 = d10 * this.Y;
                break;
            }
            case 5: {
                double d11 = Math.sqrt(this.X * this.X + this.Y * this.Y);
                if (d11 > Math.PI) {
                    return false;
                }
                double d12 = Coo.sinc(d11);
                d5 = Math.cos(d11);
                d4 = d12 * this.X;
                d3 = d12 * this.Y;
                break;
            }
            case 6: {
                double d13 = this.X * this.X / 8.0 + this.Y * this.Y / 2.0;
                if (d13 > 1.0) {
                    return false;
                }
                d5 = 1.0 - d13;
                double d14 = Math.sqrt(1.0 - d13 / 2.0);
                d4 = this.X * d14 / 2.0;
                d3 = this.Y * d14;
                d13 = Math.sqrt(d5 * d5 + d4 * d4);
                if (!(d13 > 0.0)) break;
                d14 = d5;
                d5 = (d14 * d14 - d4 * d4) / d13;
                d4 = 2.0 * d14 * d4 / d13;
                break;
            }
            case 7: {
                d3 = Math.sin(this.Y);
                double d15 = 1.0 - d3 * d3;
                if (d15 < 0.0) {
                    return false;
                }
                double d16 = (d15 = Math.sqrt(d15)) == 0.0 ? 0.0 : this.X / d15;
                d5 = d15 * Math.cos(d16);
                d4 = d15 * Math.sin(d16);
                break;
            }
            case 8: {
                double d17 = 1.0 / Coo.cosh(this.Y);
                d3 = Coo.tanh(this.Y);
                d5 = d17 * Math.cos(this.X);
                d4 = d17 * Math.sin(this.X);
                break;
            }
            case 9: {
                d3 = this.Y;
                double d18 = 1.0 - d3 * d3;
                if (d18 < 0.0) {
                    return false;
                }
                d18 = Math.sqrt(d18);
                d5 = d18 * Math.cos(this.X);
                d4 = d18 * Math.sin(this.X);
                break;
            }
            default: {
                throw new IllegalArgumentException("****Proj3: Invalid Projection type #" + this.type);
            }
        }
        if (this.R != null) {
            this.point.set(this.R[0][0] * d5 + this.R[1][0] * d4 + this.R[2][0] * d3, this.R[0][1] * d5 + this.R[1][1] * d4 + this.R[2][1] * d3, this.R[0][2] * d5 + this.R[1][2] * d4 + this.R[2][2] * d3);
        } else {
            this.point.set(d5, d4, d3);
        }
        return true;
    }

    public boolean computeXY(double d, double d2) {
        double d3;
        double d4;
        double d5;
        if (d == this.point.lon && d2 == this.point.lat) {
            return Double.isNaN(this.X) ^ true;
        }
        this.point.set(d, d2);
        this.X = Double.NaN;
        this.Y = Double.NaN;
        if (this.R == null) {
            d5 = this.point.x;
            d4 = this.point.y;
            d3 = this.point.z;
        } else {
            d5 = this.R[0][0] * this.point.x + this.R[0][1] * this.point.y + this.R[0][2] * this.point.z;
            d4 = this.R[1][0] * this.point.x + this.R[1][1] * this.point.y + this.R[1][2] * this.point.z;
            d3 = this.R[2][0] * this.point.x + this.R[2][1] * this.point.y + this.R[2][2] * this.point.z;
        }
        switch (this.type) {
            case 1: {
                if (d5 <= 0.0) {
                    return false;
                }
                this.X = d4 / d5;
                this.Y = d3 / d5;
                break;
            }
            case 2: {
                double d6 = (1.0 + d5) / 2.0;
                if (d6 <= 0.0) {
                    this.X = Double.NaN;
                    this.Y = Double.NaN;
                    return false;
                }
                this.X = d4 / d6;
                this.Y = d3 / d6;
                break;
            }
            case 3: {
                if (d5 <= 0.0) {
                    return false;
                }
                this.X = d4;
                this.Y = d3;
                break;
            }
            case 4: {
                double d7 = Math.sqrt((1.0 + d5) / 2.0);
                if (d7 > 0.0) {
                    this.X = d4 / d7;
                    this.Y = d3 / d7;
                    break;
                }
                this.X = 2.0;
                this.Y = 0.0;
                break;
            }
            case 5: {
                if (d5 > -1.0) {
                    double d8 = Math.sqrt(d4 * d4 + d3 * d3);
                    double d9 = d5 > 0.0 ? Coo.asinc(d8) : Math.acos(d5) / d8;
                    this.X = d4 * d9;
                    this.Y = d3 * d9;
                    break;
                }
                this.X = Math.PI;
                this.Y = 0.0;
                break;
            }
            case 6: {
                double d10 = Math.sqrt(d5 * d5 + d4 * d4);
                double d11 = Math.sqrt(d10 * (d10 + d5) / 2.0);
                d11 = Math.sqrt((1.0 + d11) / 2.0);
                this.X = Math.sqrt(2.0 * d10 * (d10 - d5)) / d11;
                this.Y = d3 / d11;
                if (!(d4 < 0.0)) break;
                this.X = -this.X;
                break;
            }
            case 7: {
                double d12 = Math.sqrt(d5 * d5 + d4 * d4);
                this.Y = Math.asin(d3);
                if (d12 == 0.0) {
                    this.X = 0.0;
                    break;
                }
                this.X = Math.atan2(d4, d5) * d12;
                break;
            }
            case 8: {
                double d13 = Math.sqrt(d5 * d5 + d4 * d4);
                if (d13 == 0.0) {
                    return false;
                }
                this.X = Math.atan2(d4, d5);
                this.Y = Coo.atanh(d3);
                break;
            }
            case 9: {
                double d14 = Math.sqrt(d5 * d5 + d4 * d4);
                this.Y = d3;
                if (d14 == 0.0) {
                    this.X = 0.0;
                    break;
                }
                this.X = Math.atan2(d4, d5);
                break;
            }
            default: {
                throw new IllegalArgumentException("****Proj3: Invalid Projection type #" + this.type);
            }
        }
        return true;
    }

    public final double getLat() {
        return this.point.lat;
    }

    public final double getLon() {
        return this.point.lon;
    }

    public final double getX() {
        return this.X;
    }

    public final double getY() {
        return this.Y;
    }

    public String toString() {
        return String.valueOf(name[this.type]) + " projection centered at " + this.clon + " " + this.clat + ": " + this.X + " " + this.Y;
    }
}

