/*
 * Decompiled with CFR 0.152.
 */
package cds.astro;

public class Coo {
    public double lon;
    public double lat;
    public double x;
    public double y;
    public double z;
    public byte dlon;
    public byte dlat;

    public Coo() {
        this.y = 0.0;
        this.x = 0.0;
        this.z = 1.0;
        this.lon = 0.0;
        this.lat = 90.0;
    }

    public Coo(double d, double d2) {
        this.set(d, d2);
    }

    public Coo(double d, double d2, double d3) {
        this.set(d, d2, d3);
    }

    public Coo(String string) throws Exception {
        this.set(string);
    }

    public Coo(String string, boolean bl) throws Exception {
        this.set(string, bl);
    }

    public static final double asinc(double d) {
        double d2;
        double d3 = Math.abs(d);
        if (d3 <= 1.0E-4) {
            d3 *= d3;
            d2 = 1.0 + d3 * (6.0 + d3 * 0.45) / 6.0;
        } else {
            d2 = Math.asin(d3) / d3;
        }
        return d2;
    }

    public static final double asind(double d) {
        return Math.asin(d) * 57.29577951308232;
    }

    public static final double atan2d(double d, double d2) {
        return Math.atan2(d, d2) * 57.29577951308232;
    }

    public static final double atand(double d) {
        return Math.atan(d) * 57.29577951308232;
    }

    public static final double atanh(double d) {
        return 0.5 * Math.log((1.0 + d) / (1.0 - d));
    }

    public static final double cosd(double d) {
        return Math.cos(d * (Math.PI / 180));
    }

    public static final double cosh(double d) {
        double d2 = Math.exp(d);
        return 0.5 * (d2 + 1.0 / d2);
    }

    public static final double dist(double d, double d2, double d3, double d4) {
        double d5 = Coo.cosd(d2);
        double d6 = Coo.cosd(d4);
        double d7 = d5 * Coo.cosd(d) - d6 * Coo.cosd(d3);
        double d8 = d7 * d7;
        d7 = d5 * Coo.sind(d) - d6 * Coo.sind(d3);
        d8 += d7 * d7;
        d7 = Coo.sind(d2) - Coo.sind(d4);
        return 2.0 * Coo.asind(0.5 * Math.sqrt(d8 += d7 * d7));
    }

    public static final int ed1(StringBuffer stringBuffer, double d, int n, int n2, boolean bl) {
        int n3 = stringBuffer.length();
        int n4 = n - n2 - 1;
        double d2 = d;
        if (Double.isNaN(d)) {
            return 0;
        }
        if (bl && d2 >= 0.0) {
            stringBuffer.append('+');
            --n4;
        }
        if (d2 < 0.0) {
            d2 = -d2;
            stringBuffer.append('-');
            --n4;
        }
        int n5 = (int)d2;
        d2 -= (double)n5;
        int n6 = 1;
        while (n4 > 1) {
            n6 *= 10;
            --n4;
        }
        while (n5 / n6 >= 10) {
            n6 *= 10;
        }
        while (n6 > 0) {
            stringBuffer.append((char)(48 + n5 / n6));
            n5 %= n6;
            n6 /= 10;
        }
        if (n2 >= 0) {
            stringBuffer.append('.');
        }
        n6 = n3 + n - stringBuffer.length();
        while (n6 > 0) {
            n5 = (int)(d2 *= 10.0);
            d2 -= (double)n5;
            stringBuffer.append((char)(48 + n5));
            --n6;
        }
        return stringBuffer.length() - n3;
    }

    protected static final void edit(StringBuffer stringBuffer, double[] dArray) {
        Coo.ed1(stringBuffer, dArray[0], 19, 16, true);
        stringBuffer.append(' ');
        Coo.ed1(stringBuffer, dArray[1], 19, 16, true);
        stringBuffer.append(' ');
        Coo.ed1(stringBuffer, dArray[2], 19, 16, true);
    }

    public static final double[][] localMatrix(double d, double d2) {
        double[][] dArray = new double[3][3];
        dArray[2][2] = Coo.cosd(d2);
        dArray[0][2] = Coo.sind(d2);
        dArray[1][1] = Coo.cosd(d);
        dArray[1][0] = -Coo.sind(d);
        dArray[1][2] = 0.0;
        dArray[0][0] = dArray[2][2] * dArray[1][1];
        dArray[0][1] = -dArray[2][2] * dArray[1][0];
        dArray[2][0] = -dArray[0][2] * dArray[1][1];
        dArray[2][1] = dArray[0][2] * dArray[1][0];
        return dArray;
    }

    public static final double[][] prod(double[][] dArray, double[][] dArray2) {
        double[][] dArray3 = new double[3][3];
        int n = 0;
        while (n < 3) {
            int n2 = 0;
            while (n2 < 3) {
                dArray3[n][n2] = dArray[n][0] * dArray2[0][n2] + dArray[n][1] * dArray2[1][n2] + dArray[n][2] * dArray2[2][n2];
                ++n2;
            }
            ++n;
        }
        return dArray3;
    }

    public final void set(double d, double d2) {
        double d3 = Coo.cosd(d2);
        this.lon = d;
        this.lat = d2;
        this.x = d3 * Coo.cosd(d);
        this.y = d3 * Coo.sind(d);
        this.z = Coo.sind(d2);
    }

    public final void set(double d, double d2, double d3) {
        double d4 = d * d + d2 * d2;
        this.x = d;
        this.y = d2;
        this.z = d3;
        this.lon = 0.0;
        if (d4 == 0.0) {
            if (d3 == 0.0) {
                this.lon = Double.NaN;
                this.lat = Double.NaN;
            } else {
                this.lat = d3 > 0.0 ? 90.0 : -90.0;
            }
        } else {
            this.lon = Coo.atan2d(d2, d);
            this.lat = Coo.atan2d(d3, Math.sqrt(d4));
            if (this.lon < 0.0) {
                this.lon += 360.0;
            }
        }
    }

    public final void set(String string) throws Exception {
        this.set(string, false);
    }

    /*
     * Exception decompiling
     */
    public final void set(String var1_1, boolean var2_2) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Statement already marked as first in another block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.markFirstStatementInBlock(Op03SimpleStatement.java:461)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Misc.markWholeBlock(Misc.java:251)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.considerAsSimpleIf(ConditionalRewriter.java:673)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.identifyNonjumpingConditionals(ConditionalRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:722)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public final void setEq(String string) throws Exception {
        this.set(string, true);
    }

    public static final double sinc(double d) {
        double d2;
        double d3 = Math.abs(d);
        if (d3 <= 1.0E-4) {
            d3 *= d3;
            d2 = 1.0 - d3 * (1.0 - d3 / 20.0) / 6.0;
        } else {
            d2 = Math.sin(d3) / d3;
        }
        return d2;
    }

    public static final double sind(double d) {
        return Math.sin(d * (Math.PI / 180));
    }

    public static final double[][] t(double[][] dArray) {
        double[][] dArray2 = new double[3][3];
        int n = 0;
        while (n < 3) {
            int n2 = 0;
            while (n2 < 3) {
                dArray2[n][n2] = dArray[n2][n];
                ++n2;
            }
            ++n;
        }
        return dArray2;
    }

    public static final double tanh(double d) {
        double d2 = Math.exp(d);
        double d3 = 1.0 / d2;
        return (d2 - d3) / (d2 + d3);
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer(40);
        int n = this.dlon > 0 ? (int)this.dlon : 12;
        Coo.ed1(stringBuffer, this.lon, n + 4, n, false);
        stringBuffer.append(' ');
        n = this.dlat > 0 ? (int)this.dlat : 12;
        Coo.ed1(stringBuffer, this.lat, n + 4, n, true);
        return String.valueOf(String.valueOf(stringBuffer));
    }

    public static final String toString(double d, int n, int n2, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(n + 2);
        Coo.ed1(stringBuffer, d, n, n2, bl);
        return String.valueOf(String.valueOf(stringBuffer));
    }

    protected static final String toString(double[] dArray) {
        StringBuffer stringBuffer = new StringBuffer(60);
        Coo.edit(stringBuffer, dArray);
        return String.valueOf(String.valueOf(stringBuffer));
    }

    protected static final String toString(double[][] dArray) {
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append("    ");
        Coo.edit(stringBuffer, dArray[0]);
        stringBuffer.append("\n    ");
        Coo.edit(stringBuffer, dArray[1]);
        stringBuffer.append("\n    ");
        Coo.edit(stringBuffer, dArray[2]);
        return String.valueOf(String.valueOf(stringBuffer));
    }
}

