/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Calque;
import cds.aladin.Coord;
import cds.aladin.Plan;
import cds.aladin.PlanImage;
import cds.aladin.PlanImageRGB;
import cds.aladin.PointD;
import cds.aladin.View;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;

public final class ZoomView
extends Canvas
implements Runnable {
    static final int WENZOOM = 8;
    int SIZE;
    Calque calque;
    Aladin aladin;
    Image img;
    Image imgwen;
    Graphics gwen;
    Image imgzoom;
    Graphics gzoom;
    int etat = -1;
    double zoom = 1.0;
    Rectangle rectzoom;
    Rectangle or;
    boolean flagdrag;
    boolean imgok;
    Rectangle clip;
    int x;
    int y;
    int owidth;
    int oheight;
    int iz = 0;
    Rectangle rzoom;
    int W;
    int H;
    int xwen;
    int ywen;
    Point oc;
    boolean zoomok;
    Thread calculwen;
    int xmwen;
    int ymwen;
    int nmwen;
    int memR;
    int memG;
    int memB;
    int memX;
    boolean memInv;
    boolean flagRGB;
    boolean flagwen;

    protected ZoomView(Aladin aladin, Calque calque) {
        this.aladin = aladin;
        this.calque = calque;
        this.setBackground(Color.white);
        this.SIZE = calque.select.ws + 12;
        this.y = this.x = this.SIZE / 2;
        this.resize(this.SIZE, this.SIZE);
    }

    protected String Help() {
        return "!Zoom window\nDisplay a quickview of the first active image on the plane stack. \nThe green rectangle specifies the size of the current view in the ``View window'', according to the zoom scale and the Aladin window size.\n \nYou can change the scale with the little menu, or directly in the ``View window'' if the ``Zoom'' button is actived.\n \nBy dragging this rectangle, you can change the displayed area.\n \nWarning : This function is pretty time-consuming. \n";
    }

    protected void NewZoom() {
        this.NewZoom(this.x, this.y);
    }

    protected void NewZoom(int n, int n2) {
        this.NewZoom(n, n2, true);
    }

    protected void NewZoom(int n, int n2, boolean bl) {
        if (this.calculZoom(n, n2, bl)) {
            if (!this.flagdrag && this.calque.unActiveOldPlan()) {
                this.calque.select.repaint();
                this.repaint();
                System.gc();
            } else {
                this.repaint();
            }
        }
    }

    protected void calculWen(int n, int n2, int n3) {
        this.xmwen = n2;
        this.ymwen = n3;
        this.nmwen = n;
        this.run();
    }

    protected synchronized boolean calculZoom(int n, int n2, boolean bl) {
        double d;
        double d2;
        this.zoomok = false;
        this.calque.view.newView();
        this.zoom = this.calque.zoom.getValue();
        Plan plan = this.calque.getPlanRef();
        if (plan == null || plan.type != 1 || !plan.flagOk) {
            d2 = plan == null || plan.projd == null ? 500.0 : plan.projd.r;
            d = d2;
        } else {
            d = ((PlanImage)plan).width;
            d2 = ((PlanImage)plan).height;
        }
        this.W = this.SIZE;
        this.H = (int)Math.round((double)this.W / d * d2);
        if (this.H > this.W) {
            this.W = (int)((double)this.W * (double)this.W / (double)this.H);
            this.H = this.SIZE;
        }
        int n3 = (int)Math.round((double)this.W / d * (double)this.owidth / this.zoom);
        int n4 = (int)Math.round((double)this.H / d2 * (double)this.oheight / this.zoom);
        if (bl) {
            if (n3 > this.W) {
                n = this.W / 2;
            } else if (n + n3 / 2 > this.W) {
                n = this.W - n3 / 2;
            } else if (n - n3 / 2 < 0) {
                n = n3 / 2;
            }
            if (n4 > this.H) {
                n2 = this.H / 2;
            } else if (n2 + n4 / 2 > this.H) {
                n2 = this.H - n4 / 2;
            } else if (n2 - n4 / 2 < 0) {
                n2 = n4 / 2;
            }
        }
        int n5 = (int)Math.round(d / (double)this.W * (double)n);
        int n6 = (int)Math.round(d2 / (double)this.H * (double)n2);
        int n7 = (int)((double)this.owidth / this.zoom);
        int n8 = (int)((double)this.oheight / this.zoom);
        if (this.zoom > 1.0) {
            ++n7;
            ++n8;
        }
        if ((double)n7 < d && n5 - n7 / 2 < 0) {
            n5 = n7 / 2;
        }
        if ((double)n8 < d2 && n6 - n8 / 2 < 0) {
            n6 = n8 / 2;
        }
        this.rzoom = new Rectangle(n5 - n7 / 2, n6 - n8 / 2, n7, n8);
        Rectangle rectangle = new Rectangle(n - n3 / 2, n2 - n4 / 2, n3, n4);
        if (this.rectzoom != null && rectangle.equals(this.rectzoom)) {
            this.zoomok = true;
            return false;
        }
        this.rectzoom = rectangle;
        this.x = n;
        this.y = n2;
        this.zoomok = true;
        return true;
    }

    private void drawFleche(Graphics graphics, int n, int n2, int n3, int n4, String string) {
        double d;
        int n5 = 5;
        graphics.drawLine(n, n2, n3, n4);
        if (n != n3) {
            d = Math.atan((double)(n4 - n2) / (double)(n3 - n));
            if (n > n3) {
                d += Math.PI;
            }
        } else {
            d = n2 < n4 ? 1.5707963267948966 : -1.5707963267948966;
        }
        double d2 = 2.356194490192345;
        int n6 = (int)((double)n5 * Math.cos(d + d2));
        int n7 = (int)((double)n5 * Math.sin(d + d2));
        int n8 = (int)((double)n5 * Math.cos(d - d2));
        int n9 = (int)((double)n5 * Math.sin(d - d2));
        int n10 = (int)(11.0 * Math.cos(d - Math.PI));
        int n11 = (int)(11.0 * Math.sin(d - Math.PI));
        graphics.drawLine(n3 + n6, n4 + n7, n3, n4);
        graphics.drawLine(n3, n4, n3 + n8, n4 + n9);
        graphics.drawString(string, n3 - n10, n4 - n11);
    }

    protected void drawImgWen() {
        int n = this.calque.getIndexPlanBase();
        if (n < 0) {
            this.img = null;
            return;
        }
        Point point = this.getPosition(this.xwen, this.ywen);
        if (point.equals(this.oc)) {
            return;
        }
        this.oc = point;
        this.calculWen(n, point.x, point.y);
    }

    protected boolean drawImgZoom() {
        Plan plan;
        if (this.imgzoom == null) {
            if (this.gzoom != null) {
                this.gzoom.dispose();
            }
            this.imgzoom = this.createImage(this.SIZE, this.SIZE);
            this.gzoom = this.imgzoom.getGraphics();
        }
        if ((plan = this.calque.getPlanRef()) == null || plan.type != 1) {
            if (this.etat != -1) {
                this.gzoom.clearRect(0, 0, this.SIZE, this.SIZE);
                this.gzoom.setColor(Color.black);
                this.gzoom.drawRect(0, 0, this.SIZE - 1, this.SIZE - 1);
                this.etat = -1;
            }
            if (plan != null) {
                this.calculZoom(this.x, this.y, true);
            }
        } else {
            try {
                PlanImage planImage = (PlanImage)plan;
                if (this.etat != planImage.getEtat()) {
                    int n = planImage.width;
                    int n2 = planImage.height;
                    if (n <= 0 || n2 <= 0) {
                        return false;
                    }
                    int n3 = (int)((double)this.SIZE / (double)n * (double)n2);
                    int n4 = this.SIZE;
                    if (n3 > n4) {
                        n4 = (int)((double)n4 * (double)n4 / (double)n3);
                        n3 = this.SIZE;
                    }
                    this.gzoom.clearRect(0, 0, this.SIZE, this.SIZE);
                    Image image = plan instanceof PlanImageRGB ? this.createImage(new MemoryImageSource(n, n2, ((PlanImageRGB)plan).pixelsRGB, 0, n)) : this.createImage(new MemoryImageSource(n, n2, planImage.cm, planImage.pixels, 0, n));
                    PlanImage.waitImage(this, image);
                    this.gzoom.drawImage(image, 0, 0, n4, n3, this);
                    this.gzoom.setColor(Color.black);
                    this.gzoom.drawRect(0, 0, this.SIZE - 1, this.SIZE - 1);
                    this.setNE(this.gzoom, (PlanImage)plan);
                    this.etat = planImage.getEtat();
                    this.calculZoom(this.x, this.y, true);
                }
            }
            catch (OutOfMemoryError outOfMemoryError) {
                System.gc();
                System.runFinalization();
                return false;
            }
            catch (Exception exception) {
                System.out.println("Try ezoom error: " + exception);
                return false;
            }
        }
        this.img = this.imgzoom;
        return true;
    }

    protected PointD getPosition(double d, double d2) {
        if (this.rzoom == null) {
            return new PointD(d, d2);
        }
        double d3 = (double)this.rzoom.x + d / this.zoom;
        double d4 = (double)this.rzoom.y + d2 / this.zoom;
        return new PointD(d3, d4);
    }

    protected Point getPosition(int n, int n2) {
        if (this.rzoom == null) {
            return new Point(n, n2);
        }
        int n3 = this.zoom > 1.0 ? (int)(this.zoom / 2.0) : 0;
        return new Point(this.rzoom.x + (int)Math.round((double)(n - n3) / this.zoom), this.rzoom.y + (int)Math.round((double)(n2 - n3) / this.zoom));
    }

    protected Point getViewCoord(double d, double d2) {
        if (this.rzoom == null) {
            return new Point((int)Math.round(d), (int)Math.round(d2));
        }
        int n = (int)Math.round((d - (double)this.rzoom.x) * this.zoom);
        int n2 = (int)Math.round((d2 - (double)this.rzoom.y) * this.zoom);
        return new Point(n, n2);
    }

    protected Point getViewCoord(int n, int n2) {
        if (this.rzoom == null) {
            return new Point(n, n2);
        }
        int n3 = this.zoom > 1.0 ? (int)(this.zoom / 2.0) : 0;
        int n4 = (int)((double)(n - this.rzoom.x) * this.zoom + (double)n3);
        int n5 = (int)((double)(n2 - this.rzoom.y) * this.zoom + (double)n3);
        return new Point(n4, n5);
    }

    protected Point getViewCoordWithMarge(double d, double d2, int n, int n2) {
        Point point = this.getViewCoord(d, d2);
        if (point.x < -n || point.x > this.owidth + n || point.y < -n2 || point.y > this.oheight + n2) {
            return new Point(-1, -1);
        }
        return point;
    }

    protected synchronized Rectangle getZoom() {
        if (!this.zoomok || this.rzoom == null) {
            return null;
        }
        return new Rectangle(this.rzoom.x, this.rzoom.y, this.rzoom.width, this.rzoom.height);
    }

    protected Point getZoomCoord(int n, int n2) {
        double d;
        double d2;
        Point point = this.getPosition(n, n2);
        Plan plan = this.calque.getPlanRef();
        if (plan.type != 1) {
            d2 = plan.projd == null ? 500.0 : plan.projd.r;
            d = d2;
        } else {
            d = ((PlanImage)plan).width;
            d2 = ((PlanImage)plan).height;
            if (d < 0.0 || d2 < 0.0) {
                return null;
            }
        }
        return new Point((int)((double)this.W / d * (double)point.x), (int)((double)this.H / d2 * (double)point.y));
    }

    public boolean handleEvent(Event event) {
        if (Aladin.inHelp) {
            if (event.id == 504) {
                this.aladin.help.setText(this.Help());
            }
            return true;
        }
        return super.handleEvent(event);
    }

    public boolean mouseDown(Event event, int n, int n2) {
        this.or = null;
        this.flagdrag = true;
        this.NewZoom(n, n2);
        return true;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        this.flagdrag = true;
        this.NewZoom(n, n2, false);
        return true;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        this.flagdrag = false;
        if (event.shiftDown()) {
            n = this.SIZE / 2;
            n2 = this.SIZE / 2;
        }
        this.NewZoom(n, n2, true);
        this.calque.view.repaint();
        this.repaint();
        return true;
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.calque.view.size();
        if (!(Aladin.script || dimension.width == this.owidth && dimension.height == this.oheight)) {
            this.owidth = dimension.width;
            this.oheight = dimension.height;
            this.NewZoom();
            return;
        }
        if (this.flagdrag) {
            graphics.setColor(Color.green);
            graphics.setXORMode(Color.black);
            if (this.or != null) {
                graphics.drawRect(this.or.x, this.or.y, this.or.width - 1, this.or.height - 1);
            }
            graphics.drawRect(this.rectzoom.x, this.rectzoom.y, this.rectzoom.width - 1, this.rectzoom.height - 1);
            graphics.setPaintMode();
            this.or = this.rectzoom;
            this.flagdrag = false;
            return;
        }
        if (this.imgok) {
            graphics.drawImage(this.img, 0, 0, this);
        } else {
            graphics.clearRect(0, 0, this.SIZE, this.SIZE);
            graphics.setColor(Color.black);
            graphics.drawRect(0, 0, this.SIZE - 1, this.SIZE - 1);
        }
        if (!this.flagwen && this.rectzoom != null) {
            graphics.setColor(Color.green);
            graphics.drawRect(this.rectzoom.x, this.rectzoom.y, this.rectzoom.width - 1, this.rectzoom.height - 1);
        }
        if (this.flagwen) {
            int n = this.SIZE / 2 - 4;
            graphics.setColor(Color.green);
            graphics.drawRect(n, n, 8, 8);
            if (this.flagRGB) {
                graphics.setColor(this.memInv ? Color.cyan : Color.red);
                graphics.drawString(String.valueOf(this.memR), 20, this.SIZE - 20);
                graphics.setColor(this.memInv ? Color.magenta : Color.green);
                graphics.drawString(String.valueOf(this.memG), this.SIZE / 2 - 10, this.SIZE - 20);
                graphics.setColor(this.memInv ? Color.yellow : Color.blue);
                graphics.drawString(String.valueOf(this.memB), this.SIZE - 50, this.SIZE - 20);
            } else {
                graphics.drawString(String.valueOf(this.memX), this.SIZE / 2 - 10, this.SIZE - 20);
            }
        }
    }

    public void run() {
        int n = this.SIZE / 8;
        byte[] byArray = null;
        int[] nArray = null;
        byte[] byArray2 = null;
        int[] nArray2 = null;
        int n2 = this.xmwen - n / 2;
        int n3 = this.ymwen - n / 2;
        PlanImage planImage = (PlanImage)this.calque.plan[this.nmwen];
        if (byArray == null) {
            if (planImage instanceof PlanImageRGB) {
                nArray = new int[n * n];
                nArray2 = new int[n * n * 8 * 8];
            } else {
                byArray = new byte[n * n];
                byArray2 = new byte[n * n * 8 * 8];
            }
        }
        if (n2 >= 0 && n3 >= 0 && n2 + n < planImage.width && n3 + n < planImage.height) {
            if (planImage instanceof PlanImageRGB) {
                PlanImageRGB planImageRGB = (PlanImageRGB)planImage;
                planImageRGB.getPixels(nArray, n2, n3, n, n);
                int n4 = -65536;
                int n5 = -16711936;
                int n6 = -16776961;
                int n7 = this.ymwen * planImageRGB.width + this.xmwen;
                byte by = planImageRGB.red != null ? planImageRGB.red[n7] : (byte)0;
                byte by2 = planImageRGB.green != null ? planImageRGB.green[n7] : (byte)0;
                byte by3 = planImageRGB.blue != null ? planImageRGB.blue[n7] : (byte)0;
                int n8 = 0xFF000000 | by << 16 | by2 << 8 | by3;
                boolean bl = this.memInv = planImageRGB.video == 1;
                if (this.memInv) {
                    n8 ^= 0xFFFFFF;
                    n4 ^= 0xFFFFFF;
                    n5 ^= 0xFFFFFF;
                    n6 ^= 0xFFFFFF;
                }
                this.memR = (n8 & 0xFF0000) >> 16;
                int n9 = this.memR * n / 255;
                n7 = 0;
                while (n7 < n9) {
                    nArray[n7] = n4;
                    ++n7;
                }
                this.memG = (n8 & 0xFF00) >> 8;
                n9 = this.memG * n / 255;
                n7 = 0;
                while (n7 < n9) {
                    nArray[n7 + n] = n5;
                    ++n7;
                }
                this.memB = n8 & 0xFF;
                n9 = this.memB * n / 255;
                n7 = 0;
                while (n7 < n9) {
                    nArray[n7 + n * 2] = n6;
                    ++n7;
                }
                this.flagRGB = true;
                int n10 = 0;
                n7 = 0;
                while (n7 < n) {
                    int n11 = n10;
                    int n12 = 0;
                    while (n12 < n) {
                        int n13 = nArray[n7 * n + n12];
                        View.bytefill(nArray2, n10, 8, n13);
                        n10 += 8;
                        ++n12;
                    }
                    n9 = 1;
                    while (n9 < 8) {
                        System.arraycopy(nArray2, n11, nArray2, n11 + n9 * n * 8, n9 * 8 * n);
                        n9 += n9;
                    }
                    n10 += 56 * n;
                    ++n7;
                }
            } else {
                planImage.getPixels(byArray, n2, n3, n, n);
                this.memX = planImage.pixels[this.ymwen * planImage.width + this.xmwen] & 0xFF;
                this.flagRGB = false;
                int n14 = 0;
                int n15 = 0;
                while (n15 < n) {
                    int n16 = n14;
                    int n17 = 0;
                    while (n17 < n) {
                        byte by = byArray[n15 * n + n17];
                        View.bytefill(byArray2, n14, 8, by);
                        n14 += 8;
                        ++n17;
                    }
                    int n18 = 1;
                    while (n18 < 8) {
                        System.arraycopy(byArray2, n16, byArray2, n16 + n18 * n * 8, n18 * 8 * n);
                        n18 += n18;
                    }
                    n14 += 56 * n;
                    ++n15;
                }
            }
        }
        try {
            if (planImage instanceof PlanImageRGB) {
                this.imgwen = this.getToolkit().createImage(new MemoryImageSource(n * 8, n * 8, nArray2, 0, n * 8));
                PlanImage.waitImage(this, this.imgwen);
            } else {
                this.imgwen = this.getToolkit().createImage(new MemoryImageSource(n * 8, n * 8, planImage.cm, byArray2, 0, n * 8));
                PlanImage.waitImage(this, this.imgwen);
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            System.gc();
            System.runFinalization();
            return;
        }
        if (this.flagwen) {
            this.imgok = true;
            this.img = this.imgwen;
            this.repaint();
        }
    }

    protected void setCM(IndexColorModel indexColorModel) {
        this.repaint();
    }

    protected void setNE(Graphics graphics, PlanImage planImage) {
        Coord coord;
        if (planImage.projd == null) {
            return;
        }
        int n = this.SIZE / 2;
        int n2 = this.SIZE / 2;
        double d = planImage.projd.c.getImgWidth() / 6.0 / ((double)planImage.width / (double)this.SIZE);
        graphics.setColor(Color.magenta);
        try {
            coord = planImage.projd.c.getImgCenter();
        }
        catch (Exception exception) {
            return;
        }
        Coord coord2 = new Coord(coord.al, coord.del + d);
        planImage.projd.getXY(coord2);
        int n3 = (int)((double)n + coord2.x - coord.x);
        int n4 = (int)((double)n2 + coord2.y - coord.y);
        this.drawFleche(graphics, n, n2, n3, n4, "N");
        coord2 = new Coord(coord.al + d, coord.del);
        planImage.projd.getXY(coord2);
        n3 = (int)((double)n + coord2.x - coord.x);
        n4 = (int)((double)n2 + coord2.y - coord.y);
        this.drawFleche(graphics, n, n2, n3, n4, "E");
    }

    protected void setViewDim(int n, int n2) {
        this.owidth = n;
        this.oheight = n2;
    }

    public void update(Graphics graphics) {
        if (Aladin.script) {
            return;
        }
        if (this.flagwen) {
            this.imgok = true;
            this.drawImgWen();
        } else {
            if (this.flagdrag) {
                this.paint(graphics);
                return;
            }
            this.imgok = this.drawImgZoom();
        }
        this.paint(graphics);
    }

    protected void wen(int n, int n2) {
        if (!this.flagwen) {
            return;
        }
        if (this.xwen == n && this.ywen == n2) {
            return;
        }
        this.xwen = n;
        this.ywen = n2;
        this.repaint();
    }

    void wenOff() {
        this.flagwen = false;
        this.repaint();
    }

    protected void wenOn() {
        this.flagwen = true;
    }

    protected double zoom() {
        return this.zoom;
    }
}

