/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Action;
import cds.aladin.Aladin;
import cds.aladin.PlanFilter;
import cds.aladin.Source;
import cds.astro.Unit;
import cds.tools.parser.Parser;
import cds.tools.parser.ParserException;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class UCDFilter {
    static final String UNDEFINED = "undefined";
    private static final String GT = ">";
    private static final String GE = ">=";
    private static final String LT = "<";
    private static final String LE = "<=";
    private static final String EQ = "=";
    private static final String NE = "!=";
    private boolean convertProblem = false;
    private int nbConvertProblem = 0;
    private int numero;
    private int position;
    private String curOperator = null;
    private Vector constraintsBlocks;
    private ConstraintsBlock block;
    protected String definition;
    boolean isValidated = false;
    boolean badSyntax = false;
    String name = null;
    Aladin a;
    PlanFilter pf;

    UCDFilter(String string, Aladin aladin, PlanFilter planFilter) {
        this.a = aladin;
        this.pf = planFilter;
        this.decodeDefinition(string);
        if (!this.badSyntax) {
            this.isValidated = true;
        }
    }

    UCDFilter(String string, String string2, Aladin aladin, PlanFilter planFilter) {
        this.a = aladin;
        this.name = string;
        this.pf = planFilter;
        this.decodeConstraints(string2);
        if (!this.badSyntax) {
            this.isValidated = true;
        }
    }

    protected void Free() {
        if (this.constraintsBlocks != null) {
            this.constraintsBlocks.removeAllElements();
            this.constraintsBlocks = null;
        }
        this.block = null;
    }

    protected void changeDefinition(String string) {
        this.isValidated = false;
        this.badSyntax = false;
        String string2 = this.definition;
        this.decodeConstraints(string);
        if (!this.badSyntax) {
            this.isValidated = true;
        }
    }

    private boolean checkExpr(double d, String string, double d2) {
        if (string.equals(EQ)) {
            return d == d2;
        }
        if (string.equals(GT)) {
            return d > d2;
        }
        if (string.equals(GE)) {
            return d >= d2;
        }
        if (string.equals(LT)) {
            return d < d2;
        }
        if (string.equals(LE)) {
            return d <= d2;
        }
        if (string.equals(NE)) {
            return d != d2;
        }
        return false;
    }

    private boolean containsOperator(String string) {
        int n = string.indexOf(NE);
        if (n >= 0) {
            this.curOperator = NE;
            this.position = n;
            return true;
        }
        n = string.indexOf(GE);
        if (n >= 0) {
            this.curOperator = GE;
            this.position = n;
            return true;
        }
        n = string.indexOf(LE);
        if (n >= 0) {
            this.curOperator = LE;
            this.position = n;
            return true;
        }
        n = string.indexOf(EQ);
        if (n >= 0) {
            this.curOperator = EQ;
            this.position = n;
            return true;
        }
        n = string.indexOf(GT);
        if (n >= 0) {
            this.curOperator = GT;
            this.position = n;
            return true;
        }
        n = string.indexOf(LT);
        if (n >= 0) {
            this.curOperator = LT;
            this.position = n;
            return true;
        }
        return false;
    }

    protected static Parser createParser(String string, Aladin aladin) throws ParserException {
        String[] stringArray = UCDFilter.getVariables(string, aladin);
        if (stringArray == null) {
            throw new ParserException();
        }
        String[] stringArray2 = new String[stringArray.length];
        int n = 0;
        while (n < stringArray2.length) {
            stringArray2[n] = UCDFilter.encodeUCD(stringArray[n]);
            ++n;
        }
        string = UCDFilter.putEncodedVariables(string, stringArray, stringArray2);
        Parser parser = new Parser(string);
        int n2 = 0;
        while (n2 < stringArray.length) {
            parser.addVar(stringArray2[n2]);
            ++n2;
        }
        try {
            parser.parseString();
        }
        catch (ParserException parserException) {
            throw new ParserException("Maybe a problem with your variables names");
        }
        return parser;
    }

    private void decodeConstraints(String string) {
        this.constraintsBlocks = new Vector();
        while (string.length() > 0 && string.charAt(0) == '\n') {
            string = string.substring(1);
        }
        this.definition = new String(string);
        string = string.replace('\t', ' ');
        String string2 = new String("");
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (UCDFilter.skipSpaces(string3).startsWith("#")) continue;
            string2 = String.valueOf(string2) + string3 + "\n";
        }
        string = string2;
        if (Action.countNbOcc('{', string) != Action.countNbOcc('}', string)) {
            this.badSyntax = true;
            this.a.message.warning("Unbalanced { }", 1);
            return;
        }
        if (Action.countNbOcc('[', string) != Action.countNbOcc(']', string)) {
            this.badSyntax = true;
            this.a.message.warning("Unbalanced [ ]", 1);
            return;
        }
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4;
            this.block = new ConstraintsBlock();
            int n5 = this.getOpeningBracket(string, n2);
            if (n5 < 0) {
                if (n2 != 0 || !string.trim().startsWith("draw")) break;
                string = "{" + string + "}";
                this.definition = "{\n" + this.definition + "\n}";
                n += 2;
                n5 = 0;
            }
            if ((n4 = this.getClosingBracket(string, n5 + 1)) < 0) {
                this.badSyntax = true;
                this.a.message.warning("Missing }", 1);
                return;
            }
            String string4 = string.replace('$', ' ').substring(n2, n5);
            String string5 = string.replace('$', ' ').substring(n5 + 1, n4);
            this.block.actions = this.getActions(string5);
            int n6 = 0;
            while (n6 < this.block.actions.length) {
                if (this.block.actions[n6].badSyntax) {
                    this.badSyntax = true;
                    return;
                }
                ++n6;
            }
            if (UCDFilter.skipSpaces(string4 = string4.replace('\n', ' ')).length() == 0) {
                string4 = "1=1";
            }
            int n7 = 0;
            String string6 = new String();
            while (n7 < string4.length()) {
                int n8 = string4.substring(n7).indexOf("\"");
                if (n8 >= 0) {
                    n3 = string4.substring((n8 += n7) + 1).indexOf("\"");
                    if (n3 >= 0) {
                        string6 = String.valueOf(string6) + UCDFilter.skipSpaces(string4.substring(n7, n8));
                        string6 = String.valueOf(string6) + string4.substring(n8, (n3 += n8 + 1) + 1);
                        n7 = n3 + 1;
                        continue;
                    }
                    string6 = String.valueOf(string6) + UCDFilter.skipSpaces(string4.substring(n7));
                    n7 = string4.length();
                    continue;
                }
                string6 = String.valueOf(string6) + UCDFilter.skipSpaces(string4.substring(n7));
                n7 = string4.length();
            }
            string4 = string6;
            String[] stringArray = this.getConditions(string4);
            this.block.valueConstraints = new Constraint[stringArray.length];
            n3 = 0;
            while (n3 < stringArray.length) {
                if (stringArray[n3].startsWith(UNDEFINED)) {
                    this.block.valueConstraints[n3] = this.decodeUndefinedConstraint(stringArray[n3]);
                } else {
                    if (!this.containsOperator(stringArray[n3])) {
                        this.a.message.warning("Error, missing comparison operator", 1);
                        this.badSyntax = true;
                        return;
                    }
                    this.block.valueConstraints[n3] = this.decodeValueConstraint(stringArray[n3]);
                }
                if (this.badSyntax) {
                    return;
                }
                ++n3;
            }
            int n9 = 0;
            while (n9 < stringArray.length) {
                string4 = UCDFilter.replace(string4, stringArray[n9], "\\" + n9);
                ++n9;
            }
            this.block.checkExpr = string4 = UCDFilter.replace(UCDFilter.replace(string4, "||", "+"), "&&", "*");
            this.constraintsBlocks.addElement(this.block);
            this.block = new ConstraintsBlock();
            n2 = n4 + 1;
        }
    }

    void decodeDefinition(String string) {
        int n = -1;
        this.name = "";
        this.definition = string;
        if (string.indexOf("}") < 0 || (n = string.indexOf("{")) < 0) {
            this.badSyntax = true;
            this.a.message.warning("The format of the whole filter definition\nis invalid", 1);
            return;
        }
        int n2 = string.indexOf("filter") + 6;
        if (n2 < 0) {
            this.badSyntax = true;
            this.a.message.warning("The format of the whole filter definition\nis invalid", 1);
            return;
        }
        this.name = UCDFilter.skipSpaces(string.substring(n2, n));
        int n3 = string.lastIndexOf("}");
        string = string.substring(n + 1, n3);
        this.decodeConstraints(string);
    }

    protected static String decodeUCD(String string) {
        String string2 = new String(string);
        string2 = string2.replace('@', '+');
        string2 = string2.replace('!', '-');
        string2 = string2.replace('~', '*');
        string2 = string2.replace('&', '/');
        return string2;
    }

    private Constraint decodeUndefinedConstraint(String string) {
        int n = string.indexOf("(");
        int n2 = string.indexOf(")");
        if (n < 0 || n2 < 0 || n > n2) {
            this.a.message.warning("Error in syntax of undefined condition", 1);
            this.badSyntax = true;
            return null;
        }
        String string2 = string.substring(n + 1, n2);
        return new Constraint(string2);
    }

    private Constraint decodeValueConstraint(String string) {
        Parser parser;
        int n = string.indexOf(this.curOperator);
        String string2 = string.substring(0, n);
        boolean bl = false;
        String string3 = this.curOperator;
        double d = 0.0;
        String string4 = null;
        String string5 = string.substring(n + this.curOperator.length(), string.length());
        Unit unit = null;
        try {
            unit = new Unit(string5);
        }
        catch (ParseException parseException) {
            if (this.curOperator.equals(EQ) || this.curOperator.equals(NE)) {
                string4 = string5;
                bl = true;
            }
            this.a.message.warning("Error during parsing of constraints, invalid number or unit format", 1);
            this.badSyntax = true;
            return null;
        }
        catch (ArithmeticException arithmeticException) {
            this.badSyntax = true;
            this.a.message.warning("Problem with the unit", 1);
            return null;
        }
        if (bl) {
            int n2 = Action.countNbOcc('\"', string4);
            if (n2 != 0 && n2 != 2) {
                this.a.message.warning("A double quote is missing", 1);
                this.badSyntax = true;
                return null;
            }
            return new Constraint(string2, string3, string4);
        }
        try {
            parser = UCDFilter.createParser(string2, this.a);
        }
        catch (ParserException parserException) {
            this.a.message.warning("Malformed expression, error\n" + parserException.getMessage(), 1);
            this.badSyntax = true;
            return null;
        }
        d = unit.value;
        if (unit.symbol.length() > 0) {
            return new Constraint(parser, string3, d, unit);
        }
        return new Constraint(parser, string3, d);
    }

    protected static String encodeUCD(String string) {
        String string2 = new String(string);
        string2 = string2.replace('+', '@');
        string2 = string2.replace('-', '!');
        string2 = string2.replace('*', '~');
        string2 = string2.replace('/', '&');
        return string2;
    }

    private Action[] getActions(String string) {
        Action[] actionArray;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        String string2 = new String("");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            while (stringTokenizer.hasMoreTokens() && Action.countNbOcc('(', string3) != Action.countNbOcc(')', string3)) {
                string3 = String.valueOf(string3) + stringTokenizer.nextToken();
            }
            string3.replace('\n', ' ');
            string2 = String.valueOf(string2) + string3 + "\n";
        }
        string = string2;
        stringTokenizer = new StringTokenizer(string, "\n;");
        int n = stringTokenizer.countTokens();
        if (n > 0) {
            actionArray = new Action[n];
            int n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                actionArray[n2] = new Action(stringTokenizer.nextToken(), this.a, this.pf);
                ++n2;
            }
        } else {
            actionArray = new Action[]{new Action("drawobject", this.a, this.pf)};
        }
        return actionArray;
    }

    private int getClosingBracket(String string, int n) {
        int n2 = n;
        int n3;
        while ((n3 = string.indexOf("}", n)) != -1) {
            String string2 = string.substring(n2, n3 + 1);
            if (Action.countNbOcc('{', string2) + 1 == Action.countNbOcc('}', string2)) {
                return n3;
            }
            n = n3 + 1;
        }
        return -1;
    }

    private String[] getConditions(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|&");
        String string2 = null;
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            int n2;
            int n3;
            String string3 = stringTokenizer.nextToken();
            String string4 = new String(string3);
            if (string3.startsWith(UNDEFINED)) {
                stringArray[n] = string3;
                ++n;
                continue;
            }
            if (string3.indexOf("\"") > 0 && (n3 = string3.indexOf("\"")) != (n2 = string3.lastIndexOf("\""))) {
                String string5 = string3.substring(n3, n2 + 1);
                string5 = string5.replace('(', 'X');
                string5 = string5.replace(')', 'X');
                string5 = string5.replace('{', 'X');
                string5 = string5.replace('}', 'X');
                string5 = string5.replace('[', 'X');
                string5 = string5.replace(']', 'X');
                string3 = String.valueOf(string4.substring(0, n3)) + string5 + string4.substring(n2 + 1);
            }
            this.containsOperator(string3);
            String string6 = string3.substring(0, this.position);
            if (string6.indexOf("(") >= 0) {
                n3 = n2 = string6.length();
                string2 = "";
                while (n3 > 0 && Action.countNbOcc(')', string2) >= Action.countNbOcc('(', string2)) {
                    string2 = string6.substring(--n3);
                }
                if (Action.countNbOcc('(', string2) > Action.countNbOcc(')', string2)) {
                    string2 = string2.substring(1);
                    ++n3;
                }
            } else {
                n3 = 0;
            }
            n2 = (n2 = string3.substring(this.position).indexOf(41)) < 0 ? string3.length() : (n2 += this.position);
            stringArray[n] = string2 = string4.substring(n3, n2);
            ++n;
        }
        return stringArray;
    }

    protected Source[] getFilteredSources(Source[] sourceArray) {
        long l = System.currentTimeMillis();
        Vector<Source> vector = new Vector<Source>();
        int n = sourceArray.length;
        this.nbConvertProblem = 0;
        Enumeration enumeration = this.constraintsBlocks.elements();
        ConstraintsBlock constraintsBlock = null;
        ConstraintsBlock[] constraintsBlockArray = new ConstraintsBlock[this.constraintsBlocks.size()];
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            constraintsBlockArray[n2] = (ConstraintsBlock)enumeration.nextElement();
            ++n2;
        }
        int n3 = sourceArray.length - 1;
        while (n3 >= 0) {
            if (n3 % 50 == 0) {
                this.pf.pourcent = 100.0 * ((double)(n - n3) / (double)n);
                if (Aladin.isSlow) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(10L);
                    }
                    catch (Exception exception) {}
                }
            }
            boolean bl = false;
            int n4 = 0;
            while (!bl && n4 < constraintsBlockArray.length) {
                constraintsBlock = constraintsBlockArray[n4];
                if (this.verifyValueConstraints(sourceArray[n3], constraintsBlock)) {
                    vector.addElement(sourceArray[n3]);
                    bl = true;
                    sourceArray[n3].isSelected[this.numero] = true;
                    sourceArray[n3].actions[this.numero] = constraintsBlock.actions;
                    sourceArray[n3].values[this.numero] = new double[sourceArray[n3].actions[this.numero].length][3];
                    int n5 = 0;
                    while (n5 < sourceArray[n3].actions[this.numero].length) {
                        sourceArray[n3].actions[this.numero][n5].computeValues(sourceArray[n3], this.numero, n5);
                        ++n5;
                    }
                } else if (this.convertProblem) {
                    ++this.nbConvertProblem;
                    bl = true;
                }
                ++n4;
            }
            if (!bl) {
                sourceArray[n3].actions[this.numero] = null;
            }
            --n3;
        }
        Object[] objectArray = new Source[vector.size()];
        vector.copyInto(objectArray);
        if (this.nbConvertProblem > 0) {
            this.a.message.warning("Warning : there were conversion problems for " + this.nbConvertProblem + " sources", 1);
        }
        long l2 = System.currentTimeMillis();
        return objectArray;
    }

    private int getOpeningBracket(String string, int n) {
        int n2;
        while (true) {
            if ((n2 = string.indexOf("{", n)) == -1) {
                return -1;
            }
            if (n2 <= 0 || string.charAt(n2 - 1) != '$') break;
            n = n2 + 1;
        }
        return n2;
    }

    private static String[] getVariables(String string, Aladin aladin) {
        Vector<String> vector = new Vector<String>();
        String string2 = null;
        while (string.length() > 0) {
            int n;
            int n2;
            int n3 = string.indexOf("[");
            int n4 = string.indexOf("{");
            if (n3 < 0 && n4 < 0) break;
            if (n4 < 0 || n3 >= 0 && n3 < n4) {
                n2 = n3;
                n = string.indexOf("]");
                string2 = string.substring(n2, n + 1);
                try {
                    while (Action.countNbOcc('[', string2) != Action.countNbOcc(']', string2)) {
                        string2 = string.substring(n2, ++n + 1);
                    }
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    aladin.message.warning("Error : unbalanced []", 1);
                    return null;
                }
            }
            n2 = n4;
            n = string.indexOf("}");
            string2 = string.substring(n2, n + 1);
            try {
                while (Action.countNbOcc('{', string2) != Action.countNbOcc('}', string2)) {
                    string2 = string.substring(n2, ++n + 1);
                }
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                aladin.message.warning("Error : unbalanced {}");
                return null;
            }
            vector.addElement(string2);
            string = string.substring(n + 1, string.length());
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private boolean match(String string, String string2) {
        if (string.indexOf("*") >= 0 || string.indexOf("?") >= 0) {
            return UCDFilter.matchMask(string, string2);
        }
        return string2.equals(string);
    }

    protected static boolean matchMask(String string, String string2) {
        string = String.valueOf(string) + '\u0000';
        string2 = String.valueOf(string2) + '\u0000';
        int n = 0;
        int n2 = 0;
        String string3 = null;
        String string4 = null;
        while (string.charAt(n2) != '\u0000' || string2.charAt(n) != '\u0000') {
            if (string.charAt(n2) == '*') {
                string3 = string.substring(++n2);
                continue;
            }
            if (string3 != null && !string3.equals(string) && string2.charAt(n) == string2.charAt(0)) {
                string4 = string2.substring(n);
            }
            if (string.charAt(n2) == string2.charAt(n) || string.charAt(n2) == '?') {
                if (string.charAt(n2) == '\u0000') {
                    if (string3 == null) {
                        return false;
                    }
                } else {
                    ++n2;
                }
                if (string2.charAt(n) == '\u0000') {
                    return false;
                }
                ++n;
                continue;
            }
            if (string3 != null) {
                string = string3;
                n2 = 0;
                if (string4 != null) {
                    string2 = string4;
                    n = 0;
                    string4 = null;
                    continue;
                }
                if (string3.charAt(0) == string2.charAt(n)) continue;
                if (string2.charAt(n) == '\u0000') {
                    return false;
                }
                ++n;
                continue;
            }
            return false;
        }
        return true;
    }

    private static String putEncodedVariables(String string, String[] stringArray, String[] stringArray2) {
        int n;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i != stringArray.length && (n = string.indexOf(stringArray[i], n2)) >= 0; ++i) {
            int n3 = n + stringArray[i].length();
            stringBuffer.append(string.substring(n2, n));
            stringBuffer.append(stringArray2[i]);
            n2 = n3;
        }
        if (n2 < string.length()) {
            stringBuffer.append(string.substring(n2, string.length()));
        }
        return stringBuffer.toString();
    }

    public static String replace(String string, String string2, String string3) {
        int n = string2.length();
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = -1;
        int n3 = 0;
        while ((n2 = string.indexOf(string2, n3)) != -1) {
            stringBuffer.append(string.substring(n3, n2));
            stringBuffer.append(string3);
            n3 = n2 + n;
        }
        stringBuffer.append(string.substring(n3));
        return stringBuffer.toString();
    }

    protected void resetActions() {
        Enumeration enumeration = this.constraintsBlocks.elements();
        ConstraintsBlock constraintsBlock = null;
        while (enumeration.hasMoreElements()) {
            constraintsBlock = (ConstraintsBlock)enumeration.nextElement();
            int n = 0;
            while (n < constraintsBlock.actions.length) {
                constraintsBlock.actions[n].reset();
                ++n;
            }
        }
    }

    protected void select(Source[] sourceArray) {
        int n;
        ConstraintsBlock constraintsBlock = null;
        Vector<Source> vector = new Vector<Source>();
        this.nbConvertProblem = 0;
        Enumeration enumeration = this.constraintsBlocks.elements();
        this.a.calque.view.deSelect();
        while (enumeration.hasMoreElements()) {
            constraintsBlock = (ConstraintsBlock)enumeration.nextElement();
            vector.removeAllElements();
            n = sourceArray.length - 1;
            while (n >= 0) {
                if (Aladin.isSlow && n % 50 == 0) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(10L);
                    }
                    catch (Exception exception) {}
                }
                if (this.verifyValueConstraints(sourceArray[n], constraintsBlock)) {
                    sourceArray[n].select = true;
                    this.a.calque.view.vselobj.addElement(sourceArray[n]);
                } else if (this.convertProblem) {
                    ++this.nbConvertProblem;
                } else {
                    vector.addElement(sourceArray[n]);
                }
                --n;
            }
            if (vector.size() <= 0) break;
            sourceArray = new Source[vector.size()];
            vector.copyInto(sourceArray);
        }
        if (vector.size() > 0) {
            n = sourceArray.length - 1;
            while (n >= 0) {
                sourceArray[n].select = false;
                --n;
            }
        }
        if (this.nbConvertProblem > 0) {
            this.a.message.warning("Warning : there were conversion problems for " + this.nbConvertProblem + " sources", 1);
        }
    }

    void setNumero(int n) {
        this.numero = n;
    }

    public static String skipSpaces(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ", false);
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append(stringTokenizer.nextToken());
        }
        return stringBuffer.toString();
    }

    private boolean verifyOneValueConstraint(Source source, Constraint constraint) {
        double d = 0.0;
        String string = null;
        this.convertProblem = false;
        if (constraint.stringConstraint) {
            String string2 = constraint.ucd.substring(1, constraint.ucd.length() - 1);
            int n = constraint.ucd.startsWith("[") ? source.findUCD(UCDFilter.decodeUCD(string2).toUpperCase()) : source.findColumn(UCDFilter.decodeUCD(string2));
            if (n < 0) {
                return false;
            }
            string = source.getValue(n);
            if (string == null) {
                return false;
            }
            if (constraint.operator.equals(EQ)) {
                return this.match(constraint.strValue, string);
            }
            if (constraint.operator.equals(NE)) {
                return this.match(constraint.strValue, string) ^ true;
            }
        } else {
            if (constraint.undefinedConstraint) {
                String string3 = constraint.ucd.substring(1, constraint.ucd.length() - 1);
                if (constraint.ucd.startsWith("[")) {
                    return source.findUCD(UCDFilter.decodeUCD(string3).toUpperCase()) < 0;
                }
                return source.findColumn(UCDFilter.decodeUCD(string3)) < 0;
            }
            if (!Action.setAllVariables(constraint.parser, source, false, constraint.convertUnit)) {
                return false;
            }
            d = constraint.parser.eval();
            if (constraint.convertUnit) {
                Unit unit;
                try {
                    unit = new Unit(constraint.unit);
                    unit.convert(constraint.parser.evalUnit());
                }
                catch (ArithmeticException arithmeticException) {
                    System.err.println(arithmeticException);
                    this.convertProblem = true;
                    return false;
                }
                catch (ParseException parseException) {
                    System.err.println(parseException);
                    this.convertProblem = true;
                    return false;
                }
                d = unit.value;
            } else {
                d = constraint.parser.eval();
            }
            return this.checkExpr(d, constraint.operator, constraint.value);
        }
        return true;
    }

    private boolean verifyValueConstraints(Source source, ConstraintsBlock constraintsBlock) {
        Constraint constraint = null;
        if (constraintsBlock.valueConstraints == null) {
            return true;
        }
        int n = constraintsBlock.valueConstraints.length;
        boolean[] blArray = new boolean[n];
        int n2 = 0;
        while (n2 < n) {
            constraint = constraintsBlock.valueConstraints[n2];
            blArray[n2] = this.verifyOneValueConstraint(source, constraint);
            if (this.convertProblem) {
                return false;
            }
            ++n2;
        }
        String string = "1";
        String string2 = "0";
        String string3 = new String(constraintsBlock.checkExpr);
        n2 = 0;
        while (n2 < n) {
            String string4 = blArray[n2] ? "1" : "0";
            string3 = UCDFilter.replace(string3, "\\" + n2, string4);
            ++n2;
        }
        Parser parser = new Parser(string3);
        parser.parseString();
        return parser.eval() > 0.0;
    }

    class Constraint {
        Parser parser;
        double value;
        Unit unit;
        String operator;
        boolean stringConstraint;
        boolean convertUnit = false;
        boolean undefinedConstraint = false;
        String strValue = null;
        String ucd = null;

        Constraint(Parser parser, String string, double d) {
            this.parser = parser;
            this.operator = string;
            this.value = d;
            this.stringConstraint = false;
        }

        Constraint(Parser parser, String string, double d, Unit unit) {
            this(parser, string, d);
            this.unit = unit;
            this.convertUnit = true;
        }

        Constraint(String string) {
            this.ucd = string;
            this.undefinedConstraint = true;
        }

        Constraint(String string, String string2, String string3) {
            this.ucd = string;
            this.operator = string2;
            this.strValue = string3;
            this.stringConstraint = true;
            if (string3.length() > 0 && string3.charAt(0) == '\"' && string3.charAt(string3.length() - 1) == '\"') {
                this.strValue = string3.substring(1, string3.length() - 1);
            }
        }
    }

    class ConstraintsBlock {
        Action[] actions = null;
        Constraint[] valueConstraints;
        String checkExpr;

        ConstraintsBlock() {
        }
    }
}

