/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.AladinServer;
import cds.aladin.Coord;
import cds.aladin.Glu;
import cds.aladin.MetaDataTree;
import cds.aladin.MyLabel;
import cds.aladin.PlanImage;
import cds.aladin.ResourceNode;
import cds.aladin.Server;
import cds.aladin.ServerDialog;
import cds.aladin.TreeBuilder;
import cds.aladin.TreeLoader;
import cds.aladin.View;
import cds.aladin.VizieRServer;
import cds.astro.Astroframe;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.StringTokenizer;

public final class TreeView
extends Frame
implements Runnable,
WindowListener {
    static final String NOM = "Tree View";
    private static final String WERR = "Error";
    private static final String SUBMIT = "Submit";
    private static final String RESET = "Reset";
    MetaDataTree rt;
    ResourceNode root;
    ResourceNode catRootNode;
    ScrollPane scrollTree;
    ScrollPane scrollInfo;
    private static final int SCROLL_TREE_WIDTH = 320;
    private static final int SCROLL_INFO_WIDTH = 360;
    Panel infoPanel;
    Thread thread;
    TextField radius;
    TextField centerCutOut;
    private Button buildTree;
    private static int nbRunningThread = 0;
    TreeLoader treeLoader;
    Aladin aladin;
    private ResourceNode parentT;
    private URL urlT = null;
    private String targetT;
    private String radiusT;
    private Server serverT;
    private String serverNameT;
    private ResourceNode parentNodeT;
    boolean lock = false;

    protected TreeView(Aladin aladin) {
        super("Tree view");
        ((Component)this).setSize(800, 600);
        ((Component)this).setBackground(Aladin.BKGD);
        this.setLayout(new BorderLayout(5, 5));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 0;
        this.aladin = aladin;
        Panel panel = new Panel();
        panel.setLayout(gridBagLayout);
        this.treeLoader = new TreeLoader(this.aladin);
        this.addWindowListener(this);
        this.titrePanel(panel, "Metadata Tree", gridBagLayout, gridBagConstraints);
        this.scrollTree = new ScrollPane(0);
        this.scrollTree.setBackground(Aladin.LGRAY);
        this.scrollTree.setSize(320, this.getSize().height - 70);
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 3.0;
        gridBagLayout.setConstraints(this.scrollTree, gridBagConstraints);
        panel.add(this.scrollTree);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        this.centerCutOut = new TextField(15);
        TreeView.addCouple(panel, "Cutout/image center", this.centerCutOut, new Label(""), gridBagLayout, gridBagConstraints);
        this.radius = new TextField("10 arcmin", 15);
        this.buildTree = new Button("Build tree");
        this.buildTree.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TreeView.this.buildTree();
            }
        });
        TreeView.addCouple(panel, "Radius", this.radius, this.buildTree, gridBagLayout, gridBagConstraints);
        this.infoPanel = new Panel();
        this.infoPanel.setBackground(Aladin.LGRAY);
        this.scrollInfo = new ScrollPane(0);
        this.scrollInfo.add(this.infoPanel);
        this.scrollInfo.setSize(360, this.getSize().height - 120);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 0;
        gridBagLayout.setConstraints(this.scrollInfo, gridBagConstraints);
        panel.add(this.scrollInfo);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        ResourceNode resourceNode = new ResourceNode("root");
        resourceNode.hide = true;
        resourceNode.isOpen = true;
        this.rt = new MetaDataTree(resourceNode, aladin, this.scrollTree);
        this.scrollTree.add(this.rt);
        this.add((Component)panel, "Center");
        this.add((Component)this.buttonPanel(), "South");
    }

    public boolean action(Event event, Object object) {
        if (object.equals(SUBMIT)) {
            this.submit();
        } else if (object.equals(RESET)) {
            this.reset();
        }
        return true;
    }

    protected void addBranch(String string, Server server) {
        this.addBranch(string, "0", server);
    }

    protected void addBranch(String string, String string2, Server server) {
        string = string.trim();
        ResourceNode resourceNode = this.getTargetNode(string);
        this.lock();
        this.parentT = resourceNode;
        this.targetT = string;
        this.radiusT = string2;
        this.serverT = server;
        this.thread = new Thread(this);
        this.thread.start();
    }

    protected void addBranch(URL uRL) {
        TreeBuilder treeBuilder = new TreeBuilder(uRL, 1, 0, null);
        String string = treeBuilder.searchTarget();
        ResourceNode resourceNode = string != null ? this.getTargetNode(string) : (ResourceNode)this.rt.getRootNode();
        this.lock();
        this.parentT = resourceNode;
        this.urlT = uRL;
        this.serverT = null;
        this.thread = new Thread(this);
        this.thread.start();
    }

    protected static void addCouple(Panel panel, String string, Component component, Component component2, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        MyLabel myLabel = string != null ? new MyLabel(string, 2, Aladin.LBOLD) : new MyLabel();
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(myLabel, gridBagConstraints);
        panel.add(myLabel);
        if (component2 == null) {
            gridBagConstraints.gridwidth = 0;
        }
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        panel.add(component);
        gridBagConstraints.fill = 0;
        if (component2 != null) {
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 10, 0, 10);
            gridBagLayout.setConstraints(component2, gridBagConstraints);
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.anchor = 17;
            panel.add(component2);
        }
    }

    protected void addSIABranch(String string, String string2, String string3, String string4) {
        double d = Server.getRadius(string3) / 60.0;
        String string5 = this.resolveTarget(string2);
        if (string5 == null) {
            this.aladin.message.warning("Unknown object " + string2, 1);
            return;
        }
        String string6 = TreeView.getDeciCoord(string5).replace(' ', ',');
        URL uRL = null;
        try {
            uRL = new URL(String.valueOf(string) + "?POS=" + string6 + "&SIZE=" + d + "&FORMAT=image/fits");
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return;
        }
        Aladin.trace(3, "Building SIA URL : " + uRL);
        ResourceNode resourceNode = this.getTargetNode(string2);
        this.lock();
        this.parentT = resourceNode;
        this.urlT = uRL;
        this.serverT = null;
        this.serverNameT = string4;
        this.thread = new Thread(this);
        this.thread.start();
    }

    private void beginThread() {
        Aladin.makeCursor(this, 1);
        ++nbRunningThread;
    }

    private void buildTree() {
        this.treeLoader.show();
        this.treeLoader.toFront();
    }

    private URL buildURL(String string, String string2, Server server) {
        URL uRL;
        block4: {
            double d = Server.getRadius(string2) / 60.0;
            try {
                if (server instanceof AladinServer) {
                    uRL = new URL("http://aladin.u-strasbg.fr/cgi-bin/nph-HTTP.cgi?out=qualifier&position=" + URLEncoder.encode(TreeView.getDeciCoord(string)) + "&radius=" + d + "&mode=xml_votable_idha");
                    break block4;
                }
                if (server instanceof VizieRServer) {
                    uRL = new URL("http://vizier.u-strasbg.fr/cgi-bin/votable/-w?-meta&-c=" + URLEncoder.encode(string) + "&-c.r=" + d + "&-c.u=degree&-c.eq=J2000");
                    break block4;
                }
                return null;
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
                Aladin.trace(1, "URL could not be built");
                return null;
            }
        }
        Aladin.trace(3, "Building url " + uRL);
        return uRL;
    }

    private Panel buttonPanel() {
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(1));
        panel.setFont(Aladin.LBOLD);
        panel.add(new Button(SUBMIT));
        panel.add(new Button(RESET));
        return panel;
    }

    protected int creatAladinPlane(String string, String string2, String string3, String string4, String string5, String string6) {
        return this.creatAladinPlane(string, string2, string3, string4, string5, string6, "", null);
    }

    protected int creatAladinPlane(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        if (string2 == null) {
            string2 = "JPEG";
        }
        if (string3 == null) {
            string3 = "FULL";
        }
        String string9 = this.getSurvey(string4);
        String string10 = this.getColor(string4);
        Coord coord = null;
        try {
            coord = new Coord(string);
        }
        catch (Exception exception) {}
        String string11 = String.valueOf(coord.al) + " " + coord.del;
        Astroframe astroframe = new Astroframe();
        try {
            astroframe.set(string);
            astroframe.setPrecision(6);
            string = astroframe.toString(" ");
        }
        catch (Exception exception) {}
        String string12 = String.valueOf(Glu.quote(string11)) + " " + Glu.quote(string9) + " " + Glu.quote(string10) + " " + Glu.quote(string7);
        URL uRL = this.aladin.glu.getURL("Image.test", string12);
        if (uRL == null) {
            this.aladin.message.warning(WERR, 1);
            return -1;
        }
        if (string5 == null) {
            string5 = TreeView.getPlanLabel(string3, String.valueOf(string4) + " ___");
            string5 = String.valueOf(string5) + this.getLastNumber(string8);
        }
        if (string6 == null) {
            string6 = "data online provided by CDS";
        }
        return this.aladin.calque.newPlanImage(uRL, 0, string5, string, string4, string6, PlanImage.getFmt(string2), PlanImage.getRes(string3), false, null);
    }

    protected int creatAladinPlane(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9) {
        String string10 = null;
        if (string8 != null) {
            string10 = TreeView.getPlanLabel(string3, String.valueOf(string4) + ".ep" + string8.substring(5) + " ___");
            string10 = String.valueOf(string10) + this.getLastNumber(string9);
        }
        return this.creatAladinPlane(string, string2, string3, string4, string10, string6, string7, string9);
    }

    protected int creatCatPlane(String string, String string2, String string3) {
        String string4 = new Double(Server.getRadius(this.radius.getText())).toString();
        return ((VizieRServer)this.aladin.dialog.server[ServerDialog.VIZIER]).creatVizieRPlane(string2, string4, string, string3, "");
    }

    private ResourceNode createNewBranch(URL uRL, InputStream inputStream, String string, String string2, Server server, String string3, boolean bl) {
        String string4 = null;
        if (uRL == null && inputStream == null && (string4 = this.resolveTarget(string)) == null) {
            this.aladin.message.warning("Unknown object " + string, 1);
            if (bl) {
                this.endThread();
            }
            return null;
        }
        ResourceNode resourceNode = uRL == null && inputStream == null ? this.createNode(string4, string2, server) : this.createNode(uRL, inputStream, server);
        if (resourceNode == null) {
            Aladin.trace(3, "The new branch of the tree could not be built");
            if (bl) {
                this.endThread();
            }
            return null;
        }
        if (string3 == null) {
            if (server instanceof AladinServer) {
                string3 = "Aladin";
            } else if (server instanceof VizieRServer) {
                string3 = "VizieR";
            } else if (uRL == null) {
                string3 = "";
            } else {
                string3 = uRL.toString();
                string3 = "..." + string3.substring(Math.max(0, string3.length() - 20));
            }
        }
        resourceNode.name = string3;
        return resourceNode;
    }

    private ResourceNode createNode(String string, String string2, Server server) {
        URL uRL = this.buildURL(string, string2, server);
        return this.createNode(uRL, null, server);
    }

    private ResourceNode createNode(URL uRL, InputStream inputStream, Server server) {
        if (uRL == null && inputStream == null) {
            return null;
        }
        int n = -1;
        if (server instanceof AladinServer) {
            n = 0;
        } else if (server instanceof VizieRServer) {
            n = 1;
        }
        Aladin.trace(1, "Updating the data tree view, using URL " + uRL);
        ResourceNode resourceNode = null;
        try {
            resourceNode = uRL != null ? new TreeBuilder(uRL, 1, n, server).build() : new TreeBuilder(inputStream, 1, n, server).build();
            resourceNode.hide = false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return resourceNode;
    }

    private void endThread() {
        if (--nbRunningThread == 0) {
            Aladin.makeCursor(this, 0);
        }
    }

    private String getColor(String string) {
        return string.substring(string.indexOf(" ") + 1);
    }

    static String getDeciCoord(String string) {
        Coord coord;
        try {
            coord = new Coord(string);
        }
        catch (Exception exception) {
            return "";
        }
        return String.valueOf(coord.al) + " " + coord.del;
    }

    private String getLastNumber(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        String string2 = new String();
        int n = string.length() - 1;
        while (Character.isDigit(string.charAt(n)) && n >= 0) {
            string2 = String.valueOf(string.charAt(n)) + string2;
            --n;
        }
        if (string2.length() > 0) {
            return "." + string2;
        }
        return "";
    }

    protected static String getPlanLabel(int n, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = new String[3];
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n2 = 0;
        while (n2 < 3) {
            stringArray[n2] = stringTokenizer.nextToken();
            ++n2;
        }
        if (stringArray[0].indexOf("2MASS") >= 0) {
            stringArray[2] = stringArray[0];
            stringArray[0] = null;
        }
        if (n == 3) {
            stringBuffer.append("Pl-");
        } else if (n == 2) {
            stringBuffer.append("Lw-");
        }
        if (stringArray[2].equals("STScI") || stringArray[2].equals("STSCI")) {
            stringBuffer.append("DSS1");
        } else if (!stringArray[2].startsWith("___")) {
            stringBuffer.append(String.valueOf(stringArray[2]) + ".");
        }
        stringBuffer.append(stringArray[1]);
        if (stringArray[0] != null) {
            stringBuffer.append("." + (stringArray[0].startsWith("GOODS-") ? stringArray[0].substring(6) : stringArray[0]));
        }
        return stringBuffer.toString();
    }

    protected static String getPlanLabel(String string, String string2) {
        return TreeView.getPlanLabel(PlanImage.getRes(string), string2);
    }

    private String getSurvey(String string) {
        return string.substring(0, string.indexOf(" "));
    }

    private ResourceNode getTargetNode(String string) {
        ResourceNode resourceNode = (ResourceNode)this.rt.searchNodeByName(string);
        if (resourceNode == null) {
            resourceNode = new ResourceNode(string);
            this.rt.getRootNode().addChild(resourceNode);
            this.rt.traverseTree();
        }
        resourceNode.isOpen = true;
        return resourceNode;
    }

    void lock() {
        try {
            while (this.lock) {
                Thread.sleep(100L);
            }
        }
        catch (Exception exception) {}
        this.setlock(true);
    }

    protected void reset() {
        this.rt.resetCb();
    }

    private String resolveTarget(String string) {
        Coord coord;
        try {
            coord = !View.notCoord(string) ? new Coord(string) : this.aladin.view.getSimbad(string);
        }
        catch (Exception exception) {
            return null;
        }
        return coord.getSexa(":");
    }

    public void run() {
        this.beginThread();
        URL uRL = this.urlT;
        this.urlT = null;
        ResourceNode resourceNode = this.parentT;
        this.parentT = null;
        String string = this.targetT;
        this.targetT = null;
        String string2 = this.radiusT;
        this.radiusT = null;
        Server server = this.serverT;
        this.serverT = null;
        String string3 = this.serverNameT;
        this.serverNameT = null;
        this.unlock();
        ResourceNode resourceNode2 = this.createNewBranch(uRL, null, string, string2, server, string3, true);
        this.rt.addNode(resourceNode, resourceNode2);
        this.endThread();
    }

    synchronized void setlock(boolean bl) {
        this.lock = bl;
    }

    public void submit() {
        this.rt.loadSelected();
    }

    protected void titrePanel(Panel panel, String string, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        Label label = new Label(string, 1);
        label.setFont(Aladin.LLITALIC);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        panel.add(label);
    }

    void unlock() {
        this.setlock(false);
    }

    protected void updateTarget(String string) {
        this.centerCutOut.setText(string);
        this.treeLoader.updateTF(string);
    }

    public void updateTree(InputStream inputStream, MetaDataTree metaDataTree, Server server, String string) {
        ResourceNode resourceNode = this.createNewBranch(null, inputStream, null, null, server, null, false);
        this.rt.addNode(this.getTargetNode(string), resourceNode);
        ResourceNode resourceNode2 = (ResourceNode)resourceNode.clone();
        resourceNode2.hide = true;
        metaDataTree.setRoot(resourceNode2);
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.dispose();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

