/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Calque;
import cds.aladin.Cote;
import cds.aladin.FilterProperties;
import cds.aladin.FrameCM;
import cds.aladin.FrameContour;
import cds.aladin.FrameRGB;
import cds.aladin.Ligne;
import cds.aladin.Objet;
import cds.aladin.Plan;
import cds.aladin.PlanContour;
import cds.aladin.PlanImageRGB;
import cds.aladin.Properties;
import cds.aladin.Repere;
import cds.aladin.Texte;
import cds.aladin.Tool;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;

public final class ToolBox
extends Canvas {
    static int NUMBERTOOL = 0;
    static final int SELECT = 0;
    static final int DRAW = 1;
    static final int TEXT = 2;
    static final int MARK = 3;
    static final int DIST = 4;
    static final int DEL = 5;
    static final int WEN = 6;
    static final int PROP = 7;
    static final int ZOOM = 8;
    static final int COLOR = 9;
    static final int BNOTE = 10;
    static final int RGB = 11;
    static final int CONTOUR = 12;
    static final int FILTER = 13;
    static int NBTOOL = 14;
    static int[] hide = new int[0];
    static int[] sort;
    static int[] to;
    static int[] exc;
    static int[] forTool;
    static int[] up;
    static int[] imgmode;
    static int[] contourmode;
    static int[] toolmode;
    static int[] catmode;
    static int[] fieldmode;
    static int W;
    static int HMIN;
    static int HREC;
    static int L;
    static int ICONEGAP;
    static String ICONEBAR;
    static String WDEL;
    Aladin aladin;
    Calque calque;
    int ws;
    int hs;
    int nc;
    int nb;
    int H;
    Tool[] tool;
    Image img;
    Graphics g;
    boolean flagDim = false;
    boolean flagupdate;
    boolean flagDelAll;
    int deltaY = 0;
    int firstY = 0;
    int firstX = 0;
    private int oc = 0;

    static {
        int[] nArray = new int[14];
        nArray[1] = 7;
        nArray[2] = 1;
        nArray[3] = 2;
        nArray[4] = 3;
        nArray[5] = 4;
        nArray[6] = 13;
        nArray[7] = 11;
        nArray[8] = 12;
        nArray[9] = 9;
        nArray[10] = 8;
        nArray[11] = 6;
        nArray[12] = 5;
        nArray[13] = 10;
        sort = nArray;
        int[] nArray2 = new int[7];
        nArray2[1] = 1;
        nArray2[2] = 2;
        nArray2[3] = 3;
        nArray2[4] = 4;
        nArray2[5] = 8;
        nArray2[6] = 7;
        to = nArray2;
        int[] nArray3 = new int[6];
        nArray3[1] = 1;
        nArray3[2] = 2;
        nArray3[3] = 3;
        nArray3[4] = 4;
        nArray3[5] = 8;
        exc = nArray3;
        forTool = new int[]{1, 2, 3, 4};
        up = new int[]{10, 5, 11, 13};
        imgmode = new int[]{1, 2, 3, 4};
        contourmode = new int[]{9, 1, 2, 3, 4};
        toolmode = new int[]{9};
        catmode = new int[]{1, 2, 3, 4};
        fieldmode = new int[]{1, 2, 3, 4, 9};
        W = 34;
        HMIN = W - 5;
        HREC = W;
        L = 3;
        ICONEGAP = 12;
        ICONEBAR = "Change the screen proportions (drag it)";
        WDEL = "Do you really want to delete selected planes ?";
    }

    protected ToolBox(Aladin aladin) {
        this.aladin = aladin;
        this.setBackground(Aladin.BKGD);
        this.ws = this.calcConf(500 - ICONEGAP);
        this.flagupdate = false;
    }

    protected String Help(int n) {
        String string = "!Tool bar\nDisplay all of Aladin Java's tools. Depending on the selected plane in the ``plane stack'', only the tools adaptated to this plane type will be activated. If there are several ``selected planes'', only tools adaptated to all of them will be activated. In each case if the button is up, the tool can be selected. If the button is down, the tool is currently selected.\n";
        String string2 = "!Proportion modifier\nBy dragging the little square, you can alterthe relative proportions of the ``View frame'' and  ``Measurement frame''\n \nNota: This function is not available with Netscape 3.0";
        if (n == -1) {
            return string;
        }
        if (n == -2) {
            return string2;
        }
        return String.valueOf(string) + "!Tool: " + Tool.label[n] + "\n" + Tool.help[n] + "\n";
    }

    protected void afterYes() {
        this.calque.FreeSet();
        this.aladin.dialog.setGrab();
    }

    protected int calcConf(int n) {
        int n2 = 0;
        int n3 = NBTOOL - hide.length;
        this.nc = 1;
        while (this.nc < 6) {
            n2 = n3 / this.nc;
            if (n3 % this.nc != 0) {
                ++n2;
            }
            this.H = n / n2;
            if (this.H >= HMIN) break;
            ++this.nc;
        }
        this.H = HREC;
        while (this.H > HMIN) {
            if (this.H * n2 < n) break;
            --this.H;
        }
        this.nb = n / this.H;
        this.ws = this.ws = this.nc * W;
        this.hs = n + ICONEGAP;
        this.resize(this.ws, n);
        this.aladin.validate();
        Tool.resize(W, this.H);
        return this.ws;
    }

    private void defaultCursor() {
        this.makeCursor(0);
    }

    protected void drawButton(int n, int n2, Graphics graphics) {
        if (this.isHide(n2)) {
            return;
        }
        int n3 = n / this.nb * W;
        int n4 = n % this.nb * this.H;
        if (this.flagupdate) {
            this.tool[n2].updateIcone(graphics, n3, n4);
        } else {
            this.tool[n2].drawIcone(graphics, n3, n4);
        }
    }

    protected void drawIconeProp(Graphics graphics) {
        int n = this.ws / 2;
        int n2 = this.hs - L - 3;
        int[] nArray = new int[]{n, n - L, n + L, n};
        int[] nArray2 = new int[]{n2 - L - 2, n2 - 2, n2 - 2, n2 - L - 2};
        int[] nArray3 = new int[]{n2 + L + 2, n2 + 2, n2 + 2, n2 + L + 2};
        graphics.setColor(Color.black);
        graphics.drawLine(0, n2, this.ws, n2);
        graphics.fillPolygon(nArray, nArray2, nArray.length);
        graphics.fillPolygon(nArray, nArray3, nArray.length);
        graphics.drawPolygon(nArray, nArray2, nArray.length);
        graphics.drawPolygon(nArray, nArray3, nArray.length);
    }

    protected int getNTool(int n, int n2) {
        int n3 = n / W;
        int n4 = n2 / this.H + n3 * this.nb;
        if (n4 < NBTOOL && !this.isHide(sort[n4])) {
            return sort[n4];
        }
        return -1;
    }

    protected int getTool() {
        int n = 0;
        while (n < to.length) {
            if (this.tool[ToolBox.to[n]].mode == -1) {
                return to[n];
            }
            ++n;
        }
        return -1;
    }

    private void handCursor() {
        this.makeCursor(2);
    }

    public boolean handleEvent(Event event) {
        if (Aladin.inHelp) {
            if (event.id == 503) {
                return super.handleEvent(event);
            }
            return true;
        }
        return super.handleEvent(event);
    }

    protected void init(Calque calque) {
        this.calque = this.aladin.calque;
        this.tool = new Tool[NBTOOL];
        int n = 0;
        while (n < NBTOOL) {
            this.tool[n] = new Tool(n, this.aladin);
            ++n;
        }
    }

    protected boolean isExcTool(int n) {
        int n2 = 0;
        while (n2 < exc.length) {
            if (n == exc[n2]) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected static boolean isForTool(int n) {
        int n2 = 0;
        while (n2 < forTool.length) {
            if (n == forTool[n2]) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected boolean isHide(int n) {
        int n2 = 0;
        while (n2 < hide.length) {
            if (n == hide[n2]) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void makeCursor(int n) {
        if (this.oc == n) {
            return;
        }
        Aladin.makeCursor(this, n);
        this.oc = n;
    }

    public boolean mouseDown(Event event, int n, int n2) {
        this.aladin.message.hide();
        if (n2 >= this.hs - L - 1 - L && n2 <= this.hs - 1 && n >= this.ws / 2 - L && n <= this.ws / 2 + L) {
            this.flagDim = true;
            this.deltaY = this.firstY = n2;
            this.firstX = n;
            this.repaint();
            return true;
        }
        int n3 = this.getNTool(n, n2);
        if (n3 < 0) {
            return false;
        }
        this.waitCursor();
        if (n3 == 0 && this.tool[n3].mode == -1 && !this.calque.view.hasSelectedObjet()) {
            int n4 = this.calque.getFirstSelected();
            if (n4 >= 0 && this.calque.plan[n4].type == 2) {
                this.calque.view.selectAllInPlan(this.calque.plan[n4]);
            }
            return true;
        }
        if (ToolBox.isForTool(n3) && (this.tool[n3].mode == 0 || event.shiftDown())) {
            this.calque.newPlanTool("Drawing " + ++NUMBERTOOL);
            this.tool[n3].mode = 1;
            this.tool[7].mode = 1;
        }
        if (this.isExcTool(n3)) {
            if (this.tool[n3].mode == 1) {
                int n5 = 0;
                while (n5 < exc.length) {
                    if (this.tool[ToolBox.exc[n5]].mode == -1) {
                        this.tool[exc[n5]].Push();
                    }
                    ++n5;
                }
            } else if (this.tool[n3].mode == -1 && n3 != 0) {
                this.tool[0].Push();
            }
        }
        if (n3 == 0 && this.tool[n3].mode == -1) {
            this.calque.view.unSelect();
            return true;
        }
        this.tool[n3].Push();
        if (n3 == 13) {
            this.tool[n3].mode = -1;
        }
        this.repaint();
        return true;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        if (!this.flagDim) {
            return true;
        }
        this.deltaY = n2;
        this.repaint();
        return true;
    }

    public boolean mouseExit(Event event, int n, int n2) {
        Aladin.makeCursor(this, 0);
        return true;
    }

    public boolean mouseMove(Event event, int n, int n2) {
        if (Aladin.inHelp) {
            int n3 = n2 >= this.hs - 2 * L ? -2 : this.getNTool(n, n2);
            this.aladin.help.setText(this.Help(n3));
            return true;
        }
        if (n2 >= this.hs - L - L - 1) {
            this.resizeCursor();
            this.aladin.status.setText(ICONEBAR);
            return true;
        }
        int n4 = this.getNTool(n, n2);
        if (n4 < 0) {
            return true;
        }
        if (this.tool[n4].mode != 0 || ToolBox.isForTool(n4)) {
            this.handCursor();
        } else {
            this.defaultCursor();
        }
        this.tool[n4].getInfo();
        return true;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        if (this.flagDim) {
            Aladin aladin = this.aladin;
            this.flagDim = false;
            this.deltaY -= this.firstY;
            if (this.deltaY == 0) {
                this.repaint();
                this.handCursor();
                return true;
            }
            this.resize(this.size().width, this.size().height + this.deltaY);
            aladin.view.resize(aladin.view.size().width, aladin.view.size().height + this.deltaY);
            aladin.calque.resize(aladin.calque.size().width, aladin.calque.size().height + this.deltaY);
            aladin.mesure.mcanvas.resize(aladin.mesure.mcanvas.size().width, aladin.mesure.mcanvas.size().height - this.deltaY);
            aladin.mesure.scrollV.resize(aladin.mesure.scrollV.size().width, aladin.mesure.scrollV.size().height - this.deltaY);
            aladin.mesure.resize(aladin.mesure.size().width, aladin.mesure.size().height - this.deltaY);
            this.deltaY = 0;
            aladin.validate();
            aladin.repaint();
            this.handCursor();
            return true;
        }
        int n3 = this.getNTool(n, n2);
        if (n3 < 0) {
            return false;
        }
        if (n3 == 7) {
            if (this.aladin.properties == null) {
                Aladin.trace(1, "Creating the Propertie window");
                this.aladin.properties = new Properties(this.aladin);
            }
            this.aladin.properties.majProp();
            this.handCursor();
            return true;
        }
        if (n3 == 9) {
            if (this.aladin.frameCM == null) {
                Aladin.trace(1, "Creating the colormap window");
                this.aladin.frameCM = new FrameCM(this.aladin);
            }
            this.aladin.frameCM.majCM();
            this.handCursor();
            return true;
        }
        if (n3 == 11) {
            if (this.aladin.frameRGB == null) {
                Aladin.trace(1, "Creating the RGB window");
                this.aladin.frameRGB = new FrameRGB(this.aladin);
            }
            this.aladin.frameRGB.majRGB();
            this.handCursor();
            return true;
        }
        if (n3 == 12) {
            if (this.aladin.frameContour == null) {
                Aladin.trace(1, "Creating the Contour window");
                this.aladin.frameContour = new FrameContour(this.aladin);
            }
            this.aladin.frameContour.majContour();
            this.handCursor();
            return true;
        }
        if (n3 == 13) {
            int n4;
            boolean bl;
            if (this.aladin.filterProperties == null) {
                Aladin.trace(1, "Creating the FilterProperties window");
                this.aladin.filterProperties = new FilterProperties(this.aladin);
            }
            if ((bl = ((n4 = this.aladin.calque.getFirstSelected()) >= 0 && this.aladin.calque.plan[n4].type == 6) ^ true) || this.aladin.filterProperties.isShowing()) {
                int n5 = this.aladin.view.calque.newPlanFilter();
            }
            this.tool[13].mode = -1;
            this.aladin.calque.repaint();
            this.aladin.filterProperties.majProp();
            this.handCursor();
            return true;
        }
        int n6 = 0;
        while (n6 < up.length && up[n6] != n3) {
            ++n6;
        }
        if (n6 == up.length) {
            this.handCursor();
            return true;
        }
        if (this.tool[n3].mode != -1) {
            this.handCursor();
            return true;
        }
        switch (n3) {
            case 10: {
                if (event.shiftDown()) {
                    this.aladin.pad.reset();
                }
                if (this.calque.view.hasSelectedObjet()) {
                    this.calque.view.selObjToPad();
                }
                this.aladin.pad.setText(this.aladin.mesure.getText());
                this.aladin.pad.show();
                this.aladin.pad.toFront();
                break;
            }
            case 5: {
                if (this.calque.view.isDelSelObjet()) {
                    this.calque.view.delSelObjet();
                    return true;
                }
                if (event.shiftDown()) {
                    this.calque.FreeAll();
                    this.aladin.localisation.setText("");
                    this.aladin.dialog.setGrab();
                } else if (Aladin.STANDALONE) {
                    this.afterYes();
                } else {
                    this.aladin.message.yesOrNo(this, WDEL);
                }
                if (this.tool[5].mode != 1) break;
                this.tool[5].mode = -1;
            }
        }
        this.tool[n3].Push();
        this.repaint();
        this.handCursor();
        return true;
    }

    protected Objet newTool(Plan plan, double d, double d2) {
        int n = this.getTool();
        switch (n) {
            case 1: {
                return new Ligne(plan, d, d2);
            }
            case 2: {
                return new Texte(plan, d, d2);
            }
            case 3: {
                return new Repere(plan, d, d2);
            }
            case 4: {
                return new Cote(plan, d, d2);
            }
        }
        return null;
    }

    public void paint(Graphics graphics) {
        int n = this.size().width;
        int n2 = this.size().height;
        if (this.img == null || this.ws != n || this.hs != n2) {
            this.update(graphics);
            return;
        }
        graphics.drawImage(this.img, 0, 0, null);
        if (this.flagDim) {
            graphics.setColor(Color.green);
            graphics.drawLine(0, this.deltaY, this.ws, this.deltaY);
            graphics.drawLine(0, this.deltaY + 1, this.ws, this.deltaY + 1);
        }
    }

    private void resizeCursor() {
        this.makeCursor(5);
    }

    protected void toolMode() {
        Plan[] planArray = this.calque.plan;
        int[] nArray = new int[NBTOOL];
        int[] nArray2 = new int[NBTOOL];
        int[] nArray3 = new int[]{};
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = -1;
        boolean bl = false;
        int n5 = 0;
        while (n5 < nArray.length) {
            nArray[n5] = this.tool[n5].mode;
            nArray2[n5] = 1;
            ++n5;
        }
        boolean bl2 = true;
        n5 = 0;
        while (n5 < planArray.length) {
            if (planArray[n5].type != 0) {
                if (planArray[n5].flagOk) {
                    ++n2;
                }
                if (planArray[n5].flagOk && planArray[n5].type == 1) {
                    ++n3;
                }
                bl2 = false;
                if (planArray[n5].selected) {
                    ++n;
                    n4 = n5;
                    switch (planArray[n5].type) {
                        case 1: {
                            nArray3 = imgmode;
                            break;
                        }
                        case 2: {
                            nArray3 = catmode;
                            break;
                        }
                        case 3: {
                            nArray3 = toolmode;
                            break;
                        }
                        case 4: {
                            nArray3 = fieldmode;
                            break;
                        }
                        case 6: {
                            nArray3 = contourmode;
                            break;
                        }
                    }
                    if (planArray[n5] instanceof PlanContour) {
                        nArray3 = contourmode;
                    }
                    int n6 = 0;
                    while (n6 < nArray3.length) {
                        nArray2[nArray3[n6]] = 0;
                        ++n6;
                    }
                }
            }
            ++n5;
        }
        if (n == 0) {
            n5 = 0;
            while (n5 < nArray2.length) {
                nArray2[n5] = 0;
                ++n5;
            }
        } else if (n2 == 0) {
            n5 = 0;
            while (n5 < nArray2.length) {
                if (n5 != 5 && n5 != 7) {
                    nArray2[n5] = n5 == 13 ? nArray[n5] : 0;
                }
                ++n5;
            }
        } else {
            Plan plan = this.calque.getPlanBase();
            if (!bl2) {
                nArray2[0] = -1;
            }
            nArray2[6] = plan == null ? 0 : (nArray[6] != 0 ? nArray[6] : 1);
            if (n > 0) {
                nArray2[7] = nArray[7] == 0 ? 1 : nArray[7];
                nArray2[13] = nArray[13];
            }
            nArray2[12] = plan != null && !(plan instanceof PlanImageRGB) ? (nArray[12] == 0 ? 1 : nArray[12]) : 0;
            nArray2[9] = plan != null ? (nArray[9] == 0 ? 1 : nArray[9]) : 0;
        }
        nArray2[11] = n3 > 1 ? (nArray[11] == 0 ? 1 : nArray[11]) : 0;
        n5 = 0;
        while (n5 < nArray2.length) {
            if (nArray[n5] != nArray2[n5]) {
                bl = true;
            }
            if (nArray[n5] == -1 && nArray2[n5] != -1) {
                this.tool[n5].Push();
            }
            this.tool[n5].mode = nArray2[n5];
            ++n5;
        }
        if (bl) {
            this.repaint();
        }
    }

    public void update(Graphics graphics) {
        int n = this.size().width;
        int n2 = this.size().height;
        if (this.img == null || this.ws != n || this.hs != n2) {
            n = this.calcConf(n2 - ICONEGAP);
            if (this.g != null) {
                this.g.dispose();
            }
            this.img = this.createImage(n, n2);
            this.g = this.img.getGraphics();
            this.g.setColor(Aladin.BKGD);
            this.g.fillRect(0, 0, n, n2);
            this.flagupdate = false;
        }
        if (this.flagDim) {
            this.paint(graphics);
            return;
        }
        this.drawIconeProp(this.g);
        int n3 = 0;
        while (n3 < this.tool.length) {
            this.drawButton(n3, sort[n3], this.g);
            ++n3;
        }
        this.flagupdate = true;
        this.paint(graphics);
    }

    private void waitCursor() {
        this.makeCursor(1);
    }
}

