/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Event;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;

public class Status
extends Canvas {
    static int W = 10;
    static int H = 22;
    static int y = -2;
    static final Color BG = Aladin.BLUE;
    String text;
    Image img;
    Graphics g;
    Aladin aladin;

    protected Status(Aladin aladin, String string) {
        this.text = string;
        this.resize(W, H);
        this.aladin = aladin;
    }

    protected String Help() {
        return "!Status window\nDepending on the current position of the mouse, this window displays corresponding information and/or the status, such as :\n \n- the task associated with a tool button,\n- the identifier of a source,\n- the status of a plane,\n- the size of a vector,\n- the legend associated with a measurement,\n- ...";
    }

    public boolean handleEvent(Event event) {
        if (Aladin.inHelp) {
            if (event.id == 504) {
                this.aladin.help.setText(this.Help());
            }
            return true;
        }
        return super.handleEvent(event);
    }

    public void paint(Graphics graphics) {
        int n = this.size().width;
        int n2 = this.size().height;
        if (this.img == null || this.img.getWidth(this) != n || this.img.getHeight(this) != n2) {
            this.img = null;
            this.update(graphics);
            return;
        }
        graphics.drawImage(this.img, 0, 0, null);
    }

    protected void setText(String string) {
        if (this.text.equals(string)) {
            return;
        }
        this.text = string;
        this.repaint();
    }

    public void update(Graphics graphics) {
        int n = this.size().width;
        int n2 = this.size().height;
        if (this.img == null || n != W || n2 != H) {
            if (this.g != null) {
                this.g.dispose();
            }
            this.img = this.createImage(W, H);
            this.g = this.img.getGraphics();
            this.g.setFont(Aladin.LBOLD);
            W = n;
            H = n2;
            this.g.setColor(Aladin.BKGD);
            this.g.fillRect(0, 0, W, H);
            this.g.setColor(Color.white);
            this.g.drawLine(0, H - 1, W - 1, H - 1);
            this.g.drawLine(W - 1, H - 1, W - 1, 2);
            this.g.setColor(Color.darkGray);
            this.g.drawLine(0, 2, W, 2);
            this.g.drawLine(0, 2, 0, H);
        }
        this.g.setColor(BG);
        this.g.fillRect(1, 3, W - 2, H - 4);
        this.g.setColor(Color.black);
        FontMetrics fontMetrics = this.g.getFontMetrics();
        if (this.text != null && !this.text.equals("")) {
            int n3;
            if (y < 0) {
                y = H / 2 + (fontMetrics.getDescent() + fontMetrics.getAscent()) / 2 - 2;
            }
            if ((n3 = W / 2 - fontMetrics.stringWidth(this.text) / 2) < 1) {
                n3 = 5;
            }
            if (this.text.charAt(0) == '<') {
                this.text = this.text.substring(1);
                n3 = 5;
            }
            this.g.drawString(this.text, n3, y);
        }
        this.paint(graphics);
    }
}

