/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Filet;
import cds.aladin.Glu;
import cds.aladin.Server;
import java.awt.Event;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.net.URL;

public class SimbadServer
extends Server {
    static final String NOM = "Simbad";
    static final String INFO = "CDS SIMBAD astronomical database (`3,000,000 objects with bibliography)";
    static final String TITRE = "Simbad astronomical database";
    String tagGlu = "SimbadXML";
    String explication;
    String titre;

    protected SimbadServer(Aladin aladin, Label label) {
        this.init();
        this.aladin = aladin;
        this.status = label;
        this.setLayout(null);
        this.setFont(Aladin.PLAIN);
        int n = 75;
        Label label2 = new Label(this.titre);
        label2.setFont(Aladin.LLITALIC);
        label2.setBounds(101, n, 300, 20);
        this.add(label2);
        Label label3 = new Label("Specify a target (object or J2000 coordinates)");
        label3.setBounds(110, n += 40, 400, 20);
        this.add(label3);
        Label label4 = new Label("and press the SUBMIT button");
        label4.setBounds(138, n += 15, 300, 20);
        this.add(label4);
        Panel panel = this.targetPanel(35, "(\"05 47 17.0 -51 04 03\" or \"M99\" => Simbad resolver )", true, 5);
        panel.setBounds(10, n += 20, 450, 50);
        this.add(panel);
        Filet filet = new Filet(20);
        filet.setBounds(30, n += 50, 450, 20);
        this.add(filet);
        Label label5 = new Label("The default radius is calculated in order to");
        label5.setBounds(110, n += 30, 400, 20);
        this.add(label5);
        Label label6 = new Label("cover the image");
        label6.setBounds(138, n += 15, 300, 20);
        n += 20;
        this.add(label6);
        Label label7 = new Label("Radius");
        label7.setFont(Aladin.LBOLD);
        int n2 = 55;
        label7.setBounds(10, n, n2, 30);
        this.add(label7);
        TextField textField = new TextField("10 arcmin", 35);
        textField.setBounds(n2 + 5, n, 200, 30);
        this.add(textField);
        Label label8 = new Label("the unit (deg, arcsec) can be specified (default: arcmin)");
        label8.setFont(Aladin.SITALIC);
        label8.setBounds(n2 + 5, n += 30, 400, 20);
        this.add(label8);
        this.setModeRad(1, textField);
    }

    public boolean action(Event event, Object object) {
        return false;
    }

    protected int creatPlane(String string, String string2, String string3, String string4, String string5) {
        URL uRL;
        String string6 = String.valueOf(Glu.quote(string)) + " " + Glu.quote(string2);
        if (string4 == null) {
            string4 = this.getNom();
        }
        if ((uRL = this.aladin.glu.getURL(this.tagGlu, string6)) == null) {
            this.aladin.message.warning("Unknown server error", 1);
            return -1;
        }
        if (!this.verif(2, string, String.valueOf(string4) + " " + string2)) {
            return -1;
        }
        return this.aladin.calque.newPlanCatalog(uRL, string4, string, String.valueOf(string4) + " " + string2);
    }

    protected void init() {
        this.type = 1;
        this.nom = NOM;
        this.info = INFO;
        this.titre = TITRE;
        this.explication = "Specify a target (object or J2000 coordinates) nand press SUBMIT";
    }

    protected void reset() {
        super.reset();
        this.rad[0].setText("10 arcmin");
    }

    public void submit() {
        Frame frame = this.getFrame(this);
        String string = this.getTarget();
        if (string == null) {
            return;
        }
        String string2 = this.getRadius();
        if (string2.equals("")) {
            this.aladin.message.warning("You must specify the radius of your query");
            return;
        }
        this.waitCursor();
        this.creatPlane(string, string2, null, null, null);
        this.defaultCursor();
    }
}

