/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.AladinServer;
import cds.aladin.Calib;
import cds.aladin.Cote;
import cds.aladin.Legende;
import cds.aladin.Ligne;
import cds.aladin.MyButton;
import cds.aladin.MyLabel;
import cds.aladin.Objet;
import cds.aladin.Plan;
import cds.aladin.PlanImage;
import cds.aladin.PlanImageRGB;
import cds.aladin.PlanObjet;
import cds.aladin.PlanTool;
import cds.aladin.Position;
import cds.aladin.Repere;
import cds.aladin.Source;
import cds.aladin.Texte;
import cds.aladin.Words;
import cds.image.BMPWriter;
import cds.xml.Field;
import cds.xml.XMLParser;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Event;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;

public final class Save
extends Frame {
    static final String CR = System.getProperty("line.separator");
    static final String SLASH = System.getProperty("file.separator");
    Aladin aladin;
    Plan[] plan;
    Panel p;
    static final String INFO = "Choose one of these possibilities";
    TextField directory;
    TextField[] fileSavePlan;
    int[] listPlan;
    int nbSavePlan;
    Checkbox[] cbPlan;
    String errorFile = null;
    boolean first = true;
    static final String[] CHOICE = new String[]{"Backup\nthe\nstack...", "Export\nsome\nplanes...", "Export\ncurrent\nview...", "Get\nimage\nlinks..."};
    static final String[] INFOCHOICE = new String[]{"Create a file storing the current stack\n(The format is Aladin proprietary - AJ format)", "Allows you to export planes:\n- catalogs in ASCII Tab-Separated-Value,\n- images in FITS (8bits/autocut) or BMP for RGB images", "Create a file of the view with the current overlays\n(The format is BMP 24-bits)", "Produce a HTML page with links to the original images\nloaded in the stack"};
    static final String FISTINFO = "Choose one of these possibilities";
    static final String SECONDINFO = "Select or unselect each plans, specify the directory\nand press the EXPORT button";
    static final String CANCEL = "Cancel";
    static final String EXPORT = "EXPORT";
    private static int MAXBUF = 8192;
    private static byte[] buf = new byte[MAXBUF];
    private static int nbuf = 0;
    private static FileOutputStream f;
    private static String B64;
    static int[] b642a;

    static {
        B64 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
        b642a = null;
    }

    protected Save(Aladin aladin) {
        this(aladin, false);
    }

    protected Save(Aladin aladin, boolean bl) {
        super("Aladin save window");
        ((Component)this).setBackground(Aladin.BKGD);
        this.aladin = aladin;
        this.plan = aladin.calque.plan;
        this.p = this.getFirstPanel();
        Aladin.makeAdd(this, this.p, "Center");
        if (!Aladin.LSCREEN) {
            this.move(200, 300);
        } else {
            this.move(500, 400);
        }
        this.pack();
        if (bl) {
            this.show();
        }
    }

    public boolean action(Event event, Object object) {
        if (CANCEL.equals(object)) {
            this.aladin.message.hide();
            ((Component)this).hide();
        } else if (CHOICE[0].equals(object)) {
            this.saveFile(0);
        } else if (CHOICE[1].equals(object)) {
            this.exportPlans();
        } else if (CHOICE[2].equals(object)) {
            this.saveFile(1);
        } else if (CHOICE[3].equals(object)) {
            this.aladin.saveHTML();
        } else if (EXPORT.equals(object)) {
            this.actionExportPlans();
        }
        return true;
    }

    protected void actionExportPlans() {
        boolean bl = true;
        boolean bl2 = false;
        this.errorFile = "";
        int n = 0;
        while (n < this.nbSavePlan) {
            if (this.cbPlan[n].getState()) {
                Plan plan = this.plan[this.listPlan[n]];
                File file = new File(this.directory.getText(), this.fileSavePlan[n].getText());
                switch (plan.type) {
                    case 2: {
                        bl &= this.saveCatalog(file, plan);
                        break;
                    }
                    case 1: {
                        if (plan instanceof PlanImageRGB) {
                            bl &= this.saveImageRGB(String.valueOf(this.directory.getText()) + SLASH + this.fileSavePlan[n].getText(), plan);
                            break;
                        }
                        bl2 = true;
                        bl &= this.saveImage(file, plan);
                        break;
                    }
                }
            }
            ++n;
        }
        if (!bl) {
            this.aladin.message.warning("Cannot create\n " + this.errorFile, 1);
        } else {
            ((Component)this).hide();
            if (bl2) {
                this.aladin.message.info("The image saved by Aladin\nare not the original FITS image (only a basic WCS header\nand 8 bits per pixel)\nIf you want to get the original FITS images,\ngo to the original Web sites");
            }
        }
    }

    private static void append(String string) throws IOException {
        Save.append(string.toCharArray());
    }

    private static void append(char[] cArray) throws IOException {
        int n = 0;
        while (n < cArray.length) {
            Save.buf[Save.nbuf++] = (byte)cArray[n];
            if (nbuf == MAXBUF) {
                Save.flush();
            }
            ++n;
        }
    }

    private void append64(byte[] byArray) throws IOException {
        char[] cArray = B64.toCharArray();
        char[] cArray2 = new char[4];
        int n = 0;
        int n2 = 0;
        while (n < byArray.length) {
            int n3 = byArray[n++] & 0xFF;
            int n4 = n3 << 16;
            cArray2[3] = 61;
            cArray2[2] = 61;
            if (n < byArray.length) {
                n3 = byArray[n++] & 0xFF;
                n4 |= n3 << 8;
                cArray2[2] = '\u0000';
                if (n < byArray.length) {
                    n3 = byArray[n++] & 0xFF;
                    n4 |= n3;
                    cArray2[3] = '\u0000';
                }
            }
            if (cArray2[3] == '\u0000') {
                cArray2[3] = cArray[n4 & 0x3F];
            }
            n4 >>= 6;
            if (cArray2[2] == '\u0000') {
                cArray2[2] = cArray[n4 & 0x3F];
            }
            cArray2[1] = cArray[(n4 >>= 6) & 0x3F];
            cArray2[0] = cArray[(n4 >>= 6) & 0x3F];
            Save.append(cArray2);
            if ((n2 += 4) % 76 != 0) continue;
            Save.append(CR);
        }
    }

    private void appendPlanCatalogXML(Plan plan) throws IOException {
        Legende legende = null;
        this.appendXMLHeadPlan(plan);
        PlanObjet planObjet = plan.pcat;
        int n = 0;
        while (n < planObjet.nb_o) {
            Source source = (Source)planObjet.o[n];
            if (source.leg != legende) {
                if (legende != null) {
                    Save.append(this.getXMLTailTable());
                }
                Save.append(this.getXMLHeadTable(source.leg));
                legende = source.leg;
            }
            Source source2 = source;
            Save.append(String.valueOf(source2.raj) + "\t" + source2.dej + "\t" + source2.id);
            Save.append("\t" + source.info + CR);
            ++n;
        }
        Save.append(String.valueOf(this.getXMLTailTable()) + "  </PLANE>" + CR);
    }

    private void appendPlanImageXML(Plan plan) throws IOException {
        this.appendXMLHeadPlan(plan);
        Save.append("    <VALUE><![CDATA[" + CR);
        this.append64(((PlanImage)plan).pixels);
        Save.append("]]></VALUE>" + CR + "  </PLANE>" + CR);
    }

    protected void appendPlanToolXML(Plan plan) throws IOException {
        this.appendXMLHeadPlan(plan);
        Save.append("    <TABLE><VALUE><![CDATA[" + CR);
        PlanObjet planObjet = plan.pcat;
        int n = 0;
        while (n < planObjet.nb_o) {
            Position position = (Position)planObjet.o[n];
            Save.append(String.valueOf(this.getInstance(planObjet.o[n])) + "\t" + this.suite(planObjet.o[n]) + "\t" + position.raj + "\t" + position.dej + "\t" + position.x + "\t" + position.y + "\t" + position.withlabel + "\t" + position.id + CR);
            ++n;
        }
        Save.append(String.valueOf(this.getXMLTailTable()) + "  </PLANE>" + CR);
    }

    private void appendXMLHeadPlan(Plan plan) throws IOException {
        Object object;
        Save.append("  <PLANE");
        Save.append(String.valueOf(CR) + "     type=\"" + XMLParser.XMLEncode(Plan.Tp[plan.type]) + "\"");
        if (plan.label != null) {
            Save.append(String.valueOf(CR) + "     label=\"" + XMLParser.XMLEncode(plan.label) + "\"");
        }
        if (plan.objet != null) {
            Save.append(String.valueOf(CR) + "     object=\"" + XMLParser.XMLEncode(plan.objet) + "\"");
        }
        if (plan.param != null) {
            Save.append(String.valueOf(CR) + "     param=\"" + XMLParser.XMLEncode(plan.param) + "\"");
        }
        if (plan.type == 1) {
            object = PlanImage.getFormat(((PlanImage)plan).fmt);
            String string = PlanImage.getResolution(((PlanImage)plan).res);
            Save.append(String.valueOf(CR) + "     fmt=\"" + XMLParser.XMLEncode((String)object) + "\"");
            Save.append(String.valueOf(CR) + "     resolution=\"" + XMLParser.XMLEncode(string) + "\"");
        }
        if (plan.from != null) {
            Save.append(String.valueOf(CR) + "     from=\"" + XMLParser.XMLEncode(plan.from) + "\"");
        }
        if (plan.u != null) {
            Save.append(String.valueOf(CR) + "     url=\"" + XMLParser.XMLEncode(String.valueOf(String.valueOf(plan.u))) + "\"");
        }
        if (plan.projd != null) {
            Save.append(String.valueOf(CR) + "     RA=\"" + plan.projd.raj + "\"");
            Save.append(String.valueOf(CR) + "     DE=\"" + plan.projd.dej + "\"");
            Save.append(String.valueOf(CR) + "     radius=\"" + plan.projd.rm / 2.0 + "\"");
            Save.append(String.valueOf(CR) + "     proj=\"" + plan.projd.type + "\"");
            if (plan.projd.c != null) {
                object = plan.projd.c;
                Save.append(String.valueOf(CR) + "     calib=\"" + ((Calib)object).aladin + "," + ((Calib)object).epoch + "," + ((Calib)object).alpha + "," + ((Calib)object).delta + "," + ((Calib)object).yz + "," + ((Calib)object).xz + "," + ((Calib)object).focale + "," + ((Calib)object).Xorg + "," + ((Calib)object).Yorg + "," + ((Calib)object).incX + "," + ((Calib)object).incY + "," + ((Calib)object).alphai + "," + ((Calib)object).deltai + "," + ((Calib)object).incA + "," + ((Calib)object).incD + "," + ((Calib)object).Xcen + "," + ((Calib)object).Ycen + "," + ((Calib)object).widtha + "," + ((Calib)object).widthd + "," + ((Calib)object).xnpix + "," + ((Calib)object).ynpix + "," + ((Calib)object).rota + "," + ((Calib)object).cdelz + "," + ((Calib)object).sdelz + "," + ((Calib)object).type1 + "," + ((Calib)object).type2 + "," + ((Calib)object).equinox + "," + ((Calib)object).proj + "\"");
                Save.append(String.valueOf(CR) + "     adxpoly=\"" + ((Calib)object).adxpoly[0]);
                int n = 1;
                while (n < 10) {
                    Save.append("," + ((Calib)object).adxpoly[n]);
                    ++n;
                }
                Save.append("\"");
                Save.append(String.valueOf(CR) + "     adypoly=\"" + ((Calib)object).adypoly[0]);
                n = 1;
                while (n < 10) {
                    Save.append("," + ((Calib)object).adypoly[n]);
                    ++n;
                }
                Save.append("\"");
                Save.append(String.valueOf(CR) + "     xyapoly=\"" + ((Calib)object).xyapoly[0]);
                n = 1;
                while (n < 10) {
                    Save.append("," + ((Calib)object).xyapoly[n]);
                    ++n;
                }
                Save.append("\"");
                Save.append(String.valueOf(CR) + "     xydpoly=\"" + ((Calib)object).xydpoly[0]);
                n = 1;
                while (n < 10) {
                    Save.append("," + ((Calib)object).xydpoly[n]);
                    ++n;
                }
                Save.append("\"");
                Save.append(String.valueOf(CR) + "     CD=\"" + ((Calib)object).CD[0][0] + "," + ((Calib)object).CD[0][1] + "," + ((Calib)object).CD[1][0] + "," + ((Calib)object).CD[1][1] + "\"");
                Save.append(String.valueOf(CR) + "     ID=\"" + ((Calib)object).ID[0][0] + "," + ((Calib)object).ID[0][1] + "," + ((Calib)object).ID[1][0] + "," + ((Calib)object).ID[1][1] + "\"");
            }
        }
        if (plan instanceof PlanTool) {
            Save.append(String.valueOf(CR) + "     xylock=\"" + ((PlanTool)plan).lock() + "\"");
        } else if (plan instanceof PlanImage) {
            object = (PlanImage)plan;
            Save.append(String.valueOf(CR) + "     width=\"" + ((PlanImage)object).width + "\"");
            Save.append(String.valueOf(CR) + "     height=\"" + ((PlanImage)object).height + "\"");
            Save.append(String.valueOf(CR) + "     video=\"" + ((PlanImage)object).video + "\"");
            Save.append(String.valueOf(CR) + "     colormap1=\"" + ((PlanImage)object).cmControl[0] + "\"");
            Save.append(String.valueOf(CR) + "     colormap2=\"" + ((PlanImage)object).cmControl[1] + "\"");
            Save.append(String.valueOf(CR) + "     colormap3=\"" + ((PlanImage)object).cmControl[2] + "\"");
        }
        Save.append(" >" + CR);
    }

    private static void close() throws IOException {
        Save.flush();
        f.close();
    }

    private void exportPlans() {
        this.remove(this.p);
        Aladin.makeAdd(this, new MyLabel(SECONDINFO, 1, Aladin.BOLD), "North");
        Aladin.makeAdd(this, this.getPlanPanel(), "Center");
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout(5, 5));
        Panel panel2 = new Panel();
        this.directory = new TextField(".", 30);
        panel2.add(new Label("Dir: "));
        panel2.add(this.directory);
        Aladin.makeAdd(panel, panel2, "West");
        Panel panel3 = new Panel();
        panel3.setLayout(new FlowLayout(1));
        panel3.add(new Button(EXPORT));
        panel3.add(new Button(CANCEL));
        Aladin.makeAdd(panel, panel3, "Center");
        Aladin.makeAdd(this, panel, "South");
        this.pack();
    }

    private static void flush() throws IOException {
        f.write(buf, 0, nbuf);
        nbuf = 0;
    }

    protected static int get64(byte[] byArray, int n, char[] cArray, int n2, int n3) {
        int n4;
        char[] cArray2 = B64.toCharArray();
        int n5 = byArray.length;
        if (b642a == null) {
            b642a = new int[256];
            n4 = 0;
            while (n4 < b642a.length) {
                Save.b642a[n4] = 64;
                ++n4;
            }
            n4 = 0;
            while (n4 < cArray2.length) {
                Save.b642a[cArray2[n4]] = n4;
                ++n4;
            }
            Save.b642a[61] = 255;
        }
        int n6 = 0;
        boolean bl = false;
        int n7 = 1;
        int n8 = n2;
        while (n8 < n3) {
            int n9 = cArray[n8++];
            ++n6;
            if (bl) {
                System.err.print(n9);
            }
            if (n9 == 32 || n9 == 9 || n9 == 10 || n9 == 13) {
                if (n9 != 10 && n9 != 13) continue;
                ++n7;
                n6 = 0;
                bl = false;
                continue;
            }
            if (bl) continue;
            int n10 = b642a[n9 & 0xFF];
            if ((n10 & 0x40) != 0) {
                if (n6 == 1) {
                    bl = true;
                    System.err.println("++++Ignore line: " + n9);
                    continue;
                }
                System.err.println("****Bad input char " + (char)n9 + " line " + n7 + ", col " + n6);
                continue;
            }
            n10 <<= 6;
            n9 = cArray[n8++] & 0xFF;
            ++n6;
            n4 = b642a[n9 & 0xFF];
            if ((n4 & 0x40) != 0) {
                System.err.println("****Bad input char " + (char)n9 + " line " + n7 + ", col " + n6);
                n10 >>= 4;
                if (n >= n5) {
                    return n;
                }
                byArray[n++] = (byte)n10;
                continue;
            }
            n10 |= n4;
            n10 <<= 6;
            n9 = cArray[n8++] & 0xFF;
            ++n6;
            n4 = b642a[n9 & 0xFF];
            if ((n4 & 0x40) != 0) {
                if (n4 != 255) {
                    System.err.println("****Bad input char " + (char)n9 + " line " + n7 + ", col " + n6);
                }
                n10 >>= 2;
                if (n >= n5) {
                    return n;
                }
                byArray[n++] = (byte)(n10 >> 8);
                if (n >= n5) {
                    return n;
                }
                byArray[n++] = (byte)n10;
                continue;
            }
            n10 |= n4;
            n10 <<= 6;
            n9 = cArray[n8++] & 0xFF;
            ++n6;
            n4 = b642a[n9 & 0xFF];
            if ((n4 & 0x40) != 0 && n4 != 255) {
                System.err.println("****Bad input char " + (char)n9 + " line " + n7 + ", col " + n6);
            } else {
                n10 |= n4;
            }
            if (n >= n5) {
                return n;
            }
            byArray[n++] = (byte)(n10 >> 16);
            if (n >= n5) {
                return n;
            }
            byArray[n++] = (byte)(n10 >> 8);
            if (n >= n5) {
                return n;
            }
            byArray[n++] = (byte)n10;
        }
        return n;
    }

    private Panel getFirstPanel() {
        MyLabel myLabel;
        Component component;
        Panel panel = new Panel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        panel.setLayout(gridBagLayout);
        panel.setFont(Aladin.BOLD);
        int n = 0;
        while (n < CHOICE.length) {
            component = new MyButton(this.aladin, CHOICE[n]);
            gridBagConstraints.gridwidth = -1;
            gridBagLayout.setConstraints(component, gridBagConstraints);
            panel.add(component);
            myLabel = new MyLabel(INFOCHOICE[n], 0, Aladin.PLAIN);
            gridBagConstraints.gridwidth = 0;
            gridBagLayout.setConstraints(myLabel, gridBagConstraints);
            panel.add(myLabel);
            ++n;
        }
        component = new Panel();
        component.setLayout(new BorderLayout(5, 5));
        myLabel = new MyLabel("Choose one of these possibilities", 1, Aladin.BOLD);
        Aladin.makeAdd(component, myLabel, "North");
        Aladin.makeAdd(component, panel, "Center");
        Panel panel2 = new Panel();
        panel2.setLayout(new BorderLayout());
        Aladin.makeAdd(panel2, new Button(CANCEL), "East");
        Aladin.makeAdd(component, panel2, "South");
        return component;
    }

    protected static byte[] getFitsLine(String string) {
        return Save.getFitsLine("COMMENT", null, string);
    }

    protected static byte[] getFitsLine(String string, String string2, String string3) {
        int n = 0;
        byte[] byArray = new byte[80];
        char[] cArray = string.toCharArray();
        int n2 = 0;
        while (n < 8) {
            byArray[n] = (byte)(n2 < cArray.length ? cArray[n2] : 32);
            ++n2;
            ++n;
        }
        if (string2 != null) {
            byArray[n++] = 61;
            byArray[n++] = 32;
            cArray = string2.toCharArray();
            n2 = 0;
            while (n2 < 20 - cArray.length) {
                byArray[n++] = 32;
                ++n2;
            }
            n2 = 0;
            while (n < 80 && n2 < cArray.length) {
                byArray[n] = (byte)cArray[n2];
                ++n2;
                ++n;
            }
        }
        if (string3.length() > 0) {
            if (string2 != null) {
                byArray[n++] = 32;
                byArray[n++] = 47;
                byArray[n++] = 32;
            }
            cArray = string3.toCharArray();
            n2 = 0;
            while (n < 80 && n2 < cArray.length) {
                byArray[n] = (byte)cArray[n2];
                ++n2;
                ++n;
            }
        }
        while (n < 80) {
            byArray[n++] = 32;
        }
        return byArray;
    }

    private String getInstance(Object object) {
        if (object instanceof Texte) {
            return "text";
        }
        if (object instanceof Cote) {
            return "arrow";
        }
        if (object instanceof Ligne) {
            return "line";
        }
        if (object instanceof Repere) {
            return "tag";
        }
        return "unknown";
    }

    protected Panel getPlanPanel() {
        int n = 0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        Panel panel = new Panel();
        panel.setLayout(gridBagLayout);
        int n2 = this.aladin.calque.getNbUsedPlans();
        this.fileSavePlan = new TextField[n2];
        this.cbPlan = new Checkbox[n2];
        this.listPlan = new int[n2];
        int n3 = 0;
        while (n3 < this.plan.length) {
            Plan plan = this.plan[n3];
            if (plan.type != 0 && plan.type != 3 && plan.flagOk) {
                this.listPlan[n] = n3;
                this.cbPlan[n] = new Checkbox(String.valueOf(n) + ".- ", true);
                String string = String.valueOf(plan.label) + (plan.objet != null ? "-" + plan.objet : "");
                Label label = new Label(string);
                label.setForeground(plan.c);
                Label label2 = new Label(Plan.Tp[plan.type]);
                String string2 = AladinServer.blankToUnderline(string);
                string2 = plan.type == 1 ? (plan instanceof PlanImageRGB ? String.valueOf(string2) + ".bmp" : String.valueOf(string2) + ".fits") : String.valueOf(string2) + ".txt";
                this.fileSavePlan[n] = new TextField(string2, 20);
                gridBagConstraints.gridwidth = 2;
                gridBagConstraints.anchor = 13;
                gridBagLayout.setConstraints(this.cbPlan[n], gridBagConstraints);
                panel.add(this.cbPlan[n]);
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.anchor = 17;
                gridBagLayout.setConstraints(label, gridBagConstraints);
                panel.add(label);
                gridBagConstraints.gridwidth = 1;
                gridBagLayout.setConstraints(this.fileSavePlan[n], gridBagConstraints);
                panel.add(this.fileSavePlan[n]);
                gridBagConstraints.gridwidth = 0;
                gridBagLayout.setConstraints(label2, gridBagConstraints);
                panel.add(label2);
                ++n;
            }
            ++n3;
        }
        this.nbSavePlan = n;
        return panel;
    }

    protected String getShortHeader(Legende legende) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("_RAJ2000\t_DEJ2000");
        int n = 0;
        while (n < legende.field.length) {
            stringBuffer.append("\t" + legende.field[n].name);
            ++n;
        }
        stringBuffer.append(String.valueOf(CR) + "----------\t----------");
        n = 0;
        while (n < legende.field.length) {
            int n2;
            stringBuffer.append("\t");
            try {
                n2 = Integer.parseInt(legende.field[n].width);
            }
            catch (Exception exception) {
                n2 = 0;
            }
            if (n2 == 0) {
                n2 = 10;
            }
            int n3 = 0;
            while (n3 < n2) {
                stringBuffer.append("-");
                ++n3;
            }
            ++n;
        }
        stringBuffer.append(CR);
        return stringBuffer.toString();
    }

    protected String getTSV(Source source) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(source.info, "\t");
        stringTokenizer.nextElement();
        while (stringTokenizer.hasMoreTokens()) {
            Words words = new Words(stringTokenizer.nextToken());
            if (stringBuffer.length() != 0) {
                stringBuffer.append("\t");
            }
            stringBuffer.append(words.getText());
        }
        return stringBuffer.toString();
    }

    protected String getToolName(Objet objet) {
        return "Undefined";
    }

    static String getValue(String string) {
        int n;
        int n2;
        if (string.startsWith("<&") && (n2 = string.indexOf(124)) > 0 && (n = string.indexOf(62, n2 + 1)) >= 0) {
            return string.substring(n2 + 1, n);
        }
        return string;
    }

    protected String getXMLHeadTable(Legende legende) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("    <TABLE>" + CR);
        int n = 0;
        while (n < legende.field.length) {
            Field field = legende.field[n];
            stringBuffer.append("      <COLUMN");
            if (field.name != null) {
                stringBuffer.append(String.valueOf(CR) + "         name=\"" + XMLParser.XMLEncode(field.name) + "\"");
            }
            if (field.description != null) {
                stringBuffer.append(String.valueOf(CR) + "         description=\"" + XMLParser.XMLEncode(field.description) + "\"");
            }
            if (field.href != null) {
                stringBuffer.append(String.valueOf(CR) + "         href=\"" + XMLParser.XMLEncode(field.href) + "\"");
            }
            if (field.gref != null) {
                stringBuffer.append(String.valueOf(CR) + "         gref=\"" + XMLParser.XMLEncode(field.gref) + "\"");
            }
            if (field.ucd != null) {
                stringBuffer.append(String.valueOf(CR) + "         ucd=\"" + XMLParser.XMLEncode(field.ucd) + "\"");
            }
            if (field.width != null) {
                stringBuffer.append(String.valueOf(CR) + "         width=\"" + XMLParser.XMLEncode(field.width) + "\"");
            }
            if (field.type != null) {
                stringBuffer.append(String.valueOf(CR) + "         type=\"" + XMLParser.XMLEncode(field.type) + "\"");
            }
            if (field.datatype != null) {
                stringBuffer.append(String.valueOf(CR) + "         datatype=\"" + XMLParser.XMLEncode(field.datatype) + "\"");
            }
            if (field.refText != null) {
                stringBuffer.append(String.valueOf(CR) + "         refText=\"" + XMLParser.XMLEncode(field.refText) + "\"");
            }
            if (field.refValue != null) {
                stringBuffer.append(String.valueOf(CR) + "         refValue=\"" + XMLParser.XMLEncode(field.refValue) + "\"");
            }
            stringBuffer.append("/>" + CR);
            ++n;
        }
        stringBuffer.append("      <VALUE><![CDATA[" + CR);
        return stringBuffer.toString();
    }

    protected String getXMLTailTable() {
        return "]]></VALUE></TABLE>" + CR;
    }

    public boolean handleEvent(Event event) {
        if (event.id == 201) {
            ((Component)this).hide();
        }
        return super.handleEvent(event);
    }

    private static void open(File file) throws IOException {
        f = new FileOutputStream(file);
        nbuf = 0;
    }

    protected boolean save(String string) {
        File file = new File(string);
        Plan[] planArray = this.aladin.calque.plan;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        try {
            file.delete();
            Save.open(file);
            Save.append("<?xml version = \"1.0\"?>\n<!-- This file has been produced by the Aladin Java interface," + CR + "     Please do not modify it -->" + CR + CR + "<ALADINJAVA vers=\"1.0\">" + CR);
            int n = planArray.length - 1;
            while (n >= 0) {
                Plan plan = planArray[n];
                if (plan instanceof PlanImageRGB) {
                    bl = true;
                } else {
                    switch (plan.type) {
                        case 2: {
                            this.appendPlanCatalogXML(plan);
                            break;
                        }
                        case 3: {
                            this.appendPlanToolXML(plan);
                            break;
                        }
                        case 1: {
                            this.appendPlanImageXML(plan);
                            break;
                        }
                    }
                }
                --n;
            }
            Save.append("</ALADINJAVA>" + CR);
            Save.close();
            if (bl) {
                this.aladin.message.warning("Note that the RGB plane aren't saved !");
            }
        }
        catch (Exception exception) {
            this.aladin.message.warning("Cannot create\n" + file + "\n--> " + exception, 1);
            return false;
        }
        return true;
    }

    protected boolean saveCatalog(File file, Plan plan) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        PlanObjet planObjet = plan.pcat;
        Legende legende = ((Source)planObjet.o[0]).leg;
        stringBuffer.append(this.getShortHeader(legende));
        int n = 0;
        while (n < planObjet.nb_o) {
            object = (Source)planObjet.o[n];
            if (((Source)object).leg != legende) break;
            stringBuffer.append(String.valueOf(((Position)object).raj) + "\t" + ((Position)object).dej + "\t" + this.getTSV((Source)object) + CR);
            ++n;
        }
        try {
            file.delete();
            object = new FileOutputStream(file);
            char[] cArray = stringBuffer.toString().toCharArray();
            byte[] byArray = new byte[cArray.length];
            int n2 = 0;
            while (n2 < cArray.length) {
                byArray[n2] = (byte)cArray[n2];
                ++n2;
            }
            ((FileOutputStream)object).write(byArray);
        }
        catch (Exception exception) {
            this.errorFile = String.valueOf(this.errorFile) + "\n" + file;
            return false;
        }
        return true;
    }

    protected boolean saveCatalog(String string, Plan plan) {
        File file = new File(string);
        return this.saveCatalog(file, plan);
    }

    private void saveFile(int n) {
        boolean bl;
        FileDialog fileDialog = new FileDialog((Frame)this, CHOICE[0], 1);
        fileDialog.show();
        String string = fileDialog.getDirectory();
        String string2 = fileDialog.getFile();
        String string3 = String.valueOf(string == null ? "" : string) + (string2 == null ? "" : string2);
        if (n == 0 && !string3.endsWith(".aj")) {
            string3 = String.valueOf(string3) + ".aj";
        }
        if (!(bl = n == 0 ? this.save(string3) : this.saveView(string3))) {
            this.aladin.message.warning("cannot create\n" + string3 + "\n =>save aborted", 1);
        } else {
            ((Component)this).hide();
        }
    }

    protected boolean saveImage(File file, Plan plan) {
        PlanImage planImage = (PlanImage)plan;
        if (planImage instanceof PlanImageRGB) {
            return false;
        }
        return this.saveImageFITS(file, planImage.width, planImage.height, planImage.pixels, planImage.projd.c);
    }

    protected boolean saveImage(String string, Plan plan) {
        File file = new File(string);
        if (plan instanceof PlanImageRGB) {
            return this.saveImageRGB(string, plan);
        }
        return this.saveImage(file, plan);
    }

    protected boolean saveImageFITS(File file, int n, int n2, byte[] byArray, Calib calib) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        int n3 = 0;
        Vector<byte[]> vector = new Vector<byte[]>(20);
        vector.addElement(Save.getFitsLine("SIMPLE", "T", "Written by Aladin Java (CDS)"));
        vector.addElement(Save.getFitsLine("BITPIX", "8", "Bits per pixel"));
        vector.addElement(Save.getFitsLine("NAXIS", "2", "Number of dimensions"));
        if (calib != null) {
            object5 = new Vector(20);
            object4 = new Vector(20);
            try {
                calib.GetWCS((Vector)object5, (Vector)object4);
            }
            catch (Exception exception) {
                System.err.println("GetWCS error");
            }
            object3 = ((Vector)object5).elements();
            object2 = ((Vector)object4).elements();
            while (object3.hasMoreElements()) {
                object = (String)object3.nextElement();
                String string = (String)object2.nextElement();
                vector.addElement(Save.getFitsLine((String)object, string, ""));
            }
        } else {
            vector.addElement(Save.getFitsLine("NAXIS1", String.valueOf(n), "Length of x axis"));
            vector.addElement(Save.getFitsLine("NAXIS2", String.valueOf(n2), "Length of y axis"));
        }
        vector.addElement(Save.getFitsLine("This file was produced by Aladin Java from"));
        vector.addElement(Save.getFitsLine("available astronomical surveys.  The data are formatted"));
        vector.addElement(Save.getFitsLine("as a simple two-dimensional FITS image in 8 bit pixels"));
        vector.addElement(Save.getFitsLine("Copies of relevant copyright notices are included in this file"));
        vector.addElement(Save.getFitsLine(""));
        vector.addElement(Save.getFitsLine("Aladin Java"));
        vector.addElement(Save.getFitsLine("Centre de Donnees astronomiques de Strasbourg"));
        vector.addElement(Save.getFitsLine("11 rue de l'Universite"));
        vector.addElement(Save.getFitsLine("67000 STRASBOURG    FRANCE"));
        vector.addElement(Save.getFitsLine("question@simbad.u-strasbg.fr"));
        try {
            file.delete();
            object5 = new FileOutputStream(file);
            object4 = vector.elements();
            while (object4.hasMoreElements()) {
                object3 = (byte[])object4.nextElement();
                ((FileOutputStream)object5).write((byte[])object3);
                n3 += ((Object)object3).length;
            }
            object3 = new byte[3];
            object3[0] = 69;
            object3[1] = 78;
            object3[2] = 68;
            ((FileOutputStream)object5).write((byte[])object3);
            object2 = new byte[2880 - (n3 += 3) % 2880];
            int n4 = 0;
            while (n4 < ((Object)object2).length) {
                object2[n4] = 32;
                ++n4;
            }
            ((FileOutputStream)object5).write((byte[])object2);
            object = new byte[n];
            int n5 = n2 - 1;
            while (n5 >= 0) {
                System.arraycopy(byArray, n5 * n, object, 0, n);
                ((FileOutputStream)object5).write((byte[])object);
                --n5;
            }
            object2 = new byte[2880 - byArray.length % 2880];
            ((FileOutputStream)object5).write((byte[])object2);
            ((FileOutputStream)object5).close();
        }
        catch (Exception exception) {
            this.errorFile = String.valueOf(this.errorFile) + "\n" + file;
            return false;
        }
        return true;
    }

    protected boolean saveImageRGB(String string, Plan plan) {
        PlanImageRGB planImageRGB = (PlanImageRGB)plan;
        try {
            BMPWriter.write24BitBMP(planImageRGB.pixelsRGB, planImageRGB.width, planImageRGB.height, string);
        }
        catch (Exception exception) {
            System.out.println("!!! BMP image failed for \"" + string + "\"");
            System.err.println(String.valueOf(String.valueOf(exception)));
            return false;
        }
        return true;
    }

    protected boolean saveView(String string) {
        this.aladin.view.setLockRepaint(true);
        try {
            BMPWriter.write(this.aladin.view.getImage(), string);
        }
        catch (Exception exception) {
            this.aladin.view.setLockRepaint(false);
            System.out.println("!!! BMP image failed for \"" + string + "\"");
            System.err.println(String.valueOf(String.valueOf(exception)));
            exception.printStackTrace();
            return false;
        }
        this.aladin.view.setLockRepaint(false);
        this.aladin.view.repaint();
        return true;
    }

    private String suite(Objet objet) {
        if (!(objet instanceof Ligne) || ((Ligne)objet).finligne == null) {
            return ".";
        }
        return "+";
    }

    private static String toVOTableDatatype(String string) {
        if (string.equals("J")) {
            return "int";
        }
        if (string.equals("K")) {
            return "long";
        }
        if (string.equals("A")) {
            return "char";
        }
        if (string.equals("E")) {
            return "float";
        }
        if (string.equals("D")) {
            return "double";
        }
        if (string.equals("L")) {
            return "boolean";
        }
        if (string.equals("I")) {
            return "short";
        }
        if (string.equals("X")) {
            return "bit";
        }
        if (string.equals("B")) {
            return "unsignedByte";
        }
        if (string.equals("C")) {
            return "floatComplex";
        }
        if (string.equals("M")) {
            return "doubleComplex";
        }
        return "float";
    }

    private int writeAttribute(StringBuffer stringBuffer, int n, int n2, int n3, String string, String string2) {
        if (string2 == null) {
            return 0;
        }
        if (n == n2) {
            stringBuffer.append('\n');
            this.writeIndent(stringBuffer, n3 + 6);
            n = 0;
        }
        stringBuffer.append(" " + string + "=\"" + XMLParser.XMLEncode(string2) + "\"");
        return n + 1;
    }

    private void writeIndent(StringBuffer stringBuffer, int n) {
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(' ');
            ++n2;
        }
    }

    private void writePlanInVOTable(StringBuffer stringBuffer, Plan plan, boolean bl) {
        Legende legende = null;
        StringBuffer stringBuffer2 = new StringBuffer(10000);
        stringBuffer2.append("  <RESOURCE name=\"" + XMLParser.XMLEncode(plan.label) + "\">\n" + "    <DESCRIPTION>" + XMLParser.XMLEncode(plan.label) + " object selection from Aladin</DESCRIPTION>\n");
        PlanObjet planObjet = plan.pcat;
        int n = 0;
        while (n < planObjet.nb_o) {
            Source source = (Source)planObjet.o[n];
            if (!bl || source.isSelect()) {
                if (source.leg != legende) {
                    if (legende != null) {
                        stringBuffer2.append("      </TABLEDATA></DATA></TABLE>\n");
                    }
                    this.writeVOTableStartTable(stringBuffer2, source);
                    legende = source.leg;
                }
                this.writeVOTableData(stringBuffer2, source);
            }
            ++n;
        }
        if (legende == null) {
            return;
        }
        stringBuffer2.append("      </TABLEDATA></DATA></TABLE>\n");
        stringBuffer2.append("   </RESOURCE>\n");
        stringBuffer.append((Object)stringBuffer2);
    }

    protected String writeSelectedObjectInVOTable() {
        StringBuffer stringBuffer = new StringBuffer(10000);
        stringBuffer.append("<?xml version=\"1.0\"?>\n<!DOCTYPE VOTABLE SYSTEM \"http://us-vo.org/xml/VOTable.dtd\">\n<VOTABLE version=\"1.0\" xmlns=\"http://vizier.u-strasbg.fr/VOTable\">\n  <DESCRIPTION>Object selection from Aladin</DESCRIPTION>\n  <DEFINITIONS>\n    <COOSYS ID=\"J2000\" equinox=\"2000.\" epoch=\"2000\" system=\"eq_FK5\"/>\n  </DEFINITIONS>\n");
        int n = this.plan.length - 1;
        while (n >= 0) {
            Plan plan = this.plan[n];
            if (plan.type == 2 && plan.flagOk && plan.active) {
                this.writePlanInVOTable(stringBuffer, plan, true);
            }
            --n;
        }
        stringBuffer.append("</VOTABLE>\n");
        return stringBuffer.toString();
    }

    private void writeVOTableData(StringBuffer stringBuffer, Source source) {
        StringTokenizer stringTokenizer = new StringTokenizer(source.info, "\t");
        stringTokenizer.nextElement();
        this.writeIndent(stringBuffer, 7);
        stringBuffer.append("<TR>");
        String string = source.getOID();
        if (string == null) {
            string = source.setOID();
        }
        stringBuffer.append("<TD>" + string + "</TD>");
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            Words words = new Words(stringTokenizer.nextToken());
            if (n == 5) {
                n = 0;
                stringBuffer.append("\n");
                this.writeIndent(stringBuffer, 11);
            }
            stringBuffer.append("<TD>" + Save.getValue(words.getText()) + "</TD>");
            ++n;
        }
        stringBuffer.append("</TR>\n");
    }

    private void writeVOTableStartTable(StringBuffer stringBuffer, Source source) {
        int n = 4;
        Legende legende = source.leg;
        StringTokenizer stringTokenizer = new StringTokenizer(source.info, "\t");
        String string = Save.getValue(stringTokenizer.nextToken());
        this.writeIndent(stringBuffer, n);
        stringBuffer.append("<TABLE name=\"" + XMLParser.XMLEncode(string) + "\">\n");
        this.writeIndent(stringBuffer, n += 3);
        stringBuffer.append("<FIELD name=\"_OID\" ucd=\"ID_NUMBER\" datatype=\"char\" type=\"hidden\"/>\n");
        int n2 = 0;
        while (n2 < legende.field.length) {
            Field field = legende.field[n2];
            this.writeIndent(stringBuffer, n);
            stringBuffer.append("<FIELD");
            int n3 = 0;
            n3 = this.writeAttribute(stringBuffer, n3, 3, n, "ID", field.ID == null ? field.name : field.ID);
            n3 = this.writeAttribute(stringBuffer, n3, 3, n, "name", field.name);
            n3 = this.writeAttribute(stringBuffer, n3, 3, n, "unit", field.unit);
            n3 = this.writeAttribute(stringBuffer, n3, 3, n, "ucd", field.ucd);
            n3 = this.writeAttribute(stringBuffer, n3, 3, n, "datatype", Save.toVOTableDatatype(field.datatype));
            n3 = this.writeAttribute(stringBuffer, n3, 3, n, "precision", field.precision);
            n3 = this.writeAttribute(stringBuffer, n3, 3, n, "width", field.width);
            n3 = this.writeAttribute(stringBuffer, n3, 3, n, "type", field.type);
            if (field.coo) {
                n3 = this.writeAttribute(stringBuffer, n3, 3, n, "ref", "J2000");
            }
            n3 = this.writeAttribute(stringBuffer, n3, 3, n, "arraysize", field.arraysize);
            stringBuffer.append("/>\n");
            ++n2;
        }
        this.writeIndent(stringBuffer, n);
        stringBuffer.append("<DATA><TABLEDATA>\n");
    }
}

