/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.EISFov;
import cds.aladin.Plan;
import cds.aladin.ResourceNode;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;

public class ResourceTree
extends Canvas {
    ScrollPane scroll = null;
    private Panel infoPanel = null;
    private GridBagLayout g = new GridBagLayout();
    private GridBagConstraints c = new GridBagConstraints();
    int prefHeight = 600;
    int prefWidth = 250;
    static final String NOIMAGE_WARNING = "can not be loaded : \nno cutout available at this position !\nClick on the region you are interested in\nAvailable images will be marked with a red tick";
    private static Button loadCatBtn;
    private static Button btn;
    private static Button btnHide;
    private static Button btnLoad;
    private static Button showAllLevBtn;
    private static Button hideAllLevBtn;
    private static Button expandBtn;
    private static Button expandAllBtn;
    static final int XSPACE = 22;
    static final int YSPACE = 18;
    static final int LOGOSIZE = 12;
    static final int LOGOPADDING = 4;
    static final Color LITBGCOLOR;
    static final Color LITFGCOLOR;
    static final Color selectedColor;
    static final Color mouseOverColor;
    static final Color underlineColor;
    static final Color lineColor;
    static final Color voidColor;
    static Font nameFont;
    static Font boldNameFont;
    ResourceNode rootNode;
    ResourceNode lastInfoNode;
    private ResourceNode ancienCurNode;
    private boolean expandAll = true;
    private boolean mustInit = true;
    int neededHeight = 0;
    Image buffer;
    Graphics h;
    int hilightNode;
    int oHilightNode = -1;
    ResourceNode selectedNode;
    ResourceNode oselectedNode;
    private Vector nodeFullList;
    ResourceNode[] nodeFullTab;
    private Vector nodeList;
    ResourceNode[] nodeTab;
    int yCurrent = 0;
    Aladin a;

    static {
        LITBGCOLOR = Color.yellow;
        LITFGCOLOR = Color.magenta;
        selectedColor = new Color(255, 190, 255);
        mouseOverColor = Color.blue;
        underlineColor = Color.green;
        lineColor = Color.darkGray;
        voidColor = Color.red;
        nameFont = Aladin.COURIER;
        boldNameFont = Aladin.BCOURIER;
    }

    ResourceTree(ResourceNode resourceNode) {
        this.rootNode = resourceNode;
        this.createButtons();
        this.traverseTree();
    }

    ResourceTree(ResourceNode resourceNode, Aladin aladin) {
        this(resourceNode);
        this.a = aladin;
        this.createButtons();
        this.traverseTree();
    }

    protected static boolean checkCutoutAvailability(ResourceNode resourceNode, double d, double d2, Aladin aladin) {
        Coord coord = new Coord(d, d2);
        Plan plan = aladin.calque.getPlanRef();
        if (plan == null || plan.projd == null) {
            return true;
        }
        coord = plan.projd.getXY(coord);
        Point point = aladin.calque.view.zoomview.getViewCoord(coord.x, coord.y);
        return ((EISFov)((Object)resourceNode.fov)).contains(point.x, point.y, plan, aladin.calque.view.zoomview);
    }

    private void clearSelected() {
        this.ancienCurNode = null;
        if (this.oHilightNode < 0) {
            return;
        }
        ResourceNode resourceNode = this.nodeTab[this.oHilightNode];
        this.h.setColor(Aladin.LGRAY);
        this.h.fillRect(resourceNode.x, this.oHilightNode * 18, this.h.getFontMetrics().stringWidth(resourceNode.name), 18);
        this.h.setColor(Color.black);
        if (resourceNode == this.lastInfoNode) {
            this.h.setFont(boldNameFont);
        } else {
            this.h.setFont(nameFont);
        }
        this.h.drawString(resourceNode.name, resourceNode.x, this.oHilightNode * 18 + 9 + 3);
        if (resourceNode.isLeaf) {
            this.h.setColor(Aladin.LGRAY);
            int n = this.h.getFontMetrics().stringWidth(resourceNode.name);
            this.h.drawLine(resourceNode.x, this.oHilightNode * 18 + 9 + 5, resourceNode.x + n, this.oHilightNode * 18 + 9 + 5);
        }
        if (resourceNode.framed) {
            this.frameNode(resourceNode);
        }
        this.oHilightNode = -1;
        this.repaint();
    }

    private void computeHeight() {
        this.neededHeight = 0;
        this.computeNodeHeight(this.rootNode);
    }

    private void computeNodeHeight(ResourceNode resourceNode) {
        this.neededHeight += 18;
        if (!resourceNode.isLeaf && resourceNode.isOpen) {
            Enumeration enumeration = resourceNode.children.elements();
            while (enumeration.hasMoreElements()) {
                this.computeNodeHeight((ResourceNode)enumeration.nextElement());
            }
        }
    }

    private void createButtons() {
        loadCatBtn = new Button("Load catalogue");
        loadCatBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResourceTree.this.loadCat(ResourceTree.this.lastInfoNode);
            }
        });
        btn = new Button("Display/hide image field");
        btn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResourceTree.this.fovAction(ResourceTree.this.lastInfoNode);
            }
        });
        btnHide = new Button("Hide all fields");
        btnHide.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResourceTree.this.hideAllFovs();
                ResourceTree.this.unframeAll();
                ResourceTree.this.repaint();
            }
        });
        btnLoad = new Button("Load image");
        btnLoad.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResourceTree.this.loadImage(ResourceTree.this.lastInfoNode);
            }
        });
        showAllLevBtn = new Button("Show all image fields for this level");
        showAllLevBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResourceTree.this.showAllLev(ResourceTree.this.lastInfoNode);
                ResourceTree.this.frameNode(ResourceTree.this.lastInfoNode);
                ResourceTree.this.repaint();
                ResourceTree.this.a.calque.view.repaint();
            }
        });
        hideAllLevBtn = new Button("Hide all image fields for this level");
        hideAllLevBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResourceTree.this.hideAllLev(ResourceTree.this.lastInfoNode);
                ResourceTree.this.unframeNode(ResourceTree.this.lastInfoNode);
                ResourceTree.this.repaint();
                ResourceTree.this.a.calque.view.repaint();
            }
        });
        expandBtn = new Button("Expand/Collapse this node");
        expandBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResourceTree.this.lastInfoNode.changeState();
                ResourceTree.this.doDisplay();
                ResourceTree.this.repaint();
            }
        });
        expandAllBtn = new Button("Expand/Collapse all nodes");
        expandAllBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ResourceTree.this.expandAll) {
                    ResourceTree.this.openAllNodes(ResourceTree.this.rootNode);
                } else {
                    ResourceTree.this.getStartPosition();
                }
                ResourceTree.this.expandAll = ResourceTree.this.expandAll ^ true;
                ResourceTree.this.doDisplay();
                ResourceTree.this.repaint();
            }
        });
    }

    private void deactivateCutoutFov() {
        this.a.calque.cutoutEISFov = null;
        this.a.calque.view.repaint();
    }

    private void displayIconLabel(ResourceNode resourceNode, int n) {
        this.drawLogo(n += 22, this.yCurrent, resourceNode);
        this.drawHorizLine(n, this.yCurrent, resourceNode);
        if (resourceNode.isLeaf) {
            this.drawCheckBox(n, this.yCurrent, resourceNode, true);
        }
        this.h.setFont(nameFont);
        resourceNode.x = n += 22;
        resourceNode.y = this.yCurrent;
        this.drawNodeName(resourceNode);
    }

    private void displayInfo(ResourceNode resourceNode, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        if (resourceNode.description == null || resourceNode.explanation == null) {
            return;
        }
        int n = 0;
        while (n < resourceNode.description.length) {
            if (resourceNode.explanation[n].length() != 0) {
                Label label = new Label(resourceNode.description[n]);
                label.setFont(Aladin.SITALIC);
                Label label2 = new Label(resourceNode.explanation[n]);
                label2.setFont(Aladin.SBOLD);
                gridBagConstraints.gridwidth = -1;
                gridBagConstraints.weightx = 0.0;
                gridBagLayout.setConstraints(label, gridBagConstraints);
                this.infoPanel.add(label);
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.weightx = 1.0;
                gridBagLayout.setConstraints(label2, gridBagConstraints);
                this.infoPanel.add(label2);
            }
            ++n;
        }
    }

    private void displayTree(ResourceNode resourceNode, int n) {
        int n2 = 0;
        this.nodeList.addElement(resourceNode);
        resourceNode.level = n;
        n2 += 22;
        int n3 = 1;
        while (n3 < n) {
            this.drawVertLine(n2 + 22, this.yCurrent);
            n2 += 22;
            ++n3;
        }
        if (!resourceNode.hide) {
            this.displayIconLabel(resourceNode, n2);
        } else {
            n2 += 22;
            resourceNode.x = n2 += 22;
            resourceNode.y = this.yCurrent;
        }
        if (resourceNode.framed) {
            this.frameNode(resourceNode);
        }
        this.yCurrent += 18;
        if (!resourceNode.isLeaf && resourceNode.isOpen) {
            if (resourceNode.nbChildren > 0) {
                ((ResourceNode)resourceNode.lastChild()).lastNode = true;
            }
            Enumeration enumeration = resourceNode.children.elements();
            while (enumeration.hasMoreElements()) {
                this.displayTree((ResourceNode)enumeration.nextElement(), n + 1);
            }
        }
    }

    void doDisplay() {
        this.yCurrent = 0;
        this.nodeList = new Vector();
        this.h.setColor(Aladin.LGRAY);
        this.h.fillRect(0, 0, this.size().width, this.size().height);
        this.h.setColor(Color.black);
        this.displayTree(this.rootNode, 0);
        this.hilightNode = -1;
        this.nodeTab = new ResourceNode[this.nodeList.size()];
        this.nodeList.copyInto(this.nodeTab);
        this.nodeList = null;
    }

    private void drawCheckBox(int n, int n2, ResourceNode resourceNode, boolean bl) {
        int n3 = 11;
        if (bl) {
            this.h.setColor(Color.white);
            this.h.fillRect(n + 11 - 5, n2 + 3, n3, n3);
        }
        this.h.setColor(Color.black);
        this.h.drawRect(n + 11 - 5, n2 + 3, n3, n3);
        this.h.setColor(Color.red);
        if (resourceNode.isSelected()) {
            this.h.drawLine(n + 11 - 5, n2 + 3 + n3 / 2, n + 11 - 5 + n3 / 2, n2 + 3 + n3);
            this.h.drawLine(n + 11 - 5 + n3 / 2, n2 + 3 + n3, n + 11 - 5 + n3, n2 + 3);
        }
    }

    private void drawFrame(ResourceNode resourceNode) {
        if (resourceNode.col == null) {
            this.h.setColor(Color.black);
        } else {
            this.h.setColor(resourceNode.col);
        }
        this.h.drawRect(resourceNode.x, resourceNode.y / 18 * 18 + 2, this.h.getFontMetrics().stringWidth(resourceNode.name), 12);
    }

    private void drawHalfVertLine(int n, int n2) {
        this.h.setColor(lineColor);
        this.h.drawLine(n + 11 - 2, n2 - 2, n + 11 - 2, n2 + 9);
    }

    private void drawHorizLine(int n, int n2, ResourceNode resourceNode) {
        this.h.setColor(lineColor);
        if (resourceNode.isLeaf) {
            this.h.drawLine(12 + n - 22, this.yCurrent + 9 - 1, 16 + n + 5 - 22, this.yCurrent + 9 - 1);
        } else {
            this.h.drawLine(16 + n, this.yCurrent + 9 - 1, 16 + n + 5, this.yCurrent + 9 - 1);
        }
    }

    private void drawLogo(int n, int n2, ResourceNode resourceNode) {
        if (resourceNode.isLeaf) {
            return;
        }
        this.h.setColor(Color.black);
        this.h.drawRect(n + 2, n2 + 2, 12, 12);
        if (resourceNode.isOpen) {
            this.h.drawLine(n + 2 + 4, n2 + 2 + 6, n + 2 + 12 - 4, n2 + 2 + 6);
        } else {
            this.h.drawLine(n + 2 + 6, n2 + 2 + 4, n + 2 + 6, n2 + 2 + 12 - 4);
            this.h.drawLine(n + 2 + 4, n2 + 2 + 6, n + 2 + 12 - 4, n2 + 2 + 6);
        }
    }

    private void drawNodeName(ResourceNode resourceNode) {
        this.h.setColor(Color.black);
        if (resourceNode.equals(this.lastInfoNode)) {
            this.h.setFont(boldNameFont);
        } else {
            this.h.setFont(nameFont);
        }
        if (this.oHilightNode >= 0 && this.nodeTab != null && resourceNode.equals(this.nodeTab[this.oHilightNode])) {
            this.h.setColor(mouseOverColor);
        }
        this.h.drawString(resourceNode.name, resourceNode.x, resourceNode.y + 9 + 3);
    }

    private void drawVertLine(int n, int n2) {
        this.h.setColor(lineColor);
        this.h.drawLine(n + 11 - 2, n2 - 2, n + 11 - 2, n2 + 18);
    }

    private void fovAction(ResourceNode resourceNode) {
        if (resourceNode.fov == null) {
            return;
        }
        int n = this.a.calque.EISFovs.indexOf(resourceNode.fov);
        if (n >= 0) {
            this.a.calque.EISFovs.removeElementAt(n);
        } else {
            this.a.calque.EISFovs.addElement(resourceNode.fov);
        }
        this.a.calque.view.repaint();
    }

    private void frameNode(ResourceNode resourceNode) {
        resourceNode.framed = true;
        this.drawFrame(resourceNode);
    }

    public Dimension getMinimumSize() {
        if (this.mustInit) {
            this.init();
            this.mustInit = false;
        }
        return new Dimension(this.prefWidth, this.prefHeight);
    }

    public Dimension getPreferredSize() {
        if (this.mustInit) {
            this.init();
            this.mustInit = false;
        }
        return new Dimension(this.prefWidth, this.prefHeight);
    }

    public Vector getSelectedLeaves() {
        Vector vector = new Vector();
        this.recGetSelectedLeaves(this.rootNode, vector);
        return vector;
    }

    protected void getStartPosition() {
        int n = 0;
        while (n < this.nodeFullTab.length) {
            ResourceNode resourceNode = this.nodeFullTab[n];
            if (!resourceNode.isLeaf) {
                resourceNode.isOpen = resourceNode.nbChildren <= 0 || !((ResourceNode)resourceNode.children.elementAt((int)0)).isLeaf && !((ResourceNode)resourceNode.children.elementAt((int)0)).name.startsWith("epoch");
            }
            ++n;
        }
    }

    private void hideAllFovs() {
        this.a.calque.EISFovs.removeAllElements();
        this.a.calque.view.repaint();
    }

    /*
     * Unable to fully structure code
     */
    private void hideAllLev(ResourceNode var1_1) {
        block2: {
            var2_2 = var1_1.children.elements();
            if (!var2_2.hasMoreElements()) break block2;
            var3_3 = (ResourceNode)var1_1.children.elementAt(0);
            if (var3_3.isLeaf) ** GOTO lbl13
            while (var2_2.hasMoreElements()) {
                this.hideAllLev((ResourceNode)var2_2.nextElement());
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                var3_3 = (ResourceNode)var2_2.nextElement();
                var4_4 = this.a.calque.EISFovs.indexOf(var3_3.fov);
                if (var4_4 < 0) continue;
                this.a.calque.EISFovs.removeElementAt(var4_4);
lbl13:
                // 3 sources

                ** while (var2_2.hasMoreElements())
            }
        }
    }

    private void hideFov(ResourceNode resourceNode) {
        this.a.calque.curEISFov = null;
        this.a.calque.view.repaint();
    }

    private boolean inLogo(ResourceNode resourceNode, int n) {
        int n2 = (resourceNode.level + 1) * 22;
        int n3 = (resourceNode.level + 2) * 22;
        return n > n2 && n < n3;
    }

    protected void init() {
        this.nodeList = new Vector();
        this.setSize(350, this.nodeFullTab.length * 18 + 20);
        this.prefWidth = 350;
        this.prefHeight = this.nodeFullTab.length * 18 + 20;
        this.buffer = this.createImage(this.size().width, this.size().height);
        this.h = this.buffer.getGraphics();
        this.doDisplay();
    }

    protected void litUpNode(ResourceNode resourceNode) {
        if (resourceNode.litup) {
            return;
        }
        resourceNode.litup = true;
        this.h.setColor(LITBGCOLOR);
        this.h.fillRect(resourceNode.x, resourceNode.y / 18 * 18, this.h.getFontMetrics().stringWidth(resourceNode.name), 18);
        this.h.setColor(LITFGCOLOR);
        if (resourceNode.equals(this.lastInfoNode)) {
            this.h.setFont(boldNameFont);
        } else {
            this.h.setFont(nameFont);
        }
        this.h.drawString(resourceNode.name, resourceNode.x, resourceNode.y + 9 + 3);
    }

    private void loadCat(ResourceNode resourceNode) {
        String string = this.a.dialog.goods.centerCutOut.getText().trim();
        if (string.length() == 0) {
            string = "CDFS";
        }
        this.a.dialog.goods.creatCatPlane(resourceNode.name, string, resourceNode.name);
    }

    private void loadImage(ResourceNode resourceNode) {
        if (resourceNode.fov == null) {
            return;
        }
        String string = String.valueOf(resourceNode.survey) + " " + resourceNode.color;
        String string2 = null;
        if (resourceNode.father != null && resourceNode.father.nbChildren > 1) {
            string2 = resourceNode.name;
        }
        if (resourceNode.cutout) {
            double d;
            double d2;
            try {
                Coord coord = new Coord(this.a.dialog.goods.centerCutOut.getText());
                d2 = coord.al;
                d = coord.del;
            }
            catch (Exception exception) {
                d2 = 53.11629;
                d = -27.80875;
            }
            String string3 = Coord.getSexa(d2, d, " ");
            if (ResourceTree.checkCutoutAvailability(resourceNode, d2, d, this.a)) {
                this.a.dialog.goods.creatAladinPlane(string3, "FITS", "STAND", string, null, null, resourceNode.name, resourceNode.epoch, string2);
            } else {
                this.a.message.warning("Image " + resourceNode.name + " " + NOIMAGE_WARNING, 1);
            }
        } else {
            this.a.dialog.goods.creatAladinPlane(Coord.getSexa(((EISFov)((Object)resourceNode.fov)).alpha, ((EISFov)((Object)resourceNode.fov)).delta, " "), "FITS", "STAND", string, null, null, resourceNode.name, resourceNode.epoch, string2);
        }
    }

    public boolean mouseDown(Event event, int n, int n2) {
        this.oselectedNode = this.selectedNode;
        try {
            this.selectedNode = this.nodeTab[n2 / 18];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return true;
        }
        if (this.selectedNode.hide) {
            return true;
        }
        boolean bl = this.inLogo(this.selectedNode, n);
        if (this.infoPanel != null && !this.selectedNode.equals(this.lastInfoNode) && !bl) {
            this.showInfo(this.selectedNode);
            ResourceNode resourceNode = this.lastInfoNode;
            this.lastInfoNode = this.selectedNode;
            try {
                this.h.setColor(Aladin.LGRAY);
                this.h.fillRect(this.selectedNode.x, n2 / 18 * 18, this.h.getFontMetrics().stringWidth(this.lastInfoNode.name), 18);
                this.h.setFont(boldNameFont);
                if (n2 / 18 == this.oHilightNode) {
                    this.h.setColor(mouseOverColor);
                } else {
                    this.h.setColor(Color.black);
                }
                this.h.drawString(this.lastInfoNode.name, this.lastInfoNode.x, n2 / 18 * 18 + 9 + 3);
                if (this.lastInfoNode.framed) {
                    this.frameNode(this.lastInfoNode);
                }
                if (n2 / 18 == this.oHilightNode && this.lastInfoNode.isLeaf) {
                    this.h.setColor(underlineColor);
                    int n3 = this.h.getFontMetrics().stringWidth(this.lastInfoNode.name);
                    this.h.drawLine(this.lastInfoNode.x, n2 / 18 * 18 + 9 + 5, this.lastInfoNode.x + n3, n2 / 18 * 18 + 9 + 5);
                }
                if (resourceNode != null && !resourceNode.hide) {
                    this.h.setColor(Aladin.LGRAY);
                    this.h.fillRect(resourceNode.x, resourceNode.y / 18 * 18, this.h.getFontMetrics().stringWidth(resourceNode.name), 18);
                    this.h.setFont(nameFont);
                    this.h.setColor(Color.black);
                    this.h.drawString(resourceNode.name, resourceNode.x, resourceNode.y / 18 * 18 + 9 + 3);
                    if (resourceNode.framed) {
                        this.frameNode(resourceNode);
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        }
        if (this.selectedNode.isLeaf) {
            if (bl) {
                this.selectedNode.isSelected ^= true;
                this.drawCheckBox(this.selectedNode.x - 22, this.selectedNode.y, this.selectedNode, true);
            }
            this.repaint();
        } else {
            if (bl) {
                this.selectedNode.changeState();
                this.doDisplay();
            }
            this.repaint();
        }
        return true;
    }

    public boolean mouseExit(Event event, int n, int n2) {
        this.a.calque.curEISFov = null;
        this.a.calque.cutoutEISFov = null;
        this.clearSelected();
        this.a.calque.repaint();
        return true;
    }

    public boolean mouseMove(Event event, int n, int n2) {
        ResourceNode resourceNode;
        this.hilightNode = n2 / 18;
        this.h.setFont(nameFont);
        try {
            resourceNode = this.nodeTab[this.hilightNode];
            if (resourceNode.hide) {
                return true;
            }
            if (this.ancienCurNode == resourceNode) {
                return true;
            }
            this.ancienCurNode = resourceNode;
            this.h.setColor(Aladin.LGRAY);
            this.h.fillRect(resourceNode.x, this.hilightNode * 18, this.h.getFontMetrics().stringWidth(resourceNode.name), 18);
            this.h.setColor(mouseOverColor);
            if (resourceNode.equals(this.lastInfoNode)) {
                this.h.setFont(boldNameFont);
            }
            this.h.drawString(resourceNode.name, resourceNode.x, this.hilightNode * 18 + 9 + 3);
            this.h.setColor(underlineColor);
            if (resourceNode.isLeaf) {
                int n3 = this.h.getFontMetrics().stringWidth(resourceNode.name);
                this.h.drawLine(resourceNode.x, this.hilightNode * 18 + 9 + 5, resourceNode.x + n3, this.hilightNode * 18 + 9 + 5);
            }
            if (resourceNode.framed) {
                this.frameNode(resourceNode);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return true;
        }
        if (resourceNode.isLeaf && resourceNode.type == 1) {
            this.showFov(resourceNode);
            if (resourceNode.cutout) {
                this.showCutoutFov(resourceNode);
            } else {
                this.deactivateCutoutFov();
            }
        } else {
            this.deactivateCutoutFov();
        }
        if (this.oHilightNode != this.hilightNode) {
            this.h.setColor(Color.black);
            this.h.setFont(nameFont);
            try {
                ResourceNode resourceNode2 = this.nodeTab[this.oHilightNode];
                if (!resourceNode.isLeaf) {
                    this.hideFov(resourceNode2);
                }
                if (this.nodeTab[this.oHilightNode].equals(this.lastInfoNode)) {
                    this.h.setFont(boldNameFont);
                }
                this.h.setColor(Aladin.LGRAY);
                this.h.fillRect(resourceNode2.x, this.oHilightNode * 18, this.h.getFontMetrics().stringWidth(resourceNode2.name), 18);
                this.h.setColor(Color.black);
                this.h.drawString(resourceNode2.name, resourceNode2.x, this.oHilightNode * 18 + 9 + 3);
                if (resourceNode2.framed) {
                    this.frameNode(resourceNode2);
                }
                if (resourceNode2.isLeaf) {
                    this.h.setColor(Aladin.LGRAY);
                    int n4 = this.h.getFontMetrics().stringWidth(resourceNode2.name);
                    this.h.drawLine(resourceNode2.x, this.oHilightNode * 18 + 9 + 5, resourceNode2.x + n4, this.oHilightNode * 18 + 9 + 5);
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        }
        this.oHilightNode = this.hilightNode;
        this.repaint();
        return true;
    }

    public void openAllNodes(ResourceNode resourceNode) {
        this.recOpenAllNodes(resourceNode);
    }

    public void paint(Graphics graphics) {
        if (this.mustInit) {
            this.init();
            this.mustInit = false;
        }
        graphics.drawImage(this.buffer, 0, 0, null);
    }

    private void recGetSelectedLeaves(ResourceNode resourceNode, Vector vector) {
        if (resourceNode.isSelected()) {
            vector.addElement(resourceNode);
        }
        if (resourceNode.isOpen) {
            Enumeration enumeration = resourceNode.children.elements();
            while (enumeration.hasMoreElements()) {
                this.recGetSelectedLeaves((ResourceNode)enumeration.nextElement(), vector);
            }
        }
    }

    private void recOpenAllNodes(ResourceNode resourceNode) {
        resourceNode.isOpen = true;
        Enumeration enumeration = resourceNode.children.elements();
        while (enumeration.hasMoreElements()) {
            this.recOpenAllNodes((ResourceNode)enumeration.nextElement());
        }
    }

    private void recTraverseTree(ResourceNode resourceNode) {
        this.nodeFullList.addElement(resourceNode);
        Enumeration enumeration = resourceNode.children.elements();
        while (enumeration.hasMoreElements()) {
            this.recTraverseTree((ResourceNode)enumeration.nextElement());
        }
    }

    protected void resetCb() {
        int n = 0;
        while (n < this.nodeFullTab.length) {
            if (this.nodeFullTab[n].isLeaf) {
                this.nodeFullTab[n].isSelected = false;
            }
            ++n;
        }
        this.oHilightNode = -1;
        this.doDisplay();
        this.repaint();
    }

    public ResourceNode searchNodeByName(String string) {
        int n = 0;
        while (n < this.nodeFullTab.length) {
            if (this.nodeFullTab[n].name.equals(string)) {
                return this.nodeFullTab[n];
            }
            ++n;
        }
        return null;
    }

    protected void setInfoPanel(Panel panel) {
        this.infoPanel = panel;
        this.infoPanel.setLayout(this.g);
    }

    /*
     * Unable to fully structure code
     */
    private void showAllLev(ResourceNode var1_1) {
        block3: {
            var2_2 = var1_1.children.elements();
            var3_3 = (ResourceNode)var1_1.children.elementAt(0);
            if (var3_3.isLeaf) ** GOTO lbl13
            while (var2_2.hasMoreElements()) {
                this.showAllLev((ResourceNode)var2_2.nextElement());
            }
            break block3;
lbl-1000:
            // 1 sources

            {
                var3_3 = (ResourceNode)var2_2.nextElement();
                if (var3_3.fov == null) {
                    return;
                }
                if (this.a.calque.EISFovs.contains(var3_3.fov)) continue;
                this.a.calque.EISFovs.addElement(var3_3.fov);
lbl13:
                // 3 sources

                ** while (var2_2.hasMoreElements())
            }
        }
    }

    private void showCutoutFov(ResourceNode resourceNode) {
        if (resourceNode.fov == null) {
            return;
        }
        try {
            this.a.calque.cutoutEISFov = new EISFov(this.a.dialog.goods.centerCutOut.getText(), ((EISFov)((Object)resourceNode.fov)).cutout_x, ((EISFov)((Object)resourceNode.fov)).cutout_y, ((EISFov)((Object)resourceNode.fov)).angle);
        }
        catch (Exception exception) {
            this.a.calque.cutoutEISFov = new EISFov(53.11629, -27.80875, ((EISFov)((Object)resourceNode.fov)).cutout_x, ((EISFov)((Object)resourceNode.fov)).cutout_y, ((EISFov)((Object)resourceNode.fov)).angle);
        }
        this.a.calque.view.repaint();
    }

    private void showFov(ResourceNode resourceNode) {
        if (resourceNode.fov == null) {
            return;
        }
        this.a.calque.curEISFov = resourceNode.fov;
        this.a.calque.view.repaint();
    }

    private void showInfo(ResourceNode resourceNode) {
        this.infoPanel.removeAll();
        this.c.fill = 1;
        if (resourceNode.type == 1) {
            this.displayInfo(resourceNode, this.g, this.c);
            if (resourceNode.filterDesc != null && resourceNode.filterExpla != null) {
                Label label = new Label(" ");
                this.c.gridwidth = 0;
                this.c.weightx = 1.0;
                this.g.setConstraints(label, this.c);
                this.infoPanel.add(label);
                Label label2 = new Label("Filter characteristics");
                label2.setFont(Aladin.BOLD);
                this.c.gridwidth = 0;
                this.c.weightx = 1.0;
                this.g.setConstraints(label2, this.c);
                this.infoPanel.add(label2);
                int n = 0;
                while (n < resourceNode.filterDesc.length) {
                    if (resourceNode.filterExpla[n].length() != 0) {
                        Label label3 = new Label(resourceNode.filterDesc[n]);
                        label3.setFont(Aladin.SITALIC);
                        Label label4 = new Label(resourceNode.filterExpla[n]);
                        label4.setFont(Aladin.SBOLD);
                        this.c.gridwidth = -1;
                        this.c.weightx = 0.0;
                        this.g.setConstraints(label3, this.c);
                        this.infoPanel.add(label3);
                        this.c.gridwidth = 0;
                        this.c.weightx = 1.0;
                        this.g.setConstraints(label4, this.c);
                        this.infoPanel.add(label4);
                    }
                    ++n;
                }
            }
            if (resourceNode.isLeaf) {
                this.c.gridwidth = 0;
                this.c.weightx = 0.0;
                this.g.setConstraints(btn, this.c);
                this.infoPanel.add(btn);
                this.c.gridwidth = 0;
                this.c.weightx = 0.0;
                this.g.setConstraints(btnHide, this.c);
                this.infoPanel.add(btnHide);
                this.c.gridwidth = 0;
                this.c.weightx = 0.0;
                this.g.setConstraints(btnLoad, this.c);
                this.infoPanel.add(btnLoad);
            } else {
                this.c.gridwidth = 0;
                this.c.weightx = 0.0;
                this.g.setConstraints(showAllLevBtn, this.c);
                this.infoPanel.add(showAllLevBtn);
                this.c.gridwidth = 0;
                this.c.weightx = 0.0;
                this.g.setConstraints(hideAllLevBtn, this.c);
                this.infoPanel.add(hideAllLevBtn);
            }
        } else if (resourceNode.type == 2 && resourceNode.isLeaf) {
            String string = resourceNode.catDesc;
            String string2 = null;
            int n = resourceNode.catDesc.indexOf("(");
            if (n > 0) {
                string = resourceNode.catDesc.substring(0, n);
                string2 = resourceNode.catDesc.substring(n);
            }
            Label label = new Label(string);
            label.setFont(Aladin.SBOLD);
            this.c.gridwidth = 0;
            this.c.weightx = 1.0;
            this.g.setConstraints(label, this.c);
            this.infoPanel.add(label);
            if (string2 != null) {
                Label label5 = new Label(string2);
                label5.setFont(Aladin.SBOLD);
                this.c.gridwidth = 0;
                this.c.weightx = 1.0;
                this.g.setConstraints(label5, this.c);
                this.infoPanel.add(label5);
            }
            this.displayInfo(resourceNode, this.g, this.c);
            this.c.gridwidth = 0;
            this.c.weightx = 0.0;
            this.g.setConstraints(loadCatBtn, this.c);
            this.infoPanel.add(loadCatBtn);
        }
        if (!resourceNode.isLeaf) {
            this.c.gridwidth = 0;
            this.c.weightx = 0.0;
            this.g.setConstraints(expandBtn, this.c);
            this.infoPanel.add(expandBtn);
            this.c.gridwidth = 0;
            this.c.weightx = 0.0;
            this.g.setConstraints(expandAllBtn, this.c);
            this.infoPanel.add(expandAllBtn);
        }
        this.infoPanel.invalidate();
        this.infoPanel.validate();
    }

    private void traverseTree() {
        this.nodeFullList = new Vector();
        this.recTraverseTree(this.rootNode);
        this.nodeFullTab = new ResourceNode[this.nodeFullList.size()];
        this.nodeFullList.copyInto(this.nodeFullTab);
    }

    protected void turnOffAllNodes() {
        int n = 0;
        while (n < this.nodeTab.length) {
            if (this.nodeTab[n].isLeaf && this.nodeTab[n].type == 1) {
                this.turnOffNode(this.nodeTab[n]);
            }
            ++n;
        }
        this.repaint();
    }

    protected void turnOffNode(ResourceNode resourceNode) {
        if (!resourceNode.litup) {
            return;
        }
        resourceNode.litup = false;
        this.h.setColor(Aladin.LGRAY);
        this.h.fillRect(resourceNode.x, resourceNode.y / 18 * 18, this.h.getFontMetrics().stringWidth(resourceNode.name), 18);
        if (resourceNode.equals(this.lastInfoNode)) {
            this.h.setFont(boldNameFont);
        } else {
            this.h.setFont(nameFont);
        }
        this.h.setColor(Color.black);
        this.h.drawString(resourceNode.name, resourceNode.x, resourceNode.y + 9 + 3);
    }

    private void unframeAll() {
        int n = 0;
        while (n < this.nodeFullTab.length) {
            if (this.nodeFullTab[n].framed) {
                this.unframeNode(this.nodeFullTab[n]);
            }
            ++n;
        }
    }

    private void unframeNode(ResourceNode resourceNode) {
        Enumeration enumeration;
        if (resourceNode.framed) {
            resourceNode.framed = false;
            this.h.setColor(Aladin.LGRAY);
            this.h.fillRect(resourceNode.x, resourceNode.y / 18 * 18, this.h.getFontMetrics().stringWidth(resourceNode.name) + 1, 18);
            this.drawNodeName(resourceNode);
        }
        if ((enumeration = resourceNode.children.elements()).hasMoreElements()) {
            ResourceNode resourceNode2 = (ResourceNode)resourceNode.children.elementAt(0);
            if (!resourceNode2.isLeaf) {
                while (enumeration.hasMoreElements()) {
                    this.unframeNode((ResourceNode)enumeration.nextElement());
                }
            }
        }
    }

    public void update(Graphics graphics) {
        if (this.mustInit) {
            this.init();
            this.mustInit = false;
        }
        this.paint(graphics);
    }
}

