/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Coord;
import cds.aladin.Plan;
import cds.aladin.PlanTool;
import cds.aladin.Position;
import cds.aladin.ZoomView;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;

public class Repere
extends Position {
    static final int DEFAULT = 0;
    static final int TARGET = 1;
    int L = 5;
    int dw;
    int dh;
    int type = 0;

    protected Repere(Plan plan) {
        super(plan);
    }

    protected Repere(Plan plan, double d, double d2) {
        super(plan, d, d2, 0.0, 0.0, 5, null);
        char[] cArray = this.id.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            if (cArray[n] == ':') {
                cArray[n] = 32;
            }
            ++n;
        }
        plan.aladin.pad.setText(String.valueOf(new String(cArray)) + "\n");
    }

    protected Repere(Plan plan, double d, double d2, double d3, double d4) {
        super(plan, d, d2, d3, d4, 3, null);
        this.setId();
        this.withlabel = false;
    }

    protected Repere(Plan plan, Coord coord) {
        super(plan, 0.0, 0.0, coord.al, coord.del, 10, null);
    }

    protected void draw(Graphics graphics, ZoomView zoomView, int n, int n2) {
        Point point = this.getViewCoord(zoomView, this.L, this.L);
        if (point.x < 0) {
            return;
        }
        point.x += n;
        point.y += n2;
        if (this.plan != null) {
            graphics.setColor(this.type == 1 ? this.plan.aladin.calque.plan[0].c : this.plan.c);
        }
        switch (this.type) {
            case 0: {
                graphics.drawLine(point.x - this.L, point.y, point.x + this.L, point.y);
                graphics.drawLine(point.x, point.y - this.L, point.x, point.y + this.L);
                break;
            }
            case 1: {
                graphics.drawLine(point.x - this.L, point.y, point.x - 3, point.y);
                graphics.drawLine(point.x + 3, point.y, point.x + this.L, point.y);
                graphics.drawLine(point.x, point.y - this.L, point.x, point.y - 3);
                graphics.drawLine(point.x, point.y + 3, point.x, point.y + this.L);
                break;
            }
        }
        if (this.withlabel) {
            graphics.drawString(this.id, point.x - this.dw / 2, point.y - this.L - 1);
        }
        if (this.select) {
            this.drawSelect(graphics, zoomView);
        }
    }

    protected Rectangle getClip(ZoomView zoomView) {
        Point point = this.getViewCoord(zoomView, this.L, this.L);
        Rectangle rectangle = this.select ? new Rectangle(point.x - this.L - 4, point.y - this.L - 4, this.L * 2 + 8, this.L * 2 + 8) : new Rectangle(point.x - this.L, point.y - this.L, this.L * 2, this.L * 2);
        if (this.withlabel) {
            rectangle = rectangle.union(new Rectangle(point.x - this.dw / 2, point.y - this.L - 1 - this.dh - 1, this.dw, this.dh));
        }
        return rectangle;
    }

    protected boolean inside(double d, double d2, double d3) {
        double d4 = (double)this.L / d3;
        return this.x <= d + d4 && this.x >= d - d4 && this.y <= d2 + d4 && this.y >= d2 - d4;
    }

    protected void setCoord() {
        super.setCoord();
        this.setId();
    }

    void setD() {
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(Position.DF);
        this.dw = fontMetrics.stringWidth(this.id) + 4;
        this.dh = Position.HF;
    }

    void setId() {
        this.id = this.plan.type == 3 && ((PlanTool)this.plan).lock() ? "(" + this.x + "," + this.y + ")" : this.plan.aladin.localisation.toString(this.raj, this.dej);
        this.setD();
    }

    protected void setSize(int n) {
        this.L = n;
    }

    protected void setType(int n) {
        this.type = n;
    }
}

