/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.Couleur;
import cds.aladin.Curseur;
import cds.aladin.Filet;
import cds.aladin.FrameNewCalib;
import cds.aladin.Histogramme;
import cds.aladin.Plan;
import cds.aladin.PlanCatalog;
import cds.aladin.PlanContour;
import cds.aladin.PlanField;
import cds.aladin.PlanFree;
import cds.aladin.PlanImage;
import cds.aladin.PlanImageRGB;
import cds.aladin.PlanTool;
import cds.aladin.Projection;
import cds.aladin.Source;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.TextField;
import java.io.Serializable;

public final class Properties
extends Frame {
    static String SEEFITS = "Get header";
    static String NEWCALIB = "New...";
    static String MODCALIB = "Edit...";
    static String TOPBOTTOM = "Top/Bottom";
    static String RIGHTLEFT = "Right/Left";
    Aladin aladin;
    Plan plan;
    Panel panel;
    PlanFree pmemo = null;
    int hcmemo = 0;
    boolean flagHide = true;
    TextField label;
    Couleur couleur = null;
    Choice sourceType = null;
    CheckboxGroup state = null;
    Checkbox viewableCb;
    Checkbox hiddenCb;
    CheckboxGroup xyLock = null;
    Choice planRefChoice = null;
    Plan[] planRef = null;
    Choice projsChoice = null;
    Projection[] projs = null;
    Button modCalib = null;
    TextField centerField = null;
    String sField = null;
    TextField rollField = null;
    TextField eqField = null;
    String sEquinox = null;
    String sRoll = null;
    Checkbox cbT = null;
    Checkbox cbS = null;
    Checkbox cbG = null;
    Checkbox[] contoursCB;
    Couleur[] contoursCouleurs;
    Curseur curs = null;
    Panel panelCont;
    Panel panelScroll;
    ScrollPane scroll;

    protected Properties(Aladin aladin) {
        super("Properties");
        ((Component)this).setBackground(Aladin.BKGD);
        this.aladin = aladin;
        super.show();
        if (!Aladin.LSCREEN) {
            this.move(400, 300);
        } else {
            this.move(800, 400);
        }
        super.hide();
    }

    public boolean action(Event event, Object object) {
        if (event.target == this.projsChoice && this.projsChoice.countItems() > 1) {
            int n = this.projsChoice.getSelectedIndex();
            this.modCalib.setEnabled(this.projs[n].isModifiable());
            if (this.plan.xyLock) {
                this.plan.pcat.setCoord(this.projs[n]);
                this.aladin.view.repaint();
            } else {
                this.apply();
            }
            return true;
        }
        if (event.target == this.planRefChoice) {
            this.apply();
        } else if ("Close".equals(object)) {
            this.hide();
        } else if (TOPBOTTOM.equals(object)) {
            ((PlanImage)this.plan).flip(0);
        } else if (RIGHTLEFT.equals(object)) {
            ((PlanImage)this.plan).flip(1);
        } else if (NEWCALIB.equals(object)) {
            Plan plan;
            Plan plan2 = plan = this.plan.xyLock ? this.plan : this.aladin.calque.getPlanRef();
            if (this.aladin.frameNewCalib == null) {
                this.aladin.frameNewCalib = new FrameNewCalib(this.aladin, plan, null);
            } else {
                this.aladin.frameNewCalib.majFrameNewCalib(plan);
            }
        } else if (MODCALIB.equals(object)) {
            Plan plan;
            Plan plan3 = plan = this.plan.xyLock ? this.plan : this.aladin.calque.getPlanRef();
            if (this.aladin.frameNewCalib == null) {
                this.aladin.frameNewCalib = new FrameNewCalib(this.aladin, plan, this.projs[this.projsChoice.getSelectedIndex()]);
            } else {
                this.aladin.frameNewCalib.majFrameNewCalib(plan, this.projs[this.projsChoice.getSelectedIndex()]);
            }
        } else if ("Apply".equals(object)) {
            this.apply();
        } else if (SEEFITS.equals(object)) {
            ((PlanImage)this.plan).headerFits.seeHeaderFits();
        }
        return true;
    }

    private void actionPlanRefProjs() {
        if (this.planRefChoice.getSelectedIndex() < 0 || this.projsChoice.getSelectedIndex() < 0) {
            return;
        }
        Plan plan = this.planRef[this.planRefChoice.getSelectedIndex()];
        boolean bl = false;
        if (!plan.ref) {
            Aladin.trace(2, "New reference plane => " + plan.label);
            this.aladin.calque.setPlanRef(plan);
            this.majProjs();
            bl = true;
        }
        if (this.projsChoice.getSelectedIndex() < 0) {
            return;
        }
        Projection projection = this.projs[this.projsChoice.getSelectedIndex()];
        if (plan.projd != projection) {
            Aladin.trace(2, "New proj. method for plane " + plan.label + " => " + projection.label);
            plan.projd = projection;
            bl = true;
        }
        if (!bl) {
            return;
        }
        this.plan.flagProj = false;
        this.aladin.calque.view.newView();
        this.aladin.calque.repaint();
        this.majPlanRef();
        this.majProjs();
    }

    protected static void addCouple(Panel panel, String string, Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        Label label = new Label(string);
        label.setFont(Aladin.ITALIC);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        panel.add(label);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        panel.add(component);
    }

    protected static void addFilet(Panel panel, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        Filet filet = new Filet();
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(filet, gridBagConstraints);
        panel.add(filet);
    }

    private void apply() {
        String string;
        Color[] colorArray;
        PlanContour planContour;
        int n;
        this.plan.label = this.label.getText();
        if (this.planRefChoice != null) {
            this.actionPlanRefProjs();
        }
        if (this.couleur != null && !(this.plan instanceof PlanContour)) {
            this.plan.c = this.couleur.getCouleur();
        }
        if (this.state != null) {
            n = this.state.getCurrent().getLabel().equals("viewable");
            if (n != 0 && !this.plan.isViewable()) {
                this.aladin.calque.setPlanRef(this.plan);
            }
            this.plan.active = n;
        }
        if (this.plan instanceof PlanContour) {
            planContour = (PlanContour)this.plan;
            n = 0;
            while (n < planContour.orgLevels.length) {
                planContour.setViewable(n, this.contoursCB[n].getState());
                planContour.adjustColor(this.contoursCouleurs[n].getCouleur(), n);
                ++n;
            }
            double[] dArray = new double[this.curs.niveaux.length];
            n = 0;
            while (n < dArray.length) {
                dArray[n] = this.curs.niveaux[n];
                ++n;
            }
            planContour.adjustContour(dArray);
            this.curs.repaint();
            Color color = this.couleur.getCouleur();
            if (!color.equals(planContour.c)) {
                planContour.c = new Color(color.getRGB());
                colorArray = Couleur.getBrighterColors(planContour.c, 4);
                n = 0;
                while (n < planContour.nbLevels) {
                    planContour.adjustColor(new Color(colorArray[n % colorArray.length].getRGB()), n);
                    ++n;
                }
                this.pmemo = null;
                this.showProp(this.plan);
            }
        }
        if (this.plan.type == 3 && this.xyLock != null) {
            ((PlanTool)this.plan).setLock(this.xyLock.getCurrent().getLabel().equals("yes"));
        }
        if (this.centerField != null) {
            String string2 = this.centerField.getText();
            PlanContour planContour2 = planContour = this.rollField != null ? this.rollField.getText() : null;
            if (!string2.equals(this.sField) || planContour != null && !((String)((Object)planContour)).equals(this.sRoll)) {
                try {
                    double d = planContour == null ? 0.0 : Double.valueOf((String)((Object)planContour));
                    colorArray = new Coord(string2);
                    ((PlanField)this.plan).setCenter(colorArray.al, colorArray.del, d);
                    this.aladin.calque.view.newView();
                }
                catch (Exception exception) {
                    this.aladin.message.warning(" Coordinates error  ");
                }
            }
        }
        if (this.eqField != null && !(string = this.eqField.getText()).equals(this.sEquinox)) {
            ((PlanImage)this.plan).projd.c.SetEquinox(Double.valueOf(string));
            this.plan.flagProj = false;
            this.aladin.calque.view.newView();
        }
        if (this.sourceType != null) {
            ((PlanCatalog)this.plan).setSourceType(this.sourceType.getSelectedIndex());
        }
        this.aladin.view.repaint();
        this.aladin.calque.select.repaint();
        this.aladin.calque.zoom.zoomView.repaint();
    }

    public boolean handleEvent(Event event) {
        if (event.id == 201) {
            this.hide();
        }
        return super.handleEvent(event);
    }

    public void hide() {
        this.flagHide = true;
        this.aladin.toolbox.tool[7].mode = 1;
        this.aladin.toolbox.toolMode();
        this.aladin.toolbox.repaint();
        super.hide();
    }

    private void majPlanRef() {
        int n = 0;
        this.planRef = this.plan.getAvailablePlanRef();
        if (this.planRefChoice == null) {
            this.planRefChoice = new Choice();
        }
        this.planRefChoice.removeAll();
        if (this.planRef.length > 0) {
            int n2 = 0;
            while (n2 < this.planRef.length) {
                String string = String.valueOf(Plan.Tp[this.planRef[n2].type]) + " \"" + this.planRef[n2].label + "\"";
                this.planRefChoice.addItem(string);
                if (this.planRef[n2].ref) {
                    n = n2;
                }
                ++n2;
            }
            this.planRefChoice.select(n);
        }
    }

    protected void majProjs() {
        int n = -1;
        Plan plan = null;
        if (this.plan.xyLock) {
            this.projs = this.plan.getAvailableProj();
        } else if (this.planRefChoice.getSelectedIndex() >= 0) {
            plan = this.planRef[this.planRefChoice.getSelectedIndex()];
            this.projs = plan.getAvailableProj();
        }
        if (this.projsChoice == null) {
            this.projsChoice = new Choice();
        }
        this.projsChoice.removeAll();
        if (this.projs != null && plan != null && this.projs.length > 0) {
            int n2 = 0;
            while (n2 < this.projs.length) {
                this.projsChoice.addItem(this.projs[n2].label);
                if (this.plan.xyLock) {
                    if (this.plan.projd == this.projs[n2]) {
                        n = n2;
                    }
                } else if (plan.projd == this.projs[n2]) {
                    n = n2;
                }
                ++n2;
            }
            this.projsChoice.select(n);
            this.modCalib.setEnabled(n >= 0 && this.projs[n].isModifiable());
        } else {
            this.modCalib.setEnabled(false);
        }
    }

    protected void majProp() {
        int n = this.aladin.calque.getFirstSelected();
        if (n >= 0 && this.aladin.calque.plan[n].type == 6) {
            return;
        }
        if (this.aladin.toolbox.tool[7].mode == -1 && n >= 0 && this.aladin.calque.plan[n].type != 6) {
            this.showProp(this.aladin.calque.plan[n]);
            return;
        }
        if (!this.flagHide) {
            this.hide();
        }
    }

    private void majState(Plan plan) {
        if (plan == null || this.hiddenCb == null || this.viewableCb == null) {
            return;
        }
        this.hiddenCb.setState(plan.active ^ true);
        this.viewableCb.setState(plan.active);
    }

    protected Panel propertiesPlan() {
        Serializable serializable;
        Object object;
        Object object2;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagConstraints.fill = 1;
        Panel panel = new Panel();
        panel.setLayout(gridBagLayout);
        this.label = new TextField(this.plan.label, 15);
        Properties.addCouple(panel, "Label:", this.label, gridBagLayout, gridBagConstraints);
        if (this.plan.type != 1 && this.plan.type != 5 && !(this.plan instanceof PlanContour)) {
            this.couleur = new Couleur(this.plan.c);
            Properties.addCouple(panel, "Color:", this.couleur, gridBagLayout, gridBagConstraints);
        }
        if (this.plan instanceof PlanContour) {
            PlanContour cfr_ignored_0 = (PlanContour)this.plan;
            this.couleur = new Couleur(PlanContour.couleursBase, this.plan.c, 25, 4);
            Properties.addCouple(panel, "Color:", this.couleur, gridBagLayout, gridBagConstraints);
        }
        if (!this.plan.flagOk) {
            object2 = new Label();
            ((Component)object2).setForeground(Color.red);
            ((Component)object2).setFont(Aladin.BOLD);
            if (this.plan.error != null) {
                object = "Error:";
                ((Label)object2).setText(this.plan.error);
            } else {
                object = "State:";
                ((Label)object2).setText("Plane under construction...");
            }
            Properties.addCouple(panel, (String)object, (Component)object2, gridBagLayout, gridBagConstraints);
        }
        if (this.plan.flagOk) {
            if (this.plan.type == 2) {
                this.sourceType = new Choice();
                int n = 0;
                while (n < Source.TYPENAME.length) {
                    this.sourceType.addItem(Source.TYPENAME[n]);
                    ++n;
                }
                this.sourceType.select(this.plan.pcat.sourceType);
                Properties.addCouple(panel, "Shape:", this.sourceType, gridBagLayout, gridBagConstraints);
            }
            object2 = new Panel();
            ((Container)object2).setLayout(new FlowLayout(0));
            if (this.plan.type != 5) {
                this.state = new CheckboxGroup();
                this.hiddenCb = new Checkbox("hidden", this.plan.active ^ true, this.state);
                this.viewableCb = new Checkbox("viewable", this.plan.active, this.state);
                ((Container)object2).add(this.hiddenCb);
                ((Container)object2).add(this.viewableCb);
                Properties.addCouple(panel, "State:", (Component)object2, gridBagLayout, gridBagConstraints);
            } else {
                this.state = null;
            }
            if (this.plan instanceof PlanContour) {
                Object object3;
                object = (PlanContour)this.plan;
                Properties.addCouple(panel, "Image:", new Label(String.valueOf(((PlanContour)object).p.label) + " - " + ((PlanContour)object).p.objet), gridBagLayout, gridBagConstraints);
                this.contoursCB = new Checkbox[((PlanContour)object).levels.length];
                this.contoursCouleurs = new Couleur[((PlanContour)object).levels.length];
                int n = 150;
                int n2 = 200;
                this.panelScroll = new Panel();
                this.panelScroll.setLayout(gridBagLayout);
                this.scroll = new ScrollPane(0);
                this.scroll.setSize(n, n2);
                int n3 = 0;
                while (n3 < ((PlanContour)object).orgLevels.length) {
                    this.contoursCB[n3] = new Checkbox("Viewable", ((PlanContour)object).isViewable(n3));
                    this.panelCont = new Panel();
                    this.panelCont.add(this.contoursCB[n3]);
                    this.contoursCouleurs[n3] = new Couleur(((PlanContour)object).couleursContours[n3], 15, 3, Couleur.getBrighterColors(((Plan)object).c, 4));
                    this.panelCont.add(this.contoursCouleurs[n3]);
                    object3 = n3 == 0 ? "1st" : (n3 == 1 ? "2nd" : (n3 == 2 ? "3rd" : String.valueOf(n3 + 1) + "th"));
                    Properties.addCouple(this.panelScroll, String.valueOf(object3) + " level", this.panelCont, gridBagLayout, gridBagConstraints);
                    ++n3;
                }
                this.scroll.add(this.panelScroll);
                gridBagLayout.setConstraints(this.scroll, gridBagConstraints);
                panel.add(this.scroll);
                object3 = new Histogramme((PlanImage)((PlanContour)object).p);
                Properties.addCouple(panel, "Levels", (Component)object3, gridBagLayout, gridBagConstraints);
                this.curs = new Curseur();
                this.curs.nbNiveaux = ((PlanContour)object).orgLevels.length;
                this.curs.couleurTriangle = ((PlanContour)object).couleursContours;
                int n4 = 0;
                while (n4 < ((PlanContour)object).orgLevels.length) {
                    this.curs.niveaux[n4] = (int)((PlanContour)object).orgLevels[n4];
                    ++n4;
                }
                serializable = new Panel();
                Properties.addCouple(panel, "Levels", this.curs, gridBagLayout, gridBagConstraints);
            }
            if (this.plan.type == 2 || this.plan.type == 1) {
                Properties.addFilet(panel, gridBagLayout, gridBagConstraints);
            }
        }
        if (this.plan.projd != null && this.plan.type != 4) {
            Properties.addCouple(panel, "Field:", new Label(this.aladin.target.getField(this.plan)), gridBagLayout, gridBagConstraints);
        }
        if (this.plan.type == 4) {
            object2 = (PlanField)this.plan;
            this.sField = ((PlanField)object2).getCenter();
            this.centerField = new TextField(this.sField);
            Properties.addCouple(panel, "Reference coord:", this.centerField, gridBagLayout, gridBagConstraints);
            if (((PlanField)object2).isRollable()) {
                this.sRoll = ((PlanField)object2).getRoll();
                this.rollField = new TextField(this.sRoll);
                Properties.addCouple(panel, "Angle:", this.rollField, gridBagLayout, gridBagConstraints);
            }
        } else {
            this.centerField = null;
        }
        if (this.plan.flagOk && this.plan.type == 2) {
            Properties.addCouple(panel, "Sources:", new Label(String.valueOf(this.plan.pcat.nb_o)), gridBagLayout, gridBagConstraints);
        }
        if (this.plan.type == 1) {
            object2 = (PlanImage)this.plan;
            object = ((PlanImage)object2).survey();
            if (object != null && ((String)object).length() > 0) {
                Properties.addCouple(panel, "Info:", new Label(((PlanImage)object2).survey()), gridBagLayout, gridBagConstraints);
            }
            Label label = new Label(PlanImage.describeFmtRes(((PlanImage)object2).fmt, ((PlanImage)object2).res));
            if (((PlanImage)object2).headerFits != null) {
                Panel panel2 = new Panel();
                panel2.add(label);
                panel2.add(new Button(SEEFITS));
                Properties.addCouple(panel, "Format:", panel2, gridBagLayout, gridBagConstraints);
            } else {
                Properties.addCouple(panel, "Format:", label, gridBagLayout, gridBagConstraints);
            }
            if (this.plan.flagOk && this.plan.projd != null) {
                double d;
                double d2 = this.plan.projd.c.GetEpoch();
                if (d2 != 0.0) {
                    d2 = (double)((int)(d2 * 1000.0)) / 1000.0;
                    Properties.addCouple(panel, "Epoch:", new Label(String.valueOf(d2)), gridBagLayout, gridBagConstraints);
                }
                if ((d = this.plan.projd.c.GetEquinox()) != 0.0) {
                    d = (double)((int)(d * 1000.0)) / 1000.0;
                    Properties.addCouple(panel, "WCS equinox:", new Label(String.valueOf(d)), gridBagLayout, gridBagConstraints);
                } else {
                    this.sEquinox = "2000.0";
                    this.eqField = new TextField(this.sEquinox);
                    Properties.addCouple(panel, "WCS equinox:", this.eqField, gridBagLayout, gridBagConstraints);
                }
                serializable = this.plan.projd.c.getImgSize();
                Properties.addCouple(panel, "Size:", new Label(String.valueOf(serializable.width) + "x" + serializable.height + " pixels"), gridBagLayout, gridBagConstraints);
            }
        }
        if (this.plan.from != null) {
            Properties.addCouple(panel, "Origin:", new Label(this.plan.from), gridBagLayout, gridBagConstraints);
        }
        if (this.plan.flagOk && (this.plan.type == 1 || this.plan.type == 2)) {
            Properties.addFilet(panel, gridBagLayout, gridBagConstraints);
            object2 = new Label(this.plan.type == 1 ? "Astrometrical reduction" : (this.plan.xyLock ? "XY to coordinates reduction" : "Projection"));
            ((Component)object2).setFont(Aladin.BOLD);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagLayout.setConstraints((Component)object2, gridBagConstraints);
            panel.add((Component)object2);
            this.planRefChoice = null;
            this.majPlanRef();
            if (this.plan.type != 1 && !this.plan.xyLock) {
                Properties.addCouple(panel, "   .on plane ", this.planRefChoice, gridBagLayout, gridBagConstraints);
            }
            this.projsChoice = null;
            object = new Button(NEWCALIB);
            this.modCalib = new Button(MODCALIB);
            this.majProjs();
            if (this.projsChoice.countItems() == 0) {
                this.projsChoice.addItem("-- none --");
            }
            Panel panel3 = new Panel();
            panel3.add(this.projsChoice);
            panel3.add((Component)object);
            panel3.add(this.modCalib);
            Properties.addCouple(panel, "   .method ", panel3, gridBagLayout, gridBagConstraints);
            if (this.plan.type == 1 && !(this.plan instanceof PlanImageRGB)) {
                Properties.addFilet(panel, gridBagLayout, gridBagConstraints);
                object2 = new Label("Flipflop methods");
                ((Component)object2).setFont(Aladin.BOLD);
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.weightx = 1.0;
                gridBagLayout.setConstraints((Component)object2, gridBagConstraints);
                panel.add((Component)object2);
                Panel panel4 = new Panel();
                panel4.setLayout(new FlowLayout(0));
                panel4.add(new Button(TOPBOTTOM));
                panel4.add(new Button(RIGHTLEFT));
                Properties.addCouple(panel, "", panel4, gridBagLayout, gridBagConstraints);
            }
        }
        Properties.addFilet(panel, gridBagLayout, gridBagConstraints);
        return panel;
    }

    void showProp(Plan plan) {
        this.flagHide = false;
        if (this.pmemo != null && this.hcmemo == plan.hashCode() && this.pmemo.equals(plan)) {
            if (this.isShowing()) {
                return;
            }
            this.majState(plan);
            this.show();
            return;
        }
        boolean bl = this.pmemo != null && this.pmemo.type == plan.type && this.pmemo.flagOk == plan.flagOk && this.pmemo.projd == plan.projd;
        this.pmemo = new PlanFree(this.aladin);
        this.pmemo.objet = plan.objet == null ? null : new String(plan.objet);
        this.pmemo.type = plan.type;
        this.pmemo.param = plan.param == null ? null : new String(plan.param);
        this.pmemo.error = plan.error == null ? null : new String(plan.error);
        this.pmemo.flagOk = plan.flagOk;
        this.pmemo.projd = plan.projd;
        this.hcmemo = plan.hashCode();
        this.plan = plan;
        this.sourceType = null;
        this.state = null;
        this.couleur = null;
        this.sEquinox = null;
        this.sField = null;
        this.rollField = null;
        this.eqField = null;
        if (this.panel != null) {
            this.remove(this.panel);
        }
        this.panel = new Panel();
        this.panel.setLayout(new BorderLayout(5, 5));
        Label label = new Label("Properties of the plane ``" + this.plan.label + "''", 1);
        label.setFont(Aladin.LBOLD);
        Aladin.makeAdd(this.panel, label, "North");
        Aladin.makeAdd(this.panel, this.propertiesPlan(), "Center");
        Aladin.makeAdd(this.panel, this.valid(), "South");
        Aladin.makeAdd(this, this.panel, "Center");
        if (!bl) {
            this.pack();
        }
        this.show();
    }

    protected Panel valid() {
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(1));
        panel.setFont(Aladin.LBOLD);
        panel.add(new Button("Apply"));
        panel.add(new Button("Close"));
        return panel;
    }
}

