/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.Plan;
import cds.aladin.Source;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.Enumeration;
import java.util.Vector;

class Printer
implements Runnable {
    Thread thread;
    private Aladin aladin;
    static int MARGE = 22;

    Printer(Aladin aladin) {
        this.aladin = aladin;
        this.thread = new Thread(this);
        this.thread.setPriority(4);
        this.thread.start();
    }

    private String getCenter(Plan plan) {
        int n = this.aladin.calque.view.size().width / 2;
        int n2 = this.aladin.calque.view.size().height / 2;
        Point point = this.aladin.calque.zoom.zoomView.getPosition(n, n2);
        Coord coord = new Coord();
        coord.x = point.x;
        coord.y = point.y;
        coord = plan.projd.getCoord(coord);
        return coord.getSexa(":");
    }

    private String getSize(Plan plan) {
        Rectangle rectangle = this.aladin.calque.zoom.zoomView.getZoom();
        Coord coord = new Coord();
        Coord coord2 = new Coord();
        int n = rectangle.x;
        int n2 = rectangle.y + rectangle.height / 2;
        Point point = this.aladin.calque.zoom.zoomView.getPosition(n, n2);
        coord.x = point.x;
        coord.y = point.y;
        coord = plan.projd.getCoord(coord);
        point = this.aladin.calque.zoom.zoomView.getPosition(n += rectangle.width, n2);
        coord2.x = point.x;
        coord2.y = point.y;
        coord2 = plan.projd.getCoord(coord2);
        String string = Coord.getUnit(Coord.getDist(coord, coord2));
        n = rectangle.x + rectangle.width / 2;
        n2 = rectangle.y;
        point = this.aladin.calque.zoom.zoomView.getPosition(n, n2);
        coord.x = point.x;
        coord.y = point.y;
        coord = plan.projd.getCoord(coord);
        point = this.aladin.calque.zoom.zoomView.getPosition(n, n2 += rectangle.height);
        coord2.x = point.x;
        coord2.y = point.y;
        coord2 = plan.projd.getCoord(coord2);
        String string2 = Coord.getUnit(Coord.getDist(coord, coord2));
        return String.valueOf(string) + " x " + string2;
    }

    private void print() {
        int n = MARGE;
        int n2 = MARGE;
        PrintJob printJob = Toolkit.getDefaultToolkit().getPrintJob(Aladin.f, "Aladin", null);
        if (printJob != null) {
            Graphics graphics = printJob.getGraphics();
            if (graphics != null) {
                this.aladin.setFlagPrint(true);
                int n3 = this.aladin.calque.view.size().width;
                int n4 = this.aladin.calque.view.size().height;
                n2 = this.printTitre(graphics, n, n2, n3);
                graphics.drawImage(this.aladin.calque.view.imgprep, MARGE, n2, this.aladin);
                this.aladin.calque.view.paintOverlays(graphics, null, MARGE, n2);
                int n5 = printJob.getPageDimension().width;
                int n6 = printJob.getPageDimension().height;
                graphics.setColor(Color.white);
                graphics.fillRect(0, 0, n5, n2);
                graphics.fillRect(0, n2 + n4, n5, n6 - n2 + n4);
                graphics.fillRect(0, n2, MARGE, n4);
                graphics.fillRect(MARGE + n3, n2, n5, n4);
                graphics.setColor(Color.black);
                this.printTitre(graphics, n, MARGE, n3);
                graphics.drawRect(n, n2, n3, n4);
                this.printLegende(graphics, printJob.getPageDimension().width - 20, n2 + 20);
                n2 += n4;
                n2 = this.printCopyright(graphics, n3, n2);
                graphics.dispose();
            }
            printJob.end();
        }
        this.aladin.setFlagPrint(false);
        this.aladin.view.repaint();
    }

    private int printCopyright(Graphics graphics, int n, int n2) {
        Font font = new Font("TimesRoman", 0, 6);
        graphics.setColor(Color.black);
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n3 = MARGE;
        int n4 = n2 + fontMetrics.getAscent() + 2;
        graphics.drawString("Produced by Aladin (Centre de Donnees astronomiques de Strasbourg)", n3, n4);
        graphics.drawString("http://aladin.u-strasbg.fr", n3, n4 += fontMetrics.getHeight());
        Plan plan = this.aladin.calque.getPlanRef();
        if (plan != null && plan.from != null) {
            n4 = n2 + fontMetrics.getAscent() + 2;
            n3 = MARGE + n - fontMetrics.stringWidth(plan.from);
            graphics.drawString(plan.from, n3, n4);
        }
        return n4 + fontMetrics.getDescent() + fontMetrics.getLeading();
    }

    private void printLegende(Graphics graphics, int n, int n2) {
        Plan plan;
        Plan[] planArray = this.aladin.calque.plan;
        Font font = new Font("TimesRoman", 0, 12);
        Vector<Plan> vector = new Vector<Plan>(10);
        int n3 = 0;
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n4 = fontMetrics.getHeight();
        int n5 = 0;
        while (n5 < planArray.length) {
            plan = planArray[n5];
            if (plan.type == 2 && plan.flagOk && plan.error == null) {
                vector.addElement(plan);
                int n6 = fontMetrics.stringWidth(plan.getLabel());
                if (n6 > n3) {
                    n3 = n6;
                }
            }
            ++n5;
        }
        if (vector.size() == 0) {
            return;
        }
        int n7 = vector.size() * n4 + fontMetrics.getDescent();
        graphics.setColor(Color.white);
        graphics.fillRect(n - (n3 += 28), n2, n3, n7);
        graphics.setColor(Color.black);
        graphics.drawRect(n - n3, n2, n3, n7);
        int n8 = n2 + n4;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            plan = (Plan)enumeration.nextElement();
            Source source = (Source)plan.pcat.o[0];
            int n9 = n - n3 + 10;
            source.print(graphics, n9, n8 - n4 / 3);
            graphics.setColor(Color.black);
            graphics.drawString(plan.getLabel(), n9 += 10, n8);
            n8 += n4;
        }
    }

    private int printTitre(Graphics graphics, int n, int n2, int n3) {
        int n4;
        Font font = new Font("TimesRoman", 0, 30);
        Font font2 = new Font("TimesRoman", 0, 18);
        Font font3 = new Font("TimesRoman", 0, 14);
        Plan plan = this.aladin.calque.getPlanRef();
        if (plan == null || plan.projd == null) {
            return 30;
        }
        char c = plan.objet.charAt(0);
        String string = c < '0' || c > '9' ? plan.objet : null;
        String string2 = this.getCenter(plan);
        String string3 = this.getSize(plan);
        graphics.setColor(Color.black);
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n5 = n2 + fontMetrics.getHeight();
        if (plan.type == 1) {
            graphics.setFont(font2);
            fontMetrics = graphics.getFontMetrics();
            n4 = MARGE + n3 - fontMetrics.stringWidth(plan.label) - 10;
            graphics.drawString(plan.label, n4, n5);
            graphics.setFont(font);
            fontMetrics = graphics.getFontMetrics();
        }
        n4 = n;
        if (string != null) {
            graphics.drawString(string, n4, n5);
            n5 += fontMetrics.getAscent();
            graphics.setFont(font2);
            fontMetrics = graphics.getFontMetrics();
            graphics.drawString(string2, n4, n5);
            graphics.setFont(font3);
            fontMetrics = graphics.getFontMetrics();
            n4 = MARGE + n3 - fontMetrics.stringWidth(string3);
        } else {
            graphics.drawString(string2, n4, n5);
            n5 += fontMetrics.getHeight();
            graphics.setFont(font2);
            fontMetrics = graphics.getFontMetrics();
        }
        graphics.drawString(string3, n4, n5);
        return n5 + 10;
    }

    public void run() {
        this.print();
    }
}

