/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Calque;
import cds.aladin.Coord;
import cds.aladin.Cote;
import cds.aladin.FrameNewCalib;
import cds.aladin.Legende;
import cds.aladin.Objet;
import cds.aladin.Plan;
import cds.aladin.PlanCatalog;
import cds.aladin.PlanContour;
import cds.aladin.PointD;
import cds.aladin.Position;
import cds.aladin.Projection;
import cds.aladin.RectangleD;
import cds.aladin.Source;
import cds.aladin.Status;
import cds.aladin.Texte;
import cds.astro.Coo;
import cds.savot.model.SavotTR;
import cds.savot.model.SavotTable;
import cds.xml.Astrores;
import cds.xml.AstroresConsumer;
import cds.xml.Field;
import cds.xml.VOTable;
import cds.xml.VOTableConsumer;
import cds.xml.formatDetection;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.DataInputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public final class PlanObjet
implements AstroresConsumer,
VOTableConsumer {
    static final int MAX = 200;
    Objet[] o;
    int nb_o;
    Color c;
    int sourceType = 0;
    int iz = -1;
    int numId = -1;
    boolean flagVOTable = false;
    Calque calque;
    Plan plan;
    Status status;
    Aladin aladin;
    String catalog;
    String table;
    double rajc;
    double dejc;
    double rm;
    Legende leg = null;
    Vector vField = new Vector(10);
    boolean flagXY;
    boolean flagTarget;
    boolean flagEndResource;
    boolean flagFirstRecord = true;
    double minRa;
    double maxRa;
    double minDec;
    double maxDec;
    boolean[] hiddenField;
    boolean firstTrace = true;
    private int indexOID = -1;

    protected PlanObjet(Plan plan, Color color, Calque calque, Status status, Aladin aladin) {
        this.aladin = aladin;
        this.status = status;
        this.calque = calque;
        this.plan = plan;
        this.c = color;
        this.nb_o = 0;
    }

    protected void Draw(Graphics graphics, Rectangle rectangle, boolean bl, int n, int n2) {
        graphics.setColor(this.c);
        if (this.plan.type == 2 || this.plan.type == 3 || this.plan.type == 4) {
            this.projection();
        }
        if (!bl) {
            return;
        }
        int n3 = 0;
        while (n3 < this.nb_o) {
            if (rectangle == null || rectangle.intersects(this.o[n3].getClip(this.calque.zoom.zoomView))) {
                this.o[n3].draw(graphics, this.calque.zoom.zoomView, n, n2);
            }
            ++n3;
        }
    }

    private int astroresParsing(DataInputStream dataInputStream) throws Exception {
        this.o = new Objet[200];
        this.nb_o = 0;
        this.catalog = this.plan.label;
        this.table = this.plan.label;
        this.leg = null;
        this.flagTarget = false;
        this.minDec = Double.MAX_VALUE;
        this.minRa = Double.MAX_VALUE;
        this.maxDec = -1.7976931348623157E308;
        this.maxRa = -1.7976931348623157E308;
        this.hiddenField = null;
        this.flagEndResource = false;
        Astrores astrores = new Astrores(this);
        boolean bl = astrores.parse(dataInputStream);
        if (bl) {
            if (!this.flagEndResource) {
                this.endResource();
            }
            if (!this.flagXY && this.rm == 0.0) {
                Aladin.error = this.plan.error = "no RA or DE rows";
            }
        } else {
            Aladin.error = this.plan.error = "Error: " + astrores.getError();
        }
        if (this.plan.error != null) {
            System.out.println("!!! " + this.plan.label + ": " + this.plan.error);
        }
        return bl ? this.nb_o : -1;
    }

    private void computeTarget() {
        if (this.maxRa - this.minRa > 180.0) {
            double d = 360.0 - this.maxRa;
            this.rajc = (this.minRa + d) / 2.0 - d;
        } else {
            this.rajc = (this.minRa + this.maxRa) / 2.0;
        }
        this.dejc = (this.minDec + this.maxDec) / 2.0;
        this.rm = this.nb_o == 1 ? 7.0 : Math.abs(this.minDec - this.dejc) * 60.0 * 1.4142;
        Aladin.trace(3, "computeTarget ra=[" + this.minRa + ".." + this.maxRa + "]=>" + this.rajc + " de=[" + this.minDec + ".." + this.maxDec + "]=>" + this.dejc + " rm=[" + this.rm + "]");
    }

    protected boolean delObjet(Objet objet) {
        if (objet instanceof Source) {
            return false;
        }
        int n = 0;
        while (n < this.nb_o && objet != this.o[n]) {
            ++n;
        }
        if (n < this.nb_o) {
            if (n != this.nb_o - 1) {
                this.o[n] = this.o[this.nb_o - 1];
            }
            --this.nb_o;
            return true;
        }
        return false;
    }

    private String dollarSub(String string, String[] stringArray, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        char[] cArray = string.toCharArray();
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        int n5 = 0;
        while (n5 <= cArray.length) {
            char c = n5 == cArray.length ? (char)'\u0000' : cArray[n5];
            switch (n2) {
                case 0: {
                    if (c != '$') break;
                    n2 = 1;
                    stringBuffer.append(cArray, n3, n5 - n3);
                    n3 = n5;
                    break;
                }
                case 1: {
                    n4 = n5;
                    if (c == '{') {
                        n2 = 10;
                        bl = true;
                        break;
                    }
                    n2 = 2;
                    bl = false;
                    break;
                }
                case 10: {
                    if (c != '}') break;
                    n2 = 3;
                    break;
                }
                case 2: {
                    if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_') break;
                    n2 = 3;
                    break;
                }
                case 3: {
                    String string2;
                    int n6;
                    boolean bl2 = false;
                    if (bl) {
                        ++n4;
                    }
                    int n7 = n5 - n4 - 1;
                    boolean bl3 = bl2 = n == 1;
                    if (cArray[n4] == '+') {
                        bl2 = true;
                        ++n4;
                        --n7;
                    }
                    if (cArray[n4] == '*') {
                        ++n4;
                        --n7;
                    }
                    if ((n6 = this.getFieldIndex(string2 = new String(cArray, n4, n7))) < 0) {
                        n2 = 0;
                        break;
                    }
                    stringBuffer.append(bl2 ? URLEncoder.encode(stringArray[n6]) : stringArray[n6]);
                    n3 = bl ? n5 : n5 - 1;
                    n2 = 0;
                    --n5;
                    break;
                }
            }
            ++n5;
        }
        stringBuffer.append(cArray, n3, cArray.length - n3);
        return stringBuffer.toString();
    }

    public void endResource() {
        this.flagEndResource = true;
        if (!this.flagTarget && !this.flagXY && this.nb_o > 0) {
            this.computeTarget();
        }
        this.postJob(this.rajc, this.dejc, this.rm);
    }

    public void endTable() {
    }

    private int getFieldIndex(String string) {
        Enumeration enumeration = this.vField.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            if (((Field)enumeration.nextElement()).name.equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    protected Vector getObjWith(double d, double d2) {
        Vector<Objet> vector;
        block5: {
            double d3;
            block4: {
                d3 = this.calque.zoom.getValue();
                vector = new Vector<Objet>(500);
                if (this.plan.type != 4) break block4;
                int n = 0;
                while (n < this.nb_o && !this.o[n].in(d, d2, d3)) {
                    ++n;
                }
                if (n >= this.nb_o) break block5;
                n = 0;
                while (n < this.nb_o) {
                    vector.addElement(this.o[n]);
                    ++n;
                }
                break block5;
            }
            int n = 0;
            while (n < this.nb_o) {
                if (this.o[n].inside(d, d2, d3)) {
                    vector.addElement(this.o[n]);
                }
                ++n;
            }
        }
        return vector;
    }

    protected PointD getOriginalXY(Objet objet) {
        if (!this.plan.xyLock || ((PlanCatalog)this.plan).xy == null) {
            return null;
        }
        int n = 0;
        while (n < this.nb_o) {
            if (this.o[n] == objet) {
                return ((PlanCatalog)this.plan).xy[n];
            }
            ++n;
        }
        return null;
    }

    private boolean isSexa(String string) {
        char[] cArray = string.toCharArray();
        int n = 0;
        int n2 = 0;
        while (n2 < cArray.length) {
            if (cArray[n2] == ':' || cArray[n2] == ' ' || cArray[n2] == '\t') {
                ++n;
            }
            if (n > 1) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    int nextIndex() {
        if (this.o == null) {
            this.o = new Objet[200];
            this.nb_o = 0;
        }
        if (this.nb_o < this.o.length) {
            return this.nb_o++;
        }
        Objet[] objetArray = new Objet[this.o.length * 2];
        System.arraycopy(this.o, 0, objetArray, 0, this.o.length);
        this.o = objetArray;
        return this.nb_o++;
    }

    double[] parseTarget(String string) {
        double[] dArray = new double[3];
        StringTokenizer stringTokenizer = new StringTokenizer(string, "+-,=/");
        try {
            dArray[0] = Double.valueOf(stringTokenizer.nextToken().trim());
        }
        catch (Exception exception) {}
        boolean bl = string.lastIndexOf(45) > 0;
        try {
            dArray[1] = Double.valueOf(stringTokenizer.nextToken().trim());
            if (bl) {
                dArray[1] = -dArray[1];
            }
        }
        catch (Exception exception) {}
        try {
            stringTokenizer.nextToken();
            dArray[2] = 11.0;
            dArray[2] = Double.valueOf(stringTokenizer.nextToken().trim());
            if (string.indexOf("bm") > 0) {
                dArray[2] = dArray[2] / 2.0;
            }
        }
        catch (Exception exception) {}
        return dArray;
    }

    protected void postJob(double d, double d2, double d3) {
        ((PlanCatalog)this.plan).setSourceType(Source.getDefaultType(this.nb_o));
        if (this.flagXY) {
            this.plan.xyLock = true;
            this.plan.error = "No astronomical reduction";
            ((PlanCatalog)this.plan).xy = new PointD[this.nb_o];
            int n = 0;
            while (n < this.nb_o) {
                ((PlanCatalog)this.plan).xy[n] = new PointD(((Position)this.o[n]).x, ((Position)this.o[n]).y);
                ++n;
            }
            this.aladin.message.info("The table \"" + this.plan.label + "\" has only\n" + "XY positions. Aladin needs an astrometrical\n" + "reduction to compute the associated astronomical\n" + "coordinates.");
            if (this.aladin.frameNewCalib == null) {
                this.aladin.frameNewCalib = new FrameNewCalib(this.aladin, this.plan, null);
            } else {
                this.aladin.frameNewCalib.majFrameNewCalib(this.plan);
            }
            return;
        }
        this.plan.setNewProjD(new Projection(null, 3, d, d2, d3 * 2.0, 250.0, 250.0, 500.0, 0.0, false, Projection.getDefaultType(d3 / 60.0)));
        this.plan.co = new Coord(d, d2);
    }

    protected void projection() {
        Plan plan = this.calque.getPlanRef();
        if (plan == null || plan.projd == null) {
            return;
        }
        Projection projection = plan.projd;
        if (projection.type == 0) {
            return;
        }
        if (this.plan.proj == projection && this.plan.flagProj) {
            return;
        }
        if (this.plan.type != 3 && !projection.agree(this.plan.projd, this.calque.zoom.getValue())) {
            return;
        }
        this.plan.proj = projection;
        this.plan.flagProj = false;
        int n = 0;
        while (n < this.nb_o) {
            Position position = (Position)this.o[n];
            position.projection(projection);
            ++n;
        }
        this.plan.flagProj = true;
        this.calque.view.newView();
        this.calque.view.repaint();
        Aladin.trace(3, "Proj. ra/dec->XY of \"" + this.plan.label + "\" on \"" + plan.label + "/" + projection.label + "\"");
    }

    protected void setCoord() {
        if (this.plan.type != 3) {
            return;
        }
        int n = 0;
        while (n < this.nb_o) {
            ((Position)this.o[n]).setCoord();
            ++n;
        }
    }

    protected void setCoord(Projection projection) {
        if (!this.plan.xyLock) {
            System.err.println("Recalibration on a no-XYlocked planed !!! Aborted");
            return;
        }
        Aladin.trace(3, "Recalibration \"" + projection.label + "\" XY->ra/dec on \"" + this.plan.label + "\"");
        int n = 0;
        while (n < this.nb_o) {
            Position position = (Position)this.o[n];
            position.x = ((PlanCatalog)this.plan).xy[n].x;
            position.y = ((PlanCatalog)this.plan).xy[n].y;
            position.setCoord(projection);
            ++n;
        }
        this.plan.flagProj = false;
    }

    public void setField(Field field) {
        Aladin.trace(3, "setField " + (field.ID != null ? field.ID : (field.name != null ? field.name : "null")) + " width=" + (field.width != null ? field.width : "null"));
        if (field.name != null && field.name.equals("Identifier")) {
            this.numId = this.vField.size();
        }
        this.vField.addElement(field);
    }

    protected Vector setMultiSelect(RectangleD rectangleD) {
        Vector<Position> vector = new Vector<Position>(100);
        int n = 0;
        while (n < this.nb_o) {
            Position position = (Position)this.o[n];
            if (!(position.plan instanceof PlanContour) && rectangleD.inside(position.x, position.y)) {
                position.select = true;
                vector.addElement(position);
            }
            ++n;
        }
        return vector;
    }

    protected void setObjet(Objet objet) {
        int n = this.nextIndex();
        if (n < 0) {
            return;
        }
        if (objet instanceof Texte) {
            Texte texte = (Texte)objet;
            texte.inProgress(false);
        } else if (objet instanceof Cote) {
            Cote cote = (Cote)objet;
            if (cote.debligne != null) {
                cote.setId();
                this.aladin.pad.setText(String.valueOf(cote.id) + "\n");
            }
        }
        this.o[n] = objet;
    }

    protected void setObjetFast(Objet objet) {
        int n = this.nextIndex();
        this.o[n] = objet;
    }

    protected int setPlanCat(Plan plan, DataInputStream dataInputStream) {
        return this.setPlanCat(plan, dataInputStream, false);
    }

    protected int setPlanCat(Plan plan, DataInputStream dataInputStream, boolean bl) {
        return this.setPlanCat(plan, null, dataInputStream, bl);
    }

    protected int setPlanCat(Plan plan, URL uRL) {
        return this.setPlanCat(plan, uRL, null, false);
    }

    protected int setPlanCat(Plan plan, URL uRL, DataInputStream dataInputStream, boolean bl) {
        int n = -1;
        try {
            if (uRL != null) {
                try {
                    dataInputStream = new DataInputStream(uRL.openStream());
                }
                catch (Exception exception) {
                    dataInputStream = new DataInputStream(uRL.openStream());
                }
            }
            String string = null;
            if (bl) {
                string = "VOTABLE";
            } else {
                formatDetection formatDetection2 = new formatDetection();
                string = formatDetection2.parse(dataInputStream);
            }
            if (uRL != null) {
                try {
                    dataInputStream = new DataInputStream(uRL.openStream());
                }
                catch (Exception exception) {
                    dataInputStream = new DataInputStream(uRL.openStream());
                }
            }
            if (string == null) {
                n = this.astroresParsing(dataInputStream);
            } else if (string.compareTo("VOTABLE") == 0) {
                n = this.votableParsing(dataInputStream);
            } else if (string.compareTo("ASTRO") == 0) {
                n = this.astroresParsing(dataInputStream);
            }
        }
        catch (Exception exception) {
            if (Aladin.levelTrace == 3) {
                exception.printStackTrace();
            }
            Aladin.error = "Catalog loading aborted\n --> " + exception;
            System.out.println("!!! " + plan.label + ": " + Aladin.error);
            this.aladin.message.warning(Aladin.error);
            n = -1;
        }
        return n;
    }

    public void setRecord(double d, double d2, String[] stringArray) {
        String string = null;
        try {
            Object object;
            Object object2;
            int n;
            Serializable serializable;
            int n2;
            if (this.flagFirstRecord) {
                this.firstTrace = true;
                n2 = this.vField.size();
                serializable = new Vector(n2);
                this.hiddenField = new boolean[n2];
                Enumeration enumeration = this.vField.elements();
                this.indexOID = -1;
                n = 0;
                while (enumeration.hasMoreElements()) {
                    object2 = (Field)enumeration.nextElement();
                    if (object2 != null) {
                        if (this.indexOID == -1 && ((Field)object2).name != null && ((Field)object2).name.equals("_OID")) {
                            this.indexOID = n;
                        }
                        if (((Field)object2).type != null && (((Field)object2).type.indexOf("hidden") >= 0 || ((Field)object2).type.indexOf("trigger") >= 0) || ((Field)object2).name != null && (((Field)object2).name.equals("_RAJ2000") || ((Field)object2).name.equals("_DEJ2000"))) {
                            this.hiddenField[n] = true;
                        } else {
                            ((Vector)serializable).addElement(object2);
                        }
                    }
                    ++n;
                }
                this.leg = new Legende((Vector)serializable);
                this.flagFirstRecord = false;
            }
            if (this.nb_o == this.o.length) {
                this.nextIndex();
                --this.nb_o;
            }
            serializable = this.catalog.equals("Simbad") ? new StringBuffer("<&_SIMBAD |Simbad>") : (this.catalog.equals("NED") || this.catalog.equals("Ned") ? new StringBuffer("<&_NED |NED>") : new StringBuffer("<&_getReadMe " + this.catalog + " |" + this.table + ">"));
            n2 = stringArray.length;
            int n3 = -1;
            n = 0;
            while (n < n2) {
                if (this.indexOID >= 0 && n == this.indexOID) {
                    string = stringArray[n];
                }
                if (this.hiddenField == null || n >= this.hiddenField.length || !this.hiddenField[n]) {
                    if (this.leg == null || !this.leg.hasInfo(++n3) || stringArray[n].length() == 0 || stringArray[n].equals("0") || stringArray[n].equals("-")) {
                        ((StringBuffer)serializable).append("\t" + (stringArray[n].length() == 0 ? " " : stringArray[n]));
                    } else {
                        Object object3;
                        object2 = this.leg.getHref(n3);
                        object = this.leg.getGref(n3);
                        String string2 = this.leg.getRefText(n3);
                        String string3 = this.leg.getRefValue(n3);
                        Object object4 = object != null ? object : (object3 = object2 != null ? "Http " + (String)object2 : null);
                        if (object3 != null && string3 != null && string3.startsWith("image/")) {
                            object3 = "^" + (String)object3;
                        }
                        String string4 = string2 != null ? string2 : stringArray[n];
                        ((StringBuffer)serializable).append("\t");
                        if (object3 != null) {
                            ((StringBuffer)serializable).append("<&" + this.dollarSub((String)object3, stringArray, object2 != null ? 1 : 0));
                            if (string4 != null) {
                                ((StringBuffer)serializable).append("|" + this.dollarSub(string4, stringArray, 0));
                            }
                            ((StringBuffer)serializable).append(">");
                        } else {
                            ((StringBuffer)serializable).append(string4);
                        }
                    }
                }
                ++n;
            }
            if (this.flagXY || !this.flagTarget) {
                if (d < this.minRa) {
                    this.minRa = d;
                }
                if (d > this.maxRa) {
                    this.maxRa = d;
                }
                if (d2 < this.minDec) {
                    this.minDec = d2;
                }
                if (d2 > this.maxDec) {
                    this.maxDec = d2;
                }
            }
            Object object5 = object2 = this.numId >= 0 ? stringArray[this.numId] : "Source " + this.nb_o;
            if (this.firstTrace) {
                Aladin.trace(3, "setRecord " + (string != null ? "(oid=" + string + ")" : "") + " \"" + (String)object2 + "\" " + (this.flagXY ? "XY" : "pos") + "=(" + d + "," + d2 + ") [" + serializable + "]");
                this.firstTrace = false;
            }
            object = this.flagXY ? new Source(this.plan, d, d2, 0.0, 0.0, 1, (String)object2, ((StringBuffer)serializable).toString(), this.leg) : new Source(this.plan, d, d2, (String)object2, ((StringBuffer)serializable).toString(), this.leg);
            if (string != null) {
                ((Source)object).setOID(string);
            }
            this.o[this.nb_o++] = object;
        }
        catch (Exception exception) {
            System.out.println("setRecord (3p) " + exception);
        }
    }

    public void setRecord(SavotTR savotTR, int n, int n2) {
        try {
            if (savotTR == null) {
                return;
            }
            Vector vector = savotTR.getTDs().getItems();
            if (vector == null) {
                return;
            }
            if (vector.size() == 0) {
                return;
            }
            String[] stringArray = new String[vector.size()];
            int n3 = 0;
            while (n3 < vector.size()) {
                stringArray[n3] = (String)vector.elementAt(n3);
                ++n3;
            }
            if (stringArray.length >= 2) {
                StringBuffer stringBuffer = new StringBuffer(String.valueOf(stringArray[n]) + " ");
                char c = stringArray[n2].charAt(0);
                if (c != '-' && c != '+') {
                    stringBuffer.append('+');
                }
                stringBuffer.append(stringArray[n2]);
                boolean bl = this.isSexa(stringBuffer.toString());
                Coo coo = new Coo();
                coo.set(stringBuffer.toString(), bl);
                this.setRecord(coo.lon, coo.lat, stringArray);
            } else if (stringArray.length >= 1) {
                this.setRecord(new Double(stringArray[n]), 0.0, stringArray);
            } else {
                this.setRecord(0.0, 0.0, stringArray);
            }
        }
        catch (Exception exception) {
            System.out.println("setRecord " + exception);
        }
    }

    public void setResourceInfo(String string, String string2) {
        if (string.equals("NAME")) {
            this.catalog = string2;
        }
    }

    public void setTableData(String string, String string2) {
    }

    public void setTableInfo(String string, String string2) {
        if (string.equals("NAME")) {
            this.table = string2;
        } else if (string.equals("__XYPOS") && string2.equals("true")) {
            this.flagXY = true;
        }
    }

    public void setTarget(String string) {
        this.flagTarget = true;
        double[] dArray = this.parseTarget(string);
        this.rajc = dArray[0];
        this.dejc = dArray[1];
        this.rm = dArray[2];
    }

    protected void showBaratin(int n) {
        this.o[n].status(this.aladin);
    }

    public void startResource(String string) {
        Aladin.trace(3, "startResource " + string);
        this.catalog = this.plan.label;
        this.table = this.plan.label;
    }

    public void startTable(SavotTable savotTable) {
        this.startTable(savotTable.getName());
    }

    public void startTable(String string) {
        Aladin.trace(3, "startTable " + string);
        this.flagFirstRecord = true;
        this.flagXY = false;
        this.vField = new Vector(10);
        this.numId = -1;
    }

    private int votableParsing(DataInputStream dataInputStream) throws Exception {
        try {
            this.o = new Objet[200];
            this.nb_o = 0;
            this.catalog = this.plan.label;
            this.table = this.plan.label;
            this.leg = null;
            this.flagTarget = false;
            this.minDec = Double.MAX_VALUE;
            this.minRa = Double.MAX_VALUE;
            this.maxDec = -1.7976931348623157E308;
            this.maxRa = -1.7976931348623157E308;
            this.hiddenField = null;
            this.flagEndResource = false;
            VOTable vOTable = new VOTable(this);
            boolean bl = vOTable.parse(dataInputStream);
            if (bl) {
                if (!this.flagEndResource) {
                    this.endResource();
                }
                if (this.rm == 0.0) {
                    Aladin.error = this.plan.error = "no RA or DE rows";
                }
            } else {
                Aladin.error = this.plan.error = "Error: " + vOTable.getError();
            }
            if (this.plan.error != null) {
                System.out.println("!!! " + this.plan.label + ": " + this.plan.error);
            }
            return bl ? this.nb_o : -1;
        }
        catch (Exception exception) {
            System.out.println("votableParsing : " + exception);
            return -1;
        }
    }
}

