/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.PlanImage;
import java.awt.image.ColorModel;
import java.util.Hashtable;

public final class PlanImageRGB
extends PlanImage {
    protected int[] pixelsRGB;
    protected byte[] red;
    protected byte[] green;
    protected byte[] blue;
    protected boolean twoColors;
    protected int[] RGBCONTROL;
    protected int[] RGBControl;
    protected PlanImage[] pi;
    protected String[] labels;
    PlanImage Red;
    PlanImage Green;
    PlanImage Blue;
    PlanImage Ref;
    protected boolean diff;

    protected PlanImageRGB(Aladin aladin, PlanImage planImage, PlanImage planImage2, PlanImage planImage3, PlanImage planImage4, boolean bl) {
        super(aladin);
        int[] nArray = new int[9];
        nArray[1] = 128;
        nArray[2] = 255;
        nArray[4] = 128;
        nArray[5] = 255;
        nArray[7] = 128;
        nArray[8] = 255;
        this.RGBCONTROL = nArray;
        this.pi = new PlanImage[3];
        this.labels = new String[3];
        this.Red = planImage;
        this.Green = planImage2;
        this.Blue = planImage3;
        double d = Double.MAX_VALUE;
        if (planImage4 == null) {
            if (planImage != null && Math.abs(planImage.projd.c.incA) < d) {
                planImage4 = planImage;
                d = Math.abs(planImage.projd.c.incA);
            }
            if (planImage2 != null && Math.abs(planImage2.projd.c.incA) < d) {
                planImage4 = planImage2;
                d = Math.abs(planImage2.projd.c.incA);
            }
            if (planImage3 != null && Math.abs(planImage3.projd.c.incA) < d) {
                planImage4 = planImage3;
                d = Math.abs(planImage3.projd.c.incA);
            }
        }
        Aladin.trace(3, "RGB ref plane: " + planImage4.label + " (incX=" + d + ")");
        this.Ref = planImage4;
        this.diff = bl;
        this.init(aladin, this.Ref);
        this.runme = new Thread(this);
        this.runme.setPriority(4);
        this.runme.start();
    }

    protected void Free() {
        this.Ref = null;
        this.Blue = null;
        this.Green = null;
        this.Red = null;
        this.blue = null;
        this.green = null;
        this.red = null;
        this.pi[2] = null;
        this.pi[1] = null;
        this.pi[0] = null;
        super.Free();
    }

    protected void createImgRGB() {
        int n = this.width * this.height;
        this.pixelsRGB = new int[n];
        int n2 = 0;
        while (n2 < n) {
            this.pixelsRGB[n2] = 0xFF000000 | (this.red[n2] & 0xFF) << 16 | (this.green[n2] & 0xFF) << 8 | this.blue[n2] & 0xFF;
            ++n2;
        }
        if (this.video == 1) {
            this.inverseRGB();
        }
        PlanImage.changeEtat(1);
    }

    protected void createLastColor(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        int n = this.width * this.height;
        int n2 = 0;
        while (n2 < n) {
            if (this.diff) {
                int n3 = byArray2[n2] & 0xFF;
                int n4 = byArray3[n2] & 0xFF;
                if (n3 - n4 > 0) {
                    byArray2[n2] = (byte)(n3 - n4);
                    byArray[n2] = 0;
                    byArray3[n2] = 0;
                } else {
                    byArray3[n2] = (byte)(n4 - n3);
                    byArray[n2] = 0;
                    byArray2[n2] = 0;
                }
            } else {
                byArray[n2] = (byte)(Math.min(byArray2[n2] & 0xFF, byArray3[n2] & 0xFF) & 0xFF);
            }
            ++n2;
        }
    }

    protected int filter(int n, int n2, int n3, int n4) {
        double d = 128.0;
        if (n4 <= n) {
            return 0;
        }
        if (n4 >= n3) {
            return 255;
        }
        if (n4 > n && n4 <= n2) {
            double d2 = n2 - n;
            if (d2 > 0.0) {
                double d3 = d / d2;
                double d4 = -d3 * (double)n;
                return (byte)((double)n4 * d3 + d4);
            }
        } else {
            double d5 = n3 - n2;
            if (d5 > 0.0) {
                double d6 = d / d5;
                double d7 = 128.0 - d6 * (double)n2;
                return (byte)((double)n4 * d6 + d7);
            }
        }
        return n4;
    }

    public void filterRGB(int[] nArray, int n) {
        PlanImage.changeEtat(1);
        int n2 = nArray[0];
        int n3 = nArray[1];
        int n4 = nArray[2];
        int n5 = this.width * this.height;
        int n6 = 0;
        while (n6 < n5) {
            int n7 = (this.pixelsRGB[n6] & 0xFF0000) >> 16;
            int n8 = (this.pixelsRGB[n6] & 0xFF00) >> 8;
            int n9 = this.pixelsRGB[n6] & 0xFF;
            if (n == 0) {
                n7 = this.filter(n2, n3, n4, this.red[n6] & 0xFF);
            } else if (n == 1) {
                n8 = this.filter(n2, n3, n4, this.green[n6] & 0xFF);
            } else {
                n9 = this.filter(n2, n3, n4, this.blue[n6] & 0xFF);
            }
            if (this.video == 1) {
                if (n == 0) {
                    n7 ^= 0xFFFFFFFF;
                } else if (n == 1) {
                    n8 ^= 0xFFFFFFFF;
                } else {
                    n9 ^= 0xFFFFFFFF;
                }
                if (this.twoColors) {
                    if (this.Red == null) {
                        n7 = Math.max(n8 & 0xFF, n9 & 0xFF);
                    } else if (this.Green == null) {
                        n8 = Math.max(n7 & 0xFF, n9 & 0xFF);
                    } else {
                        n9 = Math.max(n7 & 0xFF, n8 & 0xFF);
                    }
                }
            } else if (this.twoColors) {
                if (this.Red == null) {
                    n7 = Math.min(n8 & 0xFF, n9 & 0xFF);
                } else if (this.Green == null) {
                    n8 = Math.min(n7 & 0xFF, n9 & 0xFF);
                } else {
                    n9 = Math.min(n7 & 0xFF, n8 & 0xFF);
                }
            }
            this.pixelsRGB[n6] = 0xFF000000 | (n7 & 0xFF) << 16 | (n8 & 0xFF) << 8 | n9 & 0xFF;
            ++n6;
        }
    }

    public void filterRGB(int[] nArray, int n, int n2, int n3, int n4) {
        int n5 = n2 + n;
        int n6 = n3 + n;
        int[] nArray2 = this.aladin.view.pixelsCMRGB;
        PlanImage.changeEtat(1);
        int n7 = nArray[0];
        int n8 = nArray[1];
        int n9 = nArray[2];
        int n10 = n3;
        while (n10 < n6) {
            int n11 = n2;
            while (n11 < n5) {
                int n12 = n10 * this.width + n11;
                int n13 = this.pixelsRGB[n12];
                int n14 = (n13 & 0xFF0000) >> 16;
                int n15 = (n13 & 0xFF00) >> 8;
                int n16 = n13 & 0xFF;
                if (n4 == 0) {
                    n14 = this.filter(n7, n8, n9, this.red[n12] & 0xFF);
                } else if (n4 == 1) {
                    n15 = this.filter(n7, n8, n9, this.green[n12] & 0xFF);
                } else {
                    n16 = this.filter(n7, n8, n9, this.blue[n12] & 0xFF);
                }
                if (this.video == 1) {
                    if (n4 == 0) {
                        n14 ^= 0xFFFFFFFF;
                    } else if (n4 == 1) {
                        n15 ^= 0xFFFFFFFF;
                    } else {
                        n16 ^= 0xFFFFFFFF;
                    }
                    if (this.twoColors) {
                        if (this.Red == null) {
                            n14 = Math.max(n15 & 0xFF, n16 & 0xFF);
                        } else if (this.Green == null) {
                            n15 = Math.max(n14 & 0xFF, n16 & 0xFF);
                        } else {
                            n16 = Math.max(n14 & 0xFF, n15 & 0xFF);
                        }
                    }
                } else if (this.twoColors) {
                    if (this.Red == null) {
                        n14 = Math.min(n15 & 0xFF, n16 & 0xFF);
                    } else if (this.Green == null) {
                        n15 = Math.min(n14 & 0xFF, n16 & 0xFF);
                    } else {
                        n16 = Math.min(n14 & 0xFF, n15 & 0xFF);
                    }
                }
                nArray2[(n10 - n3) * (n5 - n2) + n11 - n2] = 0xFF000000 | (n14 & 0xFF) << 16 | (n15 & 0xFF) << 8 | n16 & 0xFF;
                ++n11;
            }
            ++n10;
        }
    }

    protected void getPixels(int[] nArray, int n, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        if (n + n3 > this.width) {
            n7 = n + n3 - this.width;
            n3 -= n7;
        }
        if (n2 + n4 > this.height) {
            n6 = n2 + n4 - this.height;
            n4 -= n6;
        }
        int n8 = n2;
        int n9 = n2 + n4;
        while (n8 < n9) {
            System.arraycopy(this.pixelsRGB, n8 * this.width + n, nArray, n5, n3);
            n5 += n3 + n7;
            ++n8;
        }
    }

    protected void init(Aladin aladin, PlanImage planImage) {
        this.flagOk = false;
        this.active = false;
        this.headerFits = null;
        this.width = planImage.width;
        this.height = planImage.height;
        this.video = 0;
        this.fmt = 6;
        this.res = 0;
        this.orig = 3;
        this.status = "Re-sampling (at the nearest pixel):";
        this.progress = "computing...";
        this.objet = planImage.objet;
        this.label = "img";
        this.co = planImage.co;
        this.c = planImage.c;
        this.projd = planImage.projd;
        this.projD = (Hashtable)planImage.projD.clone();
        this.from = "Colored composition by Aladin";
        this.xzoom = planImage.xzoom;
        this.yzoom = planImage.yzoom;
        this.zoom = planImage.zoom;
        this.pi[0] = this.Red;
        this.pi[1] = this.Green;
        this.pi[2] = this.Blue;
        this.labels[0] = this.Red != null ? this.Red.label : "none";
        this.labels[1] = this.Green != null ? this.Green.label : "none";
        this.labels[2] = this.Blue != null ? this.Blue.label : "none";
        this.RGBControl = new int[this.RGBCONTROL.length];
        int n = 0;
        while (n < this.RGBCONTROL.length) {
            this.RGBControl[n] = this.RGBCONTROL[n];
            ++n;
        }
        this.param = "R:" + this.labels[0] + " G:" + this.labels[1] + " B:" + this.labels[2];
    }

    protected void inverseRGB() {
        int n = this.width * this.height;
        int n2 = 0;
        while (n2 < n) {
            this.pixelsRGB[n2] = this.pixelsRGB[n2] ^ 0xFFFFFF;
            ++n2;
        }
        PlanImage.changeEtat(1);
        this.aladin.calque.select.repaint();
    }

    protected boolean waitForPlan() {
        boolean bl;
        PlanImage planImage = null;
        PlanImage planImage2 = null;
        PlanImage planImage3 = null;
        if (this.Ref == this.Red) {
            planImage = this.Red;
            planImage2 = this.Green;
            planImage3 = this.Blue;
        } else if (this.Ref == this.Green) {
            planImage = this.Green;
            planImage2 = this.Red;
            planImage3 = this.Blue;
        } else if (this.Ref == this.Blue) {
            planImage = this.Blue;
            planImage2 = this.Red;
            planImage3 = this.Green;
        }
        Aladin.trace(3, "Resampling (R:" + this.labels[0] + ",G:" + this.labels[1] + ",B:" + this.labels[2] + " astro from " + this.Ref.label + ")...");
        Coord coord = new Coord();
        int n = 0;
        int n2 = 0;
        int n3 = planImage.width;
        byte[] byArray = this.diff ? new byte[planImage.pixels.length] : planImage.pixels;
        byte[] byArray2 = new byte[planImage.pixels.length];
        byte[] byArray3 = new byte[planImage.pixels.length];
        int n4 = 0;
        while (n4 < byArray.length) {
            byArray2[n4] = 50;
            byArray3[n4] = 100;
            ++n4;
        }
        boolean bl2 = planImage != null && planImage2 != null && planImage.projd.c.TheSame(planImage2.projd.c);
        boolean bl3 = bl = planImage != null && planImage3 != null && planImage.projd.c.TheSame(planImage3.projd.c);
        if (this.diff) {
            System.arraycopy(planImage.pixels, 0, byArray, 0, planImage.pixels.length);
        }
        if (bl2) {
            System.arraycopy(planImage2.pixels, 0, byArray2, 0, planImage2.pixels.length);
        }
        if (bl) {
            System.arraycopy(planImage3.pixels, 0, byArray3, 0, planImage3.pixels.length);
        }
        if (!bl2 || !bl) {
            n4 = 0;
            while (n4 < planImage.pixels.length) {
                coord.x = n4 % n3;
                coord.y = n4 / n3;
                planImage.projd.getCoord(coord);
                if (!bl2 && planImage2 != null && planImage2.projd.getXY(coord) != null) {
                    n = (int)Math.round(coord.x);
                    n2 = (int)Math.round(coord.y);
                    if (n >= 0 && n < planImage2.width && n2 >= 0 && n2 < planImage2.height) {
                        byArray2[n4] = planImage2.pixels[n2 * planImage2.width + n];
                    }
                }
                if (!bl && planImage3 != null && planImage3.projd.getXY(coord) != null) {
                    n = (int)Math.round(coord.x);
                    n2 = (int)Math.round(coord.y);
                    if (n >= 0 && n < planImage3.width && n2 >= 0 && n2 < planImage3.height) {
                        byArray3[n4] = planImage3.pixels[n2 * planImage3.width + n];
                    }
                }
                if (n4 % 10000 == 0) {
                    this.pourcent = n4 * 100 / planImage.pixels.length;
                    try {
                        Thread.currentThread();
                        Thread.sleep(10L);
                    }
                    catch (Exception exception) {}
                }
                ++n4;
            }
        }
        this.pourcent = -1.0;
        if (this.Ref == this.Red) {
            this.red = byArray;
            this.green = byArray2;
            this.blue = byArray3;
        } else if (this.Ref == this.Green) {
            this.red = byArray2;
            this.green = byArray;
            this.blue = byArray3;
        } else if (this.Ref == this.Blue) {
            this.red = byArray2;
            this.green = byArray3;
            this.blue = byArray;
        }
        Aladin.trace(3, "Resampling achieved...");
        this.cm = ColorModel.getRGBdefault();
        boolean bl4 = this.twoColors = this.Red == null || this.Green == null || this.Blue == null;
        if (this.Red == null) {
            this.createLastColor(this.red, this.green, this.blue);
        } else if (this.Green == null) {
            this.createLastColor(this.green, this.red, this.blue);
        } else if (this.Blue == null) {
            this.createLastColor(this.blue, this.red, this.green);
        }
        this.createImgRGB();
        return true;
    }
}

