/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Action;
import cds.aladin.Aladin;
import cds.aladin.Objet;
import cds.aladin.Plan;
import cds.aladin.PlanCatalog;
import cds.aladin.Source;
import cds.aladin.UCDFilter;
import java.awt.Color;
import java.util.Enumeration;
import java.util.Vector;

public final class PlanFilter
extends Plan {
    private static final int INCREMENT = 20;
    protected static int LIMIT = 20;
    static final String[] PREDEFFILTERS = new String[]{"# This filter draws for each source a circle \n# whose radius is proportional to the magnitude\n{draw circle(-$[PHOT*])}", "# This example shows how to draw \n# an ellipse associated with a source\n{\n# draws the source itself\ndraw\n# draws the ellipse ; \n# parameters are semi-major axis, semi-minor axis, and position angle\ndraw ellipse(0.5*$[EXTENSION_DIAM],0.5*$[EXTENSION_MIN],${DimPA})\n}", "# Only sources with a magnitude \n# brighter than 16 are displayed\n$[PHOT*]<16 {draw}\n", "# This filter draws for each source the content\n# of the column tagged by the UCD \"CLASS_OBJECT\"\n{\ndraw $[CLASS_OBJECT]\n}", "# In this filter, the green and blue components\n# of the color of each source are defined\n# according to the value of the magnitude\n{\ndraw rgb(255,-$[PHOT*],$[PHOT*]) square\n}", "# We draw a different symbol according to\n# the object type (value of the column \"otyp\")\n${otyp}=\"Star\" {draw red square}\n${otyp}=\"Radio\" {draw blue rhomb}\n${otyp}=\"Galaxy\" || ${otyp}=\"Seyfert\" {draw green plus}\n# etc ...\n", "# Draws an arrow representing\n# the proper motion of the source\n{draw pm(5*$[POS_EQ_PMRA],5*$[POS_EQ_PMDEC])}\n# Remark : You are suggested to modify the factor \n# if the arrows are too small or too long\n", "# This filters aims to visualize the color of stars\n# according to their color index B-V.\n# The optional parameters -0.3 and 1 mean that :\n# - any source with a color index lesser than -0.3\n#   is displayed in blue\n# - any source with a color index greater than 1\n#    is displayed in red\n{draw rainbow($[PHOT_*_B-V],-0.3,1)}", "# This filter assigns colors related\n# to the spectral type of sources.\n# The association spectral type --> color\n# is the following:\n# O : violet\n# B : blue/violet\n# A : blue\n# F : green/yellow\n# G : yellow\n# K : orange\n# M R N S C : red\n# T L : brown\n# W : violet\n# D : gray\n\n$[SPECT_TYPE*] = \"*B*\" {draw #8a2be2}\n$[SPECT_TYPE*] = \"*A*\" {draw blue}\n$[SPECT_TYPE*] = \"*F*\" {draw #adff2f}\n$[SPECT_TYPE*] = \"*G*\" {draw yellow}\n$[SPECT_TYPE*] = \"*K*\" {draw orange}\n$[SPECT_TYPE*] = \"*M*\" || $[SPECT_TYPE*] = \"*R*\" || $[SPECT_TYPE*] = \"*N*\" || \n$[SPECT_TYPE*] = \"*S*\" || $[SPECT_TYPE*] = \"*S*\" {draw red}\n$[SPECT_TYPE*] = \"*T*\" || $[SPECT_TYPE*] = \"*L*\" {draw #a52a2a}\n$[SPECT_TYPE*] = \"*O*\" {draw #ee82ee}\n$[SPECT_TYPE*] = \"*W*\" {draw #ee82ee}\n$[SPECT_TYPE*] = \"*D*\" {draw gray}\n"};
    static final String[] PREDEFLABELS = new String[]{"Magnitude circle", "Ellipses", "Magnitude cut", "Display text", "Parameterized colors", "Select object type", "Proper motions", "Color index", "Spectral types"};
    static String[] saveFilters = new String[LIMIT];
    static String[] saveLabels = new String[LIMIT];
    String script;
    static int num = -1;
    static PlanFilter[] allFilters = new PlanFilter[0];
    int numero;
    private UCDFilter filter;
    private Vector memPlan;
    private Vector omemPlan;
    boolean mustUpdate = true;
    boolean mustRepaint = true;
    boolean initPlanMem = true;

    protected PlanFilter(Aladin aladin, String string, String string2) {
        this.aladin = aladin;
        this.flagOk = true;
        this.type = 6;
        this.c = Color.black;
        this.active = false;
        this.selected = true;
        this.numero = ++num;
        this.memPlan = new Vector();
        this.omemPlan = new Vector();
        if (num >= LIMIT) {
            this.realloc();
        }
        if (string2 != null) {
            this.createFilter(string2, string);
        } else {
            this.createFilter("", "Filter" + num);
        }
        this.script = this.filter.definition;
        this.label = this.filter.name;
        String string3 = this.filter.name;
        this.uniqueName(string3);
        this.saveDef();
        if (string2 != null) {
            this.doLog();
        }
    }

    protected void Free() {
        if (this.runme != null) {
            this.runme.stop();
        }
        this.memPlan = null;
        this.omemPlan = null;
        this.filter.Free();
        super.Free();
        PlanFilter.updateAllFilters(this.aladin);
    }

    static void activateAllFilters() {
        PlanFilter planFilter = null;
        if (allFilters == null) {
            return;
        }
        int n = 0;
        while (n < allFilters.length) {
            planFilter = allFilters[n];
            planFilter.mustRepaint = false;
            planFilter.applyFilter();
            planFilter.active = true;
            ++n;
        }
        if (planFilter != null) {
            planFilter.aladin.view.setMesure();
            planFilter.aladin.calque.select.repaint();
        }
        planFilter.mustRepaint = true;
    }

    protected void applyFilter() {
        if (this.initPlanMem) {
            this.setPlanMemory();
            this.updateInfluence();
            this.initPlanMem = false;
        }
        if (this.runme != null) {
            this.runme.stop();
        }
        this.runme = new Thread(this);
        this.runme.setPriority(4);
        this.runme.start();
    }

    private void createFilter(String string, String string2) {
        this.filter = string2 == null ? new UCDFilter(string, this.aladin, this) : new UCDFilter(string2, string, this.aladin, this);
        this.filter.setNumero(this.numero);
        this.error = !this.isValid() ? "ERROR" : null;
    }

    static void desactivateAllFilters() {
        PlanFilter planFilter = null;
        if (allFilters == null) {
            return;
        }
        int n = 0;
        while (n < allFilters.length) {
            planFilter = allFilters[n];
            planFilter.active = false;
            ++n;
        }
        if (planFilter != null) {
            planFilter.aladin.view.setMesure();
            planFilter.aladin.calque.select.repaint();
        }
    }

    protected void doApplyFilter() {
        Source[] sourceArray;
        if (this.mustUpdate) {
            Aladin.trace(1, "Updating filter results");
            if (!this.isValid()) {
                this.active = false;
                return;
            }
            this.flagOk = false;
            this.aladin.calque.repaint();
            sourceArray = this.getSources(this.aladin);
            this.resetFlags();
            this.filter.getFilteredSources(sourceArray);
            this.flagOk = true;
            this.pourcent = -1.0;
        }
        if (this.mustRepaint) {
            sourceArray = this.aladin.mesure.text;
            synchronized (sourceArray) {
                this.aladin.view.setMesure();
            }
        }
        this.mustUpdate = false;
    }

    private void doLog() {
    }

    protected void export() {
        int n = this.aladin.calque.newPlanCatalog();
        PlanCatalog planCatalog = (PlanCatalog)this.aladin.calque.plan[n];
        planCatalog.setLabel("Selected sources from filter " + this.label);
        Source[] sourceArray = this.filter.getFilteredSources(this.getSources(this.aladin));
        int n2 = sourceArray.length - 1;
        while (n2 >= 0) {
            Source source = sourceArray[n2];
            Source source2 = new Source(planCatalog, source.raj, source.dej, source.id, source.info);
            planCatalog.pcat.setObjetFast(source2);
            source2.isSelected = source.isSelected;
            source2.values = source.values;
            source2.actions = source.actions;
            source2.leg = source.leg;
            --n2;
        }
        if (this.aladin.calque.getPlanRef() != null) {
            planCatalog.objet = this.aladin.calque.getPlanRef().objet;
        }
        planCatalog.active = true;
        planCatalog.setSourceType(Source.getDefaultType(sourceArray.length));
        this.aladin.view.repaint();
    }

    private static PlanFilter[] getAllFilters(Aladin aladin) {
        Vector<PlanFilter> vector = new Vector<PlanFilter>();
        int n = aladin.calque.plan.length - 1;
        while (n >= 0) {
            Plan plan = aladin.calque.plan[n];
            if (plan.type == 6) {
                vector.addElement((PlanFilter)plan);
            }
            --n;
        }
        Object[] objectArray = new PlanFilter[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private Vector getAllPlansOfFolder(Plan plan) {
        Vector vector = new Vector(10);
        this.getAllPlansOfFolder(plan, vector);
        return vector;
    }

    private void getAllPlansOfFolder(Plan plan, Vector vector) {
        Plan[] planArray = this.aladin.calque.getFolderPlan(plan);
        int n = 0;
        while (n < planArray.length) {
            Plan plan2 = planArray[n];
            if (plan2.type == 5) {
                this.getAllPlansOfFolder(plan2, vector);
            } else {
                vector.addElement(plan2);
            }
            ++n;
        }
    }

    protected Plan[] getConcernedPlans() {
        int n = this.getPositionOfPlan(this);
        Vector<Plan> vector = new Vector<Plan>();
        Plan plan = this.getFolder();
        Vector vector2 = null;
        if (plan != null) {
            vector2 = this.getAllPlansOfFolder(this.getFolder());
        }
        int n2 = this.aladin.calque.plan.length - 1;
        while (n2 >= n) {
            Plan plan2 = this.aladin.calque.plan[n2];
            if (plan2.type == 2 && plan2.flagOk && plan2.active && (plan == null || vector2.contains(plan2))) {
                vector.addElement(plan2);
            }
            --n2;
        }
        Object[] objectArray = new Plan[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    protected static PlanFilter getFilterByName(String string, Aladin aladin) {
        int n = aladin.calque.plan.length - 1;
        while (n >= 0) {
            Plan plan = aladin.calque.plan[n];
            if (plan.type == 6 && plan.label.equals(string)) {
                return (PlanFilter)plan;
            }
            --n;
        }
        return null;
    }

    private Plan getFolder() {
        int n = this.aladin.calque.plan.length - 1;
        while (n >= 0) {
            Plan plan = this.aladin.calque.plan[n];
            if (plan.type == 5) {
                Plan[] planArray = this.aladin.calque.getFolderPlan(plan);
                int n2 = 0;
                while (n2 < planArray.length) {
                    if (planArray[n2] == this) {
                        return plan;
                    }
                    ++n2;
                }
            }
            --n;
        }
        return null;
    }

    protected String getLabel() {
        int n = (int)this.getPourcent();
        if (n > 0) {
            return String.valueOf(this.label.substring(0, this.label.length() < 5 ? this.label.length() : 5)) + "..  " + n + "%";
        }
        return super.getLabel();
    }

    private int getPositionOfPlan(Plan plan) {
        int n = this.aladin.calque.plan.length - 1;
        while (n >= 0) {
            Plan plan2 = this.aladin.calque.plan[n];
            if (plan2 == plan) {
                return n;
            }
            --n;
        }
        return -1;
    }

    protected Source[] getSources(Aladin aladin) {
        Plan plan = null;
        Objet[] objetArray = null;
        Vector<Objet> vector = new Vector<Objet>();
        Plan[] planArray = this.getConcernedPlans();
        int n = planArray.length - 1;
        while (n >= 0) {
            plan = planArray[n];
            objetArray = plan.pcat.o;
            int n2 = objetArray.length - 1;
            while (n2 >= 0) {
                if (objetArray[n2] instanceof Source && objetArray[n2] != null) {
                    vector.addElement(objetArray[n2]);
                }
                --n2;
            }
            --n;
        }
        Object[] objectArray = new Source[vector.size()];
        vector.copyInto(objectArray);
        vector = null;
        return objectArray;
    }

    protected boolean isOn() {
        return this.active;
    }

    protected boolean isValid() {
        return this.filter.badSyntax ^ true;
    }

    private boolean morePlans(Vector vector, Vector vector2) {
        if (vector2.size() > vector.size()) {
            return true;
        }
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            if (vector.contains(enumeration.nextElement())) continue;
            return true;
        }
        return false;
    }

    static void newPlan(Plan plan) {
        PlanFilter planFilter = null;
        if (allFilters == null) {
            return;
        }
        int n = 0;
        while (n < allFilters.length) {
            planFilter = allFilters[n];
            planFilter.setMustUpdate();
            if (planFilter.isOn()) {
                planFilter.applyFilter();
            }
            ++n;
        }
    }

    protected void positionChange() {
        PlanFilter.updateAllFilters(this.aladin);
        this.setMustUpdate();
        if (this.isOn()) {
            this.applyFilter();
        }
    }

    private void realloc() {
        Object[] objectArray;
        LIMIT += 20;
        int n = this.aladin.calque.plan.length - 1;
        while (n >= 0) {
            Plan plan = this.aladin.calque.plan[n];
            if (plan.type == 2) {
                objectArray = new boolean[LIMIT];
                System.arraycopy(plan.influence, 0, objectArray, 0, plan.influence.length);
                plan.influence = (boolean[])objectArray;
                Objet[] objetArray = plan.pcat.o;
                int n2 = objetArray.length - 1;
                while (n2 >= 0) {
                    if (objetArray[n2] instanceof Source) {
                        Source source = (Source)objetArray[n2];
                        boolean[] blArray = new boolean[LIMIT];
                        System.arraycopy(source.isSelected, 0, blArray, 0, source.isSelected.length);
                        source.isSelected = blArray;
                        Action[][] actionArray = new Action[LIMIT][];
                        int n3 = 0;
                        while (n3 < LIMIT - 20) {
                            actionArray[n3] = source.actions[n3];
                            ++n3;
                        }
                        source.actions = actionArray;
                        double[][][] dArray = new double[LIMIT][][];
                        int n4 = 0;
                        while (n4 < LIMIT - 20) {
                            dArray[n4] = source.values[n4];
                            ++n4;
                        }
                        source.values = dArray;
                    }
                    --n2;
                }
            }
            --n;
        }
        objectArray = new String[LIMIT];
        System.arraycopy(saveFilters, 0, objectArray, 0, saveFilters.length);
        saveFilters = objectArray;
        objectArray = new String[LIMIT];
        System.arraycopy(saveLabels, 0, objectArray, 0, saveLabels.length);
        saveLabels = objectArray;
    }

    private void resetFlags() {
        Plan plan = null;
        Objet[] objetArray = null;
        int n = this.aladin.calque.plan.length - 1;
        while (n >= 0) {
            plan = this.aladin.calque.plan[n];
            if (plan.type == 2 && plan.flagOk) {
                objetArray = plan.pcat.o;
                int n2 = objetArray.length - 1;
                while (n2 >= 0) {
                    if (objetArray[n2] instanceof Source && objetArray[n2] != null) {
                        ((Source)objetArray[n2]).isSelected[this.numero] = false;
                    }
                    --n2;
                }
            }
            --n;
        }
    }

    private void saveDef() {
        PlanFilter.saveFilters[this.numero] = this.script;
        PlanFilter.saveLabels[this.numero] = this.label;
    }

    protected void select() {
        this.filter.select(this.getSources(this.aladin));
        this.aladin.view.setMesure();
    }

    private void setMustUpdate() {
        this.setPlanMemory();
        this.updateInfluence();
        if (this.morePlans(this.omemPlan, this.memPlan)) {
            this.mustUpdate = true;
            this.filter.resetActions();
        }
    }

    private void setPlanMemory() {
        Plan[] planArray = this.getConcernedPlans();
        this.omemPlan = this.memPlan;
        this.memPlan = new Vector();
        int n = 0;
        while (n < planArray.length) {
            this.memPlan.addElement(planArray[n]);
            ++n;
        }
    }

    private void uniqueName(String string) {
        int n = 1;
        String string2 = string;
        while (PlanFilter.getFilterByName(string2, this.aladin) != null) {
            string2 = String.valueOf(string) + n++;
        }
        this.label = string2;
    }

    protected static void updateAllFilters(Aladin aladin) {
        allFilters = PlanFilter.getAllFilters(aladin);
    }

    protected void updateDefinition(String string, String string2) {
        String string3 = this.script;
        if (string2 != null) {
            string2 = UCDFilter.skipSpaces(string2);
        }
        this.script = string;
        this.createFilter(string, string2);
        this.script = this.filter.definition;
        String string4 = this.label = this.filter.name.length() == 0 ? this.label : this.filter.name;
        this.label = "";
        this.uniqueName(string4);
        this.saveDef();
        this.doLog();
        if (!UCDFilter.skipSpaces(this.script).equals(UCDFilter.skipSpaces(string3))) {
            this.setPlanMemory();
            this.updateInfluence();
            this.mustUpdate = true;
        }
        if (!this.isValid()) {
            if (!this.aladin.filterProperties.isShowing()) {
                this.aladin.message.warning("This filter can not be applied : please check the syntax", 1);
            }
            this.active = false;
            this.aladin.calque.select.repaint();
            this.aladin.view.setMesure();
            return;
        }
        if (this.isOn()) {
            this.applyFilter();
        }
    }

    private void updateInfluence() {
        int n = this.aladin.calque.plan.length - 1;
        while (n >= 0) {
            Plan plan = this.aladin.calque.plan[n];
            if (plan.type == 2) {
                plan.influence[this.numero] = this.memPlan.contains(plan);
            }
            --n;
        }
    }

    static void updatePlan(Plan plan) {
        PlanFilter planFilter = null;
        if (allFilters == null) {
            return;
        }
        int n = 0;
        while (n < allFilters.length) {
            planFilter = allFilters[n];
            planFilter.setMustUpdate();
            if (planFilter.isOn()) {
                planFilter.applyFilter();
            }
            ++n;
        }
    }

    static void updatePlan(Plan plan, int n, int n2) {
        PlanFilter planFilter = null;
        if (allFilters == null) {
            return;
        }
        int n3 = 0;
        while (n3 < allFilters.length) {
            planFilter = allFilters[n3];
            planFilter.setMustUpdate();
            if (planFilter.isOn()) {
                planFilter.applyFilter();
            }
            ++n3;
        }
    }

    protected void updateState() {
        if (this.isOn()) {
            if (!this.isValid()) {
                this.aladin.message.warning("This filter can not be applied : please check the syntax", 1);
                this.active = false;
                this.aladin.calque.select.repaint();
                this.aladin.view.setMesure();
                return;
            }
            this.mustRepaint = true;
            this.applyFilter();
        } else {
            this.aladin.view.setMesure();
        }
    }

    protected boolean waitForPlan() {
        this.doApplyFilter();
        return true;
    }
}

