/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Calque;
import cds.aladin.ContourAlgorithm;
import cds.aladin.Coord;
import cds.aladin.Couleur;
import cds.aladin.Ligne;
import cds.aladin.Plan;
import cds.aladin.PlanImage;
import cds.aladin.PlanTool;
import cds.aladin.PointD;
import java.awt.Color;
import java.awt.Rectangle;

public final class PlanContour
extends PlanTool {
    static final String OutOfMemoryMESSAGE = "\n\n Either the image is too big \n or there are too many control points.\n Try to zoom in the part of the picture you are interested in \n(and select Consider current zoom only) \n and/or reduce the number of contour levels";
    static final int MAXLEVELS = 20;
    static final Color[] couleursBase = new Color[]{new Color(250, 51, 51), new Color(51, 51, 250), new Color(153, 51, 255), new Color(255, 51, 153), new Color(51, 153, 255), new Color(51, 255, 153)};
    static int icouleursBase = 0;
    boolean mustAdjustContour = false;
    double[] adjustTab = null;
    Calque calque;
    Plan p;
    boolean reduceNoise = true;
    boolean useOnlyCurrentZoom = false;
    private Ligne[][] Ligne;
    private double partDessin = 0.15;
    private int xShift = 0;
    private int yShift = 0;
    Rectangle zoomv;
    boolean useSmoothing = false;
    int smoothingLevel = 2;
    short[] pixels;
    int width = -1;
    int height = -1;
    int orgWidth = -1;
    int orgHeight = -1;
    int max;
    int min;
    double[] levels = null;
    double[] orgLevels = null;
    PointD[][] contours = null;
    Color[] couleursContours;
    protected ContourAlgorithm cAlgo = null;
    protected int nbLevels;
    private int nbLevelsComputed = 0;

    protected PlanContour(Aladin aladin) {
        this(aladin, "");
    }

    protected PlanContour(Aladin aladin, String string) {
        super(aladin, string);
        this.calque = aladin.calque;
        this.pourcent = -1.0;
    }

    protected PlanContour(Aladin aladin, String string, double[] dArray, ContourAlgorithm contourAlgorithm, boolean bl, int n, boolean bl2, boolean bl3, Color[] colorArray, Color color) {
        this(aladin, string);
        this.xyLock = aladin.calque.getPlanRef() == null;
        this.active = false;
        this.flagOk = false;
        contourAlgorithm.pc = this;
        this.levels = dArray;
        this.orgLevels = (double[])this.levels.clone();
        this.nbLevels = dArray.length;
        this.cAlgo = contourAlgorithm;
        this.useSmoothing = bl;
        this.smoothingLevel = n;
        this.useOnlyCurrentZoom = bl2;
        this.reduceNoise = bl3;
        this.initCouleurs(colorArray);
        this.c = color;
        this.runme = new Thread(this);
        this.runme.setPriority(4);
        this.runme.start();
    }

    protected void Free() {
        this.pixels = null;
        this.levels = null;
        this.contours = null;
        this.Ligne = null;
        this.cAlgo = null;
        super.Free();
    }

    protected void adjustColor(Color color, int n) {
        if (!this.couleursContours[n].equals(color)) {
            this.couleursContours[n] = new Color(color.getRGB());
            Ligne[] ligneArray = this.Ligne[n];
            int n2 = 0;
            while (n2 < ligneArray.length) {
                Ligne ligne = ligneArray[n2];
                ligne.couleur = new Color(color.getRGB());
                ++n2;
            }
        }
    }

    protected void adjustContour(double[] dArray) {
        this.adjustTab = dArray;
        this.mustAdjustContour = true;
        this.runme = new Thread(this);
        this.runme.setPriority(4);
        this.runme.start();
    }

    private void adjustLevels() {
        if (this.useSmoothing) {
            int n = 0;
            while (n < this.orgLevels.length) {
                this.levels[n] = (double)(this.smoothingLevel * this.smoothingLevel) * this.orgLevels[n];
                ++n;
            }
        }
    }

    private synchronized void doAdjustContour(double d, int n) {
        Aladin.trace(3, "Level adjusted for index " + n);
        this.mustAdjustContour = true;
        this.orgLevels[n] = d;
        this.levels[n] = d;
        this.adjustLevels();
        PointD[] pointDArray = this.getContour(this.levels[n]);
        this.contours[n] = pointDArray;
        Ligne[] ligneArray = this.Ligne[n];
        boolean bl = true;
        int n2 = 0;
        while (n2 < ligneArray.length) {
            Ligne ligne = ligneArray[n2];
            if (n2 == 0) {
                bl = ligne.hidden ^ true;
            }
            this.pcat.delObjet(ligne);
            ++n2;
        }
        this.drawContour(n);
        this.setViewable(n, bl);
        this.calque.repaint();
    }

    protected void drawAllContours() {
        if (this.couleursContours == null) {
            this.couleursContours = new Color[this.levels.length];
            Color[] colorArray = Couleur.getBrighterColors(this.c, 4);
            int n = 0;
            while (n < this.couleursContours.length) {
                this.couleursContours[n] = colorArray[n % colorArray.length];
                ++n;
            }
        }
        this.Ligne = new Ligne[this.levels.length][];
        int n = 0;
        while (n < this.levels.length) {
            this.drawContour(n);
            ++n;
        }
        this.calque.repaint();
    }

    protected void drawContour(int n) {
        Object object;
        int n2 = 0;
        Plan plan = this.calque.getPlanBase();
        if (plan == null) {
            plan = this;
        }
        int n3 = 1;
        if (this.useSmoothing) {
            n3 = this.smoothingLevel;
        }
        if (this.useOnlyCurrentZoom) {
            this.xShift = this.zoomv.x;
            this.yShift = this.zoomv.y;
        }
        if (this.useSmoothing) {
            if (this.reduceNoise) {
                this.xShift += this.smoothingLevel;
                this.yShift += this.smoothingLevel;
            } else {
                this.xShift += this.smoothingLevel / 2 + this.smoothingLevel % 2;
                this.yShift += this.smoothingLevel / 2 + this.smoothingLevel % 2;
            }
        } else if (this.reduceNoise) {
            ++this.xShift;
            ++this.yShift;
        }
        PointD[] pointDArray = this.contours[n];
        Ligne[] ligneArray = new Ligne[pointDArray.length];
        String string = "Isocontour at level " + this.orgLevels[n];
        int n4 = 0;
        while (n4 < pointDArray.length - 1) {
            if ((object = pointDArray[++n4]) == null) continue;
            Coord coord = new Coord();
            coord.x = (double)n3 * object.x + (double)this.xShift;
            coord.y = (double)n3 * object.y + (double)this.yShift;
            double d = coord.x;
            double d2 = coord.y;
            if (this.p.projd != plan.projd) {
                this.p.projd.getCoord(coord);
                plan.projd.getXY(coord);
                d = coord.x;
                d2 = coord.y;
            }
            Ligne ligne = new Ligne((Plan)this, d, d2, this.couleursContours[n]);
            ligne.withlabel = true;
            ligne.setText(string);
            this.pcat.setObjet(ligne);
            ligneArray[n2] = ligne;
            ++n2;
            PointD pointD = null;
            boolean bl = false;
            int n5 = 1;
            while (n4 + n5 < pointDArray.length) {
                PointD pointD2 = pointDArray[n4 + n5];
                if (pointD2 == null) break;
                coord.x = (double)n3 * pointD2.x + (double)this.xShift;
                coord.y = (double)n3 * pointD2.y + (double)this.yShift;
                d = coord.x;
                d2 = coord.y;
                if (this.p.projd != plan.projd) {
                    this.p.projd.getCoord(coord);
                    plan.projd.getXY(coord);
                    d = coord.x;
                    d2 = coord.y;
                }
                Ligne ligne2 = new Ligne((Plan)this, d, d2, ligne, this.couleursContours[n]);
                ligne2.withlabel = true;
                ligne2.setText(string);
                this.pcat.setObjet(ligne2);
                ligneArray[n2] = ligne2;
                ++n2;
                ligne = ligne2;
                pointD = pointD2;
                ++n5;
            }
            n4 += n5;
        }
        object = new Ligne[n2];
        System.arraycopy(ligneArray, 0, object, 0, n2);
        this.Ligne[n] = object;
        this.xShift = 0;
        this.yShift = 0;
    }

    protected boolean getAllContours() {
        this.contours = new PointD[this.levels.length][];
        if (!this.getPixels()) {
            return false;
        }
        this.adjustLevels();
        this.cAlgo.setData(this.pixels);
        this.cAlgo.setDimension(this.width, this.height);
        try {
            int n = 0;
            while (n < this.levels.length) {
                PointD[] pointDArray = this.getContour(this.levels[n]);
                this.contours[n] = pointDArray;
                ++this.nbLevelsComputed;
                ++n;
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Aladin.error = outOfMemoryError.toString();
            return false;
        }
        return true;
    }

    private PointD[] getContour(double d) {
        this.cAlgo.setLevel(d);
        return this.cAlgo.getContours();
    }

    protected String getLabel() {
        int n = (int)this.getPourcent();
        if (n > 0) {
            return String.valueOf(this.label.substring(0, 6)) + "..  " + n + "%";
        }
        return super.getLabel();
    }

    protected static Color getNextColor(Calque calque) {
        int n = 0;
        while (n < couleursBase.length) {
            int n2 = 0;
            while (n2 < calque.plan.length && (calque.plan[n2].type == 0 || couleursBase[n] != calque.plan[n2].c)) {
                ++n2;
            }
            if (n2 == calque.plan.length) break;
            ++n;
        }
        if (n == couleursBase.length) {
            if (++icouleursBase == couleursBase.length) {
                icouleursBase = 0;
            }
            n = icouleursBase;
        }
        return couleursBase[n];
    }

    protected boolean getPixels() {
        this.p = this.calque.getPlanBase();
        if (this.p == null) {
            return false;
        }
        this.objet = this.p.objet;
        this.orgWidth = ((PlanImage)this.p).width;
        this.orgHeight = ((PlanImage)this.p).height;
        this.zoomv.x = this.zoomv.x > 0 ? this.zoomv.x : 0;
        this.zoomv.y = this.zoomv.y > 0 ? this.zoomv.y : 0;
        this.zoomv.width = this.zoomv.width > this.orgWidth ? this.orgWidth : this.zoomv.width;
        int n = this.zoomv.height = this.zoomv.height > this.orgHeight ? this.orgHeight : this.zoomv.height;
        if (this.zoomv.x + this.zoomv.width > this.orgWidth) {
            this.zoomv.width = this.orgWidth - this.zoomv.x;
        }
        if (this.zoomv.y + this.zoomv.height > this.orgHeight) {
            this.zoomv.height = this.orgHeight - this.zoomv.y;
        }
        try {
            short[] sArray = new short[((PlanImage)this.p).pixels.length];
            int n2 = sArray.length - 1;
            while (n2 >= 0) {
                sArray[n2] = (short)(((PlanImage)this.p).pixels[n2] < 0 ? 256 + ((PlanImage)this.p).pixels[n2] : ((PlanImage)this.p).pixels[n2]);
                --n2;
            }
            if (this.useOnlyCurrentZoom) {
                this.width = this.zoomv.width;
                this.height = this.zoomv.height;
                if (this.useSmoothing) {
                    this.width /= this.smoothingLevel;
                    this.height /= this.smoothingLevel;
                    this.pixels = new short[this.width * this.height];
                    this.makeSmoothing(sArray, this.pixels, this.width, this.height, this.orgWidth, this.orgHeight, this.zoomv.x, this.zoomv.y, this.smoothingLevel);
                } else {
                    this.pixels = new short[this.width * this.height];
                    int n3 = this.height - 1;
                    while (n3 >= 0) {
                        int n4 = this.width - 1;
                        while (n4 >= 0) {
                            this.pixels[n3 * this.width + n4] = sArray[n3 * this.orgWidth + n4 + this.zoomv.x + this.orgWidth * this.zoomv.y];
                            --n4;
                        }
                        --n3;
                    }
                }
            } else {
                this.width = this.orgWidth;
                this.height = this.orgHeight;
                if (this.useSmoothing) {
                    this.width /= this.smoothingLevel;
                    this.height /= this.smoothingLevel;
                    this.pixels = new short[this.width * this.height];
                    this.makeSmoothing(sArray, this.pixels, this.width, this.height, this.orgWidth, this.orgHeight, 0, 0, this.smoothingLevel);
                } else {
                    this.pixels = new short[this.width * this.height];
                    this.pixels = sArray;
                }
            }
            if (this.reduceNoise) {
                this.pixels = this.moyenne(this.pixels, this.width, this.height);
                --this.width;
                --this.height;
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Aladin.error = outOfMemoryError.toString();
            System.gc();
            System.runFinalization();
            return false;
        }
        catch (Exception exception) {
            Aladin.error = exception.toString();
            return false;
        }
        return true;
    }

    private void initCouleurs(Color[] colorArray) {
        if (colorArray != null) {
            this.couleursContours = new Color[this.orgLevels.length];
            int n = 0;
            while (n < this.couleursContours.length) {
                this.couleursContours[n] = colorArray[n];
                ++n;
            }
        } else {
            this.couleursContours = null;
        }
    }

    protected boolean isViewable(int n) {
        Ligne[] ligneArray = this.Ligne[n];
        if (ligneArray.length != 0) {
            Ligne ligne = ligneArray[0];
            return ligne.hidden ^ true;
        }
        return true;
    }

    private void makeSmoothing(short[] sArray, short[] sArray2, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n7 * n7;
        int[] nArray = new int[n8];
        int[] nArray2 = new int[n8];
        int n9 = n2 - 1;
        while (n9 >= 0) {
            int n10 = n9 * n;
            int n11 = n - 1;
            while (n11 >= 0) {
                if ((n10 + n11) % 4000 == 0 && Aladin.isSlow) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(10L);
                    }
                    catch (Exception exception) {}
                }
                int n12 = n7 * n9 * n3 + n7 * n11 + n5 + n6 * n3;
                int n13 = n7 - 1;
                while (n13 >= 0) {
                    nArray[n13] = n12 + n13;
                    nArray2[n13] = sArray[nArray[n13]];
                    int n14 = n7 - 1;
                    while (n14 >= 1) {
                        int n15 = n14 * n7;
                        nArray[n13 + n15] = nArray[n13] + n14 * n3;
                        nArray2[n13 + n15] = sArray[nArray[n13 + n15]];
                        --n14;
                    }
                    --n13;
                }
                int n16 = 0;
                n13 = n8 - 1;
                while (n13 >= 0) {
                    n16 += nArray2[n13];
                    --n13;
                }
                sArray2[n10 + n11] = (short)n16;
                --n11;
            }
            --n9;
        }
    }

    private short[] moyenne(short[] sArray, int n, int n2) {
        short[] sArray2 = new short[(n - 1) * (n2 - 1)];
        int n3 = n2 - 2;
        while (n3 >= 0) {
            int n4 = n3 * n;
            int n5 = n - 2;
            while (n5 >= 0) {
                if (Aladin.isSlow && (n4 + n5) % 4000 == 0) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(10L);
                    }
                    catch (Exception exception) {}
                }
                short s = sArray[n4 + n5];
                short s2 = sArray[n4 + n5 + 1];
                short s3 = sArray[n4 + n5 + n];
                short s4 = sArray[n4 + n5 + n + 1];
                sArray2[n3 * (n - 1) + n5] = (short)((s + s2 + s3 + s4) / 4);
                --n5;
            }
            --n3;
        }
        return sArray2;
    }

    protected void setViewable(int n, boolean bl) {
        Ligne[] ligneArray = this.Ligne[n];
        int n2 = 0;
        while (n2 < ligneArray.length) {
            Ligne ligne = ligneArray[n2];
            ligne.hidden = bl ^ true;
            ++n2;
        }
    }

    protected void setlevels(double[] dArray) {
        this.levels = dArray;
        this.orgLevels = (double[])this.levels.clone();
    }

    protected void updatePourcent(double d) {
        if (this.mustAdjustContour) {
            return;
        }
        this.pourcent = (1.0 - this.partDessin) * 100.0 * (((double)this.nbLevelsComputed + d) / (double)this.orgLevels.length);
    }

    protected void useSmoothing(boolean bl) {
        this.useSmoothing = bl;
    }

    protected boolean waitForPlan() {
        try {
            this.pourcent = -1.0;
            if (this.mustAdjustContour) {
                int n = 0;
                while (n < this.orgLevels.length) {
                    if (this.adjustTab[n] != this.orgLevels[n]) {
                        this.doAdjustContour(this.adjustTab[n], n);
                    }
                    ++n;
                }
                this.mustAdjustContour = false;
                return true;
            }
            Rectangle rectangle = this.calque.zoom.zoomView.getZoom();
            while (!this.calque.zoom.zoomView.zoomok || this.calque.zoom.zoomView.rzoom == null) {
                try {
                    Thread.currentThread();
                    Thread.sleep(10L);
                }
                catch (Exception exception) {}
            }
            this.zoomv = this.calque.zoom.zoomView.getZoom();
            this.pourcent = 0.0;
            if (!this.getAllContours()) {
                this.aladin.message.warning(String.valueOf(Aladin.error) + OutOfMemoryMESSAGE);
                return false;
            }
            this.drawAllContours();
            this.pourcent = 100.0;
            this.pourcent = -1.0;
            return true;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Aladin.error = outOfMemoryError.toString();
            this.aladin.message.warning(String.valueOf(String.valueOf(outOfMemoryError)) + OutOfMemoryMESSAGE);
            return false;
        }
        catch (Exception exception) {
            Aladin.error = exception.toString();
            this.aladin.message.warning(Aladin.error);
            return false;
        }
    }
}

