/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.BasicNode;
import cds.aladin.BasicTree;
import cds.aladin.Coord;
import cds.aladin.Fov;
import cds.aladin.FrameInfo;
import cds.aladin.Plan;
import cds.aladin.ResourceNode;
import cds.aladin.ServerDialog;
import java.awt.Color;
import java.awt.Event;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.ScrollPane;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class MetaDataTree
extends BasicTree {
    private static final String NOIMAGE_WARNING = "can not be loaded : \nno cutout available at this position !\nClick on the region you are interested in\nAvailable images will be marked with a red tick";
    private static final String SORTBY = "Sort by ...";
    private GridBagLayout g = new GridBagLayout();
    private GridBagConstraints c = new GridBagConstraints();
    Aladin aladin;

    MetaDataTree(Aladin aladin, ScrollPane scrollPane) {
        this(new ResourceNode(), aladin, scrollPane);
    }

    MetaDataTree(BasicNode basicNode, Aladin aladin) {
        super(basicNode);
        this.aladin = aladin;
    }

    MetaDataTree(BasicNode basicNode, Aladin aladin, ScrollPane scrollPane) {
        this(basicNode, aladin);
        this.scroll = scrollPane;
    }

    public boolean action(Event event, Object object) {
        super.action(event, object);
        if (object.equals("Delete")) {
            return true;
        }
        if (event.target instanceof MenuItem) {
            if (object.equals(SORTBY) || object.equals("Collapse all") || object.equals("Expand all") || object.equals("Flat view") || object.equals("Hierarchical view")) {
                return true;
            }
            this.sortNode((ResourceNode)this.selectedNode, ((MenuItem)event.target).getActionCommand());
        }
        return true;
    }

    void addNode(ResourceNode resourceNode, ResourceNode resourceNode2) {
        resourceNode.addChild(resourceNode2);
        this.traverseTree();
        this.getStartPosition(resourceNode2);
        this.init();
        this.repaint();
    }

    protected boolean checkCutoutAvailability(BasicNode basicNode, double d, double d2, Aladin aladin) {
        Coord coord = new Coord(d, d2);
        Plan plan = aladin.calque.getPlanRef();
        if (plan == null || plan.projd == null) {
            return true;
        }
        coord = plan.projd.getXY(coord);
        Point point = aladin.calque.view.zoomview.getViewCoord(coord.x, coord.y);
        return ((ResourceNode)basicNode).fov.contains(point.x, point.y, plan, aladin.calque.view.zoomview);
    }

    void clear() {
        ResourceNode resourceNode = new ResourceNode();
        resourceNode.hide = true;
        this.setRoot(resourceNode);
    }

    private void createMenuItem(Menu menu, String[] stringArray) {
        if (stringArray.length == 1) {
            MenuItem menuItem = new MenuItem(stringArray[0]);
            menuItem.setActionCommand(String.valueOf(menu.getActionCommand()) + ";" + stringArray[0]);
            menu.add(menuItem);
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            Menu menu2 = new Menu(stringArray[n]);
            menu2.setActionCommand(String.valueOf(menu.getActionCommand()) + ";" + stringArray[n]);
            menu.add(menu2);
            String[] stringArray2 = new String[stringArray.length - 1];
            int n2 = 0;
            if (n > 0) {
                System.arraycopy(stringArray, 0, stringArray2, 0, n);
                n2 = n;
            }
            if (n < stringArray.length - 1) {
                System.arraycopy(stringArray, n + 1, stringArray2, n2, stringArray.length - (n + 1));
            }
            this.createMenuItem(menu2, stringArray2);
            ++n;
        }
    }

    private void deactivateCutoutFov() {
        this.aladin.calque.cutoutFov = null;
        this.aladin.calque.view.repaint();
    }

    protected void drawFrame(BasicNode basicNode) {
        ResourceNode resourceNode = (ResourceNode)basicNode;
        if (resourceNode.col == null) {
            this.h.setColor(Color.black);
        } else {
            this.h.setColor(resourceNode.col);
        }
        this.h.drawRect(resourceNode.x, basicNode.y / 18 * 18 + 2, this.h.getFontMetrics().stringWidth(resourceNode.name), 12);
    }

    protected void fovAction(ResourceNode resourceNode) {
        if (resourceNode.fov == null) {
            return;
        }
        int n = this.aladin.calque.Fovs.indexOf(resourceNode.fov);
        if (n >= 0) {
            this.aladin.calque.Fovs.removeElementAt(n);
        } else {
            this.aladin.calque.Fovs.addElement(resourceNode.fov);
        }
        this.aladin.calque.view.repaint();
    }

    protected void getStartPosition() {
        this.getStartPosition(this.nodeFullTab);
    }

    protected void getStartPosition(BasicNode basicNode) {
        Vector<BasicNode> vector = new Vector<BasicNode>();
        this.getAllSubnodes(basicNode, vector);
        vector.addElement(basicNode);
        Object[] objectArray = new BasicNode[vector.size()];
        vector.copyInto(objectArray);
        vector = null;
        this.getStartPosition((BasicNode[])objectArray);
    }

    private void getStartPosition(BasicNode[] basicNodeArray) {
        int n = 0;
        while (n < basicNodeArray.length) {
            BasicNode basicNode = basicNodeArray[n];
            if (!basicNode.isLeaf) {
                basicNode.isOpen = basicNode.nbChildren <= 0 || !basicNode.getChildrenAt((int)0).isLeaf && ((ResourceNode)basicNode).valueCriteria == null;
            }
            ++n;
        }
    }

    private String getTarget() {
        return this.aladin.treeView.centerCutOut.getText().trim();
    }

    protected void hideAllFovs() {
        this.aladin.calque.Fovs.removeAllElements();
        this.aladin.calque.view.repaint();
    }

    protected void hideAllLev(ResourceNode resourceNode) {
        this.recHideAllLev(resourceNode);
        this.aladin.calque.view.repaint();
    }

    private void hideFov(BasicNode basicNode) {
        this.aladin.calque.curFov = null;
        this.aladin.calque.view.repaint();
    }

    protected void litUpNode(BasicNode basicNode) {
        if (basicNode.litup) {
            return;
        }
        basicNode.litup = true;
        this.h.setColor(BasicTree.LITBGCOLOR);
        this.h.fillRect(basicNode.x, basicNode.y / 18 * 18, this.h.getFontMetrics().stringWidth(basicNode.name), 18);
        this.h.setColor(BasicTree.LITFGCOLOR);
        if (basicNode.equals(this.lastInfoNode)) {
            this.h.setFont(BasicTree.boldNameFont);
        } else {
            this.h.setFont(BasicTree.nameFont);
        }
        this.h.drawString(basicNode.name, basicNode.x, basicNode.y + 9 + 3);
    }

    protected void load(ResourceNode resourceNode) {
        if (resourceNode.type == 1) {
            this.loadImage(resourceNode);
        } else if (resourceNode.type == 2) {
            this.loadCat(resourceNode);
        }
    }

    private void loadCat(BasicNode basicNode) {
        String string = this.getTarget();
        if (string.length() == 0) {
            this.aladin.message.warning("Please enter a target to load the catalogue", 1);
            return;
        }
        this.aladin.treeView.creatCatPlane(basicNode.name, string, basicNode.name);
    }

    private void loadImage(ResourceNode resourceNode) {
        if (resourceNode.location != null) {
            String string = resourceNode.location;
            if (string.startsWith("file:")) {
                string = string.substring(5);
            }
            this.aladin.dialog.server[ServerDialog.LOCAL].creatPlane("", "", String.valueOf(string) + " image/fits", resourceNode.name, "");
            return;
        }
        if (resourceNode.fov == null) {
            return;
        }
        String string = String.valueOf(resourceNode.survey) + " " + resourceNode.color;
        String string2 = null;
        if (resourceNode.getParent() != null && resourceNode.getParent().nbChildren > 1) {
            string2 = resourceNode.name;
        }
        if (resourceNode.cutout) {
            double d;
            double d2;
            block12: {
                d2 = -1.0;
                d = -1.0;
                try {
                    Coord coord = new Coord(this.getTarget());
                    d = coord.al;
                    d2 = coord.del;
                }
                catch (Exception exception) {
                    Coord coord = this.aladin.view.getSimbad(this.getTarget());
                    if (coord == null) break block12;
                    d = coord.al;
                    d2 = coord.del;
                }
            }
            String string3 = Coord.getSexa(d, d2, " ");
            if (d == -1.0 && d2 == -1.0) {
                this.aladin.message.warning("You have to give the center of the cutout", 1);
            } else if (this.checkCutoutAvailability(resourceNode, d, d2, this.aladin)) {
                this.aladin.treeView.creatAladinPlane(string3, "FITS", "STAND", string, null, null, resourceNode.name, resourceNode.epoch, string2);
            } else {
                this.aladin.message.warning("Image " + resourceNode.name + " " + NOIMAGE_WARNING, 1);
            }
        } else {
            this.aladin.treeView.creatAladinPlane(Coord.getSexa(resourceNode.fov.alpha, resourceNode.fov.delta, " "), "FITS", "STAND", string, null, null, resourceNode.name, resourceNode.epoch, string2);
        }
    }

    void loadSelected() {
        Vector vector = this.getSelectedLeaves();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ResourceNode resourceNode = (ResourceNode)enumeration.nextElement();
            this.load(resourceNode);
        }
    }

    public boolean mouseExit(Event event, int n, int n2) {
        this.aladin.calque.curFov = null;
        this.aladin.calque.cutoutFov = null;
        this.clearSelected();
        this.aladin.calque.repaint();
        return true;
    }

    protected void onMouseMoved(BasicNode basicNode, boolean bl) {
        block6: {
            ResourceNode resourceNode = (ResourceNode)basicNode;
            if (resourceNode.isLeaf && resourceNode.type == 1 && bl) {
                this.showFov(resourceNode);
                if (resourceNode.cutout) {
                    this.showCutoutFov(resourceNode);
                } else {
                    this.deactivateCutoutFov();
                }
            } else {
                this.deactivateCutoutFov();
            }
            if (resourceNode.isLeaf && bl && resourceNode.type == 1) break block6;
            try {
                ResourceNode resourceNode2 = (ResourceNode)this.nodeTab[this.oHilightNode];
                this.hideFov(resourceNode2);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        }
    }

    protected void onNodeCollapsed(BasicNode basicNode) {
    }

    protected void onNodeExpanded(BasicNode basicNode) {
    }

    protected void onNodeRemoved(BasicNode basicNode) {
        Vector vector = new Vector();
        this.getAllSubnodes(basicNode, vector);
        if (basicNode.equals(this.lastInfoNode) || vector.contains(this.lastInfoNode)) {
            this.lastInfoNode = null;
        }
    }

    protected void onNodeSelected(BasicNode basicNode) {
        this.showInfo((ResourceNode)basicNode);
    }

    protected void onRightClickInNode(BasicNode basicNode, int n, int n2) {
        ResourceNode resourceNode = (ResourceNode)basicNode;
        this.popup.removeAll();
        this.popup.add("Delete");
        if (resourceNode.sortCriteria != null && resourceNode.sortCriteria.length > 1) {
            this.popup.add("-");
            this.popup.add(SORTBY);
            this.createMenuItem(this.popup, resourceNode.sortCriteria);
        }
        this.popup.show(this, n, n2);
    }

    /*
     * Unable to fully structure code
     */
    private void recHideAllLev(ResourceNode var1_1) {
        block2: {
            var2_2 = var1_1.getChildren();
            if (!var2_2.hasMoreElements()) break block2;
            var3_3 = (ResourceNode)var1_1.getChildrenAt(0);
            if (var3_3.isLeaf) ** GOTO lbl13
            while (var2_2.hasMoreElements()) {
                this.hideAllLev((ResourceNode)var2_2.nextElement());
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                var3_3 = (ResourceNode)var2_2.nextElement();
                var4_4 = this.aladin.calque.Fovs.indexOf(var3_3.fov);
                if (var4_4 < 0) continue;
                this.aladin.calque.Fovs.removeElementAt(var4_4);
lbl13:
                // 3 sources

                ** while (var2_2.hasMoreElements())
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void recShowAllLev(ResourceNode var1_1) {
        block3: {
            var2_2 = var1_1.getChildren();
            var3_3 = (ResourceNode)var1_1.getChildrenAt(0);
            if (var3_3.isLeaf) ** GOTO lbl13
            while (var2_2.hasMoreElements()) {
                this.showAllLev((ResourceNode)var2_2.nextElement());
            }
            break block3;
lbl-1000:
            // 1 sources

            {
                var3_3 = (ResourceNode)var2_2.nextElement();
                if (var3_3.fov == null) {
                    return;
                }
                if (this.aladin.calque.Fovs.contains(var3_3.fov)) continue;
                this.aladin.calque.Fovs.addElement(var3_3.fov);
lbl13:
                // 3 sources

                ** while (var2_2.hasMoreElements())
            }
        }
    }

    void setRoot(ResourceNode resourceNode) {
        this.rootNode = resourceNode;
        this.traverseTree();
        this.getStartPosition(this.rootNode);
        this.init();
        this.repaint();
    }

    protected void showAllLev(ResourceNode resourceNode) {
        this.recShowAllLev(resourceNode);
        this.aladin.calque.view.repaint();
    }

    private void showCutoutFov(ResourceNode resourceNode) {
        if (resourceNode.fov == null) {
            return;
        }
        try {
            this.aladin.calque.cutoutFov = new Fov(this.getTarget(), resourceNode.fov.cutout_x, resourceNode.fov.cutout_y, resourceNode.fov.angle);
        }
        catch (Exception exception) {}
        this.aladin.calque.view.repaint();
    }

    private void showFov(ResourceNode resourceNode) {
        if (resourceNode.fov == null) {
            return;
        }
        this.aladin.calque.curFov = resourceNode.fov;
        this.aladin.calque.view.repaint();
    }

    private void showInfo(ResourceNode resourceNode) {
        FrameInfo.getInstance().update(resourceNode, this);
    }

    private void sortAndCreate(ResourceNode[] resourceNodeArray, ResourceNode resourceNode, String[] stringArray, Hashtable hashtable) {
        if (resourceNodeArray.length == 0) {
            return;
        }
        int n = 0;
        while (n < resourceNodeArray.length) {
            ResourceNode resourceNode2 = resourceNodeArray[n];
            Hashtable hashtable2 = resourceNode2.criteriaVal;
            ResourceNode resourceNode3 = resourceNode;
            String string = null;
            int n2 = 0;
            while (n2 < stringArray.length) {
                string = (String)hashtable2.get(stringArray[n2]);
                ResourceNode resourceNode4 = (ResourceNode)resourceNode3.getChild(string);
                if (resourceNode4 == null) {
                    resourceNode4 = new ResourceNode((ResourceNode)hashtable.get(string));
                    resourceNode3.addChild(resourceNode4);
                }
                resourceNode3 = resourceNode4;
                ++n2;
            }
            resourceNode3.addChild(resourceNode2);
            if (resourceNode3.col == null) {
                resourceNode3.col = resourceNode2.col;
            }
            ++n;
        }
    }

    private void sortNode(ResourceNode resourceNode, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = stringTokenizer.nextToken();
            ++n;
        }
        Vector vector = new Vector();
        this.getAllLeaves(resourceNode, vector);
        Object[] objectArray = new ResourceNode[vector.size()];
        vector.copyInto(objectArray);
        vector = null;
        vector = new Vector();
        this.getAllNonLeaves(resourceNode, vector);
        Enumeration enumeration = vector.elements();
        Hashtable<String, ResourceNode> hashtable = new Hashtable<String, ResourceNode>();
        while (enumeration.hasMoreElements()) {
            ResourceNode resourceNode2 = (ResourceNode)enumeration.nextElement();
            resourceNode2.removeAllChild();
            hashtable.put(resourceNode2.name, resourceNode2);
        }
        resourceNode.removeAllChild();
        this.sortAndCreate((ResourceNode[])objectArray, resourceNode, stringArray, hashtable);
        this.traverseTree();
        this.majSize();
        this.doDisplay();
        this.repaint();
    }

    protected void turnOffAllNodes() {
        if (this.nodeTab == null) {
            return;
        }
        int n = 0;
        while (n < this.nodeTab.length) {
            ResourceNode resourceNode = (ResourceNode)this.nodeTab[n];
            if (resourceNode.isLeaf && resourceNode.type == 1) {
                this.turnOffNode(resourceNode);
            }
            ++n;
        }
        this.repaint();
    }

    protected void turnOffNode(ResourceNode resourceNode) {
        if (!resourceNode.litup) {
            return;
        }
        resourceNode.litup = false;
        this.h.setColor(Aladin.LGRAY);
        this.h.fillRect(resourceNode.x, resourceNode.y / 18 * 18, this.h.getFontMetrics().stringWidth(resourceNode.name), 18);
        if (resourceNode.equals(this.lastInfoNode)) {
            this.h.setFont(BasicTree.boldNameFont);
        } else {
            this.h.setFont(BasicTree.nameFont);
        }
        this.h.setColor(Color.black);
        this.h.drawString(resourceNode.name, resourceNode.x, resourceNode.y + 9 + 3);
    }
}

