/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.LCoord;
import cds.aladin.Plan;
import cds.aladin.PlanImage;
import cds.aladin.PointD;
import cds.aladin.Source;
import cds.aladin.Warning;
import cds.astro.Astroframe;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Event;
import java.awt.Font;
import java.awt.Panel;
import java.awt.TextField;

public final class Localisation
extends Panel {
    static final int XY = 0;
    static final int J2000 = 1;
    static final int J2000D = 2;
    static final int B1950 = 3;
    static final int B1950D = 4;
    static final int ICRS = 5;
    static final int ICRSD = 6;
    static final int GAL = 7;
    static final int SGAL = 8;
    static final int DF = 12;
    static final Font F = Aladin.PLAIN;
    static final String UNDEF = "";
    static final String[] REPERE = new String[]{"(x,y)", "J2000", "J2000d", "B1950", "B1950d", "ICRS", "ICRSd", "Gal", "SGal"};
    Aladin aladin;
    Choice c;
    LCoord pos;
    Warning warning;
    Panel p;
    TextField text;
    boolean flagFirst = true;
    boolean flagText = false;
    CardLayout cl;
    Astroframe afs = new Astroframe();
    Astroframe aft = null;
    int oi = -1;

    protected Localisation(Aladin aladin) {
        this.aladin = aladin;
        this.c = new Choice();
        this.c.setFont(F);
        int n = 0;
        while (n < REPERE.length) {
            this.c.addItem(REPERE[n]);
            ++n;
        }
        this.c.select(1);
        this.pos = new LCoord(aladin, UNDEF);
        this.text = new TextField();
        this.text.setForeground(Color.blue);
        this.warning = new Warning(aladin);
        this.setLayout(new BorderLayout(3, 0));
        Aladin.makeAdd(this, this.c, "West");
        this.cl = new CardLayout();
        this.p = new Panel();
        this.p.setLayout(this.cl);
        this.p.add("pos", this.pos);
        this.p.add("text", this.text);
        Aladin.makeAdd(this, this.p, "Center");
        Aladin.makeAdd(this, this.warning, "East");
    }

    protected String Help() {
        return "!Localization window\nDisplays the coordinates and the pixel value corresponding to the current position of the mouse in the `` View window''.\nYou can choose the reference system from the menu on the left of the coordinates.\n \nBy clicking on the gray rectangle, you can insert in it a\"quick Aladin command\". It follows this syntax:\n!ServerName[,ServerName] Target\n- The \"ServerNames\" can be Simbad, NED, Aladin or VizieR. For Aladin, you can specified in parenthesis the survey (POSSI,SERC...) or the scan (DSS1,DSS2,MAMA,2MASS) or the resolution (FULL,LOW,PLATE) or the color (J,R,...) or the format (JPEG,FITS)For example: Aladin(DSS1,LOW,FITS).\nFor VizieR, you must specified in parenthesis the catalog name. For example: VizieR(USNO2).\n- The \"Target\" can be a Simbad identifier or J2000 coordinates in sexagesimal syntax.\n \nIf the \"Target\" is omitted, Aladin takes into account the last specified target.\nIf there is only a \"Target\" and no \"ServerName\", two cases:\n- Aladin will load a default data set if the plane stack is free\n- Aladin will move the current target tag to the corresponding position eventually by resolving the identifier into coordinates.";
    }

    public boolean action(Event event, Object object) {
        if (event.target instanceof Choice && this.getFrameSelected() != this.oi) {
            this.aladin.calque.changeFrame();
            return true;
        }
        return false;
    }

    private int getFrame(int n) {
        return n == 1 || n == 2 ? 5 : (n == 3 || n == 4 ? 1 : (n == 5 ? 6 : (n == 7 ? 2 : (n == 8 ? 3 : 5))));
    }

    protected int getFrameSelected() {
        return this.c.getSelectedIndex();
    }

    public boolean handleEvent(Event event) {
        if (Aladin.inHelp) {
            if (event.id == 504) {
                this.aladin.help.setText(this.Help());
            }
            return true;
        }
        return super.handleEvent(event);
    }

    public boolean keyDown(Event event, int n) {
        if (event.target instanceof TextField) {
            if (n != 13 && n != 10) {
                return false;
            }
            String string = this.text.getText().trim();
            this.text.selectAll();
            if (string.length() > 0 && !this.aladin.command.execScript(string, false)) {
                this.aladin.command.execGetCmd(string);
            }
            return true;
        }
        return false;
    }

    protected void seeCoord(Source source) {
        this.seeCoord(source, 0);
    }

    protected void seeCoord(Source source, int n) {
        String string;
        int n2 = this.getFrameSelected();
        switch (n2) {
            case 0: {
                string = String.valueOf(source.x) + "  " + source.y;
                break;
            }
            default: {
                string = this.toString(source.raj, source.dej);
            }
        }
        if (n == 0) {
            this.pos.setText(string);
            this.setPanelPos();
        } else {
            this.setText(string);
            this.setPanelText();
        }
    }

    protected void setPanelPos() {
        if (!this.flagText) {
            return;
        }
        this.flagText = false;
        this.cl.show(this.p, "pos");
    }

    protected void setPanelText() {
        if (Aladin.inHelp || this.flagText) {
            return;
        }
        this.flagText = true;
        this.cl.show(this.p, "text");
    }

    protected void setPos(int n, int n2) {
        this.setPos(n, n2, 0);
    }

    protected void setPos(int n, int n2, int n3) {
        int n4 = this.getFrameSelected();
        Plan plan = this.aladin.calque.getPlanRef();
        PointD pointD = this.aladin.calque.zoom.zoomView.getPosition((double)n, (double)n2);
        String string = null;
        if (plan == null) {
            return;
        }
        if (n4 == 0) {
            if (plan.type != 1) {
                return;
            }
            string = String.valueOf(pointD.x) + "  " + ((double)((PlanImage)plan).height - pointD.y);
        } else {
            if (plan.projd == null) {
                return;
            }
            Coord coord = new Coord();
            coord.x = pointD.x;
            coord.y = pointD.y;
            if ((coord = plan.projd.getCoord(coord)) == null) {
                return;
            }
            string = this.toString(coord.al, coord.del);
        }
        if (n3 == 1) {
            this.setText(string);
            this.setPanelText();
        } else {
            this.pos.setText(string);
            this.setPanelPos();
        }
    }

    protected void setText(String string) {
        this.text.setText(string);
        if (string.length() > 0) {
            this.text.select(0, 0);
        }
    }

    protected void setUndef() {
        this.pos.setText(UNDEF);
    }

    protected String toString(double d, double d2) {
        int n = this.getFrameSelected();
        this.afs.set(d, d2);
        if (n != this.oi) {
            this.oi = n;
            this.aft = new Astroframe(this.getFrame(n));
        }
        this.afs.convert(this.aft);
        try {
            return n == 2 || n == 4 || n == 6 ? this.aft.toString("d") : this.aft.toString(":");
        }
        catch (Exception exception) {
            System.err.println(exception);
            return UNDEF;
        }
    }
}

