/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Calib;
import cds.aladin.ColorMap;
import cds.aladin.Cote;
import cds.aladin.Legende;
import cds.aladin.Ligne;
import cds.aladin.MetaDataTree;
import cds.aladin.Objet;
import cds.aladin.Plan;
import cds.aladin.PlanCatalog;
import cds.aladin.PlanImage;
import cds.aladin.PlanTool;
import cds.aladin.Position;
import cds.aladin.Projection;
import cds.aladin.Repere;
import cds.aladin.Save;
import cds.aladin.Server;
import cds.aladin.Source;
import cds.aladin.Texte;
import cds.xml.Field;
import cds.xml.XMLConsumer;
import cds.xml.XMLParser;
import java.awt.Button;
import java.awt.Event;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Label;
import java.awt.ScrollPane;
import java.awt.TextField;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class LocalServer
extends Server
implements XMLConsumer {
    static final String NOM = "Local";
    static final String TITRE = "Image/data/script loading by file or URL";
    static final String INFO = "Access to images/data/scripts by filename/URL";
    static final String DEFAULT_METHODE = "\n- The image has to be in FITS format (eventually gzipped).\n  Its header has to contain WCS fields\n \n- The data has to be in XML/Astrores or XML/VOTable format\n  see documentation for details\n  or simplier, in Tab-Separated-Value\n  with the first two columns as RA and DE in J2000 decimal degrees\n \n- The Aladin backups have to be produced by the Aladin save method\n  (XML/AJ format)\n \n- The Aladin script must have the extension \".ajs\"";
    static final String HELP = "\nSpecify a filename and press\nthe SUBMIT button below.\n";
    static final String BROWSE = "Browse...";
    TextField file;
    static String loadError;
    String explication;
    String titre;
    FileDialog fd = null;
    boolean inPlane;
    boolean inName;
    boolean inTable;
    boolean inValue;
    Vector vField;
    Legende leg = null;
    Plan plan = null;
    double ra = 0.0;
    double de = 0.0;
    double rm = 0.0;
    int proj = 0;
    int typePlan = -1;
    String rec;
    Objet prevO = null;
    boolean prevFlagSuite = false;
    int pOffset = 0;

    protected LocalServer(Aladin aladin, Label label) {
        this.init();
        this.aladin = aladin;
        this.status = label;
        this.setLayout(null);
        this.setFont(Aladin.PLAIN);
        int n = 45;
        Label label2 = new Label(this.titre);
        label2.setFont(Aladin.LLITALIC);
        label2.setBounds(65, n, 400, 20);
        this.add(label2);
        Label label3 = new Label("Specify a filename or an URL");
        label3.setBounds(110, n += 40, 400, 20);
        this.add(label3);
        Label label4 = new Label("and press the SUBMIT button");
        label4.setBounds(118, n += 15, 300, 20);
        this.add(label4);
        this.file = new TextField(50);
        this.file.setBounds(10, n += 20, 430, 30);
        this.add(this.file);
        Button button = new Button(BROWSE);
        button.setBounds(300, n += 40, 100, 20);
        n += 40;
        this.add(button);
        ScrollPane scrollPane = new ScrollPane();
        this.tree = new MetaDataTree(aladin, scrollPane);
        scrollPane.add(this.tree);
        scrollPane.setBounds(10, n, 430, 200);
        n += 200;
        this.add(scrollPane);
    }

    public boolean action(Event event, Object object) {
        if (BROWSE.equals(object)) {
            if (this.fd == null || Aladin.JAVABEFORE118) {
                this.fd = new FileDialog((Frame)Aladin.f, INFO);
            }
            this.fd.show();
            String string = this.fd.getDirectory();
            String string2 = this.fd.getFile();
            String string3 = String.valueOf(string == null ? "" : string) + (string2 == null ? "" : string2);
            this.file.setText(string3);
            if (string2 != null && string2.length() > 0) {
                this.submit();
            }
            return true;
        }
        return true;
    }

    protected String autoDetectMimeType(String string) {
        if ((string = string.toUpperCase()).endsWith(".IDHA")) {
            return "idha/xml";
        }
        if (string.endsWith(".FITS") || string.endsWith(".FIT")) {
            return "image/fits";
        }
        if (string.endsWith(".GZ")) {
            return "image/gfits";
        }
        if (string.endsWith(".H")) {
            return "image/hfits";
        }
        if (string.endsWith(".MRC") || string.endsWith(".MRCOMP")) {
            return "image/mrfits";
        }
        if (string.endsWith(".AJ")) {
            return "application/aladin";
        }
        if (string.endsWith(".AJS")) {
            return "text/script";
        }
        if (string.endsWith(".XML")) {
            return "text/xml";
        }
        return "text/tsv";
    }

    /*
     * Exception decompiling
     */
    public void characters(char[] var1_1, int var2_2, int var3_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: First case is not immediately after switch.
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:442)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected int creatLocalPlane(String string, String string2, String string3, String string4) {
        int n = -1;
        if (string2 == null) {
            string2 = this.autoDetectMimeType(string);
        }
        if (string3 == null) {
            String string5 = string3 = string.length() > 10 ? string.substring(0, 10) : string;
        }
        if (string4 == null) {
            string4 = string;
        }
        this.flagVerif = false;
        this.verif(0, null, null, null);
        try {
            if (string.startsWith("http://")) {
                URL uRL = this.aladin.glu.getURL("Http", string, true, true);
                if (string2.equals("text/script")) {
                    InputStream inputStream = uRL.openStream();
                    this.aladin.command.readFromStream(inputStream);
                } else {
                    n = string2.charAt(0) == 't' ? this.aladin.calque.newPlanCatalog(uRL, string3, "", string) : this.aladin.calque.newPlanImage(uRL, 2, string3, null, string, string4, 0, 0, true, null);
                }
            } else if (string2.equals("text/script")) {
                FileInputStream fileInputStream = new FileInputStream(string);
                this.aladin.command.readFromStream(fileInputStream);
            } else if (string2.charAt(0) == 'i') {
                this.loadIDHA(string);
            } else if (string2.charAt(0) == 't') {
                n = this.aladin.calque.newPlanCatalog(string);
            } else if (string2.charAt(0) == 'a') {
                this.loadAJ(string);
                n = 0;
            } else {
                n = this.aladin.calque.newPlanImage(string, true);
            }
        }
        catch (Exception exception) {
            this.aladin.message.warning(String.valueOf(String.valueOf(exception)), 1);
            return -1;
        }
        return n;
    }

    protected int creatPlane(String string, String string2, String string3, String string4, String string5) {
        int n;
        String string6 = null;
        String string7 = string3;
        if (string4 == null && string5 == null && string3.indexOf(44) > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
            string7 = stringTokenizer.nextToken();
            if (stringTokenizer.hasMoreTokens()) {
                string4 = stringTokenizer.nextToken();
                if (stringTokenizer.hasMoreTokens()) {
                    string5 = stringTokenizer.nextToken();
                }
            }
        }
        if ((n = string7.indexOf(32)) > 0) {
            string6 = string7.substring(n + 1, string7.length());
            string7 = string7.substring(0, n);
        }
        return this.creatLocalPlane(string7, string6, string4, string5);
    }

    private Plan creatPlaneByAJ(Hashtable hashtable) {
        String string = (String)hashtable.get("type");
        int n = 0;
        while (n < Plan.Tp.length && !Plan.Tp[n].equals(string)) {
            ++n;
        }
        this.typePlan = n;
        switch (n) {
            case 2: {
                this.plan = new PlanCatalog(this.aladin);
                String string2 = (String)hashtable.get("label");
                if (string2 != null) {
                    this.plan.label = string2;
                }
                if ((string2 = (String)hashtable.get("object")) != null) {
                    this.plan.objet = string2;
                }
                if ((string2 = (String)hashtable.get("param")) != null) {
                    this.plan.param = string2;
                }
                if ((string2 = (String)hashtable.get("from")) != null) {
                    this.plan.from = string2;
                }
                if ((string2 = (String)hashtable.get("RA")) != null) {
                    this.ra = Double.valueOf(string2);
                }
                if ((string2 = (String)hashtable.get("DE")) != null) {
                    this.de = Double.valueOf(string2);
                }
                if ((string2 = (String)hashtable.get("radius")) == null) break;
                this.rm = Double.valueOf(string2);
                break;
            }
            case 3: {
                this.plan = new PlanTool(this.aladin);
                String string3 = (String)hashtable.get("label");
                if (string3 != null) {
                    this.plan.label = string3;
                }
                if ((string3 = (String)hashtable.get("xylock")) == null) break;
                ((PlanTool)this.plan).xyLock = new Boolean(string3);
                break;
            }
            case 1: {
                this.plan = new PlanImage(this.aladin);
                String string4 = (String)hashtable.get("label");
                if (string4 != null) {
                    this.plan.label = string4;
                }
                if ((string4 = (String)hashtable.get("object")) != null) {
                    this.plan.objet = string4;
                }
                if ((string4 = (String)hashtable.get("param")) != null) {
                    this.plan.param = string4;
                }
                if ((string4 = (String)hashtable.get("fmt")) != null) {
                    ((PlanImage)this.plan).fmt = PlanImage.getFmt(string4);
                }
                if ((string4 = (String)hashtable.get("resolution")) != null) {
                    ((PlanImage)this.plan).res = PlanImage.getRes(string4);
                }
                if ((string4 = (String)hashtable.get("from")) != null) {
                    this.plan.from = string4;
                }
                if ((string4 = (String)hashtable.get("url")) != null) {
                    try {
                        this.plan.u = new URL(string4);
                    }
                    catch (Exception exception) {}
                }
                if ((string4 = (String)hashtable.get("RA")) != null) {
                    this.ra = Double.valueOf(string4);
                }
                if ((string4 = (String)hashtable.get("DE")) != null) {
                    this.de = Double.valueOf(string4);
                }
                if ((string4 = (String)hashtable.get("radius")) != null) {
                    this.rm = Double.valueOf(string4);
                }
                if ((string4 = (String)hashtable.get("proj")) != null) {
                    this.proj = Integer.parseInt(string4);
                }
                PlanImage planImage = (PlanImage)this.plan;
                string4 = (String)hashtable.get("width");
                if (string4 != null) {
                    planImage.width = Integer.parseInt(string4);
                }
                if ((string4 = (String)hashtable.get("height")) != null) {
                    planImage.height = Integer.parseInt(string4);
                }
                if ((string4 = (String)hashtable.get("video")) != null) {
                    planImage.video = Integer.parseInt(string4);
                }
                if ((string4 = (String)hashtable.get("colormap1")) != null) {
                    planImage.cmControl[0] = Integer.parseInt(string4);
                }
                if ((string4 = (String)hashtable.get("colormap2")) != null) {
                    planImage.cmControl[1] = Integer.parseInt(string4);
                }
                if ((string4 = (String)hashtable.get("colormap3")) != null) {
                    planImage.cmControl[2] = Integer.parseInt(string4);
                }
                if ((string4 = (String)hashtable.get("calib")) == null) break;
                Calib calib = new Calib();
                this.parseCalib(calib, string4);
                calib.adxpoly = this.parsePoly((String)hashtable.get("adxpoly"));
                calib.adypoly = this.parsePoly((String)hashtable.get("adypoly"));
                calib.xyapoly = this.parsePoly((String)hashtable.get("xyapoly"));
                calib.xydpoly = this.parsePoly((String)hashtable.get("xydpoly"));
                calib.CD = this.parseMat((String)hashtable.get("CD"));
                calib.ID = this.parseMat((String)hashtable.get("ID"));
                this.plan.setNewProjD(new Projection(this.proj, calib));
                break;
            }
            default: {
                this.plan = null;
            }
        }
        return this.plan;
    }

    public void endElement(String string) {
        if (string.equals("PLANE")) {
            this.inPlane = false;
            if (this.plan != null) {
                if (this.typePlan == 2) {
                    this.plan.pcat.postJob(this.ra, this.de, this.rm);
                }
                if (this.typePlan == 1) {
                    PlanImage planImage = (PlanImage)this.plan;
                    planImage.cm = ColorMap.getCM(planImage.cmControl[0], planImage.cmControl[1], planImage.cmControl[2], planImage.inverseCM(), 0);
                    PlanImage.changeEtat();
                }
                this.plan.flagOk = true;
                this.aladin.calque.plan[this.aladin.calque.getFirstFree()] = this.plan;
                this.plan = null;
            }
        } else if (string.equals("NAME")) {
            this.inName = false;
        } else if (string.equals("TABLE")) {
            this.inTable = false;
            this.leg = null;
            this.vField = null;
        } else if (string.equals("VALUE")) {
            this.inValue = false;
        } else if (string.equals("ALADINJAVA")) {
            this.aladin.calque.setDefaultPlanRef();
            this.aladin.calque.activeAllPlan();
            this.aladin.calque.repaint();
        }
    }

    private void getImage(char[] cArray, int n, int n2) {
        PlanImage planImage = (PlanImage)this.plan;
        if (planImage.pixels == null) {
            planImage.pixels = new byte[planImage.width * planImage.height];
            this.pOffset = 0;
        }
        this.pOffset = Save.get64(planImage.pixels, this.pOffset, cArray, n, n2);
    }

    private int getSource(char[] cArray, int n, int n2) {
        boolean bl = false;
        while (n < n2 && (cArray[n] == '\r' || cArray[n] == '\n')) {
            ++n;
        }
        n = this.getSourceField(cArray, n, n2);
        double d = Double.valueOf(this.rec);
        n = this.getSourceField(cArray, n, n2);
        double d2 = Double.valueOf(this.rec);
        n = this.getSourceField(cArray, n, n2);
        String string = this.rec;
        int n3 = n;
        while (n < n2 && cArray[n] != '\n') {
            ++n;
        }
        this.rec = new String(cArray, n3, n - n3).trim();
        Source source = this.leg != null ? new Source(this.plan, d, d2, string, this.rec, this.leg) : new Source(this.plan, d, d2, string, this.rec);
        this.plan.pcat.setObjetFast(source);
        return n;
    }

    private int getSourceField(char[] cArray, int n, int n2) {
        int n3 = n;
        while (n < n2 && cArray[n] != '\t' && cArray[n] != '\n') {
            ++n;
        }
        this.rec = new String(cArray, n3, n - n3).trim();
        return cArray[n] == '\t' ? n + 1 : n;
    }

    private int getTool(char[] cArray, int n, int n2) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        String string = null;
        while (n < n2 && (cArray[n] == '\r' || cArray[n] == '\n')) {
            ++n;
        }
        n = this.getSourceField(cArray, n, n2);
        string = this.rec;
        n = this.getSourceField(cArray, n, n2);
        bl2 = this.rec.equals("+");
        n = this.getSourceField(cArray, n, n2);
        double d = Double.valueOf(this.rec);
        n = this.getSourceField(cArray, n, n2);
        double d2 = Double.valueOf(this.rec);
        n = this.getSourceField(cArray, n, n2);
        int n3 = Integer.parseInt(this.rec);
        n = this.getSourceField(cArray, n, n2);
        int n4 = Integer.parseInt(this.rec);
        n = this.getSourceField(cArray, n, n2);
        bl3 = new Boolean(this.rec);
        n = this.getSourceField(cArray, n, n2);
        String string2 = this.rec;
        Position position = null;
        if (string.equals("tag")) {
            position = new Repere(this.plan);
        } else if (string.equals("text")) {
            position = new Texte(this.plan);
        } else if (string.equals("line")) {
            position = new Ligne(this.plan);
        } else if (string.equals("arrow")) {
            position = new Cote(this.plan);
        }
        if (position != null) {
            position.raj = d;
            position.dej = d2;
            position.x = n3;
            position.y = n4;
            position.id = string2;
            position.withlabel = bl3;
            if (this.prevFlagSuite) {
                ((Ligne)this.prevO).finligne = (Ligne)position;
                ((Ligne)position).debligne = (Ligne)this.prevO;
            }
            if (string.equals("text")) {
                ((Texte)position).setWH();
            }
            this.plan.pcat.setObjetFast(position);
            this.prevO = position;
            this.prevFlagSuite = bl2;
        }
        return n;
    }

    protected void init() {
        this.type = 0;
        this.nom = NOM;
        this.info = INFO;
        this.titre = TITRE;
        this.explication = DEFAULT_METHODE;
    }

    protected boolean loadAJ(String string) {
        boolean bl;
        XMLParser xMLParser = new XMLParser(this);
        loadError = null;
        try {
            DataInputStream dataInputStream = new DataInputStream(new FileInputStream(string));
            bl = xMLParser.parse(dataInputStream);
        }
        catch (Exception exception) {
            loadError = String.valueOf(String.valueOf(exception));
            return false;
        }
        if (!bl) {
            loadError = xMLParser.getError();
        }
        return bl && loadError == null;
    }

    private void loadIDHA(String string) {
        try {
            FileInputStream fileInputStream = new FileInputStream(new File(string));
            this.aladin.treeView.updateTree(fileInputStream, this.tree, this, "");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void parseCalib(Calib calib, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        calib.aladin = Integer.parseInt(stringTokenizer.nextToken());
        calib.epoch = Double.valueOf(stringTokenizer.nextToken());
        calib.alpha = Double.valueOf(stringTokenizer.nextToken());
        calib.delta = Double.valueOf(stringTokenizer.nextToken());
        calib.yz = Double.valueOf(stringTokenizer.nextToken());
        calib.xz = Double.valueOf(stringTokenizer.nextToken());
        calib.focale = Double.valueOf(stringTokenizer.nextToken());
        calib.Xorg = Double.valueOf(stringTokenizer.nextToken());
        calib.Yorg = Double.valueOf(stringTokenizer.nextToken());
        calib.incX = Double.valueOf(stringTokenizer.nextToken());
        calib.incY = Double.valueOf(stringTokenizer.nextToken());
        calib.alphai = Double.valueOf(stringTokenizer.nextToken());
        calib.deltai = Double.valueOf(stringTokenizer.nextToken());
        calib.incA = Double.valueOf(stringTokenizer.nextToken());
        calib.incD = Double.valueOf(stringTokenizer.nextToken());
        calib.Xcen = Double.valueOf(stringTokenizer.nextToken());
        calib.Ycen = Double.valueOf(stringTokenizer.nextToken());
        calib.widtha = Double.valueOf(stringTokenizer.nextToken());
        calib.widthd = Double.valueOf(stringTokenizer.nextToken());
        calib.xnpix = Integer.parseInt(stringTokenizer.nextToken());
        calib.ynpix = Integer.parseInt(stringTokenizer.nextToken());
        calib.rota = Double.valueOf(stringTokenizer.nextToken());
        calib.cdelz = Double.valueOf(stringTokenizer.nextToken());
        calib.sdelz = Double.valueOf(stringTokenizer.nextToken());
        calib.type1 = stringTokenizer.nextToken();
        calib.type2 = stringTokenizer.nextToken();
        try {
            calib.equinox = Double.valueOf(stringTokenizer.nextToken());
        }
        catch (Exception exception) {
            calib.equinox = 2000.0;
        }
        try {
            calib.proj = Integer.parseInt(stringTokenizer.nextToken());
        }
        catch (Exception exception) {
            calib.proj = 1;
        }
    }

    private double[][] parseMat(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        double[][] dArray = new double[2][2];
        dArray[0][0] = Double.valueOf(stringTokenizer.nextToken());
        dArray[0][1] = Double.valueOf(stringTokenizer.nextToken());
        dArray[1][0] = Double.valueOf(stringTokenizer.nextToken());
        dArray[1][1] = Double.valueOf(stringTokenizer.nextToken());
        return dArray;
    }

    private double[] parsePoly(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        double[] dArray = new double[stringTokenizer.countTokens()];
        int n = 0;
        while (n < dArray.length) {
            dArray[n] = Double.valueOf(stringTokenizer.nextToken());
            ++n;
        }
        return dArray;
    }

    protected void reset() {
        this.file.setText("");
        super.reset();
    }

    public void startElement(String string, Hashtable hashtable) {
        if (string.equals("ALADINJAVA")) {
            this.aladin.calque.FreeAll();
        } else if (string.equals("PLANE")) {
            this.inPlane = true;
            this.plan = this.creatPlaneByAJ(hashtable);
        } else if (string.equals("NAME")) {
            this.inName = true;
        } else if (string.equals("TABLE")) {
            this.inTable = true;
            this.vField = new Vector(10);
        } else if (string.equals("VALUE")) {
            this.inValue = true;
            if (this.vField != null && this.vField.size() > 0) {
                this.leg = new Legende(this.vField);
            }
        } else if (string.equals("COLUMN")) {
            Field field = new Field(hashtable);
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                field.addInfo(string2, (String)hashtable.get(string2));
            }
            this.vField.addElement(field);
        }
    }

    public void submit() {
        this.waitCursor();
        this.creatLocalPlane(this.file.getText(), null, null, null);
        this.defaultCursor();
    }
}

