/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Plan;
import cds.aladin.PointD;
import cds.aladin.Position;
import cds.aladin.ZoomView;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class Ligne
extends Position {
    static final int L = 7;
    static final int DL = 4;
    protected int bout;
    protected Color couleur = null;
    protected boolean hidden = false;
    protected Ligne debligne = null;
    protected Ligne finligne = null;

    protected Ligne(Plan plan) {
        super(plan);
    }

    protected Ligne(Plan plan, double d, double d2) {
        super(plan, d, d2, 0.0, 0.0, 5, null);
    }

    protected Ligne(Plan plan, double d, double d2, Ligne ligne) {
        this(plan, d, d2, "", ligne);
    }

    protected Ligne(Plan plan, double d, double d2, Ligne ligne, Color color) {
        this(plan, d, d2, "", ligne, color);
        this.couleur = new Color(color.getRGB());
    }

    protected Ligne(Plan plan, double d, double d2, Color color) {
        this(plan, d, d2);
        this.couleur = new Color(color.getRGB());
    }

    protected Ligne(Plan plan, double d, double d2, String string) {
        super(plan, d, d2, 0.0, 0.0, 5, string);
    }

    protected Ligne(Plan plan, double d, double d2, String string, Ligne ligne) {
        super(plan, d, d2, 0.0, 0.0, 5, string);
        this.debligne = ligne;
        ligne.finligne = this;
    }

    protected Ligne(Plan plan, double d, double d2, String string, Ligne ligne, Color color) {
        this(plan, d, d2, string);
        this.debligne = ligne;
        ligne.finligne = this;
        this.couleur = new Color(color.getRGB());
    }

    protected Ligne(Plan plan, double d, double d2, String string, Color color) {
        this(plan, d, d2, string);
        this.couleur = new Color(color.getRGB());
    }

    protected void draw(Graphics graphics, ZoomView zoomView, int n, int n2) {
        if (!this.hidden) {
            Point point;
            if (this.couleur != null) {
                graphics.setColor(this.couleur);
            } else {
                graphics.setColor(this.plan.c);
            }
            if (this.debligne != null) {
                point = this.getViewCoord(zoomView);
                Point point2 = this.debligne.getViewCoord(zoomView);
                point2.x += n;
                point2.y += n2;
                point.x += n;
                point.y += n2;
                graphics.drawLine(point2.x, point2.y, point.x, point.y);
                if (this.bout > 0) {
                    double d;
                    if (point2.x != point.x) {
                        d = Math.atan((double)(point.y - point2.y) / (double)(point.x - point2.x));
                        if (point2.x > point.x) {
                            d += Math.PI;
                        }
                    } else {
                        d = point2.y < point.y ? 1.5707963267948966 : -1.5707963267948966;
                    }
                    double d2 = 2.356194490192345;
                    int n3 = (int)(7.0 * Math.cos(d + d2));
                    int n4 = (int)(7.0 * Math.sin(d + d2));
                    int n5 = (int)(7.0 * Math.cos(d - d2));
                    int n6 = (int)(7.0 * Math.sin(d - d2));
                    graphics.drawLine(point.x + n3, point.y + n4, point.x, point.y);
                    graphics.drawLine(point.x, point.y, point.x + n5, point.y + n6);
                    if (this.bout == 2) {
                        graphics.drawLine(point2.x - n3, point2.y - n4, point2.x, point2.y);
                        graphics.drawLine(point2.x, point2.y, point2.x - n5, point2.y - n6);
                    }
                }
            } else {
                point = this.getViewCoord(zoomView, 0, 0);
                if (point.x < 0) {
                    return;
                }
                point.x += n;
                point.y += n2;
            }
            if (this.select) {
                int n7 = 2;
                graphics.setColor(Color.green);
                graphics.fillRect(point.x - n7 + 1, point.y - n7 + 1, 3, 3);
                graphics.setColor(Color.black);
                graphics.drawRect(point.x - n7, point.y - n7, 4, 4);
            }
        }
    }

    protected Rectangle getClip(ZoomView zoomView) {
        Point[] pointArray = new Point[4];
        int n = 2048;
        int n2 = 2048;
        int n3 = 0;
        int n4 = 0;
        pointArray[0] = this.debligne != null ? this.debligne.getViewCoord(zoomView) : null;
        pointArray[1] = this.getViewCoord(zoomView);
        pointArray[2] = this.finligne != null ? this.finligne.getViewCoord(zoomView) : null;
        int n5 = 0;
        while (n5 < 4) {
            if (pointArray[n5] != null) {
                if (pointArray[n5].x < n) {
                    n = pointArray[n5].x;
                }
                if (pointArray[n5].y < n2) {
                    n2 = pointArray[n5].y;
                }
                if (pointArray[n5].x > n3) {
                    n3 = pointArray[n5].x;
                }
                if (pointArray[n5].y > n4) {
                    n4 = pointArray[n5].y;
                }
            }
            ++n5;
        }
        if (this.bout > 0 || this.select) {
            n -= 4;
            n2 -= 4;
            n3 += 4;
            n4 += 4;
        }
        return new Rectangle(n, n2, n3 - n + 1, n4 - n2 + 1);
    }

    protected Point getViewCoord(ZoomView zoomView) {
        this.vp = zoomView.getViewCoord(this.x, this.y);
        this.oiz = zoomView.iz;
        return this.vp;
    }

    protected boolean in(double d, double d2, double d3) {
        double d4 = 9.0 / d3;
        if (this.debligne == null) {
            return false;
        }
        PointD pointD = new PointD(this.x, this.y);
        PointD pointD2 = new PointD(this.debligne.x, this.debligne.y);
        if ((pointD.x - d) * (pointD2.x - d) > d4 || (pointD.y - d2) * (pointD2.y - d2) > d4) {
            return false;
        }
        double d5 = pointD.x - pointD2.x;
        double d6 = pointD.y - pointD2.y;
        double d7 = d - pointD2.x;
        double d8 = d2 - pointD2.y;
        double d9 = d7 * d7 + d8 * d8;
        if (d5 != 0.0 || d6 != 0.0) {
            double d10 = d5 * d7 + d6 * d8;
            d9 -= d10 * d10 / (d5 * d5 + d6 * d6);
        }
        return d9 <= d4;
    }

    protected boolean inside(double d, double d2, double d3) {
        return this.nearArrow(d, d2, d3);
    }

    boolean nearArrow(double d, double d2, double d3) {
        double d4 = d - this.x;
        double d5 = d2 - this.y;
        double d6 = 9.0 / d3;
        return d4 * d4 + d5 * d5 <= d6;
    }
}

