/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.xml.Field;
import java.util.Enumeration;
import java.util.Vector;

public final class Legende {
    Field[] field;

    protected Legende(Vector vector) {
        this.field = new Field[vector.size()];
        Enumeration enumeration = vector.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            this.field[n] = (Field)enumeration.nextElement();
            ++n;
        }
    }

    protected String getDataType(int n) {
        return n >= this.field.length ? null : this.field[n].datatype;
    }

    protected String getDescription(int n) {
        if (n >= this.field.length) {
            return null;
        }
        Field field = this.field[n];
        String string = String.valueOf(field.name) + " : ";
        string = String.valueOf(string) + (field.description != null ? field.description : (field.name != null ? field.name : null));
        if (field.ucd != null) {
            string = String.valueOf(string) + " (UCD: " + field.ucd;
            if (field.unit != null) {
                string = String.valueOf(string) + " / unit: " + field.unit;
            }
            string = String.valueOf(string) + ")";
        } else if (field.unit != null) {
            string = String.valueOf(string) + " (unit: " + field.unit + ")";
        }
        return string;
    }

    protected String getGref(int n) {
        return n >= this.field.length ? null : this.field[n].gref;
    }

    protected String getHref(int n) {
        return n >= this.field.length ? null : this.field[n].href;
    }

    protected String getRefText(int n) {
        return n >= this.field.length ? null : this.field[n].refText;
    }

    protected int getRefTextLength(int n) {
        if (n >= this.field.length) {
            return -1;
        }
        if (this.field[n].refText == null) {
            return 0;
        }
        return this.field[n].refText.length() + 1;
    }

    protected String getRefValue(int n) {
        return n >= this.field.length ? null : this.field[n].refValue;
    }

    protected String getToolTipText(int n) {
        if (n >= this.field.length || n < 0) {
            return null;
        }
        Field field = this.field[n];
        String string = field.name;
        string = String.valueOf(string) + " / ";
        string = String.valueOf(string) + (field.ucd != null ? field.ucd : "");
        string = String.valueOf(string) + " / ";
        string = String.valueOf(string) + (field.unit != null ? field.unit : "");
        return string;
    }

    protected int getWidth(int n) {
        int n2 = 0;
        if (n >= this.field.length) {
            return -1;
        }
        Field field = this.field[n];
        if (field.width != null) {
            if (field.refText != null && field.refText.indexOf("${") < 0) {
                return field.refText.length() + 1;
            }
            try {
                n2 = Integer.parseInt(field.width);
            }
            catch (Exception exception) {
                return -1;
            }
        } else if (field.arraysize != null) {
            n2 = !field.arraysize.endsWith("*") ? Integer.parseInt(field.arraysize) : Integer.parseInt(field.arraysize.substring(0, field.arraysize.length() - 1));
        }
        return n2;
    }

    protected boolean hasInfo(int n) {
        return n >= this.field.length ? false : n < this.field.length;
    }
}

