/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.PlanImage;
import cds.aladin.PlanImageRGB;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;

public class Histogramme
extends Canvas {
    static final int mX = 10;
    static final int mY = 0;
    static final int Hp = 150;
    static final int W = 276;
    static final int H = 150;
    static final String TITLE = "Pixel values histogram";
    double[] hist;
    Image img = null;
    PlanImage pimg;
    byte[] pixels;

    protected Histogramme(PlanImage planImage) {
        if (planImage != null && !(planImage instanceof PlanImageRGB)) {
            double d = 0.0;
            this.pimg = planImage;
            this.pixels = planImage.pixels;
            this.hist = new double[256];
            int n = 0;
            while (n < this.pixels.length) {
                double d2;
                int n2;
                int n3 = n2 = this.pixels[n] < 0 ? 256 + this.pixels[n] : this.pixels[n];
                this.hist[n3] = this.hist[n3] + 1.0;
                if (d2 > d) {
                    d = d2;
                }
                ++n;
            }
            n = 0;
            while (n < this.hist.length) {
                this.hist[n] = Math.log(1.0 + this.hist[n]);
                ++n;
            }
            d = Math.log(1.0 + d);
            d += d / 5.0;
            n = 0;
            while (n < this.hist.length) {
                this.hist[n] = this.hist[n] * 150.0 / d;
                ++n;
            }
            this.setBackground(Aladin.BKGD);
            this.resize(276, 150);
        }
    }

    public Dimension getPreferredSize() {
        return this.preferredSize();
    }

    public void paint(Graphics graphics) {
        if (this.pimg == null) {
            return;
        }
        if (this.img == null) {
            this.update(graphics);
            return;
        }
        graphics.drawImage(this.img, 10, 0, null);
    }

    public Dimension preferredSize() {
        return new Dimension(276, 150);
    }

    public void update(Graphics graphics) {
        if (this.img == null) {
            this.img = this.createImage(256, 150);
        }
        Graphics graphics2 = this.img.getGraphics();
        graphics2.setColor(Color.white);
        graphics2.fillRect(0, 0, 256, 150);
        graphics2.setColor(Color.blue);
        int n = 0;
        while (n < 256) {
            graphics2.drawLine(n, 150, n, 150 - (int)this.hist[n]);
            ++n;
        }
        graphics2.setColor(Color.black);
        graphics2.drawRect(0, 0, 255, 149);
        graphics2.setFont(Aladin.SPLAIN);
        graphics2.drawString(TITLE, 73, 14);
        graphics2.dispose();
        this.paint(graphics);
    }
}

