/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.EISFov;
import cds.aladin.Glu;
import cds.aladin.MyLabel;
import cds.aladin.PlanImage;
import cds.aladin.ResourceNode;
import cds.aladin.ResourceTree;
import cds.aladin.Server;
import cds.aladin.TreeBuilder;
import cds.astro.Astroframe;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.TextField;
import java.io.DataInputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public final class GoodsServer
extends Server
implements Runnable {
    static final String NOM = "GOODS";
    static final String INFO = "GOODS images provided by Aladin image server";
    static final String IMAGE_METHODE = "Step 2: pick up one of these images, and SUBMIT again";
    static final int MAXLINE = 7;
    private static final String URLCAT = "http://vizier.u-strasbg.fr/cgi-bin/votable/-w?-meta&-c=cdfs&-c.r=0.25&-c.u=degree&-c.eq=J2000";
    List aladinchoix;
    Vector vqual;
    Vector vresol;
    boolean enableOtherImage;
    Panel qual;
    Panel hier;
    ResourceTree rt;
    ResourceNode rootNode;
    ResourceNode catRootNode;
    ScrollPane scroll;
    Panel infoPanel;
    Thread thread;
    TextField radius;
    TextField centerCutOut;
    static String[] ACOLOR = new String[]{"J", "F", "E", "EJ", "V", "O", "R", "I", "S", "SR", "ER", "U", "B", "N"};
    static String[] COLOR = new String[]{"Blue", "Red", "Red", "Equ. blue", "Visible", "Blue", "Red", "InfraRed", "Short red", "Short red", "Equ. red", "UV", "Blue", "Red/IR"};
    static String lastQual = "";
    static boolean flagContWhichQual = false;
    String targetT;
    String criteriaT;
    String labelT;
    String originT;
    boolean sync = true;
    static String otarget = null;
    static FileDialog fd = null;

    protected GoodsServer(Aladin aladin, Label label) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 0;
        this.setLayout(gridBagLayout);
        this.aladin = aladin;
        this.status = label;
        this.type = 0;
        this.nom = NOM;
        this.info = INFO;
        this.titrePanel(this, "GOODS images by Aladin image server", gridBagLayout, gridBagConstraints);
        this.qual = new Panel();
        this.qual.setLayout(new BorderLayout(0, 0));
        Label label2 = new Label("SURVEY   ORIGIN   COLOR        SIZE               COMMENT     ");
        label2.setFont(Aladin.COURIER);
        label2.setForeground(Color.white);
        label2.setBackground(Color.gray);
        Aladin.makeAdd(this.qual, label2, "North");
        this.aladinchoix = new List(8, true);
        Aladin.makeAdd(this.qual, this.aladinchoix, "Center");
        int n = 0;
        while (n < 7) {
            this.aladinchoix.addItem(" ");
            ++n;
        }
        this.aladinchoix.setFont(Aladin.COURIER);
        this.createRootNode();
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout());
        this.hier = new Panel();
        this.hier.setLayout(new BorderLayout(0, 0));
        this.scroll = new ScrollPane(0);
        this.scroll.add(this.hier);
        this.scroll.setSize(300, 430);
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.scroll, gridBagConstraints);
        this.add(this.scroll);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        this.centerCutOut = new TextField(15);
        this.grab = new Button("Grab coord");
        ((Component)this.grab).enable(false);
        GoodsServer.addCouple(this, "Center of cutout", this.centerCutOut, new Label(""), gridBagLayout, gridBagConstraints);
        this.radius = new TextField("10 arcmin", 15);
        this.setModeRad(1, this.radius);
        GoodsServer.addCouple(this, "Radius", this.radius, null, gridBagLayout, gridBagConstraints);
        this.infoPanel = new Panel(){

            public Dimension getMinimumSize() {
                return new Dimension(360, 420);
            }

            public Dimension getPreferredSize() {
                return new Dimension(360, 420);
            }
        };
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 0;
        gridBagLayout.setConstraints(this.infoPanel, gridBagConstraints);
        this.add(this.infoPanel);
        gridBagLayout.setConstraints(this.qual, gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 0;
        this.enableOtherImage(false);
    }

    protected static void addCouple(Panel panel, String string, Component component, Component component2, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        MyLabel myLabel = string != null ? new MyLabel(string, 2, Aladin.LBOLD) : new MyLabel();
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(myLabel, gridBagConstraints);
        panel.add(myLabel);
        if (component2 == null) {
            gridBagConstraints.gridwidth = 0;
        }
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        panel.add(component);
        gridBagConstraints.fill = 0;
        if (component2 != null) {
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 10, 0, 10);
            gridBagLayout.setConstraints(component2, gridBagConstraints);
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.anchor = 17;
            panel.add(component2);
        }
    }

    protected static String blankToUnderline(String string) {
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            if (cArray[n] == ' ') {
                cArray[n] = 95;
            }
            ++n;
        }
        return new String(cArray);
    }

    static String change2FITS(String string) {
        int n = string.indexOf("JPEG");
        if (n < 0) {
            return string;
        }
        return String.valueOf(string.substring(0, n)) + "FITS" + string.substring(n + 4, string.length());
    }

    protected int creatAladinPlane(String string, String string2, String string3, String string4, String string5, String string6) {
        return this.creatAladinPlane(string, string2, string3, string4, string5, string6, "", null);
    }

    protected int creatAladinPlane(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        if (string2 == null) {
            string2 = "JPEG";
        }
        if (string3 == null) {
            string3 = "FULL";
        }
        String string9 = this.getSurvey(string4);
        String string10 = this.getColor(string4);
        Coord coord = null;
        try {
            coord = new Coord(string);
        }
        catch (Exception exception) {}
        String string11 = String.valueOf(coord.al) + " " + coord.del;
        Astroframe astroframe = new Astroframe();
        try {
            astroframe.set(string);
            astroframe.setPrecision(6);
            string = astroframe.toString(" ");
        }
        catch (Exception exception) {}
        String string12 = String.valueOf(Glu.quote(string11)) + " " + Glu.quote(string9) + " " + Glu.quote(string10) + " " + Glu.quote(string7);
        URL uRL = this.aladin.glu.getURL("Image.GOODS", string12);
        if (uRL == null) {
            this.aladin.message.warning("Unknown server error", 1);
            return -1;
        }
        if (string5 == null) {
            string5 = GoodsServer.getPlanLabel(string3, String.valueOf(string4) + " ___");
            string5 = String.valueOf(string5) + this.getLastNumber(string8);
        }
        if (string6 == null) {
            string6 = "GOODS data - provided on line by CDS";
        }
        return this.aladin.calque.newPlanImage(uRL, 0, string5, string, string4, string6, PlanImage.getFmt(string2), PlanImage.getRes(string3), false, null);
    }

    protected int creatAladinPlane(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9) {
        String string10 = null;
        if (string8 != null) {
            string10 = GoodsServer.getPlanLabel(string3, String.valueOf(string4) + ".ep" + string8.substring(5) + " ___");
            string10 = String.valueOf(string10) + this.getLastNumber(string9);
        }
        return this.creatAladinPlane(string, string2, string3, string4, string10, string6, string7, string9);
    }

    protected int creatCatPlane(String string, String string2, String string3) {
        String string4 = this.getRadius();
        if (string4.equals("")) {
            this.aladin.message.warning("You must specify the radius of your query");
            return -1;
        }
        String string5 = "2";
        String string6 = String.valueOf(Glu.quote(string)) + " " + Glu.quote(string2) + " " + Glu.quote(string4);
        URL uRL = this.aladin.glu.getURL("VizieRXML.rm", string6);
        if (uRL == null) {
            this.aladin.message.warning("Unknown server error", 1);
            return -1;
        }
        if (!this.verif(2, string2, String.valueOf(string3) + " " + string4)) {
            return -1;
        }
        return this.aladin.calque.newPlanCatalog(uRL, string3, string2, String.valueOf(string3) + " " + string4);
    }

    protected int creatPlane(String string, String string2, String string3, String string4, String string5) {
        String string6 = null;
        String string7 = null;
        String string8 = null;
        if (string3 != null) {
            this.targetT = string;
            this.criteriaT = string3;
            this.originT = string5;
            this.labelT = string4;
            this.thread = new Thread(this);
            this.setSync(false);
            this.thread.start();
            return 0;
        }
        return this.creatAladinPlane(string, string6, string7, string8, string4, string5);
    }

    private void createCatRootNodeLocally() {
        Aladin.trace(1, "Creating Goods catalogues tree using local backup file");
        String string = Aladin.HOME;
        String string2 = "backupcattree.xml";
        this.catRootNode = new TreeBuilder(String.valueOf(string) + string2, 1, 2).build();
    }

    protected void createResourceTree() {
        if (this.rt != null) {
            return;
        }
        Aladin.trace(1, "Creating the Resource Tree");
        this.rootNode.name = "Images";
        this.catRootNode.name = "Catalogues";
        ResourceNode resourceNode = new ResourceNode("root");
        resourceNode.type = 0;
        resourceNode.addChild(this.rootNode);
        resourceNode.addChild(this.catRootNode);
        resourceNode.hide = true;
        resourceNode.isOpen = true;
        this.rt = new ResourceTree(resourceNode, this.aladin);
        this.rt.scroll = this.scroll;
        this.rt.setInfoPanel(this.infoPanel);
        this.rt.getStartPosition();
        this.hier.add(this.rt);
        this.scroll.doLayout();
    }

    protected void createRootNode() {
        if (!Aladin.NETWORK || !Aladin.NET) {
            this.createRootNodeLocally();
            this.createCatRootNodeLocally();
        } else {
            URL uRL;
            URL uRL2;
            try {
                uRL2 = new URL("http://aladin.u-strasbg.fr/cgi-bin/nph-HTTP1.cgi?out=qualifier&position=053.11629+-27.80875&radius=0.25&mode=xml_votable_idha");
            }
            catch (Exception exception) {
                System.err.println("Can't create GOODS tree " + exception);
                return;
            }
            Aladin.trace(1, "Creating the Images Tree root node for images, using URL " + uRL2);
            this.rootNode = new TreeBuilder(uRL2, 1, 1).build();
            try {
                uRL = new URL(URLCAT);
            }
            catch (Exception exception) {
                System.err.println("Can't create GOODS image tree " + exception);
                return;
            }
            Aladin.trace(1, "Creating the Catalogues Tree root node for images, using URL " + uRL);
            this.catRootNode = new TreeBuilder(uRL, 1, 2).build();
        }
        if (this.rootNode == null) {
            this.createRootNodeLocally();
            return;
        }
    }

    private void createRootNodeLocally() {
        Aladin.trace(1, "Creating Goods images tree using local backup file");
        String string = Aladin.HOME;
        String string2 = "backuptree.xml";
        this.rootNode = new TreeBuilder(String.valueOf(string) + string2, 1, 1).build();
    }

    private void deselect() {
        int n = this.aladinchoix.countItems();
        while (n >= 0) {
            this.aladinchoix.deselect(n);
            --n;
        }
    }

    protected void enableOtherImage(boolean bl) {
        if (bl != this.enableOtherImage) {
            this.enableOtherImage = bl;
        }
    }

    protected static String fixChar(String string, int n) {
        char[] cArray = string.toCharArray();
        char[] cArray2 = new char[n];
        int n2 = 0;
        while (n2 < n) {
            cArray2[n2] = n2 < cArray.length ? cArray[n2] : 32;
            ++n2;
        }
        return new String(cArray2);
    }

    private String getColor(String string) {
        return string.substring(string.indexOf(" ") + 1);
    }

    private String getLastNumber(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        String string2 = new String();
        int n = string.length() - 1;
        while (Character.isDigit(string.charAt(n)) && n >= 0) {
            string2 = String.valueOf(string.charAt(n)) + string2;
            --n;
        }
        if (string2.length() > 0) {
            return "." + string2;
        }
        return "";
    }

    protected static String getPlanLabel(int n, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = new String[3];
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n2 = 0;
        while (n2 < 3) {
            stringArray[n2] = stringTokenizer.nextToken();
            ++n2;
        }
        if (stringArray[0].indexOf("2MASS") >= 0) {
            stringArray[2] = stringArray[0];
            stringArray[0] = null;
        }
        if (n == 3) {
            stringBuffer.append("Pl-");
        } else if (n == 2) {
            stringBuffer.append("Lw-");
        }
        if (stringArray[2].equals("STScI") || stringArray[2].equals("STSCI")) {
            stringBuffer.append("DSS1");
        } else if (!stringArray[2].startsWith("___")) {
            stringBuffer.append(String.valueOf(stringArray[2]) + ".");
        }
        stringBuffer.append(stringArray[1]);
        if (stringArray[0] != null) {
            stringBuffer.append("." + (stringArray[0].startsWith("GOODS-") ? stringArray[0].substring(6) : stringArray[0]));
        }
        return stringBuffer.toString();
    }

    protected static String getPlanLabel(String string, String string2) {
        return GoodsServer.getPlanLabel(PlanImage.getRes(string), string2);
    }

    private String getSurvey(String string) {
        return string.substring(0, string.indexOf(" "));
    }

    protected String getTarget() {
        String string;
        String string2 = "";
        if (this.coo == null) {
            return null;
        }
        string2 = this.coo[0].getText().trim();
        if (this.coo.length > 1 && (string = this.coo[1].getText().trim()).length() > 0) {
            string2 = String.valueOf(string2) + " " + string;
        }
        return Server.mefCoord(string2);
    }

    void grabIt() {
        this.reset();
        super.grabIt();
    }

    protected synchronized boolean isSync() {
        return this.sync;
    }

    public boolean keyDown(Event event, int n) {
        if (event.target instanceof TextField && this.enableOtherImage) {
            if (this.aladinchoix.countItems() > 0) {
                this.aladinchoix.clear();
            }
            this.enableOtherImage(false);
        }
        return super.keyDown(event, n);
    }

    protected void memoTarget(String string) {
        otarget = string;
    }

    protected void reset() {
        if (this.aladinchoix.countItems() > 0) {
            this.aladinchoix.clear();
            int n = 0;
            while (n < 7) {
                this.aladinchoix.addItem(" ");
                ++n;
            }
        }
        this.enableOtherImage(false);
        this.aladin.dialog.goods.rt.resetCb();
        super.reset();
    }

    public void run() {
        String string = null;
        String string2 = null;
        String string3 = null;
        try {
            URL uRL = this.aladin.glu.getURL(Glu.debugTag("DefQual"), String.valueOf(Glu.quote(this.targetT)) + " " + Glu.quote(this.criteriaT));
            DataInputStream dataInputStream = new DataInputStream(uRL.openStream());
            string = dataInputStream.readLine();
            string2 = dataInputStream.readLine();
            string3 = dataInputStream.readLine();
        }
        catch (Exception exception) {}
        if (string == null) {
            this.aladin.message.warning("No such aladin image (" + this.criteriaT + ") for target \"" + this.targetT + "\".", 1);
        } else {
            this.creatAladinPlane(this.targetT, string3, string2, string, this.labelT, this.originT);
        }
        this.setSync(true);
    }

    private synchronized void setSync(boolean bl) {
        this.sync = bl;
    }

    protected void setTarget(String string) {
        this.centerCutOut.setText(string);
        if (otarget != null && !otarget.equals(string)) {
            this.reset();
        }
        super.setTarget(string);
    }

    public void setVisible(boolean bl) {
        if (bl && this.rt == null) {
            this.createResourceTree();
        }
        super.setVisible(bl);
    }

    public void show() {
        if (this.rt == null) {
            this.createResourceTree();
        }
        super.show();
    }

    public void submit() {
        Frame frame = this.getFrame(this);
        Object var2_2 = null;
        boolean bl = false;
        Vector vector = new Vector(5);
        Object var5_5 = null;
        String string = this.getTarget();
        this.memoTarget(string);
        if (PlanImage.isSolar(string)) {
            this.creatAladinPlane(string, null, null, null, string, "CDS joke");
            return;
        }
        Vector vector2 = this.rt.getSelectedLeaves();
        Enumeration enumeration = vector2.elements();
        boolean bl2 = false;
        while (enumeration.hasMoreElements()) {
            String string2;
            bl2 = false;
            ResourceNode resourceNode = (ResourceNode)enumeration.nextElement();
            if (resourceNode.type == 1) {
                string2 = resourceNode.name;
                Astroframe astroframe = new Astroframe();
                String string3 = null;
                String string4 = null;
                if (resourceNode.cutout) {
                    double d;
                    double d2;
                    try {
                        Coord coord = new Coord(this.centerCutOut.getText());
                        d2 = coord.al;
                        d = coord.del;
                        string4 = Coord.getSexa(d2, d, " ");
                    }
                    catch (Exception exception) {
                        d2 = 53.11629;
                        d = -27.80875;
                        string4 = Coord.getSexa(d2, d, " ");
                    }
                    string3 = String.valueOf(d2) + " " + d;
                    if (!ResourceTree.checkCutoutAvailability(resourceNode, d2, d, this.aladin)) {
                        bl2 = true;
                    }
                } else {
                    try {
                        astroframe.set(String.valueOf(((EISFov)((Object)resourceNode.fov)).alpha) + " " + ((EISFov)((Object)resourceNode.fov)).delta);
                        string3 = astroframe.toString("d");
                        string4 = astroframe.toString(" ");
                    }
                    catch (Exception exception) {}
                }
                if (bl2) {
                    this.aladin.message.warning("Image " + resourceNode.name + " " + "can not be loaded : \nno cutout available at this position !\nClick on the region you are interested in\nAvailable images will be marked with a red tick", 1);
                    continue;
                }
                String string5 = String.valueOf(resourceNode.survey) + " " + resourceNode.color;
                String string6 = "GOODS data - provided on line by CDS";
                String string7 = null;
                if (resourceNode.father != null && resourceNode.father.nbChildren > 1) {
                    string7 = resourceNode.name;
                }
                this.creatAladinPlane(string4, "FITS", "STAND", string5, null, null, string2, resourceNode.epoch, string7);
                continue;
            }
            if (resourceNode.type != 2) continue;
            string2 = this.centerCutOut.getText().trim();
            if (string2.length() == 0) {
                string2 = "CDFS";
            }
            this.creatCatPlane(resourceNode.name, string2, resourceNode.name);
        }
    }

    static String whichQual(String string) {
        boolean bl = flagContWhichQual && string.equals(lastQual);
        flagContWhichQual = true;
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (stringTokenizer.countTokens() < 3) {
            return string;
        }
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        String string4 = stringTokenizer.nextToken();
        stringBuffer.append(GoodsServer.fixChar(bl ? "   \"" : string2, 6));
        stringBuffer.append(GoodsServer.fixChar(bl ? "    \"   \"" : "  " + (string4.equals("MAMA") ? "MAMA/CAI" : (string4.equalsIgnoreCase("STSCI") ? "DSS1/STScI" : (string4.equalsIgnoreCase("DSS2") ? "DSS2/STScI" : (string2.equalsIgnoreCase("2MASS") ? "UMass/IRSA" : string4)))), 12));
        if (string2.equalsIgnoreCase("2MASS") || string2.equalsIgnoreCase("EROSI")) {
            stringBuffer.append(GoodsServer.fixChar("  " + string3, 12));
        } else {
            int n = 0;
            while (n < ACOLOR.length) {
                if (ACOLOR[n].equals(string3)) break;
                ++n;
            }
            if (n < ACOLOR.length) {
                stringBuffer.append(GoodsServer.fixChar(bl ? "  \"  \"" : "  " + string3 + " (" + COLOR[n] + ")", 12));
            } else {
                stringBuffer.append(GoodsServer.fixChar(bl ? "  \"" : "  " + string3, 12));
            }
        }
        lastQual = string;
        return stringBuffer.toString();
    }

    static String whichQualifier(String string) {
        flagContWhichQual = false;
        return GoodsServer.whichQual(string);
    }

    String whichSize(String string, String string2) {
        String string3 = string.indexOf("2MASS") >= 0 ? "~8.5x17'" : (string2.startsWith("STAND") ? "-" : (string.indexOf("STScI") > 0 || string.indexOf("STSCI") > 0 ? (string2.equals("PLATE") ? "~7.7x7.7deg" : (string2.equals("LOW") ? "~1.5x1.5deg" : "~14.1x14.1'")) : (string.indexOf("MAMA") > 0 ? (string2.equals("PLATE") ? "~6.1x6.1deg" : "~11.5x11.5'") : (string.indexOf("DSS2") > 0 ? (string2.equals("PLATE") ? "~6.5x6.5deg" : "~12.9x12.9'") : "-"))));
        return GoodsServer.fixChar(string3, 11);
    }
}

