/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Calib;
import cds.aladin.Coord;
import cds.aladin.Filet;
import cds.aladin.HeaderFits;
import cds.aladin.MyLabel;
import cds.aladin.Plan;
import cds.aladin.PlanImage;
import cds.aladin.PlanObjet;
import cds.aladin.PointD;
import cds.aladin.Position;
import cds.aladin.Projection;
import cds.aladin.Properties;
import cds.aladin.Repere;
import cds.aladin.Server;
import cds.astro.Coo;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.ScrollPane;
import java.awt.TextArea;
import java.awt.TextField;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public final class FrameNewCalib
extends Frame {
    static final int SIMPLE = 0;
    static final int QUADRUPLET = 1;
    static final int WCS = 2;
    static int num = 0;
    static final String SUBMIT = "CREATE";
    static final String MODIFY = "MODIFY";
    static final String HELP = "Help";
    static final String RESET = "Reset";
    static final String CANCEL = "Close";
    static final String ONE = "by parameters";
    static final String TWO = "by matching stars";
    static final String THREE = "by WCS header";
    static final String HELPSTRING = "Aladin allows you to recalibrate images following\ntwo different methods. You can specify the basic parameters\nto describe the new projection. You can also select a set\nof stars and their corresponding coordinates that you will\npick from a overlaying catalog.";
    Aladin a;
    Plan plan;
    Projection oldp;
    TextField labelT;
    TextField cooT;
    TextField xyT;
    TextField rmT;
    TextField rT;
    TextField rotT;
    TextArea wcsT;
    Choice projChoice = null;
    Checkbox trueSym;
    Checkbox falseSym;
    CheckboxGroup symRadio = null;
    Panel pSym;
    Button submitButton;
    int maxPosT = 30;
    TextField[] xyPosT;
    TextField[] cooPosT;
    String label;
    double raj;
    double dej;
    double cx;
    double cy;
    double rm;
    double r;
    double rot;
    boolean sym;
    int t;
    TextField focusTextField = null;
    boolean flagXY = false;
    Panel panelOne;
    Panel panelTwo;
    Panel panelThree;
    CardLayout cardMethod;
    Panel panelMethod;
    Choice methodChoice = null;
    int method;
    Plan suivi = null;
    double suiviHeight;
    protected static final int W = 16;

    protected FrameNewCalib(Aladin aladin, Plan plan, Projection projection) {
        super("Astronomical calibration");
        ((Component)this).setBackground(Aladin.BKGD);
        this.a = aladin;
        this.plan = plan;
        this.oldp = projection;
        if (!Aladin.LSCREEN) {
            this.move(350, 380);
        } else {
            this.move(500, 450);
        }
        this.createPanel();
        this.pack();
        this.majFrameNewCalib(plan, projection);
    }

    public boolean action(Event event, Object object) {
        if (CANCEL.equals(object)) {
            this.hide();
        } else if (event.target == this.methodChoice) {
            this.changeMethod();
        } else if (SUBMIT.equals(object) || MODIFY.equals(object)) {
            this.submit();
        } else if (HELP.equals(object)) {
            this.a.message.info(HELPSTRING);
        } else if (RESET.equals(object)) {
            this.reset();
        }
        return true;
    }

    private Point bestPoint(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < 16) {
            int n5 = 0;
            while (n5 < 16) {
                if (n3 < (byArray[n4 * 16 + n5] & 0xFF)) {
                    n3 = byArray[n4 * 16 + n5] & 0xFF;
                    n = n4;
                    n2 = n5;
                    System.out.println("i=" + n4 + " j=" + n5 + " =>" + n3);
                }
                ++n5;
            }
            ++n4;
        }
        Point point = new Point(8 - n, 8 - n2);
        System.out.println("Corrections: " + point);
        return point;
    }

    private void changeFocus() {
        int n = this.getIndexPos(this.focusTextField);
        if (n == -1) {
            this.focusTextField = null;
            return;
        }
        ((Component)this.focusTextField).setBackground(Color.white);
        if (this.focusTextField == this.xyPosT[n]) {
            this.focusTextField = this.cooPosT[n];
            this.flagXY = false;
        } else if (++n == this.maxPosT) {
            this.focusTextField = null;
        } else {
            this.focusTextField = this.xyPosT[n];
            this.flagXY = true;
        }
        if (this.focusTextField != null) {
            ((Component)this.focusTextField).setBackground(Color.yellow);
        }
    }

    private void changeMethod() {
        String string = this.methodChoice.getSelectedItem();
        this.cardMethod.show(this.panelMethod, string);
        int n = string.equals(THREE) ? 2 : (this.method = string.equals(TWO) ? 1 : 0);
        if (this.method != 1) {
            this.clearSuivi();
        }
        if (this.method == 1) {
            this.xyPosT[0].requestFocus();
            this.setFocusPos(this.xyPosT[0]);
        }
    }

    private void clearSuivi() {
        if (this.suivi != null) {
            this.suivi.Free();
            this.suivi = null;
            this.a.calque.repaint();
        }
    }

    private void createPanel() {
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        Panel panel2 = new Panel();
        MyLabel myLabel = new MyLabel(this.oldp == null ? "Choose a calibration method,\nfill up the corresponding form\naccording to the plane \"" + this.plan.label + "\"" : "Adjust the following form\naccording to the plane \"" + this.plan.label + "\"", 1, Aladin.ITALIC);
        panel2.add(myLabel);
        this.methodChoice = new Choice();
        this.methodChoice.addItem(ONE);
        this.methodChoice.addItem(TWO);
        this.methodChoice.addItem(THREE);
        panel2.add(this.methodChoice);
        Panel panel3 = new Panel();
        panel3.setLayout(new BorderLayout());
        Aladin.makeAdd(panel3, panel2, "North");
        Panel panel4 = new Panel();
        panel4.setLayout(new BorderLayout());
        panel4.setFont(Aladin.BOLD);
        this.labelT = new TextField();
        Aladin.makeAdd(panel4, new Label("Label:"), "West");
        Aladin.makeAdd(panel4, this.labelT, "Center");
        Aladin.makeAdd(panel3, panel4, "Center");
        Aladin.makeAdd(panel3, new Filet(), "South");
        Aladin.makeAdd(panel, panel3, "North");
        this.cardMethod = new CardLayout();
        this.panelOne = this.createPanelOne();
        this.panelTwo = this.createPanelTwo();
        this.panelThree = this.createPanelThree();
        this.panelMethod = new Panel();
        this.panelMethod.setLayout(this.cardMethod);
        this.panelMethod.add(ONE, this.panelOne);
        this.panelMethod.add(TWO, this.panelTwo);
        this.panelMethod.add(THREE, this.panelThree);
        Aladin.makeAdd(panel, this.panelMethod, "Center");
        Panel panel5 = this.valid();
        Aladin.makeAdd(panel, panel5, "South");
        Aladin.makeAdd(this, panel, "Center");
    }

    private Panel createPanelOne() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        Panel panel = new Panel();
        panel.setLayout(gridBagLayout);
        this.cooT = new TextField();
        this.xyT = new TextField();
        this.rmT = new TextField();
        this.rT = new TextField();
        this.rotT = new TextField();
        this.setSymRadio(this.sym);
        this.setProjChoice(this.t);
        Properties.addCouple(panel, "Coordinates (J2000):", this.cooT, gridBagLayout, gridBagConstraints);
        Properties.addCouple(panel, "Corresp. pos. (x y):", this.xyT, gridBagLayout, gridBagConstraints);
        Properties.addCouple(panel, "Field angular size", this.rmT, gridBagLayout, gridBagConstraints);
        Properties.addCouple(panel, "Corresp. number of pixels", this.rT, gridBagLayout, gridBagConstraints);
        Properties.addCouple(panel, "Projection:", this.projChoice, gridBagLayout, gridBagConstraints);
        Properties.addCouple(panel, "Rotation (deg):", this.rotT, gridBagLayout, gridBagConstraints);
        Properties.addCouple(panel, "RA symetry:", this.pSym, gridBagLayout, gridBagConstraints);
        return panel;
    }

    private Panel createPanelThree() {
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout(0, 0));
        Panel panel2 = new Panel();
        panel2.setLayout(new BorderLayout(0, 0));
        ScrollPane scrollPane = new ScrollPane(2);
        scrollPane.setSize(150, 200);
        this.wcsT = new TextArea(50, 70);
        this.wcsT.setFont(Aladin.COURIER);
        Aladin.makeAdd(panel2, this.wcsT, "Center");
        scrollPane.add(panel2);
        Aladin.makeAdd(panel, scrollPane, "Center");
        return panel;
    }

    private Panel createPanelTwo() {
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout(0, 0));
        this.xyPosT = new TextField[this.maxPosT];
        this.cooPosT = new TextField[this.maxPosT];
        int n = 150;
        int n2 = 200;
        Panel panel2 = new Panel();
        panel2.setLayout(new BorderLayout());
        panel2.setFont(Aladin.ITALIC);
        MyLabel myLabel = new MyLabel("Click in the image (or in the measurement frame) to get\nthe corresponding coordinates. (nearest star for XY fields,\nnearest catalog object for RA/Dec fields");
        Panel panel3 = new Panel();
        panel3.setLayout(new FlowLayout(1));
        panel3.add(new Label("\"x y\" position"));
        Panel panel4 = new Panel();
        panel4.setLayout(new FlowLayout(1));
        panel4.add(new Label("\"hh mm ss +dd mm ss\""));
        Aladin.makeAdd(panel2, myLabel, "North");
        Aladin.makeAdd(panel2, panel3, "West");
        Aladin.makeAdd(panel2, panel4, "East");
        Aladin.makeAdd(panel, panel2, "North");
        Panel panel5 = new Panel();
        panel5.setLayout(new GridLayout(0, 2));
        ScrollPane scrollPane = new ScrollPane(0);
        scrollPane.setSize(n, n2);
        int n3 = 0;
        while (n3 < this.maxPosT) {
            this.xyPosT[n3] = new TextField();
            this.cooPosT[n3] = new TextField();
            panel5.add(this.xyPosT[n3]);
            panel5.add(this.cooPosT[n3]);
            ++n3;
        }
        scrollPane.add(panel5);
        Aladin.makeAdd(panel, scrollPane, "Center");
        return panel;
    }

    private Coord[] getCoo() throws Exception {
        int n = 0;
        TextField textField = this.xyPosT[0];
        Vector<Coord> vector = new Vector<Coord>();
        Coord[] coordArray = null;
        try {
            Object object;
            n = 0;
            while (n < this.maxPosT) {
                object = this.xyPosT[n].getText().trim();
                String string = this.cooPosT[n].getText().trim();
                if (((String)object).length() != 0 && string.length() != 0) {
                    textField = this.cooPosT[n];
                    Coord coord = new Coord(string);
                    textField = this.xyPosT[n];
                    StringTokenizer stringTokenizer = new StringTokenizer((String)object);
                    coord.x = Double.valueOf(stringTokenizer.nextToken());
                    coord.y = Double.valueOf(stringTokenizer.nextToken());
                    vector.addElement(coord);
                }
                ++n;
            }
            int n2 = vector.size();
            object = vector.elements();
            coordArray = new Coord[n2];
            n = 0;
            while (n < n2) {
                coordArray[n] = (Coord)object.nextElement();
                ++n;
            }
        }
        catch (Exception exception) {
            textField.requestFocus();
            this.setFocusPos(textField);
            throw new Exception("Error on field " + n);
        }
        return coordArray;
    }

    private int getIndexPos(Component component) {
        int n = 0;
        while (n < this.maxPosT) {
            if (component == this.xyPosT[n] || component == this.cooPosT[n]) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private String getNewLabel() {
        return "My projection " + ++num;
    }

    private void getWCS(Projection projection) {
        StringBuffer stringBuffer = new StringBuffer();
        this.wcsT.setText("");
        if (projection == null) {
            return;
        }
        Vector vector = new Vector(20);
        Vector vector2 = new Vector(20);
        try {
            projection.c.GetWCS(vector, vector2);
        }
        catch (Exception exception) {
            System.err.println("GetWCS error");
            return;
        }
        Enumeration enumeration = vector.elements();
        Enumeration enumeration2 = vector2.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)enumeration2.nextElement();
            stringBuffer.append(String.valueOf(string) + " = " + string2 + "\n");
        }
        this.wcsT.setText(stringBuffer.toString());
    }

    public boolean handleEvent(Event event) {
        if (event.id == 1004 && event.target instanceof Component) {
            this.setFocusPos((Component)event.target);
        } else if (event.id == 201) {
            this.hide();
        }
        return super.handleEvent(event);
    }

    public void hide() {
        if (this.suivi != null) {
            this.clearSuivi();
        }
        super.hide();
    }

    protected void majFrameNewCalib(Plan plan) {
        this.majFrameNewCalib(plan, null);
    }

    protected void majFrameNewCalib(Plan plan, Projection projection) {
        this.plan = plan;
        this.oldp = projection;
        this.setData();
        this.show();
    }

    private void majSuivi() {
        Object object;
        int n;
        if (this.suivi == null) {
            n = this.a.calque.getFirstSelected();
            int n2 = this.a.calque.newPlanTool("Calibration");
            if (n2 < 0) {
                return;
            }
            this.suivi = this.a.calque.plan[n2];
            this.suivi.c = this.a.calque.plan[0].c;
            this.suivi.selected = false;
            this.suiviHeight = 0.0;
            this.a.calque.plan[n].selected = true;
            object = this.a.calque.getPlanRef();
            if (((Plan)object).type == 1) {
                this.suiviHeight = ((PlanImage)object).height;
            }
        }
        this.suivi.pcat = new PlanObjet(this.suivi, this.suivi.c, this.a.calque, this.a.status, this.a);
        n = 0;
        while (n < this.maxPosT) {
            String string = this.xyPosT[n].getText().trim();
            if (string.length() != 0) {
                object = new StringTokenizer(string);
                double d = Double.valueOf(((StringTokenizer)object).nextToken());
                double d2 = Double.valueOf(((StringTokenizer)object).nextToken());
                this.suivi.pcat.setObjet(new Repere(this.suivi, d, this.suiviHeight - d2));
            }
            ++n;
        }
    }

    protected PointD mouse(double d, double d2, byte[] byArray, Position position) {
        String string;
        PointD pointD = null;
        if (this.method != 1) {
            return pointD;
        }
        Aladin.trace(3, "x=" + d + " y=" + d2 + (position != null ? " source=" + position.id : "") + (byArray != null ? " pix[]" : ""));
        if (this.focusTextField == null) {
            return pointD;
        }
        if (this.plan == null || !this.plan.xyLock && this.plan.projd == null) {
            return pointD;
        }
        if (this.flagXY) {
            if (this.plan.xyLock) {
                PointD pointD2 = null;
                if (position != null) {
                    pointD2 = this.plan.pcat.getOriginalXY(position);
                }
                if (pointD2 == null) {
                    System.out.println("No XY object near the pointer, try again");
                    return null;
                }
                d = pointD2.x;
                d2 = pointD2.y;
            }
            string = String.valueOf(d) + "  " + d2;
            System.out.println("Position: " + string);
            pointD = new PointD(d, d2);
            this.majSuivi();
        } else {
            if (this.plan.xyLock) {
                if (position != null && this.plan.pcat.getOriginalXY(position) == null) {
                    string = Coord.getSexa(position.raj, position.dej);
                } else {
                    Projection projection;
                    Plan plan = this.a.calque.getPlanRef();
                    Projection projection2 = projection = plan == null || plan.projd == null ? null : plan.projd;
                    if (projection == null) {
                        System.out.println("No RA/DEC reference plane !");
                        return null;
                    }
                    Coord coord = new Coord();
                    coord.x = d;
                    coord.y = d2;
                    projection.getCoord(coord);
                    string = Coord.getSexa(coord.al, coord.del);
                }
            } else {
                if (position == null) {
                    System.out.println("No object near the pointer, try again !!");
                    return null;
                }
                string = Coord.getSexa(position.raj, position.dej);
            }
            System.out.println("Coordonnee: " + string);
        }
        this.focusTextField.setText(string);
        this.changeFocus();
        return pointD;
    }

    protected void reset() {
        this.setData();
        this.setFocusPos(this.xyPosT[0]);
    }

    private void setCoo(Projection projection) {
        int n = 0;
        while (n < this.maxPosT) {
            String string;
            String string2;
            if (projection == null || projection.coo == null || n >= projection.coo.length) {
                string2 = "";
                string = "";
            } else {
                Coord coord = projection.coo[n];
                string = String.valueOf(projection.coo[n].x) + " " + projection.coo[n].y;
                string2 = projection.coo[n].getSexa();
            }
            this.xyPosT[n].setText(string);
            this.cooPosT[n].setText(string2);
            ++n;
        }
    }

    private void setData() {
        if (this.plan.projd != null) {
            this.label = this.oldp != null ? this.plan.projd.label : this.getNewLabel();
            try {
                Coord coord = this.plan.projd.c.getProjCenter();
                this.raj = coord.al;
                this.dej = coord.del;
                this.cx = coord.x;
                this.cy = coord.y;
                this.rm = this.plan.projd.c.getImgWidth() * 60.0;
                this.r = this.plan.projd.c.getImgSize().width;
                this.rot = this.plan.projd.c.getProjRot();
                this.sym = this.plan.projd.c.getProjSym();
                this.t = this.plan.projd.c.getProjSys();
            }
            catch (Exception exception) {
                System.err.println("Error on projd: " + exception);
            }
        } else {
            this.label = this.getNewLabel();
            this.rot = 0.0;
            this.r = 0.0;
            this.rm = 0.0;
            this.cy = 0.0;
            this.cx = 0.0;
            this.dej = 0.0;
            this.raj = 0.0;
            if (this.plan.type == 1) {
                this.rm = 10.0;
                this.r = ((PlanImage)this.plan).width;
                this.cx = ((PlanImage)this.plan).width / 2;
                this.cy = ((PlanImage)this.plan).height / 2;
            }
            this.sym = false;
            this.t = 1;
        }
        this.labelT.setText(this.label);
        this.cooT.setText(Coord.getSexa(this.raj, this.dej, " "));
        this.xyT.setText(String.valueOf(Math.round(this.cx)) + " " + Math.round(this.cy));
        this.rmT.setText(this.rm == 0.0 ? "0" : Coord.getUnit(this.rm / 60.0));
        this.rT.setText(String.valueOf(this.r));
        this.rotT.setText(String.valueOf(this.rot));
        this.setSymRadio(this.sym);
        this.setProjChoice(this.t >= 0 ? this.t : 0);
        this.setCoo(this.plan.projd);
        this.submitButton.setLabel(this.oldp == null ? SUBMIT : MODIFY);
        this.method = 0;
        if (this.plan.projd != null) {
            if (this.plan.projd.type == 4) {
                this.method = 1;
            } else if (this.plan.projd.type == 2) {
                this.method = 2;
            }
        }
        this.cardMethod.show(this.panelMethod, this.method == 0 ? ONE : (this.method == 1 ? TWO : THREE));
        if (this.method == 1) {
            this.xyPosT[0].requestFocus();
            this.setFocusPos(this.xyPosT[0]);
            this.majSuivi();
            this.a.calque.repaint();
        }
        this.methodChoice.select(this.method);
        this.getWCS(this.plan.projd != null ? this.plan.projd : new Projection(this.label, 3, this.raj, this.dej, this.rm, this.cx, this.cy, this.r, this.rot, this.sym, 1));
    }

    private void setFocusPos(Component component) {
        int n = this.getIndexPos(component);
        if (this.focusTextField != null) {
            ((Component)this.focusTextField).setBackground(Color.white);
        }
        if (n == -1) {
            this.focusTextField = null;
            return;
        }
        this.flagXY = component == this.xyPosT[n];
        this.focusTextField = (TextField)component;
        ((Component)this.focusTextField).setBackground(Color.yellow);
        String string = this.xyPosT[n].getText().trim();
        if (string.length() == 0) {
            return;
        }
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            int n3 = Integer.parseInt(stringTokenizer.nextToken());
            this.a.view.setRepere(this.a.view.calque.getPlanRef(), n2, n3);
        }
        catch (Exception exception) {}
    }

    private void setProjChoice() {
        this.setProjChoice(1);
    }

    private void setProjChoice(int n) {
        if (this.projChoice == null) {
            this.projChoice = new Choice();
            String[] stringArray = Calib.getProj();
            int n2 = 0;
            while (n2 < stringArray.length) {
                this.projChoice.addItem(stringArray[n2]);
                ++n2;
            }
        }
        this.projChoice.select(n);
    }

    private void setSymRadio() {
        this.setSymRadio(false);
    }

    private void setSymRadio(boolean bl) {
        if (this.symRadio == null) {
            this.symRadio = new CheckboxGroup();
            this.trueSym = new Checkbox("True", bl, this.symRadio);
            this.falseSym = new Checkbox("False", bl ^ true, this.symRadio);
            this.pSym = new Panel();
            this.pSym.add(this.trueSym);
            this.pSym.add(this.falseSym);
        } else {
            this.symRadio.setSelectedCheckbox(bl ? this.trueSym : this.falseSym);
        }
    }

    private void submit() {
        Projection projection = null;
        String string = this.labelT.getText();
        String string2 = null;
        try {
            Coord[] coordArray;
            if (this.method == 0) {
                string2 = "coordinate";
                coordArray = new Coo(this.cooT.getText(), true);
                double d = coordArray.lon;
                double d2 = coordArray.lat;
                StringTokenizer stringTokenizer = new StringTokenizer(this.xyT.getText());
                string2 = "XY position";
                double d3 = Double.valueOf(stringTokenizer.nextToken());
                double d4 = Double.valueOf(stringTokenizer.nextToken());
                string2 = "width";
                double d5 = Server.getRadius(this.rmT.getText());
                string2 = "radius";
                double d6 = Double.valueOf(this.rT.getText());
                string2 = "rotation";
                double d7 = Double.valueOf(this.rotT.getText());
                int n = this.projChoice.getSelectedIndex();
                boolean bl = this.trueSym.getState();
                string2 = null;
                if (this.oldp != null) {
                    projection = this.oldp;
                    projection.modify(string, 3, d, d2, d5, d3, d4, d6, d7, bl, n);
                } else {
                    projection = new Projection(string, 3, d, d2, d5, d3, d4, d6, d7, bl, n);
                }
            } else if (this.method == 1) {
                coordArray = this.getCoo();
                if (coordArray == null) {
                    return;
                }
                projection = this.oldp != null ? this.oldp : new Projection(this.plan.projd);
                projection.modify(string, coordArray);
            } else if (this.method == 2) {
                coordArray = this.wcsT.getText();
                HeaderFits headerFits = new HeaderFits((String)coordArray);
                Calib calib = new Calib(headerFits);
                projection = this.oldp != null ? this.oldp : new Projection(string, 3, this.raj, this.dej, this.rm, this.cx, this.cy, this.r, this.rot, this.sym, 1);
                projection.modify(string, calib);
            }
            if (this.plan.xyLock) {
                this.plan.pcat.setCoord(projection);
            }
            if (this.oldp == null) {
                this.plan.setNewProjD(projection);
            } else if (this.a.properties != null) {
                this.a.properties.majProp();
            }
            if (this.a.properties != null) {
                this.a.properties.majProjs();
            }
            int n = 0;
            while (n < this.a.calque.plan.length) {
                this.a.calque.plan[n].flagProj = false;
                ++n;
            }
            this.a.calque.view.newView();
            this.a.calque.repaint();
            this.oldp = projection;
            this.submitButton.setLabel(MODIFY);
            this.setData();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            string2 = string2 == null ? "Calibration error: \n" + exception : "Calibration error\non \"" + string2 + "\" field";
            this.a.message.warning(string2, 1);
        }
    }

    protected Panel valid() {
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(1));
        panel.setFont(Aladin.LBOLD);
        this.submitButton = new Button(this.oldp != null ? MODIFY : SUBMIT);
        panel.add(this.submitButton);
        panel.add(new Button(HELP));
        panel.add(new Button(RESET));
        panel.add(new Button(CANCEL));
        return panel;
    }
}

