/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.AladinServer;
import cds.aladin.Filet;
import cds.aladin.MetaDataTree;
import cds.aladin.ResourceNode;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class FrameInfo
extends Frame
implements WindowListener {
    static final int SCROLL_MAX_WIDTH = 300;
    static final int SCROLL_MAX_HEIGHT = 400;
    private Button loadCatBtn;
    private Button btn;
    private Button btnHide;
    private Button btnLoad;
    private Button showAllLevBtn;
    private Button hideAllLevBtn;
    private Button expandBtn;
    private Button expandAllBtn;
    private ScrollPane scroll;
    private Panel mainPanel;
    private Panel infoPanel;
    private Panel btnPanel;
    private Panel pjpg;
    private CheckboxGroup fmt;
    Button lockBtn;
    private GridBagLayout g = new GridBagLayout();
    private GridBagConstraints c = new GridBagConstraints();
    private ResourceNode node;
    private MetaDataTree tree;
    private static FrameInfo curInstance = null;
    private boolean isLocked = false;

    private FrameInfo() {
        super("Info Frame");
        this.createComponents();
        this.setLayout(new BorderLayout(0, 0));
        this.infoPanel = new Panel();
        this.infoPanel.setLayout(this.g);
        this.scroll = new ScrollPane(0);
        this.scroll.add(this.infoPanel);
        this.mainPanel = new Panel();
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.add((Component)this.scroll, "Center");
        this.btnPanel = new Panel();
        this.btnPanel.setLayout(this.g);
        this.mainPanel.add((Component)this.btnPanel, "South");
        this.add((Component)this.mainPanel, "Center");
        Panel panel = new Panel();
        this.lockBtn = new Button("Lock");
        this.lockBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FrameInfo.this.isLocked = true;
                FrameInfo.this.lockBtn.setEnabled(false);
            }
        });
        Button button = new Button("Close");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((Component)FrameInfo.this).hide();
            }
        });
        panel.setLayout(new FlowLayout());
        panel.add(this.lockBtn);
        panel.add(button);
        this.add((Component)panel, "South");
        this.scroll.setSize(300, 400);
        this.addWindowListener(this);
    }

    static /* synthetic */ boolean access$0(FrameInfo frameInfo) {
        return frameInfo.isLocked;
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    private void createComponents() {
        this.fmt = new CheckboxGroup();
        this.pjpg = new Panel();
        this.pjpg.setLayout(new FlowLayout(0));
        String string = "JPEG";
        String string2 = "MRCOMP";
        String string3 = "FITS";
        this.pjpg.add(new Label("Get in:"));
        this.pjpg.add(new Checkbox(string, true, this.fmt));
        this.pjpg.add(new Checkbox(string3, false, this.fmt));
        this.pjpg.setFont(Aladin.PLAIN);
        this.loadCatBtn = new Button("Load catalogue");
        this.loadCatBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FrameInfo.this.tree.load(FrameInfo.this.node);
            }
        });
        this.btn = new Button("Display/hide image field");
        this.btn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FrameInfo.this.tree.fovAction(FrameInfo.this.node);
            }
        });
        this.btnHide = new Button("Hide all fields");
        this.btnHide.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FrameInfo.this.tree.hideAllFovs();
                FrameInfo.this.tree.unframeAll();
                FrameInfo.this.repaint();
            }
        });
        this.btnLoad = new Button("Load image");
        this.btnLoad.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FrameInfo.this.tree.load(FrameInfo.this.node);
            }
        });
        this.showAllLevBtn = new Button("Show all image fields for this level");
        this.showAllLevBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FrameInfo.this.tree.showAllLev(FrameInfo.this.node);
                FrameInfo.this.tree.frameNode(FrameInfo.this.node);
                FrameInfo.this.tree.repaint();
            }
        });
        this.hideAllLevBtn = new Button("Hide all image fields for this level");
        this.hideAllLevBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FrameInfo.this.tree.hideAllLev(FrameInfo.this.node);
                FrameInfo.this.tree.unframeNode(FrameInfo.this.node);
                FrameInfo.this.tree.repaint();
            }
        });
        this.expandBtn = new Button("Expand/Collapse this node");
        this.expandBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FrameInfo.this.node.changeState();
                FrameInfo.this.tree.doDisplay();
                FrameInfo.this.tree.repaint();
            }
        });
    }

    private void displayInfo(ResourceNode resourceNode, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        if (resourceNode.description == null || resourceNode.explanation == null) {
            return;
        }
        int n = 0;
        while (n < resourceNode.description.length) {
            if (resourceNode.explanation[n].length() != 0) {
                Label label = new Label(resourceNode.description[n]);
                label.setFont(Aladin.SITALIC);
                Label label2 = new Label(resourceNode.explanation[n]);
                if (resourceNode.explanation[n].length() > 60) {
                    label2 = new Label(String.valueOf(resourceNode.explanation[n].substring(0, 57)) + "...");
                }
                label2.setFont(Aladin.SBOLD);
                gridBagConstraints.gridwidth = -1;
                gridBagConstraints.weightx = 0.0;
                gridBagLayout.setConstraints(label, gridBagConstraints);
                this.infoPanel.add(label);
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.weightx = 1.0;
                gridBagLayout.setConstraints(label2, gridBagConstraints);
                this.infoPanel.add(label2);
            }
            ++n;
        }
    }

    public static FrameInfo getInstance() {
        if (curInstance == null || FrameInfo.curInstance.isLocked) {
            curInstance = new FrameInfo();
        }
        return curInstance;
    }

    public void update(ResourceNode resourceNode, MetaDataTree metaDataTree) {
        Object object;
        this.node = resourceNode;
        this.tree = metaDataTree;
        this.infoPanel.removeAll();
        this.btnPanel.removeAll();
        this.c.fill = 1;
        if (resourceNode.type == 1) {
            Label label;
            if (resourceNode.criteria != null && resourceNode.valueCriteria != null) {
                object = new Label(resourceNode.criteria);
                ((Component)object).setFont(Aladin.SITALIC);
                label = new Label(resourceNode.valueCriteria);
                label.setFont(Aladin.SBOLD);
                this.c.gridwidth = -1;
                this.c.weightx = 0.0;
                this.g.setConstraints((Component)object, this.c);
                this.infoPanel.add((Component)object);
                this.c.gridwidth = 0;
                this.c.weightx = 1.0;
                this.g.setConstraints(label, this.c);
                this.infoPanel.add(label);
                Label label2 = new Label(" ");
                this.c.gridwidth = 0;
                this.c.weightx = 1.0;
                this.g.setConstraints(label2, this.c);
                this.infoPanel.add(label2);
            }
            this.displayInfo(resourceNode, this.g, this.c);
            if (resourceNode.filterDesc != null && resourceNode.filterExpla != null) {
                object = new Label(" ");
                this.c.gridwidth = 0;
                this.c.weightx = 1.0;
                this.g.setConstraints((Component)object, this.c);
                this.infoPanel.add((Component)object);
                label = new Label("Filter characteristics");
                label.setFont(Aladin.BOLD);
                this.c.gridwidth = 0;
                this.c.weightx = 1.0;
                this.g.setConstraints(label, this.c);
                this.infoPanel.add(label);
                int n = 0;
                while (n < resourceNode.filterDesc.length) {
                    if (resourceNode.filterExpla[n].length() != 0) {
                        Label label3 = new Label(resourceNode.filterDesc[n]);
                        label3.setFont(Aladin.SITALIC);
                        Label label4 = new Label(resourceNode.filterExpla[n]);
                        label4.setFont(Aladin.SBOLD);
                        this.c.gridwidth = -1;
                        this.c.weightx = 0.0;
                        this.g.setConstraints(label3, this.c);
                        this.infoPanel.add(label3);
                        this.c.gridwidth = 0;
                        this.c.weightx = 1.0;
                        this.g.setConstraints(label4, this.c);
                        this.infoPanel.add(label4);
                    }
                    ++n;
                }
            }
            if (resourceNode.isLeaf) {
                this.c.gridwidth = 0;
                this.c.weightx = 0.0;
                this.g.setConstraints(this.btn, this.c);
                this.btnPanel.add(this.btn);
                this.c.gridwidth = 0;
                this.c.weightx = 0.0;
                this.g.setConstraints(this.btnHide, this.c);
                this.btnPanel.add(this.btnHide);
                if (resourceNode.server != null && resourceNode.server instanceof AladinServer) {
                    this.g.setConstraints(this.pjpg, this.c);
                    this.btnPanel.add(this.pjpg);
                }
                this.c.gridwidth = 0;
                this.c.weightx = 0.0;
                this.g.setConstraints(this.btnLoad, this.c);
                this.btnPanel.add(this.btnLoad);
            } else {
                this.c.gridwidth = 0;
                this.c.weightx = 0.0;
                this.g.setConstraints(this.showAllLevBtn, this.c);
                this.btnPanel.add(this.showAllLevBtn);
                this.c.gridwidth = 0;
                this.c.weightx = 0.0;
                this.g.setConstraints(this.hideAllLevBtn, this.c);
                this.btnPanel.add(this.hideAllLevBtn);
            }
        } else if (resourceNode.type == 2 && resourceNode.isLeaf) {
            object = resourceNode.catDesc;
            String string = null;
            int n = resourceNode.catDesc.indexOf("(");
            if (n > 0) {
                object = resourceNode.catDesc.substring(0, n);
                string = resourceNode.catDesc.substring(n);
            }
            Label label = new Label((String)object);
            label.setFont(Aladin.SBOLD);
            this.c.gridwidth = 0;
            this.c.weightx = 1.0;
            this.g.setConstraints(label, this.c);
            this.infoPanel.add(label);
            if (string != null) {
                Label label5 = new Label(string);
                label5.setFont(Aladin.SBOLD);
                this.c.gridwidth = 0;
                this.c.weightx = 1.0;
                this.g.setConstraints(label5, this.c);
                this.infoPanel.add(label5);
            }
            this.displayInfo(resourceNode, this.g, this.c);
            this.c.gridwidth = 0;
            this.c.weightx = 0.0;
            this.g.setConstraints(this.loadCatBtn, this.c);
            this.btnPanel.add(this.loadCatBtn);
        }
        if (!resourceNode.isLeaf) {
            this.c.gridwidth = 0;
            this.c.weightx = 0.0;
            this.g.setConstraints(this.expandBtn, this.c);
            this.btnPanel.add(this.expandBtn);
            this.c.gridwidth = 0;
            this.c.weightx = 0.0;
        }
        object = new Filet();
        this.g.setConstraints((Component)object, this.c);
        this.btnPanel.add((Component)object);
        this.infoPanel.invalidate();
        this.infoPanel.validate();
        this.pack();
        this.show();
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
        ((Component)this).hide();
    }

    public void windowClosing(WindowEvent windowEvent) {
        ((Component)this).hide();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

