/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Coord;
import cds.aladin.Plan;
import cds.aladin.PointD;
import cds.aladin.ZoomView;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;

public class Fov {
    double alpha;
    double delta;
    double x;
    double y;
    double angle;
    double cutout_x;
    double cutout_y;
    Color color = Color.red;
    private PointD[] bords = new PointD[4];

    Fov(double d, double d2, double d3, double d4, double d5) {
        this.alpha = d;
        this.delta = d2;
        this.x = d3;
        this.y = d4;
        this.angle = d5;
        this.computePoints();
    }

    Fov(String string, double d, double d2, double d3) throws Exception {
        Coord coord = new Coord(string);
        this.alpha = coord.al;
        this.delta = coord.del;
        this.x = d;
        this.y = d2;
        this.angle = d3;
        this.computePoints();
    }

    private void computePoints() {
        int n = 0;
        while (n < 4) {
            int n2 = n == 1 || n == 2 ? -1 : 1;
            int n3 = n < 2 ? 1 : -1;
            double d = this.delta + (double)n3 * this.y / 2.0;
            double d2 = this.alpha + (double)n2 * (this.x / 2.0) / Math.cos(d * Math.PI / 180.0);
            this.bords[n] = new PointD(d2, d);
            ++n;
        }
    }

    protected boolean contains(int n, int n2, Plan plan, ZoomView zoomView) {
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        Point[] pointArray = this.getBorders(plan, zoomView);
        int n3 = 0;
        while (n3 < 4) {
            nArray[n3] = pointArray[n3].x;
            nArray2[n3] = pointArray[n3].y;
            ++n3;
        }
        Polygon polygon = new Polygon(nArray, nArray2, 4);
        return polygon.contains(n, n2);
    }

    protected void draw(Plan plan, ZoomView zoomView, Graphics graphics, int n, int n2, Color color) {
        Point[] pointArray = this.getBorders(plan, zoomView);
        graphics.setColor(color != null ? color : this.color);
        int n3 = 0;
        while (n3 < 4) {
            int n4 = (n3 + 1) % 4;
            graphics.drawLine(pointArray[n3].x + n, pointArray[n3].y + n2, pointArray[n4].x + n, pointArray[n4].y + n2);
            ++n3;
        }
    }

    protected Point[] getBorders(Plan plan, ZoomView zoomView) {
        Point[] pointArray = new Point[4];
        Coord coord = new Coord(this.alpha, this.delta);
        coord = plan.projd.getXY(coord);
        Point point = zoomView.getViewCoord(coord.x, coord.y);
        int n = 0;
        while (n < 4) {
            coord = new Coord(this.bords[n].x, this.bords[n].y);
            coord = plan.projd.getXY(coord);
            pointArray[n] = this.rotation(zoomView.getViewCoord(coord.x, coord.y), point, this.angle);
            ++n;
        }
        return pointArray;
    }

    private PointD rotation(PointD pointD, PointD pointD2, double d) {
        double d2 = -d * Math.PI / 180.0;
        double d3 = pointD2.x + (pointD.x - pointD2.x) * Math.cos(d2) - (pointD.y - pointD2.y) * Math.sin(d2);
        double d4 = pointD2.y + (pointD.x - pointD2.x) * Math.sin(d2) + (pointD.y - pointD2.y) * Math.cos(d2);
        return new PointD(d3, d4);
    }

    private Point rotation(Point point, Point point2, double d) {
        double d2 = -d * Math.PI / 180.0;
        double d3 = (double)point2.x + (double)(point.x - point2.x) * Math.cos(d2) - (double)(point.y - point2.y) * Math.sin(d2);
        double d4 = (double)point2.y + (double)(point.x - point2.x) * Math.sin(d2) + (double)(point.y - point2.y) * Math.cos(d2);
        return new Point((int)d3, (int)d4);
    }
}

