/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.astro.Astroframe;
import cds.astro.Coo;
import java.util.StringTokenizer;

public final class Coord {
    protected double al;
    protected double del;
    protected double x;
    protected double dx;
    protected double y;
    protected double dy;
    protected double xstand;
    protected double ystand;
    static Astroframe coo = new Astroframe();

    protected Coord() {
    }

    protected Coord(double d, double d2) {
        this.al = d;
        this.del = d2;
    }

    protected Coord(String string) throws Exception {
        coo.set(string);
        this.al = coo.getLon();
        this.del = coo.getLat();
    }

    protected String getDE() {
        return this.getDE(':');
    }

    protected String getDE(char c) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(coo.toString(":"), " ");
            stringTokenizer.nextToken();
            if (c == ':') {
                return stringTokenizer.nextToken();
            }
            return stringTokenizer.nextToken().replace(':', c);
        }
        catch (Exception exception) {
            System.err.println(exception);
            return "";
        }
    }

    protected static double getDist(Coord coord, Coord coord2) {
        return Coo.dist(coord.al, coord.del, coord2.al, coord2.del);
    }

    protected String getRA() {
        return this.getRA(':');
    }

    protected String getRA(char c) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(coo.toString(":"), " ");
            if (c == ':') {
                return stringTokenizer.nextToken();
            }
            return stringTokenizer.nextToken().replace(':', c);
        }
        catch (Exception exception) {
            System.err.println(exception);
            return "";
        }
    }

    String getSexa() {
        return this.getSexa(" ");
    }

    protected static String getSexa(double d, double d2) {
        return Coord.getSexa(d, d2, " ");
    }

    protected static String getSexa(double d, double d2, String string) {
        coo.set(d, d2);
        coo.setPrecision(6);
        try {
            return coo.toString(string);
        }
        catch (Exception exception) {
            System.err.println(exception);
            return "";
        }
    }

    String getSexa(String string) {
        return Coord.getSexa(this.al, this.del, string);
    }

    protected static String getUnit(double d) {
        String string = null;
        if (d >= 1.0) {
            string = "\u00b0";
        }
        if (d < 1.0) {
            string = "'";
            d *= 60.0;
        }
        if (d < 1.0) {
            string = "\"";
            d *= 60.0;
        }
        d = (double)((int)(d * 100.0)) / 100.0;
        string = String.valueOf(d) + string;
        return string;
    }

    protected static String getUnitTime(double d) {
        String string = null;
        if (d >= 1.0) {
            string = "h";
        }
        if (d < 1.0) {
            string = "min";
            d *= 60.0;
        }
        if (d < 1.0) {
            string = "s";
            d *= 60.0;
        }
        d = (double)((int)(d * 100.0)) / 100.0;
        string = String.valueOf(d) + " " + string;
        return string;
    }
}

